/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;

public class PGM_Reader
extends ImagePlus
implements PlugIn {
    private int width;
    private int height;
    private boolean rawBits;
    private boolean sixteenBits;

    public void run(String arg) {
        ImageProcessor ip;
        OpenDialog od = new OpenDialog("PGM Reader...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String path = directory + name;
        IJ.showStatus("Opening: " + path);
        try {
            ip = this.openFile(path);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            IJ.showMessage("PGM Reader", msg.equals("") ? "" + e : msg);
            return;
        }
        this.setProcessor(name, ip);
        if (arg.equals("")) {
            this.show();
        }
    }

    public ImageProcessor openFile(String path) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(path));
        StreamTokenizer tok = new StreamTokenizer(is);
        tok.resetSyntax();
        tok.wordChars(33, 255);
        tok.whitespaceChars(0, 32);
        tok.parseNumbers();
        tok.eolIsSignificant(true);
        tok.commentChar(35);
        this.openHeader(tok);
        if (this.sixteenBits) {
            if (this.rawBits) {
                return this.open16bitRawImage(is, this.width, this.height);
            }
            return this.open16bitAsciiImage(tok, this.width, this.height);
        }
        byte[] pixels = new byte[this.width * this.height];
        ByteProcessor ip = new ByteProcessor(this.width, this.height, pixels, null);
        if (this.rawBits) {
            this.openRawImage(is, this.width * this.height, pixels);
        } else {
            this.openAsciiImage(tok, this.width * this.height, pixels);
        }
        return ip;
    }

    public void openHeader(StreamTokenizer tok) throws IOException {
        String magicNumber = this.getWord(tok);
        if (magicNumber.equals("P5")) {
            this.rawBits = true;
        } else if (!magicNumber.equals("P2")) {
            throw new IOException("PGM files must start with \"P2\" or \"P5\"");
        }
        this.width = this.getInt(tok);
        this.height = this.getInt(tok);
        int maxValue = this.getInt(tok);
        if (this.width == -1 || this.height == -1 || maxValue == -1) {
            throw new IOException("Error opening PGM header..");
        }
        this.sixteenBits = maxValue > 255;
        String msg = "The maximum gray value is larger than ";
        if (this.sixteenBits && maxValue > 65535) {
            throw new IOException(msg + "65535.");
        }
    }

    public void openAsciiImage(StreamTokenizer tok, int size, byte[] pixels) throws IOException {
        int i = 0;
        int inc = size / 20;
        while (true) {
            if (tok.nextToken() == -1) break;
            if (tok.ttype != -2) continue;
            pixels[i++] = (byte)((int)tok.nval & 0xFF);
            if (i % inc != 0) continue;
            IJ.showProgress(0.5 + (double)i / (double)size / 2.0);
        }
        IJ.showProgress(1.0);
    }

    public void openRawImage(InputStream is, int size, byte[] pixels) throws IOException {
        int count = 0;
        while (count < size && count >= 0) {
            count = is.read(pixels, count, size - count);
        }
    }

    public ImageProcessor open16bitRawImage(InputStream is, int width, int height) throws IOException {
        int size = width * height * 2;
        byte[] bytes = new byte[size];
        int count = 0;
        while (count < size && count >= 0) {
            count = is.read(bytes, count, size - count);
        }
        short[] pixels = new short[size / 2];
        int i = 0;
        int j = 0;
        while (i < size / 2) {
            pixels[i] = (short)((bytes[j] & 0xFF) << 8 | bytes[j + 1] & 0xFF);
            ++i;
            j += 2;
        }
        return new ShortProcessor(width, height, pixels, null);
    }

    public ImageProcessor open16bitAsciiImage(StreamTokenizer tok, int width, int height) throws IOException {
        int i = 0;
        int size = width * height;
        int inc = size / 20;
        short[] pixels = new short[size];
        while (true) {
            if (tok.nextToken() == -1) break;
            if (tok.ttype != -2) continue;
            pixels[i++] = (short)((int)tok.nval & 0xFFFF);
            if (i % inc != 0) continue;
            IJ.showProgress(0.5 + (double)i / (double)size / 2.0);
        }
        IJ.showProgress(1.0);
        return new ShortProcessor(width, height, pixels, null);
    }

    String getWord(StreamTokenizer tok) throws IOException {
        block1: {
            do {
                if (tok.nextToken() == -1) break block1;
            } while (tok.ttype != -3);
            return tok.sval;
        }
        return null;
    }

    int getInt(StreamTokenizer tok) throws IOException {
        block1: {
            do {
                if (tok.nextToken() == -1) break block1;
            } while (tok.ttype != -2);
            return (int)tok.nval;
        }
        return -1;
    }
}

