/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class Rotator
implements PlugInFilter {
    private static double angle = 15.0;
    private static boolean interpolate = true;
    private static boolean firstTime;
    private static boolean canceled;
    private ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        IJ.register(Rotator.class);
        firstTime = true;
        canceled = false;
        return IJ.setupDialog(imp, 31);
    }

    public void run(ImageProcessor ip) {
        if (canceled) {
            return;
        }
        if (firstTime) {
            GenericDialog gd = new GenericDialog(IJ.getPluginBundle().getString("Rotate"), IJ.getInstance());
            gd.addNumericField(IJ.getPluginBundle().getString("Angle") + " (" + IJ.getPluginBundle().getString("Degrees") + "): ", angle, 1);
            gd.addCheckbox(IJ.getPluginBundle().getString("Interpolate"), interpolate);
            gd.showDialog();
            canceled = gd.wasCanceled();
            if (canceled) {
                return;
            }
            angle = gd.getNextNumber();
            if (gd.invalidNumber()) {
                IJ.error(IJ.getPluginBundle().getString("AngleErr"));
                return;
            }
            interpolate = gd.getNextBoolean();
            this.imp.startTiming();
            firstTime = false;
        }
        ip.setInterpolate(interpolate);
        ip.rotate(angle);
    }
}

