/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.ima4;

import com.ibm.media.codec.audio.BufferedEncoder;
import com.ibm.media.codec.audio.ima4.IMA4;
import com.ibm.media.codec.audio.ima4.IMA4State;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class JavaEncoder
extends BufferedEncoder {
    private IMA4State ima4stateL;
    private IMA4State ima4stateR;

    public JavaEncoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, -1, 0, 1, -1, -1.0, Format.byteArray)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("ima4")};
        this.PLUGIN_NAME = "IMA4 Encoder";
        this.historySize = 256;
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("ima4", af.getSampleRate(), 16, af.getChannels(), -1, -1, 272 * af.getChannels(), -1.0, Format.byteArray)};
        return this.supportedOutputFormats;
    }

    public void open() {
        this.ima4stateL = new IMA4State();
        this.ima4stateR = new IMA4State();
    }

    public void close() {
        this.ima4stateL = null;
        this.ima4stateR = null;
    }

    public void codecReset() {
        this.ima4stateL.index = 0;
        this.ima4stateL.valprev = 0;
        this.ima4stateR.index = 0;
        this.ima4stateR.valprev = 0;
    }

    protected int calculateOutputSize(int inputSize) {
        return this.calculateFramesNumber(inputSize) * 34 * 2;
    }

    protected int calculateFramesNumber(int inputSize) {
        return inputSize / 128;
    }

    protected boolean codecProcess(byte[] inpData, int readPtr, byte[] outData, int writePtr, int inpLength, int[] readBytes, int[] writeBytes, int[] frameNumber, int[] regions, int[] regiostypes) {
        int inCount = 0;
        int outCount = 0;
        int channels = this.inputFormat.getChannels();
        boolean isStereo = channels == 2;
        int stride = isStereo ? 2 : 0;
        int frames = inpLength / (channels * 128);
        regions[0] = writePtr;
        for (int frameCounter = 0; frameCounter < frames; ++frameCounter) {
            if (this.ima4stateL.index > 88) {
                this.ima4stateL.index = 88;
            } else if (this.ima4stateL.index < 0) {
                this.ima4stateL.index = 0;
            }
            this.ima4stateL.valprev &= 0xFFFFFF80;
            int stateL = this.ima4stateL.valprev | this.ima4stateL.index;
            outData[writePtr + outCount++] = (byte)(stateL >> 8);
            outData[writePtr + outCount++] = (byte)stateL;
            IMA4.encode(inpData, readPtr + inCount, outData, writePtr + outCount, 64, this.ima4stateL, stride);
            outCount += 32;
            if (isStereo) {
                if (this.ima4stateR.index > 88) {
                    this.ima4stateR.index = 88;
                } else if (this.ima4stateR.index < 0) {
                    this.ima4stateR.index = 0;
                }
                this.ima4stateR.valprev &= 0xFFFFFF80;
                int stateR = this.ima4stateR.valprev | this.ima4stateR.index;
                outData[writePtr + outCount++] = (byte)(stateR >> 8);
                outData[writePtr + outCount++] = (byte)stateR;
                IMA4.encode(inpData, readPtr + inCount + 2, outData, writePtr + outCount, 64, this.ima4stateR, stride);
                outCount += 32;
                inCount += 256;
            } else {
                inCount += 128;
            }
            regions[frameCounter + 1] = outCount + writePtr;
            this.regionsTypes[frameCounter] = 0;
        }
        readBytes[0] = inCount;
        writeBytes[0] = outCount;
        frameNumber[0] = frames;
        return true;
    }
}

