/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicModule;
import com.sun.media.BasicMuxModule;
import com.sun.media.BasicProcessor;
import com.sun.media.BasicSinkModule;
import com.sun.media.BasicTrackControl;
import com.sun.media.GraphNode;
import com.sun.media.InputConnector;
import com.sun.media.Log;
import com.sun.media.OutputConnector;
import com.sun.media.PlaybackEngine;
import com.sun.media.SimpleGraphBuilder;
import com.sun.media.SlowPlugIn;
import com.sun.media.codec.video.colorspace.RGBScaler;
import com.sun.media.controls.ProgressControl;
import com.sun.media.util.Resource;
import java.awt.Dimension;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Owned;
import javax.media.PlugIn;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.Track;
import javax.media.UnsupportedPlugInException;
import javax.media.control.FrameRateControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;

public class ProcessEngine
extends PlaybackEngine {
    protected BasicMuxModule muxModule;
    protected ContentDescriptor outputContentDes = null;
    String prefetchError = "Failed to prefetch: " + this;
    protected Vector targetMuxNames = null;
    protected GraphNode[] targetMuxes = null;
    protected GraphNode targetMux = null;
    protected Format[] targetMuxFormats = null;

    public ProcessEngine(BasicProcessor p) {
        super(p);
    }

    protected boolean doConfigure() {
        if (!this.doConfigure1()) {
            return false;
        }
        String[] names = this.source.getOutputConnectorNames();
        this.trackControls = new BasicTrackControl[this.tracks.length];
        for (int i2 = 0; i2 < this.tracks.length; ++i2) {
            this.trackControls[i2] = new ProcTControl(this, this.tracks[i2], this.source.getOutputConnector(names[i2]));
        }
        if (!this.doConfigure2()) {
            return false;
        }
        this.outputContentDes = new ContentDescriptor("raw");
        this.reenableHintTracks();
        return true;
    }

    protected synchronized boolean doRealize() {
        this.targetMuxes = null;
        if (!super.doRealize1()) {
            return false;
        }
        if (this.targetMux != null && !this.connectMux()) {
            Log.error(this.realizeError);
            Log.error("  Cannot connect the multiplexer\n");
            this.player.processError = this.genericProcessorError;
            return false;
        }
        return super.doRealize2();
    }

    boolean isRTPFormat(Format fmt) {
        return fmt != null && fmt.getEncoding() != null && fmt.getEncoding().endsWith("rtp") || fmt.getEncoding().endsWith("RTP");
    }

    void reenableHintTracks() {
        for (int i2 = 0; i2 < this.trackControls.length; ++i2) {
            if (!this.isRTPFormat(this.trackControls[i2].getOriginalFormat())) continue;
            this.trackControls[i2].setEnabled(true);
            break;
        }
    }

    BasicMuxModule getMuxModule() {
        return this.muxModule;
    }

    boolean connectMux() {
        BasicTrackControl[] tcs = new BasicTrackControl[this.trackControls.length];
        int total = 0;
        Multiplexer mux = (Multiplexer)this.targetMux.plugin;
        for (int i2 = 0; i2 < this.trackControls.length; ++i2) {
            if (!this.trackControls[i2].isEnabled()) continue;
            tcs[total++] = this.trackControls[i2];
        }
        try {
            mux.setContentDescriptor(this.outputContentDes);
        }
        catch (Exception e2) {
            Log.comment("Failed to set the output content descriptor on the multiplexer.");
            return false;
        }
        boolean failed = false;
        if (mux.setNumTracks(this.targetMuxFormats.length) != this.targetMuxFormats.length) {
            Log.comment("Failed  to set number of tracks on the multiplexer.");
            return false;
        }
        for (int mf = 0; mf < this.targetMuxFormats.length; ++mf) {
            if (this.targetMuxFormats[mf] != null && mux.setInputFormat(this.targetMuxFormats[mf], mf) != null) continue;
            Log.comment("Failed to set input format on the multiplexer.");
            failed = true;
            break;
        }
        if (failed) {
            return false;
        }
        if (SimpleGraphBuilder.inspector != null && !SimpleGraphBuilder.inspector.verify(mux, this.targetMuxFormats)) {
            return false;
        }
        BasicMuxModule bmm = new BasicMuxModule(mux, this.targetMuxFormats);
        if (DEBUG) {
            bmm.setJMD(this.jmd);
        }
        for (int j2 = 0; j2 < this.targetMuxFormats.length; ++j2) {
            InputConnector ic = bmm.getInputConnector(BasicMuxModule.ConnectorNamePrefix + j2);
            if (ic == null) {
                Log.comment("BasicMuxModule: connector mismatched.");
                return false;
            }
            ic.setFormat(this.targetMuxFormats[j2]);
            tcs[j2].lastOC.setProtocol(ic.getProtocol());
            tcs[j2].lastOC.connectTo(ic, this.targetMuxFormats[j2]);
        }
        if (!bmm.doRealize()) {
            return false;
        }
        bmm.setModuleListener(this);
        bmm.setController(this);
        this.modules.addElement(bmm);
        this.sinks.addElement(bmm);
        this.muxModule = bmm;
        return true;
    }

    protected BasicSinkModule findMasterSink() {
        if (this.muxModule != null && this.muxModule.getClock() != null) {
            return this.muxModule;
        }
        return super.findMasterSink();
    }

    protected synchronized boolean doPrefetch() {
        if (this.prefetched) {
            return true;
        }
        if (!this.doPrefetch1()) {
            return false;
        }
        if (this.muxModule != null && !this.muxModule.doPrefetch()) {
            Log.error(this.prefetchError);
            Log.error("  Cannot prefetch the multiplexer: " + this.muxModule.getMultiplexer() + "\n");
            return false;
        }
        return this.doPrefetch2();
    }

    protected synchronized void doStart() {
        if (this.started) {
            return;
        }
        this.doStart1();
        if (this.muxModule != null) {
            this.muxModule.doStart();
        }
        this.doStart2();
    }

    protected synchronized void doStop() {
        if (!this.started) {
            return;
        }
        this.doStop1();
        if (this.muxModule != null) {
            this.muxModule.doStop();
        }
        this.doStop2();
    }

    public TrackControl[] getTrackControls() throws NotConfiguredError {
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("getTrackControls " + NOT_CONFIGURED_ERROR));
        }
        return this.trackControls;
    }

    public ContentDescriptor[] getSupportedContentDescriptors() throws NotConfiguredError {
        int i2;
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("getSupportedContentDescriptors " + NOT_CONFIGURED_ERROR));
        }
        Vector names = PlugInManager.getPlugInList(null, null, 5);
        Vector<Format> fmts = new Vector<Format>();
        for (i2 = 0; i2 < names.size(); ++i2) {
            Format[] fs = PlugInManager.getSupportedOutputFormats((String)names.elementAt(i2), 5);
            if (fs == null) continue;
            for (int j2 = 0; j2 < fs.length; ++j2) {
                if (!(fs[j2] instanceof ContentDescriptor)) continue;
                boolean duplicate = false;
                for (int k2 = 0; k2 < fmts.size(); ++k2) {
                    if (!fmts.elementAt(k2).equals(fs[j2])) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                fmts.addElement(fs[j2]);
            }
        }
        ContentDescriptor[] cds = new ContentDescriptor[fmts.size()];
        for (i2 = 0; i2 < fmts.size(); ++i2) {
            cds[i2] = (ContentDescriptor)fmts.elementAt(i2);
        }
        return cds;
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor ocd) throws NotConfiguredError {
        Vector cnames;
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("setContentDescriptor " + NOT_CONFIGURED_ERROR));
        }
        if (this.getState() > 180) {
            return null;
        }
        if (ocd != null && ((cnames = PlugInManager.getPlugInList(null, ocd, 5)) == null || cnames.size() == 0)) {
            return null;
        }
        this.outputContentDes = ocd;
        return this.outputContentDes;
    }

    public ContentDescriptor getContentDescriptor() throws NotConfiguredError {
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("getContentDescriptor " + NOT_CONFIGURED_ERROR));
        }
        return this.outputContentDes;
    }

    public DataSource getDataOutput() throws NotRealizedError {
        if (this.getState() < 300) {
            this.throwError(new NotRealizedError("getDataOutput " + NOT_REALIZED_ERROR));
        }
        if (this.muxModule != null) {
            return this.muxModule.getDataOutput();
        }
        return null;
    }

    protected long getBitRate() {
        if (this.muxModule != null) {
            return this.muxModule.getBitsWritten();
        }
        return this.source.getBitsRead();
    }

    protected void resetBitRate() {
        if (this.muxModule != null) {
            this.muxModule.resetBitsWritten();
        } else {
            this.source.resetBitsRead();
        }
    }

    protected PlugIn getPlugIn(BasicModule m2) {
        if (m2 instanceof BasicMuxModule) {
            return ((BasicMuxModule)m2).getMultiplexer();
        }
        return super.getPlugIn(m2);
    }

    class ProcGraphBuilder
    extends SimpleGraphBuilder {
        protected ProcessEngine engine;
        protected Format targetFormat;
        protected int trackID = 0;
        protected int numTracks = 1;
        protected int nodesVisited = 0;
        Codec[] codecs = null;
        Renderer rend = null;
        Format format = null;

        ProcGraphBuilder(ProcessEngine engine) {
            this.engine = engine;
        }

        public Format[] getSupportedOutputFormats(Format input) {
            long formatsTime = System.currentTimeMillis();
            Vector<Format> collected = new Vector<Format>();
            Vector<GraphNode> candidates = new Vector<GraphNode>();
            GraphNode node = new GraphNode(null, null, input, null, 0);
            candidates.addElement(node);
            collected.addElement(input);
            ++this.nodesVisited;
            while (!candidates.isEmpty()) {
                this.doGetSupportedOutputFormats(candidates, collected);
            }
            Format[] all = new Format[collected.size()];
            int front = 0;
            int back = all.length - 1;
            AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
            boolean mpegInput = new AudioFormat("mpegaudio").matches(input) || new AudioFormat("mpeglayer3").matches(input) || new VideoFormat("mpeg").matches(input);
            for (int i2 = 0; i2 < all.length; ++i2) {
                Object obj = collected.elementAt(i2);
                if (!mpegInput && ((Format)mpegAudio).matches((Format)obj)) {
                    all[back--] = (Format)obj;
                    continue;
                }
                all[front++] = (Format)obj;
            }
            Log.comment("Getting the supported output formats for:");
            Log.comment("  " + input);
            Log.comment("  # of nodes visited: " + this.nodesVisited);
            Log.comment("  # of formats supported: " + all.length + "\n");
            ProcessEngine.profile("getSupportedOutputFormats", formatsTime);
            return all;
        }

        void doGetSupportedOutputFormats(Vector candidates, Vector collected) {
            Format input;
            Format[] outs;
            GraphNode node = (GraphNode)candidates.firstElement();
            candidates.removeElementAt(0);
            if (!(node.input != null || node.plugin != null && node.plugin instanceof Codec)) {
                Log.error("Internal error: doGetSupportedOutputFormats");
                return;
            }
            if (node.plugin != null && ProcGraphBuilder.verifyInput(node.plugin, node.input) == null) {
                return;
            }
            if (node.plugin != null) {
                outs = node.getSupportedOutputs(node.input);
                if (outs == null || outs.length == 0) {
                    return;
                }
                for (int j2 = 0; j2 < outs.length; ++j2) {
                    int size = collected.size();
                    boolean found = false;
                    for (int k2 = 0; k2 < size; ++k2) {
                        Format other = (Format)collected.elementAt(k2);
                        if (other != outs[j2] && !other.equals(outs[j2])) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    collected.addElement(outs[j2]);
                }
                input = node.input;
            } else {
                outs = new Format[]{node.input};
                input = null;
            }
            if (node.level >= this.STAGES) {
                return;
            }
            for (int i2 = 0; i2 < outs.length; ++i2) {
                Vector cnames;
                if (input != null && input.equals(outs[i2]) || node.plugin != null && ProcGraphBuilder.verifyOutput(node.plugin, outs[i2]) == null || (cnames = PlugInManager.getPlugInList(outs[i2], null, 2)) == null || cnames.size() == 0) continue;
                for (int j3 = 0; j3 < cnames.size(); ++j3) {
                    Format[] ins;
                    Format fmt;
                    GraphNode gn = ProcGraphBuilder.getPlugInNode((String)cnames.elementAt(j3), 2, this.plugIns);
                    if (gn == null || gn.checkAttempted(outs[i2]) || (fmt = ProcGraphBuilder.matches(outs[i2], ins = gn.getSupportedInputs(), null, gn.plugin)) == null) continue;
                    GraphNode n2 = new GraphNode(gn, fmt, node, node.level + 1);
                    candidates.addElement(n2);
                    ++this.nodesVisited;
                }
            }
        }

        boolean buildGraph(BasicTrackControl tc, int trackID, int numTracks) {
            this.trackID = trackID;
            this.numTracks = numTracks;
            if (tc.isCustomized()) {
                Log.comment("Input: " + tc.getOriginalFormat());
                return this.buildCustomGraph((ProcTControl)tc);
            }
            return super.buildGraph(tc);
        }

        protected GraphNode buildTrackFromGraph(BasicTrackControl tc, GraphNode node) {
            return this.engine.buildTrackFromGraph((ProcTControl)tc, node);
        }

        GraphNode findTarget(GraphNode node) {
            GraphNode n2;
            Format[] outs;
            if (node.plugin == null) {
                outs = new Format[]{node.input};
            } else if (node.output != null) {
                outs = new Format[]{node.output};
            } else {
                outs = node.getSupportedOutputs(node.input);
                if (outs == null || outs.length == 0) {
                    return null;
                }
            }
            if (this.targetFormat != null) {
                Format matched = null;
                matched = ProcGraphBuilder.matches(outs, this.targetFormat, node.plugin, null);
                if (matched == null) {
                    return null;
                }
                if (inspector != null && !inspector.verify((Codec)node.plugin, node.input, matched)) {
                    return null;
                }
                if (this.targetPlugins == null && ProcessEngine.this.targetMuxes == null) {
                    node.output = matched;
                    return node;
                }
                outs = new Format[]{matched};
            }
            if (this.targetPlugins != null) {
                n2 = this.verifyTargetPlugins(node, outs);
                if (n2 != null) {
                    return n2;
                }
                return null;
            }
            if (ProcessEngine.this.targetMuxes != null && (n2 = this.verifyTargetMuxes(node, outs)) != null) {
                return n2;
            }
            return null;
        }

        GraphNode verifyTargetMuxes(GraphNode node, Format[] outs) {
            for (int i2 = 0; i2 < ProcessEngine.this.targetMuxes.length; ++i2) {
                GraphNode gn = ProcessEngine.this.targetMuxes[i2];
                if (gn == null) {
                    String name = (String)ProcessEngine.this.targetMuxNames.elementAt(i2);
                    if (name == null) continue;
                    gn = ProcGraphBuilder.getPlugInNode(name, 5, this.plugIns);
                    if (gn == null) {
                        ProcessEngine.this.targetMuxNames.setElementAt(null, i2);
                        continue;
                    }
                    Multiplexer mux = (Multiplexer)gn.plugin;
                    if (mux.setContentDescriptor(ProcessEngine.this.outputContentDes) == null) {
                        ProcessEngine.this.targetMuxNames.setElementAt(null, i2);
                        continue;
                    }
                    if (mux.setNumTracks(this.numTracks) != this.numTracks) {
                        ProcessEngine.this.targetMuxNames.setElementAt(null, i2);
                        continue;
                    }
                    ProcessEngine.this.targetMuxes[i2] = gn;
                }
                if (ProcessEngine.this.targetMux != null && gn != ProcessEngine.this.targetMux) continue;
                for (int j2 = 0; j2 < outs.length; ++j2) {
                    Format fmt = ((Multiplexer)gn.plugin).setInputFormat(outs[j2], this.trackID);
                    if (fmt == null || inspector != null && node.plugin != null && !inspector.verify((Codec)node.plugin, node.input, fmt)) continue;
                    ProcessEngine.this.targetMux = gn;
                    ProcessEngine.this.targetMuxFormats[this.trackID] = fmt;
                    node.output = fmt;
                    return node;
                }
            }
            return null;
        }

        boolean setDefaultTargets(Format in) {
            if (ProcessEngine.this.outputContentDes != null) {
                return this.setDefaultTargetMux();
            }
            return this.setDefaultTargetRenderer(in);
        }

        boolean setDefaultTargetRenderer(Format in) {
            if (!super.setDefaultTargetRenderer(in)) {
                return false;
            }
            ProcessEngine.this.targetMuxes = null;
            return true;
        }

        boolean setDefaultTargetMux() {
            if (ProcessEngine.this.targetMuxes != null) {
                return true;
            }
            Log.comment("An output content type is specified: " + ProcessEngine.this.outputContentDes);
            ProcessEngine.this.targetMuxNames = PlugInManager.getPlugInList(null, ProcessEngine.this.outputContentDes, 5);
            if (ProcessEngine.this.targetMuxNames == null || ProcessEngine.this.targetMuxNames.size() == 0) {
                Log.error("No multiplexer is found for that content type: " + ProcessEngine.this.outputContentDes);
                return false;
            }
            ProcessEngine.this.targetMuxes = new GraphNode[ProcessEngine.this.targetMuxNames.size()];
            ProcessEngine.this.targetMux = null;
            ProcessEngine.this.targetMuxFormats = new Format[this.numTracks];
            this.targetPluginNames = null;
            this.targetPlugins = null;
            return true;
        }

        void setTargetPlugin(PlugIn p, int type) {
            this.targetPlugins = new GraphNode[1];
            this.targetPlugins[0] = new GraphNode(p, null, null, 0);
            this.targetPlugins[0].custom = true;
            this.targetPlugins[0].type = type;
        }

        boolean buildCustomGraph(ProcTControl tc) {
            GraphNode failed;
            GraphNode node;
            this.codecs = tc.codecChainWanted;
            this.rend = tc.rendererWanted;
            this.format = tc.formatWanted;
            if (this.format instanceof VideoFormat && tc.getOriginalFormat() instanceof VideoFormat) {
                Dimension s1 = ((VideoFormat)tc.getOriginalFormat()).getSize();
                Dimension s2 = ((VideoFormat)this.format).getSize();
                if (s1 != null && s2 != null && !s1.equals(s2)) {
                    RGBScaler scaler = new RGBScaler(s2);
                    if (this.codecs == null || this.codecs.length == 0) {
                        this.codecs = new Codec[1];
                        this.codecs[0] = scaler;
                    } else {
                        int i2;
                        this.codecs = new Codec[tc.codecChainWanted.length + 1];
                        if (!PlaybackEngine.isRawVideo(this.format)) {
                            this.codecs[0] = scaler;
                            i2 = 1;
                        } else {
                            this.codecs[tc.codecChainWanted.length] = scaler;
                            i2 = 0;
                        }
                        for (int j2 = 0; j2 < tc.codecChainWanted.length; ++j2) {
                            this.codecs[i2++] = tc.codecChainWanted[j2];
                        }
                    }
                }
            }
            return (node = this.buildCustomGraph(tc.getOriginalFormat())) != null && (failed = this.buildTrackFromGraph(tc, node)) == null;
        }

        GraphNode buildCustomGraph(Format in) {
            Vector<GraphNode> candidates = new Vector<GraphNode>();
            Object n2 = null;
            GraphNode node = new GraphNode(null, null, in, null, 0);
            candidates.addElement(node);
            Log.comment("Custom options specified.");
            this.indent = 1;
            Log.setIndent(this.indent);
            if (this.codecs != null) {
                this.resetTargets();
                for (int i2 = 0; i2 < this.codecs.length; ++i2) {
                    if (this.codecs[i2] == null) continue;
                    Log.comment("A custom codec is specified: " + this.codecs[i2]);
                    this.setTargetPlugin(this.codecs[i2], 2);
                    node = this.buildGraph(candidates);
                    if (node == null) {
                        Log.error("The input format is not compatible with the given codec plugin: " + this.codecs[i2]);
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                    node.level = 0;
                    candidates = new Vector();
                    candidates.addElement(node);
                }
            }
            if (ProcessEngine.this.outputContentDes != null) {
                this.resetTargets();
                if (this.format != null) {
                    this.targetFormat = this.format;
                    Log.comment("An output format is specified: " + this.format);
                }
                if (!this.setDefaultTargetMux()) {
                    return null;
                }
                node = this.buildGraph(candidates);
                if (node == null) {
                    Log.error("Failed to build a graph for the given custom options.");
                    this.indent = 0;
                    Log.setIndent(this.indent);
                    return null;
                }
            } else {
                if (this.format != null) {
                    this.resetTargets();
                    this.targetFormat = this.format;
                    Log.comment("An output format is specified: " + this.format);
                    node = this.buildGraph(candidates);
                    if (node == null) {
                        Log.error("The input format cannot be transcoded to the specified target format.");
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                    node.level = 0;
                    candidates = new Vector();
                    candidates.addElement(node);
                    this.targetFormat = null;
                }
                if (this.rend != null) {
                    Log.comment("A custom renderer is specified: " + this.rend);
                    this.setTargetPlugin(this.rend, 4);
                    node = this.buildGraph(candidates);
                    if (node == null) {
                        if (this.format != null) {
                            Log.error("The customed transocoded format is not compatible with the given renderer plugin: " + this.rend);
                        } else {
                            Log.error("The input format is not compatible with the given renderer plugin: " + this.rend);
                        }
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                } else {
                    if (!this.setDefaultTargetRenderer(this.format == null ? in : this.format)) {
                        return null;
                    }
                    node = this.buildGraph(candidates);
                    if (node == null) {
                        if (this.format != null) {
                            Log.error("Failed to find a renderer that supports the customed transcoded format.");
                        } else {
                            Log.error("Failed to build a graph to render the input format with the given custom options.");
                        }
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                }
            }
            this.indent = 0;
            Log.setIndent(this.indent);
            return node;
        }

        public void reset() {
            super.reset();
            this.resetTargets();
        }

        void resetTargets() {
            this.targetFormat = null;
            this.targetPlugins = null;
        }
    }

    class ProcTControl
    extends BasicTrackControl
    implements Owned {
        protected Format formatWanted;
        protected Codec[] codecChainWanted;
        protected Renderer rendererWanted;
        protected ProcGraphBuilder gb;
        protected Format[] supportedFormats;

        public ProcTControl(ProcessEngine engine, Track track, OutputConnector oc) {
            super(engine, track, oc);
            this.formatWanted = null;
            this.codecChainWanted = null;
            this.rendererWanted = null;
            this.supportedFormats = null;
        }

        public Object getOwner() {
            return ProcessEngine.this.player;
        }

        public Format getFormat() {
            return this.formatWanted == null ? this.track.getFormat() : this.formatWanted;
        }

        public Format[] getSupportedFormats() {
            if (this.supportedFormats == null && (this.supportedFormats = Resource.getDB(this.track.getFormat())) == null) {
                if (this.gb == null) {
                    this.gb = new ProcGraphBuilder((ProcessEngine)this.engine);
                } else {
                    this.gb.reset();
                }
                this.supportedFormats = this.gb.getSupportedOutputFormats(this.track.getFormat());
                this.supportedFormats = Resource.putDB(this.track.getFormat(), this.supportedFormats);
                PlaybackEngine.needSavingDB = true;
            }
            if (ProcessEngine.this.outputContentDes != null) {
                return this.verifyMuxInputs(ProcessEngine.this.outputContentDes, this.supportedFormats);
            }
            return this.supportedFormats;
        }

        Format[] verifyMuxInputs(ContentDescriptor cd, Format[] inputs) {
            if (cd == null || cd.getEncoding() == "raw") {
                return inputs;
            }
            Vector cnames = PlugInManager.getPlugInList(null, cd, 5);
            if (cnames == null || cnames.size() == 0) {
                return new Format[0];
            }
            Multiplexer[] mux = new Multiplexer[cnames.size()];
            int total = 0;
            for (int i2 = 0; i2 < cnames.size(); ++i2) {
                Multiplexer m2 = (Multiplexer)SimpleGraphBuilder.createPlugIn((String)cnames.elementAt(i2), 5);
                if (m2 == null) continue;
                try {
                    m2.setContentDescriptor(ProcessEngine.this.outputContentDes);
                }
                catch (Exception e2) {
                    continue;
                }
                if (m2.setNumTracks(1) < 1) continue;
                mux[total++] = m2;
            }
            Format[] tmp = new Format[inputs.length];
            int vtotal = 0;
            block3: for (int i3 = 0; i3 < inputs.length; ++i3) {
                Format fmt;
                if (total == 1) {
                    fmt = mux[0].setInputFormat(inputs[i3], 0);
                    if (fmt == null) continue;
                    tmp[vtotal++] = fmt;
                    continue;
                }
                for (int j2 = 0; j2 < total; ++j2) {
                    fmt = mux[j2].setInputFormat(inputs[i3], 0);
                    if (fmt == null) continue;
                    tmp[vtotal++] = fmt;
                    continue block3;
                }
            }
            Format[] verified = new Format[vtotal];
            System.arraycopy(tmp, 0, verified, 0, vtotal);
            return verified;
        }

        public Format setFormat(Format format) {
            if (this.engine.getState() > 180) {
                return this.getFormat();
            }
            if (format == null || format.matches(this.track.getFormat())) {
                return format;
            }
            this.formatWanted = this.checkSize(format);
            return this.formatWanted;
        }

        private Format checkSize(Format fmt) {
            Format ofmt;
            if (!(fmt instanceof VideoFormat)) {
                return fmt;
            }
            VideoFormat vfmt = (VideoFormat)fmt;
            Dimension size = ((VideoFormat)fmt).getSize();
            if (size == null && ((ofmt = this.getOriginalFormat()) == null || (size = ((VideoFormat)ofmt).getSize()) == null)) {
                return fmt;
            }
            int w = size.width;
            int h2 = size.height;
            if (fmt.matches(new VideoFormat("jpeg/rtp")) || fmt.matches(new VideoFormat("jpeg"))) {
                if (size.width % 8 != 0) {
                    w = size.width / 8 * 8;
                }
                if (size.height % 8 != 0) {
                    h2 = size.height / 8 * 8;
                }
                if (w == 0 || h2 == 0) {
                    w = size.width;
                    h2 = size.height;
                }
            } else if (fmt.matches(new VideoFormat("h263/rtp")) || fmt.matches(new VideoFormat("h263-1998/rtp")) || fmt.matches(new VideoFormat("h263"))) {
                if (size.width >= 352) {
                    w = 352;
                    h2 = 288;
                } else if (size.width >= 160) {
                    w = 176;
                    h2 = 144;
                } else {
                    w = 128;
                    h2 = 96;
                }
            }
            if (w != size.width || h2 != size.height) {
                Log.comment("setFormat: " + fmt.getEncoding() + ": video aspect ratio mismatched.");
                Log.comment("  Scaled from " + size.width + "x" + size.height + " to " + w + "x" + h2 + ".\n");
                fmt = new VideoFormat(null, new Dimension(w, h2), -1, null, -1.0f).intersects(fmt);
            }
            return fmt;
        }

        public boolean buildTrack(int trackID, int numTracks) {
            if (this.gb == null) {
                this.gb = new ProcGraphBuilder((ProcessEngine)this.engine);
            } else {
                this.gb.reset();
            }
            boolean rtn = this.gb.buildGraph(this, trackID, numTracks);
            this.gb = null;
            return rtn;
        }

        public boolean isTimeBase() {
            for (int j2 = 0; j2 < this.modules.size(); ++j2) {
                if (this.modules.elementAt(j2) != ProcessEngine.this.masterSink) continue;
                return true;
            }
            return false;
        }

        public void setCodecChain(Codec[] codec) throws NotConfiguredError, UnsupportedPlugInException {
            if (this.engine.getState() > 180) {
                ProcessEngine.this.throwError(new NotConfiguredError("Cannot set a PlugIn before reaching the configured state."));
            }
            if (codec.length < 1) {
                throw new UnsupportedPlugInException("No codec specified in the array.");
            }
            this.codecChainWanted = new Codec[codec.length];
            for (int i2 = 0; i2 < codec.length; ++i2) {
                this.codecChainWanted[i2] = codec[i2];
            }
        }

        public void setRenderer(Renderer renderer) throws NotConfiguredError {
            if (this.engine.getState() > 180) {
                ProcessEngine.this.throwError(new NotConfiguredError("Cannot set a PlugIn before reaching the configured state."));
            }
            this.rendererWanted = renderer;
            if (renderer instanceof SlowPlugIn) {
                ((SlowPlugIn)((Object)renderer)).forceToUse();
            }
        }

        public boolean isCustomized() {
            return this.formatWanted != null || this.codecChainWanted != null || this.rendererWanted != null;
        }

        public void prError() {
            if (!this.isCustomized()) {
                super.prError();
                return;
            }
            Log.error("  Cannot build a flow graph with the customized options:");
            if (this.formatWanted != null) {
                Log.error("    Unable to transcode format: " + this.getOriginalFormat());
                Log.error("      to: " + this.getFormat());
                if (ProcessEngine.this.outputContentDes != null) {
                    Log.error("      outputting to: " + ProcessEngine.this.outputContentDes);
                }
            }
            if (this.codecChainWanted != null) {
                Log.error("    Unable to add customed codecs: ");
                for (int i2 = 0; i2 < this.codecChainWanted.length; ++i2) {
                    Log.error("      " + this.codecChainWanted[i2]);
                }
            }
            if (this.rendererWanted != null) {
                Log.error("    Unable to add customed renderer: " + this.rendererWanted);
            }
            Log.write("\n");
        }

        protected ProgressControl progressControl() {
            return ProcessEngine.this.progressControl;
        }

        protected FrameRateControl frameRateControl() {
            this.muxModule = ProcessEngine.this.getMuxModule();
            return ProcessEngine.this.frameRateControl;
        }
    }
}

