/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jmpx;

import com.sun.media.renderer.audio.device.JavaSoundOutput;
import javax.media.format.AudioFormat;

public class JmpxAudio
extends JavaSoundOutput {
    private long count = 0L;
    private long JSHackIncr = 0L;
    private long JSHackCount = 0L;
    private long JSHackSample = 0L;
    private long JSHackSampleCount = 0L;
    private Object pauseSync = new Object();
    static final long MAX_TOLERENCE = 50L;
    static final long OFFSET = 0L;
    private int sampleCountLow;
    long lastPos = 0L;
    long originPos = 0L;
    long totalCount = 0L;

    public boolean initialize(AudioFormat format) {
        this.JSHackIncr = (long)(format.getSampleRate() / 60.0);
        return super.initialize(format, JmpxAudio.bufferSize(format));
    }

    public int getSampleCountHigh() {
        long pos = this.dataLine.getFramePosition();
        if (pos < this.lastPos) {
            this.totalCount += this.lastPos - this.originPos;
            this.originPos = pos;
        }
        this.lastPos = pos;
        long s = this.totalCount + pos - this.originPos - this.count + this.JSHackSampleCount;
        if (s == this.JSHackSample) {
            if (this.JSHackCount++ > 50L) {
                this.JSHackSampleCount += this.JSHackIncr;
                this.JSHackCount = 0L;
            }
        } else {
            this.JSHackCount = 0L;
            this.JSHackSample = s;
        }
        this.sampleCountLow = (int)(s & 0xFFFFFFFFL);
        return (int)(s >> 32 & 0xFFFFFFFFL);
    }

    public int getSampleCountLow() {
        return this.sampleCountLow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.pauseSync;
        synchronized (object) {
            super.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.pauseSync;
        synchronized (object) {
            super.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] data, int off, int len) {
        Object object = this.pauseSync;
        synchronized (object) {
            if (this.paused) {
                System.err.println("writing when paused: " + len);
                return len;
            }
            return super.write(data, off, len);
        }
    }

    public void flush() {
        super.flush();
    }

    public void resetSamples() {
        if (this.dataLine != null) {
            this.lastPos = this.count = (long)this.dataLine.getFramePosition();
            this.originPos = this.count;
            this.totalCount = this.count;
        }
        this.JSHackSampleCount = 0L;
    }

    private static int bufferSize(AudioFormat f2) {
        int bufferSize = 0;
        bufferSize = 262144;
        return ++bufferSize;
    }
}

