/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.mpeg;

import com.sun.media.BasicCodec;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;

public class Packetizer
extends BasicCodec {
    public static float[] RATE_TABLE = new float[]{0.0f, 23.976f, 24.0f, 25.0f, 29.97f, 30.0f, 50.0f, 59.94f, 60.0f};
    private static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected static int SEGMENT_DONE = 1;
    protected static int SEGMENT_REPEAT = 2;
    protected static int SEGMENT_DONE_BUFFER_FULL = 3;
    protected static int PACKET_MAX = 1456;
    private static boolean debug = false;
    private VideoFormat inputFormat = null;
    private VideoFormat outputFormat = null;
    private boolean inputEOM = false;
    private boolean expectingNewInput = true;
    private boolean expectingNewOutput = true;
    private boolean resetTime = true;
    private boolean resetInProgress = true;
    private Vector outputQueue = new Vector();
    private Vector inputQueue = new Vector();
    private Vector segmentQueue = new Vector();
    private byte[] sequenceHeader = null;
    private int frameWidth = 0;
    private int frameHeight = 0;
    private double frameRate = 0.0;
    private long picNanos = 0L;
    private long gopTime = 0L;
    private long startTime = 1L;
    private long frameTime = 0L;
    private long frameCount = 0L;
    private int sequenceNumber = 0;
    private byte[] mpegHeader = new byte[]{0, 0, 0, 0};

    public Packetizer() {
        this.inputFormats = new Format[]{new VideoFormat("mpeg")};
        this.outputFormats = new Format[]{new VideoFormat("mpeg/rtp")};
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return this.outputFormats;
        }
        if (Packetizer.matches(in, this.inputFormats) == null) {
            return new Format[0];
        }
        Format[] out = new Format[]{this.makeMPEGFormat(in)};
        return out;
    }

    public Format setInputFormat(Format input) {
        this.inputFormat = (VideoFormat)input;
        return input;
    }

    public Format setOutputFormat(Format output) {
        if (!(output instanceof VideoFormat)) {
            return null;
        }
        this.outputFormat = this.makeMPEGFormat(output);
        return output;
    }

    private final VideoFormat makeMPEGFormat(Format in) {
        VideoFormat vf = (VideoFormat)in;
        return new VideoFormat("mpeg/rtp", vf.getSize(), -1, Format.byteArray, vf.getFrameRate());
    }

    public void open() throws ResourceUnavailableException {
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Incorrect formats set on MPEG converter");
        }
        this.startTime = 1L;
        this.frameRate = 0.0;
        this.picNanos = 0L;
        this.sequenceNumber = 0;
        this.resetTime = true;
    }

    public synchronized void close() {
        this.reset();
    }

    public void reset() {
        super.reset();
        this.outputQueue.removeAllElements();
        this.inputQueue.removeAllElements();
        this.segmentQueue.removeAllElements();
        this.inputEOM = false;
        this.expectingNewInput = true;
        this.expectingNewOutput = true;
        this.resetInProgress = true;
        this.resetTime = true;
        this.sequenceHeader = null;
        this.frameWidth = 0;
        this.frameHeight = 0;
        this.mpegHeader[0] = 0;
        this.mpegHeader[1] = 0;
        this.mpegHeader[2] = 0;
        this.mpegHeader[3] = 0;
        this.gopTime = 1L;
        this.frameTime = 0L;
        this.frameCount = 0L;
        if (debug) {
            System.err.println("Packetizer(V): reset completed");
        }
    }

    public synchronized int process(Buffer inBuffer, Buffer outBuffer) {
        if (this.outputQueue.size() > 0) {
            Buffer qbuf = (Buffer)this.outputQueue.firstElement();
            this.outputQueue.removeElementAt(0);
            outBuffer.setData((byte[])qbuf.getData());
            outBuffer.setOffset(qbuf.getOffset());
            outBuffer.setLength(qbuf.getLength());
            outBuffer.setFlags(qbuf.getFlags());
            outBuffer.setTimeStamp(qbuf.getTimeStamp());
            outBuffer.setSequenceNumber(this.sequenceNumber++);
            outBuffer.setFormat(this.outputFormat);
            this.expectingNewOutput = true;
            return 2;
        }
        if (this.isEOM(inBuffer)) {
            this.inputEOM = true;
            if (this.segmentQueue.isEmpty()) {
                this.propagateEOM(outBuffer);
                outBuffer.setSequenceNumber(this.sequenceNumber++);
                return 0;
            }
        }
        if (inBuffer.isDiscard()) {
            this.updateOutput(outBuffer, this.outputFormat, 0, 0);
            outBuffer.setDiscard(true);
            return 4;
        }
        int retVal = 1;
        try {
            retVal = this.doProcess(inBuffer, outBuffer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 1;
        }
        if (this.outputFormat == null) {
            this.outputFormat = this.makeMPEGFormat(inBuffer.getFormat());
        }
        if (retVal != 4) {
            outBuffer.setSequenceNumber(this.sequenceNumber++);
        }
        return retVal;
    }

    public String getName() {
        return "MPEG Video Packetizer";
    }

    public void finalize() {
        this.close();
    }

    private int doProcess(Buffer inBuffer, Buffer outBuffer) {
        if (this.expectingNewInput) {
            if (!this.inputEOM) {
                if (inBuffer.getData() == null) {
                    return 4;
                }
                if (this.resetTime) {
                    this.startTime = inBuffer.getTimeStamp();
                    if (debug) {
                        System.err.println("Packetizer(V): new synctime set: " + this.startTime);
                    }
                    if (this.startTime == 0L) {
                        this.startTime = 1L;
                    }
                    this.resetTime = false;
                }
                this.inputQueue.addElement(this.copyInto(inBuffer));
            }
            this.expectingNewInput = false;
        }
        if (this.expectingNewOutput) {
            byte[] outData = (byte[])outBuffer.getData();
            if (outData == null || outData.length < PACKET_MAX) {
                outData = new byte[PACKET_MAX];
                outBuffer.setData(outData);
            }
            System.arraycopy(this.mpegHeader, 0, outData, 0, 4);
            outBuffer.setOffset(0);
            outBuffer.setLength(4);
            outBuffer.setFlags(0);
            outBuffer.setHeader(null);
            outBuffer.setFormat(this.outputFormat);
            this.expectingNewOutput = false;
        }
        if (this.segmentQueue.isEmpty()) {
            this.findFirstStartCode();
            if (this.segmentQueue.isEmpty()) {
                this.expectingNewInput = true;
                return 4;
            }
        }
        MPEGSegment mseg = (MPEGSegment)this.segmentQueue.firstElement();
        while (mseg != null) {
            if (mseg.getLength() < 0) {
                this.expectingNewInput = true;
                return 4;
            }
            int startCode = mseg.startCode;
            int res = 0;
            res = startCode == 179 ? this.doSequenceHeader(mseg, outBuffer) : (startCode == 183 ? this.doSequenceEnd(mseg, outBuffer) : (startCode == 184 ? this.doGOP(mseg, outBuffer) : (startCode == 0 ? this.doPicture(mseg, outBuffer) : (startCode >= 1 && startCode <= 175 ? this.doSlice(mseg, outBuffer) : SEGMENT_DONE))));
            if (res == SEGMENT_DONE) {
                this.segmentQueue.removeElementAt(0);
                if (this.segmentQueue.isEmpty()) {
                    this.expectingNewInput = true;
                    if (outBuffer.getLength() > 4) {
                        return 0;
                    }
                    return 4;
                }
                mseg = (MPEGSegment)this.segmentQueue.firstElement();
                continue;
            }
            if (res == SEGMENT_DONE_BUFFER_FULL) {
                this.segmentQueue.removeElementAt(0);
                outBuffer.setFlags(outBuffer.getFlags() | 0x20);
                if (this.expectingNewInput) {
                    return 0;
                }
                return 2;
            }
            if (res != SEGMENT_REPEAT) continue;
            outBuffer.setFlags(outBuffer.getFlags() | 0x20);
            if (this.expectingNewInput) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    private Buffer copyInto(Buffer src) {
        Buffer dest = new Buffer();
        dest.copy(src);
        dest.setFlags(dest.getFlags() | 0x20);
        src.setData(null);
        src.setHeader(null);
        src.setLength(0);
        src.setOffset(0);
        return dest;
    }

    protected String toHex(byte[] inData, int inOffset) {
        String hex = new String();
        for (int i2 = 0; i2 < 4; ++i2) {
            hex = hex + hexChar[inData[inOffset + i2] >> 4 & 0xF];
            hex = hex + hexChar[inData[inOffset + i2] & 0xF];
        }
        return hex;
    }

    private int doSequenceHeader(MPEGSegment sh, Buffer outBuffer) {
        this.sequenceHeader = new byte[sh.getLength()];
        sh.copyData(this.sequenceHeader, 0);
        this.frameWidth = (this.sequenceHeader[4] & 0xFF) << 4 | (this.sequenceHeader[5] & 0xF0) >> 4;
        this.frameHeight = (this.sequenceHeader[5] & 0xF) << 8 | this.sequenceHeader[6] & 0xFF;
        int frix = this.sequenceHeader[7] & 0xF;
        if (frix > 0 && frix <= 8) {
            this.frameRate = RATE_TABLE[frix];
        }
        this.picNanos = (long)(1.0E9 / this.frameRate);
        return SEGMENT_DONE;
    }

    private int copySequenceHeader(Buffer outBuffer) {
        if (this.sequenceHeader == null) {
            return 0;
        }
        System.arraycopy(this.sequenceHeader, 0, outBuffer.getData(), outBuffer.getLength(), this.sequenceHeader.length);
        outBuffer.setLength(outBuffer.getLength() + this.sequenceHeader.length);
        return this.sequenceHeader.length;
    }

    private int doSequenceEnd(MPEGSegment se, Buffer outBuffer) {
        return SEGMENT_DONE;
    }

    private int doGOP(MPEGSegment gop, Buffer outBuffer) {
        this.gopTime = this.frameCount == 0L ? 1L + this.startTime : this.frameCount * this.picNanos + this.startTime;
        this.copySequenceHeader(outBuffer);
        gop.copyData((byte[])outBuffer.getData(), outBuffer.getLength());
        outBuffer.setLength(outBuffer.getLength() + gop.getLength());
        return SEGMENT_DONE;
    }

    private int doPicture(MPEGSegment ph, Buffer outBuffer) {
        byte[] pic = new byte[ph.getLength()];
        ph.copyData(pic, 0);
        int cnt = (pic[4] & 0xFF) << 2 | (pic[5] & 0xC0) >> 6;
        int type = (pic[5] & 0x38) >> 3;
        this.mpegHeader[0] = (byte)(cnt >> 8 & 2);
        this.mpegHeader[1] = (byte)cnt;
        this.mpegHeader[2] = (byte)type;
        if (type == 1) {
            this.mpegHeader[3] = 0;
        } else {
            int next = (pic[7] & 7) << 1 | (pic[8] & 0x80) >> 7;
            if (type > 2) {
                next |= (pic[8] & 0x78) << 1;
            }
            this.mpegHeader[3] = (byte)next;
        }
        this.resetInProgress = false;
        byte[] outData = (byte[])outBuffer.getData();
        System.arraycopy(this.mpegHeader, 0, outData, 0, 4);
        if (outBuffer.getLength() > 8 && outData[4] == 0 && outData[5] == 0 && outData[6] == 1 && (outData[7] & 0xFF) == 179) {
            outData[2] = (byte)(outData[2] | 0x20);
        }
        ph.copyData((byte[])outBuffer.getData(), outBuffer.getLength());
        outBuffer.setLength(outBuffer.getLength() + ph.getLength());
        outBuffer.setFlags(outBuffer.getFlags() | 0x10);
        ++this.frameCount;
        this.frameTime = this.gopTime + (long)cnt * this.picNanos;
        outBuffer.setTimeStamp(this.frameTime);
        outBuffer.setFormat(this.outputFormat);
        return SEGMENT_DONE;
    }

    private int doSlice(MPEGSegment slice, Buffer outBuffer) {
        byte[] outData = (byte[])outBuffer.getData();
        if (slice.getLength() < PACKET_MAX - outBuffer.getLength()) {
            slice.copyData(outData, outBuffer.getLength());
            outBuffer.setLength(outBuffer.getLength() + slice.getLength());
            outBuffer.setTimeStamp(this.frameTime);
            outBuffer.setFormat(this.outputFormat);
            outData[2] = (byte)(outData[2] | 0x18);
            if (this.segmentQueue.size() > 1) {
                MPEGSegment mse = (MPEGSegment)this.segmentQueue.elementAt(1);
                if (mse.startCode < 1 || mse.startCode > 175) {
                    outBuffer.setFlags(outBuffer.getFlags() | 0x800);
                    this.expectingNewOutput = true;
                    return SEGMENT_DONE_BUFFER_FULL;
                }
            } else if (this.inputEOM) {
                outBuffer.setFlags(outBuffer.getFlags() | 0x800);
                this.expectingNewOutput = true;
                return SEGMENT_DONE_BUFFER_FULL;
            }
            return SEGMENT_DONE;
        }
        if ((outData[2] & 0x18) != 0) {
            this.expectingNewOutput = true;
            return SEGMENT_REPEAT;
        }
        int len = PACKET_MAX - outBuffer.getLength();
        slice.copyData(0, len, outData, outBuffer.getLength());
        outBuffer.setLength(outBuffer.getLength() + len);
        outBuffer.setTimeStamp(this.frameTime);
        outBuffer.setFormat(this.outputFormat);
        outData[2] = (byte)(outData[2] | 0x10);
        int off = len;
        len = slice.getLength() - len;
        Buffer b2 = null;
        while (len > 0) {
            b2 = new Buffer();
            outData = new byte[PACKET_MAX];
            b2.setData(outData);
            b2.setTimeStamp(this.frameTime);
            b2.setHeader(null);
            b2.setFormat(this.outputFormat);
            b2.setFlags(outBuffer.getFlags());
            b2.setOffset(0);
            System.arraycopy(this.mpegHeader, 0, outData, 0, 4);
            int l2 = len;
            if (len > PACKET_MAX - 4) {
                l2 = PACKET_MAX - 4;
            }
            slice.copyData(off, l2, (byte[])b2.getData(), 4);
            b2.setLength(l2 + 4);
            off += l2;
            if ((len -= l2) <= 0) {
                outData[2] = (byte)(outData[2] | 8);
            }
            this.outputQueue.addElement(b2);
        }
        if (this.segmentQueue.size() > 1) {
            MPEGSegment mse = (MPEGSegment)this.segmentQueue.elementAt(1);
            if (mse.startCode < 1 || mse.startCode > 175) {
                b2.setFlags(b2.getFlags() | 0x800);
                this.expectingNewOutput = true;
                return SEGMENT_DONE_BUFFER_FULL;
            }
        } else if (this.inputEOM) {
            b2.setFlags(b2.getFlags() | 0x800);
            this.expectingNewOutput = true;
            return SEGMENT_DONE_BUFFER_FULL;
        }
        this.expectingNewOutput = true;
        return SEGMENT_DONE_BUFFER_FULL;
    }

    private void findFirstStartCode() {
        if (this.inputQueue.isEmpty()) {
            return;
        }
        Buffer inBuffer = (Buffer)this.inputQueue.firstElement();
        this.inputQueue.removeElementAt(0);
        byte[] inData = (byte[])inBuffer.getData();
        int off = inBuffer.getOffset();
        for (int len = inBuffer.getLength(); len > 4; --len) {
            if (inData[off] == 0 && inData[off + 1] == 0 && inData[off + 2] == 1 && (inData[off + 3] & 0xFF) != 181 && (inData[off + 3] & 0xFF) != 178) {
                if (this.resetInProgress) {
                    if ((inData[off + 3] & 0xFF) == 179 || (inData[off + 3] & 0xFF) == 184) {
                        MPEGSegment ns = new MPEGSegment(inData[off + 3] & 0xFF, off, inBuffer);
                        this.segmentQueue.addElement(ns);
                        return;
                    }
                } else {
                    MPEGSegment ns = new MPEGSegment(inData[off + 3] & 0xFF, off, inBuffer);
                    this.segmentQueue.addElement(ns);
                    return;
                }
            }
            ++off;
        }
        this.expectingNewInput = true;
    }

    class MPEGSegment {
        int startCode = -1;
        int offset = -1;
        int length = -1;
        Buffer startBuffer = null;
        Buffer endBuffer = null;

        MPEGSegment(int code, int off, Buffer buf) {
            this.startCode = code;
            this.offset = off;
            this.startBuffer = buf;
        }

        void copyData(byte[] dest, int outoffset) {
            this.copyData(0, this.length, dest, outoffset);
        }

        void copyData(int off, byte[] dest, int outoffset) {
            this.copyData(off, this.length - off, dest, outoffset);
        }

        void copyData(int off, int len, byte[] dest, int outoffset) {
            if (off + len > this.length) {
                len = this.length - off;
            }
            if (this.endBuffer == null) {
                System.arraycopy(this.startBuffer.getData(), this.offset + off, dest, outoffset, len);
                return;
            }
            int len1 = this.startBuffer.getLength() - (this.offset - this.startBuffer.getOffset());
            int len2 = this.length - len1;
            if (off + len <= len1) {
                System.arraycopy(this.startBuffer.getData(), this.offset + off, dest, outoffset, len);
                return;
            }
            if (off >= len1) {
                System.arraycopy(this.endBuffer.getData(), this.endBuffer.getOffset() + (off -= len1), dest, outoffset, len);
                return;
            }
            int l2 = len1 - off;
            System.arraycopy(this.startBuffer.getData(), this.offset + off, dest, outoffset, l2);
            System.arraycopy(this.endBuffer.getData(), this.endBuffer.getOffset(), dest, outoffset + l2, len -= l2);
        }

        int getLength() {
            if (this.length < 0) {
                this.calculateLength();
            }
            return this.length;
        }

        private void calculateLength() {
            if (this.length > 0) {
                return;
            }
            int off = this.findNextStart();
            if (off > this.offset) {
                this.length = off - this.offset;
                return;
            }
            if (Packetizer.this.inputEOM) {
                this.length = this.startBuffer.getLength() - (this.offset - this.startBuffer.getOffset());
                return;
            }
            if (this.endBuffer == null) {
                if (Packetizer.this.inputQueue.isEmpty()) {
                    return;
                }
                this.endBuffer = (Buffer)Packetizer.this.inputQueue.firstElement();
                Packetizer.this.inputQueue.removeElementAt(0);
            }
            if ((off = this.findNextStartBetweenBuffers()) > this.offset) {
                this.length = off - this.offset;
                return;
            }
            off = this.findNextStartInEndBuffer();
            this.length = this.startBuffer.getLength() - (this.offset - this.startBuffer.getOffset());
            this.length += off - this.endBuffer.getOffset();
        }

        private int findNextStart() {
            byte[] inData = (byte[])this.startBuffer.getData();
            int off = this.offset + 4;
            for (int len = this.startBuffer.getLength() - (this.offset + 4 - this.startBuffer.getOffset()); len > 3; --len) {
                if (inData[off] == 0 && inData[off + 1] == 0 && inData[off + 2] == 1 && (inData[off + 3] & 0xFF) != 181 && (inData[off + 3] & 0xFF) != 178) {
                    MPEGSegment ns = new MPEGSegment(inData[off + 3] & 0xFF, off, this.startBuffer);
                    Packetizer.this.segmentQueue.addElement(ns);
                    return off;
                }
                ++off;
            }
            return -1;
        }

        private int findNextStartBetweenBuffers() {
            byte[] inData = (byte[])this.startBuffer.getData();
            byte[] inData2 = (byte[])this.endBuffer.getData();
            int off = this.startBuffer.getOffset() + this.startBuffer.getLength() - 3;
            if (off <= this.offset) {
                return -1;
            }
            int off2 = this.endBuffer.getOffset();
            if (inData[off] == 0 && inData[off + 1] == 0 && inData[off + 2] == 1 && (inData2[off2] & 0xFF) != 181 && (inData[off2] & 0xFF) != 178) {
                MPEGSegment ns = new MPEGSegment(inData2[off2] & 0xFF, off, this.startBuffer);
                ns.endBuffer = this.endBuffer;
                Packetizer.this.segmentQueue.addElement(ns);
                this.endBuffer = null;
                return off;
            }
            if (inData[off + 1] == 0 && inData[off + 2] == 0 && inData2[off2] == 1 && (inData2[off2 + 1] & 0xFF) != 181 && (inData[off2 + 1] & 0xFF) != 178) {
                MPEGSegment ns = new MPEGSegment(inData2[off2 + 1] & 0xFF, off + 1, this.startBuffer);
                ns.endBuffer = this.endBuffer;
                Packetizer.this.segmentQueue.addElement(ns);
                this.endBuffer = null;
                return off + 1;
            }
            if (inData[off + 2] == 0 && inData2[off2] == 0 && inData2[off2 + 1] == 1 && (inData2[off2 + 2] & 0xFF) != 181 && (inData[off2 + 2] & 0xFF) != 178) {
                MPEGSegment ns = new MPEGSegment(inData2[off2 + 2] & 0xFF, off + 2, this.startBuffer);
                ns.endBuffer = this.endBuffer;
                Packetizer.this.segmentQueue.addElement(ns);
                this.endBuffer = null;
                return off + 2;
            }
            return -1;
        }

        private int findNextStartInEndBuffer() {
            byte[] inData = (byte[])this.endBuffer.getData();
            int off = this.endBuffer.getOffset();
            for (int len = this.endBuffer.getLength(); len > 3; --len) {
                if (inData[off] == 0 && inData[off + 1] == 0 && inData[off + 2] == 1 && (inData[off + 3] & 0xFF) != 181 && (inData[off + 3] & 0xFF) != 178) {
                    MPEGSegment ns = new MPEGSegment(inData[off + 3] & 0xFF, off, this.endBuffer);
                    Packetizer.this.segmentQueue.addElement(ns);
                    return off;
                }
                ++off;
            }
            return -1;
        }
    }
}

