/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.video.mpeg;

import com.sun.media.BasicPlayer;
import com.sun.media.codec.video.jmpx.Jmpx;
import java.awt.Component;
import java.io.IOException;
import javax.media.ControllerEvent;
import javax.media.GainChangeEvent;
import javax.media.IncompatibleSourceException;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;

public class Handler
extends BasicPlayer {
    private static final int ZoomedIn = 1;
    private static final int ZoomedOut = -1;
    private boolean reloaded = true;
    private int type;
    protected Jmpx jmpx;
    boolean streaming = false;
    private static int sizeChangeWidth = -1;

    public Handler() {
        this(0);
    }

    public Handler(int type) {
        this.type = type;
        this.jmpx = new Jmpx(type);
        this.manageController(this.jmpx);
    }

    public void doClose() {
        super.doClose();
        this.jmpx = null;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        super.setSource(source);
        this.jmpx.setSource(source);
    }

    protected TimeBase getMasterTimeBase() {
        return this.jmpx.getTimeBase();
    }

    public Component getVisualComponent() {
        super.getVisualComponent();
        return this.jmpx.getVisualComponent();
    }

    public void updateStats() {
    }

    protected boolean audioEnabled() {
        return this.jmpx.getStreamType() != 2;
    }

    protected boolean videoEnabled() {
        return this.jmpx.getStreamType() != 4;
    }

    public void muteChange(boolean m2) {
        this.jmpx.setMute(m2);
    }

    public void gainChange(GainChangeEvent gce) {
        this.jmpx.setGain(gce.getLevel());
    }

    public void mute(boolean m2) {
        if (this.jmpx.isInitialized()) {
            this.jmpx.mute(m2);
        }
    }

    public boolean isMuted() {
        return this.jmpx.isMuted();
    }

    public void setAudioMode(int m2) {
        if (this.jmpx.isInitialized()) {
            this.jmpx.setAudioMode(m2);
        }
    }

    public void setAudioQuality(int q) {
        if (this.jmpx.isInitialized()) {
            this.jmpx.setAudioQuality(q);
        }
    }

    public void processEvent(ControllerEvent evt) {
        super.processEvent(evt);
    }
}

