/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.BasicClock;
import com.sun.media.BasicPlugIn;
import com.sun.media.CircularBuffer;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.MediaTimeBase;
import com.sun.media.controls.MonitorAdapter;
import com.sun.media.protocol.BasicPushBufferDataSource;
import com.sun.media.protocol.BasicSourceStream;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Format;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Multiplexer;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferStream;

public class RawBufferMux
extends BasicPlugIn
implements Multiplexer,
Clock {
    protected ContentDescriptor[] supported = null;
    protected ContentDescriptor contentDesc = null;
    protected RawBufferDataSource source = null;
    protected RawBufferSourceStream[] streams = null;
    protected BasicClock clock = null;
    protected RawMuxTimeBase timeBase = null;
    protected long[] mediaTime;
    protected int masterTrackID = -1;
    boolean sourceDisconnected = false;
    boolean allowDrop = false;
    boolean hasRead = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    protected int numTracks = 0;
    protected Format[] trackFormats;
    protected MonitorAdapter[] mc = null;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    Object timeSetSync = new Object();
    boolean started = false;
    long systemStartTime = -1L;
    long mediaStartTime = -1L;
    static /* synthetic */ Class class$com$sun$media$util$MediaThread;

    public RawBufferMux() {
        this.supported = new ContentDescriptor[1];
        this.supported[0] = new ContentDescriptor("raw");
        this.timeBase = new RawMuxTimeBase();
        this.clock = new BasicClock();
        try {
            this.clock.setTimeBase(this.timeBase);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getName() {
        return "Raw Buffer Multiplexer";
    }

    public void open() throws ResourceUnavailableException {
        int i2;
        this.initializeTracks(this.trackFormats);
        if (this.source == null || this.source.getStreams() == null) {
            throw new ResourceUnavailableException("DataSource and SourceStreams were not created succesfully.");
        }
        try {
            this.source.connect();
        }
        catch (IOException e2) {
            throw new ResourceUnavailableException(e2.getMessage());
        }
        int len = 0;
        this.mediaTime = new long[this.trackFormats.length];
        this.mc = new MonitorAdapter[this.trackFormats.length];
        for (i2 = 0; i2 < this.trackFormats.length; ++i2) {
            this.mediaTime[i2] = 0L;
            if (!(this.trackFormats[i2] instanceof VideoFormat) && !(this.trackFormats[i2] instanceof AudioFormat)) continue;
            this.mc[i2] = new MonitorAdapter(this.trackFormats[i2], this);
            if (this.mc[i2] == null) continue;
            ++len;
        }
        int j2 = 0;
        this.controls = new Control[len];
        for (i2 = 0; i2 < this.mc.length; ++i2) {
            if (this.mc[i2] == null) continue;
            this.controls[j2++] = this.mc[i2];
        }
    }

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                this.source.disconnect();
            }
            catch (IOException e2) {
                // empty catch block
            }
            this.source = null;
        }
        for (int i2 = 0; i2 < this.mc.length; ++i2) {
            if (this.mc[i2] == null) continue;
            this.mc[i2].close();
        }
    }

    public void reset() {
        for (int i2 = 0; i2 < this.streams.length; ++i2) {
            this.streams[i2].reset();
            if (this.mc[i2] == null) continue;
            this.mc[i2].reset();
        }
    }

    public ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] fmt) {
        return this.supported;
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat(null), new VideoFormat(null)};
    }

    public DataSource getDataOutput() {
        return this.source;
    }

    public int setNumTracks(int nTracks) {
        this.numTracks = nTracks;
        this.trackFormats = new Format[nTracks];
        for (int i2 = 0; i2 < nTracks; ++i2) {
            this.trackFormats[i2] = null;
        }
        return nTracks;
    }

    public Format setInputFormat(Format input, int trackID) {
        if (trackID < this.numTracks) {
            this.trackFormats[trackID] = input;
        }
        for (int i2 = 0; i2 < this.numTracks; ++i2) {
            if (this.trackFormats[i2] != null) continue;
            return input;
        }
        return input;
    }

    public boolean initializeTracks(Format[] trackFormats) {
        if (this.source.getStreams() != null) {
            throw new Error("initializeTracks has been called previously. ");
        }
        this.source.initialize(trackFormats);
        this.streams = (RawBufferSourceStream[])this.source.getStreams();
        return true;
    }

    public int process(Buffer buffer, int trackID) {
        if ((buffer.getFlags() & 0x1000) != 0) {
            buffer.setFlags(buffer.getFlags() & 0xFFFFEFFF | 0x100);
        }
        if (this.mc[trackID] != null && this.mc[trackID].isEnabled()) {
            this.mc[trackID].process(buffer);
        }
        if (this.streams == null || buffer == null || trackID >= this.streams.length) {
            return 1;
        }
        this.updateTime(buffer, trackID);
        return this.streams[trackID].process(buffer);
    }

    protected void updateTime(Buffer buf, int trackID) {
        if (buf.getFormat() instanceof AudioFormat) {
            if (mpegAudio.matches(buf.getFormat())) {
                if (buf.getTimeStamp() < 0L) {
                    if (this.systemStartTime >= 0L) {
                        this.mediaTime[trackID] = (this.mediaStartTime + System.currentTimeMillis() - this.systemStartTime) * 1000000L;
                    }
                } else {
                    this.mediaTime[trackID] = buf.getTimeStamp();
                }
            } else {
                long t = ((AudioFormat)buf.getFormat()).computeDuration(buf.getLength());
                if (t >= 0L) {
                    int n2 = trackID;
                    this.mediaTime[n2] = this.mediaTime[n2] + t;
                } else {
                    this.mediaTime[trackID] = buf.getTimeStamp();
                }
            }
        } else if (buf.getTimeStamp() < 0L) {
            if (this.systemStartTime >= 0L) {
                this.mediaTime[trackID] = (this.mediaStartTime + System.currentTimeMillis() - this.systemStartTime) * 1000000L;
            }
        } else {
            this.mediaTime[trackID] = buf.getTimeStamp();
        }
        this.timeBase.update();
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor outputContentDescriptor) {
        if (RawBufferMux.matches(outputContentDescriptor, this.supported) == null) {
            return null;
        }
        this.contentDesc = outputContentDescriptor;
        this.source = new RawBufferDataSource();
        return this.contentDesc;
    }

    public void setTimeBase(TimeBase master) throws IncompatibleTimeBaseException {
        if (master != this.timeBase) {
            throw new IncompatibleTimeBaseException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncStart(Time at) {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.clock.syncStart(at);
            this.timeBase.mediaStarted();
            this.systemStartTime = System.currentTimeMillis();
            this.mediaStartTime = this.getMediaNanoseconds() / 1000000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            this.clock.stop();
            this.timeBase.mediaStopped();
        }
    }

    public void setStopTime(Time stopTime) {
        this.clock.setStopTime(stopTime);
    }

    public Time getStopTime() {
        return this.clock.getStopTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMediaTime(Time now) {
        Object object = this.timeSetSync;
        synchronized (object) {
            this.clock.setMediaTime(now);
            for (int i2 = 0; i2 < this.mediaTime.length; ++i2) {
                this.mediaTime[i2] = now.getNanoseconds();
            }
            this.timeBase.update();
            this.systemStartTime = System.currentTimeMillis();
            this.mediaStartTime = now.getNanoseconds() / 1000000L;
        }
    }

    public Time getMediaTime() {
        return this.clock.getMediaTime();
    }

    public long getMediaNanoseconds() {
        return this.clock.getMediaNanoseconds();
    }

    public Time getSyncTime() {
        return this.clock.getSyncTime();
    }

    public TimeBase getTimeBase() {
        return this.clock.getTimeBase();
    }

    public Time mapToTimeBase(Time t) throws ClockStoppedException {
        return this.clock.mapToTimeBase(t);
    }

    public float getRate() {
        return this.clock.getRate();
    }

    public float setRate(float factor) {
        if (factor == this.clock.getRate()) {
            return factor;
        }
        return this.clock.setRate(1.0f);
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    class RawBufferSourceStream
    extends BasicSourceStream
    implements PushBufferStream,
    Runnable {
        Format format = null;
        CircularBuffer bufferQ;
        boolean started = false;
        Object startReq = new Integer(0);
        BufferTransferHandler handler = null;
        Thread streamThread = null;
        boolean closed = false;
        boolean draining = false;
        Object drainSync = new Object();

        public RawBufferSourceStream(Format fmt) {
            this.contentDescriptor = RawBufferMux.this.contentDesc;
            this.format = fmt;
            this.bufferQ = new CircularBuffer(5);
            if (jmfSecurity != null) {
                String permission = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        permission = "thread";
                        jmfSecurity.requestPermission(RawBufferMux.this.m, RawBufferMux.this.cl, RawBufferMux.this.args, 16);
                        RawBufferMux.this.m[0].invoke((Object)RawBufferMux.this.cl[0], RawBufferMux.this.args[0]);
                        permission = "thread group";
                        jmfSecurity.requestPermission(RawBufferMux.this.m, RawBufferMux.this.cl, RawBufferMux.this.args, 32);
                        RawBufferMux.this.m[0].invoke((Object)RawBufferMux.this.cl[0], RawBufferMux.this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                    }
                }
                catch (Throwable e2) {
                    securityPrivelege = false;
                }
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                RawBufferSourceStream rbss = this;
                try {
                    Constructor cons = jdk12CreateThreadRunnableAction.cons;
                    this.streamThread = (MediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$util$MediaThread == null ? (class$com$sun$media$util$MediaThread = RawBufferMux.class$("com.sun.media.util.MediaThread")) : class$com$sun$media$util$MediaThread, this));
                }
                catch (Exception e3) {}
            } else {
                this.streamThread = new MediaThread(this, "RawBufferStream Thread");
            }
            if (this.streamThread != null) {
                this.streamThread.start();
            }
        }

        public Format getFormat() {
            return this.format;
        }

        public void setTransferHandler(BufferTransferHandler handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void read(Buffer buffer) throws IOException {
            if (this.closed) {
                throw new IOException("The source stream is closed");
            }
            Buffer current = null;
            Object object = this.bufferQ;
            synchronized (object) {
                while (!this.bufferQ.canRead()) {
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception e2) {}
                }
                current = this.bufferQ.read();
            }
            if (current.isEOM()) {
                object = this.drainSync;
                synchronized (object) {
                    if (this.draining) {
                        this.draining = false;
                        this.drainSync.notifyAll();
                    }
                }
            }
            Object data = buffer.getData();
            Object hdr = buffer.getHeader();
            buffer.copy(current);
            current.setData(data);
            current.setHeader(hdr);
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                RawBufferMux.this.hasRead = true;
                this.bufferQ.readReport();
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void start() {
            Object object = this.startReq;
            synchronized (object) {
                if (this.started) {
                    return;
                }
                this.started = true;
                this.startReq.notifyAll();
            }
            object = this.bufferQ;
            synchronized (object) {
                RawBufferMux.this.hasRead = true;
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stop() {
            Object object = this.startReq;
            synchronized (object) {
                this.started = false;
            }
            object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close() {
            this.closed = true;
            if (this.streamThread != null) {
                try {
                    this.reset();
                    Object object = this.startReq;
                    synchronized (object) {
                        this.startReq.notifyAll();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reset() {
            Object object = this.bufferQ;
            synchronized (object) {
                while (this.bufferQ.canRead()) {
                    Buffer b2 = this.bufferQ.read();
                    this.bufferQ.readReport();
                }
                this.bufferQ.notifyAll();
            }
            object = this.drainSync;
            synchronized (object) {
                if (this.draining) {
                    this.draining = false;
                    this.drainSync.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int process(Buffer filled) {
            Buffer buffer;
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                Buffer tmp;
                if (RawBufferMux.this.allowDrop && !this.bufferQ.canWrite() && this.bufferQ.canRead() && ((tmp = this.bufferQ.peek()).getFlags() & 0x20) == 0) {
                    this.bufferQ.read();
                    this.bufferQ.readReport();
                }
                while (!this.bufferQ.canWrite() && !this.closed) {
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception e2) {}
                }
                if (this.closed) {
                    return 0;
                }
                buffer = this.bufferQ.getEmptyBuffer();
            }
            Object bdata = buffer.getData();
            Object bheader = buffer.getHeader();
            buffer.setData(filled.getData());
            buffer.setHeader(filled.getHeader());
            filled.setData(bdata);
            filled.setHeader(bheader);
            buffer.setLength(filled.getLength());
            buffer.setEOM(filled.isEOM());
            buffer.setFlags(filled.getFlags());
            buffer.setTimeStamp(filled.getTimeStamp());
            buffer.setFormat(filled.getFormat());
            buffer.setOffset(filled.getOffset());
            buffer.setSequenceNumber(filled.getSequenceNumber());
            if (filled.isEOM()) {
                this.draining = true;
            }
            Object object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.writeReport();
                this.bufferQ.notifyAll();
            }
            if (filled.isEOM()) {
                object = this.drainSync;
                synchronized (object) {
                    try {
                        if (this.draining) {
                            this.drainSync.wait(3000L);
                        }
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    Object object = this.startReq;
                    synchronized (object) {
                        while (!this.started && !this.closed) {
                            this.startReq.wait();
                        }
                    }
                    object = this.bufferQ;
                    synchronized (object) {
                        do {
                            if (!RawBufferMux.this.hasRead) {
                                this.bufferQ.wait(250L);
                            }
                            RawBufferMux.this.hasRead = false;
                        } while (!this.bufferQ.canRead() && !this.closed && this.started);
                    }
                    if (this.closed) {
                        return;
                    }
                    if (!this.started || this.handler == null) continue;
                    this.handler.transferData(this);
                }
            }
            catch (InterruptedException e2) {
                System.err.println("Thread " + e2.getMessage());
                return;
            }
        }
    }

    class RawBufferDataSource
    extends BasicPushBufferDataSource {
        public RawBufferDataSource() {
            if (RawBufferMux.this.contentDesc == null) {
                return;
            }
            this.contentType = RawBufferMux.this.contentDesc.getContentType();
        }

        public PushBufferStream[] getStreams() {
            return RawBufferMux.this.streams;
        }

        public void start() throws IOException {
            super.start();
            for (int i2 = 0; i2 < RawBufferMux.this.streams.length; ++i2) {
                RawBufferMux.this.streams[i2].start();
            }
        }

        public void stop() throws IOException {
            super.stop();
            for (int i2 = 0; i2 < RawBufferMux.this.streams.length; ++i2) {
                RawBufferMux.this.streams[i2].stop();
            }
        }

        public void connect() throws IOException {
            super.connect();
            RawBufferMux.this.sourceDisconnected = false;
        }

        public void disconnect() {
            super.disconnect();
            RawBufferMux.this.sourceDisconnected = true;
            for (int i2 = 0; i2 < RawBufferMux.this.streams.length; ++i2) {
                RawBufferMux.this.streams[i2].stop();
                RawBufferMux.this.streams[i2].close();
            }
        }

        private void initialize(Format[] trackFormats) {
            RawBufferMux.this.streams = new RawBufferSourceStream[trackFormats.length];
            for (int i2 = 0; i2 < trackFormats.length; ++i2) {
                RawBufferMux.this.streams[i2] = new RawBufferSourceStream(trackFormats[i2]);
            }
        }
    }

    class RawMuxTimeBase
    extends MediaTimeBase {
        long ticks = 0L;
        boolean updated = false;

        RawMuxTimeBase() {
        }

        public long getMediaTime() {
            if (RawBufferMux.this.masterTrackID >= 0) {
                return RawBufferMux.this.mediaTime[RawBufferMux.this.masterTrackID];
            }
            if (!this.updated) {
                return this.ticks;
            }
            if (RawBufferMux.this.mediaTime.length == 1) {
                this.ticks = RawBufferMux.this.mediaTime[0];
            } else {
                this.ticks = RawBufferMux.this.mediaTime[0];
                for (int i2 = 1; i2 < RawBufferMux.this.mediaTime.length; ++i2) {
                    if (RawBufferMux.this.mediaTime[i2] >= this.ticks) continue;
                    this.ticks = RawBufferMux.this.mediaTime[i2];
                }
            }
            this.updated = false;
            return this.ticks;
        }

        public void update() {
            this.updated = true;
        }
    }
}

