/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol;

import java.io.IOException;
import javax.media.Time;
import javax.media.protocol.PullBufferDataSource;

public abstract class BasicPullBufferDataSource
extends PullBufferDataSource {
    protected Object[] controls = new Object[0];
    protected boolean started = false;
    protected String contentType = "content/unknown";
    protected boolean connected = false;
    protected Time duration = DURATION_UNKNOWN;

    public String getContentType() {
        if (!this.connected) {
            System.err.println("Error: DataSource not connected");
            return null;
        }
        return this.contentType;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.connected = true;
    }

    public void disconnect() {
        try {
            if (this.started) {
                this.stop();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.connected = false;
    }

    public void start() throws IOException {
        if (!this.connected) {
            throw new Error("DataSource must be connected before it can be started");
        }
        if (this.started) {
            return;
        }
        this.started = true;
    }

    public void stop() throws IOException {
        if (!this.connected || !this.started) {
            return;
        }
        this.started = false;
    }

    public Object[] getControls() {
        return this.controls;
    }

    public Object getControl(String controlType) {
        try {
            Class<?> cls = Class.forName(controlType);
            Object[] cs = this.getControls();
            for (int i2 = 0; i2 < cs.length; ++i2) {
                if (!cls.isInstance(cs[i2])) continue;
                return cs[i2];
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public Time getDuration() {
        return this.duration;
    }
}

