/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.v4l;

import com.sun.media.JMFSecurityManager;
import com.sun.media.protocol.v4l.VCapability;
import com.sun.media.protocol.v4l.VChannel;
import com.sun.media.protocol.v4l.VPicture;
import com.sun.media.protocol.v4l.VTuner;
import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

class V4LCapture {
    private int nativePeer = 0;
    private boolean supportsMMap = false;
    private boolean supportsRead = false;
    private int cardNo = 0;

    V4LCapture(int cardNo) {
        this.nativePeer = this.nOpen(cardNo);
        if (this.nativePeer == 0) {
            throw new Error("Can't open video card " + cardNo);
        }
        this.cardNo = cardNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        V4LCapture v4LCapture = this;
        synchronized (v4LCapture) {
            this.nClose();
            this.nativePeer = 0;
        }
    }

    native int nOpen(int var1);

    native int nClose();

    native int getCapability(VCapability var1);

    native int getChannel(VChannel var1);

    native int setChannel(VChannel var1);

    native int getPicture(VPicture var1);

    native int setPicture(VPicture var1);

    native int getTuner(VTuner var1);

    native int setTuner(VTuner var1);

    native int getFrequency();

    native int setFrequency(int var1);

    native int setFormat(int var1, int var2, int var3, int var4, float var5);

    native int start();

    native int stop();

    native int readNextFrame(byte[] var1, int var2, int var3);

    native int dumpCurrentSettings();

    native int storeSettings();

    native int restoreSettings();

    native int restoreFactorySettings();

    native int setAutomaticGainControl(int var1);

    native int setShutterSpeed(int var1);

    native int setFramerate(int var1);

    int formatToPalette(Format format) {
        if (format == null) {
            return 0;
        }
        if (format instanceof RGBFormat) {
            RGBFormat rgbf = (RGBFormat)format;
            int bpp = rgbf.getBitsPerPixel();
            switch (bpp) {
                case 24: {
                    return 4;
                }
                case 16: {
                    if (rgbf.getGreenMask() == 2016) {
                        return 3;
                    }
                    return 6;
                }
                case 32: {
                    return 5;
                }
            }
            return 0;
        }
        if (format instanceof YUVFormat) {
            YUVFormat yuvf = (YUVFormat)format;
            switch (yuvf.getYuvType()) {
                case 32: {
                    if (yuvf.getOffsetY() == 0) {
                        return 7;
                    }
                    return 9;
                }
                case 2: {
                    return 15;
                }
            }
        }
        return 0;
    }

    VideoFormat paletteToFormat(int palette, Dimension size) {
        VideoFormat format;
        int area = size.width * size.height;
        switch (palette) {
            case 3: {
                format = new RGBFormat(size, area * 2, Format.byteArray, -1.0f, 16, 63488, 2016, 31, 2, size.width * 2, 0, 1);
                break;
            }
            case 4: {
                format = new RGBFormat(size, area * 3, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, size.width * 3, 0, -1);
                break;
            }
            case 5: {
                format = new RGBFormat(size, area * 4, Format.byteArray, -1.0f, 32, 1, 2, 3, 4, size.width * 4, 0, -1);
                break;
            }
            case 6: {
                format = new RGBFormat(size, area * 2, Format.byteArray, -1.0f, 16, 31744, 992, 31, 2, size.width * 2, 0, 1);
                break;
            }
            case 7: 
            case 8: {
                format = new YUVFormat(size, area * 2, Format.byteArray, -1.0f, 32, size.width * 2, size.width * 2, 0, 1, 3);
                break;
            }
            case 9: {
                format = new YUVFormat(size, area * 2, Format.byteArray, -1.0f, 32, size.width * 2, size.width * 2, 1, 0, 2);
                break;
            }
            case 15: {
                format = new YUVFormat(size, area + area / 2, Format.byteArray, -1.0f, 2, size.width, size.width / 2, 0, area, area + area / 4);
                break;
            }
            default: {
                format = null;
            }
        }
        return format;
    }

    int paletteToDepth(int palette) {
        int[] p2d = new int[]{0, 8, 8, 16, 24, 32, 16, 16, 16, 16, 12, 12, 12, 16, 12, 12, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        return p2d[palette];
    }

    static {
        JMFSecurityManager.loadLibrary("jmv4l");
    }
}

