/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.BufferControlImpl;
import com.sun.media.rtp.FormatInfo;
import com.sun.media.rtp.OverallStats;
import com.sun.media.rtp.OverallTransStats;
import com.sun.media.rtp.PassiveSSRCInfo;
import com.sun.media.rtp.RTCPRawReceiver;
import com.sun.media.rtp.RTCPRawSender;
import com.sun.media.rtp.RTCPReceiver;
import com.sun.media.rtp.RTCPReporter;
import com.sun.media.rtp.RTCPTransmitter;
import com.sun.media.rtp.RTPControlImpl;
import com.sun.media.rtp.RTPDemultiplexer;
import com.sun.media.rtp.RTPMediaLocator;
import com.sun.media.rtp.RTPRawReceiver;
import com.sun.media.rtp.RTPRawSender;
import com.sun.media.rtp.RTPReceiver;
import com.sun.media.rtp.RTPSourceInfo;
import com.sun.media.rtp.RTPSourceInfoCache;
import com.sun.media.rtp.RTPSourceStream;
import com.sun.media.rtp.RTPTransmitter;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCCacheCleaner;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.SendSSRCInfo;
import com.sun.media.rtp.StreamSynch;
import com.sun.media.rtp.TrueRandom;
import com.sun.media.rtp.util.PacketFilter;
import com.sun.media.rtp.util.PacketForwarder;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.RTPPacketSender;
import com.sun.media.rtp.util.SSRCTable;
import com.sun.media.rtp.util.UDPPacketSender;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12InetAddressAction;
import com.sun.media.util.jdk12PropertyAction;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.EncryptionInfo;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.InvalidSessionAddressException;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPControl;
import javax.media.rtp.RTPManager;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.RTPSocket;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.RemoteParticipant;
import javax.media.rtp.SSRCInUseException;
import javax.media.rtp.SendStream;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionListener;
import javax.media.rtp.SessionManager;
import javax.media.rtp.SessionManagerException;
import javax.media.rtp.event.NewSendStreamEvent;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.StreamClosedEvent;
import javax.media.rtp.rtcp.SourceDescription;

public class RTPSessionMgr
extends RTPManager
implements SessionManager {
    boolean bindtome = false;
    private SSRCCache cache = null;
    int ttl;
    int sendercount = 0;
    InetAddress localDataAddress = null;
    int localDataPort = 0;
    InetAddress localControlAddress = null;
    int localControlPort = 0;
    InetAddress dataaddress = null;
    InetAddress controladdress = null;
    int dataport = 0;
    int controlport = 0;
    RTPPushDataSource rtpsource = null;
    RTPPushDataSource rtcpsource = null;
    long defaultSSRC = 0L;
    SessionAddress localSenderAddress;
    private SessionAddress localReceiverAddress;
    UDPPacketSender udpsender = null;
    RTPPacketSender rtpsender = null;
    RTCPRawSender sender = null;
    SSRCCacheCleaner cleaner = null;
    private boolean unicast = false;
    private boolean startedparticipating = false;
    private boolean nonparticipating = false;
    private boolean nosockets = false;
    private boolean started = false;
    private boolean initialized = false;
    protected Vector sessionlistener = new Vector();
    protected Vector remotelistener = new Vector();
    protected Vector streamlistener = new Vector();
    protected Vector sendstreamlistener = new Vector();
    private static final int GET_ALL_PARTICIPANTS = -1;
    boolean encryption = false;
    SSRCTable dslist = new SSRCTable();
    StreamSynch streamSynch;
    FormatInfo formatinfo = null;
    com.sun.media.protocol.rtp.DataSource defaultsource = null;
    PushBufferStream defaultstream = null;
    Format defaultformat = null;
    BufferControl buffercontrol = null;
    OverallStats defaultstats = null;
    OverallTransStats transstats = null;
    int defaultsourceid = 0;
    Vector sendstreamlist = new Vector(1);
    RTPTransmitter rtpTransmitter = null;
    boolean bds = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    Vector peerlist = new Vector();
    boolean multi_unicast = false;
    Hashtable peerrtplist = new Hashtable(5);
    Hashtable peerrtcplist = new Hashtable(5);
    static FormatInfo supportedList;
    static Vector addedList;
    private boolean newRtpInterface = false;
    private SessionAddress remoteAddress;
    private SessionAddress localAddress;
    private RTCPRawReceiver rtcpRawReceiver;
    private RTPRawReceiver rtpRawReceiver;
    private PacketForwarder rtpForwarder;
    private PacketForwarder rtcpForwarder;
    private RTPDemultiplexer rtpDemultiplexer;
    private OverallStats overallStats;
    private boolean participating;
    private UDPPacketSender udpPacketSender;
    private Vector remoteAddresses;
    private RTCPTransmitter rtcpTransmitter;
    private RTPConnector rtpConnector;
    private DatagramSocket dataSocket;
    private DatagramSocket controlSocket;
    private final int MAX_PORT = 65535;

    public RTPSessionMgr() {
        this.formatinfo = new FormatInfo();
        this.buffercontrol = new BufferControlImpl();
        this.defaultstats = new OverallStats();
        this.transstats = new OverallTransStats();
        this.streamSynch = new StreamSynch();
    }

    public Object[] getControls() {
        Object[] objectArray = new Object[]{this.buffercontrol};
        return objectArray;
    }

    public Object getControl(String string) {
        if (string.equals("javax.media.control.BufferControl")) {
            return this.buffercontrol;
        }
        return null;
    }

    public int initSession(SessionAddress sessionAddress, long l2, SourceDescription[] sourceDescriptionArray, double d2, double d3) throws InvalidSessionAddressException {
        InetAddress inetAddress;
        if (this.initialized) {
            return -1;
        }
        if (d2 == 0.0) {
            this.nonparticipating = true;
        }
        this.defaultSSRC = l2;
        this.localDataAddress = sessionAddress.getDataAddress();
        this.localControlAddress = sessionAddress.getControlAddress();
        this.localDataPort = sessionAddress.getDataPort();
        this.localControlPort = sessionAddress.getControlPort();
        InetAddress[] inetAddressArray = null;
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable throwable) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            String string;
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor constructor = jdk12InetAddressAction.cons;
                inetAddress = (InetAddress)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(null, "getLocalHost", null));
                string = (String)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(inetAddress, "getHostName", null));
                inetAddressArray = (InetAddress[])jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(null, "getAllByName", string));
            } else {
                inetAddress = InetAddress.getLocalHost();
                string = inetAddress.getHostName();
                inetAddressArray = InetAddress.getAllByName(string);
            }
        }
        catch (Throwable throwable) {
            System.err.println("InitSession : UnknownHostExcpetion " + throwable.getMessage());
            throwable.printStackTrace();
            return -1;
        }
        if (this.localDataAddress == null) {
            this.localDataAddress = inetAddress;
        }
        if (this.localControlAddress == null) {
            this.localControlAddress = inetAddress;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (!(n2 >= inetAddressArray.length || bl && bl2)) {
            if (inetAddressArray[n2].equals(this.localDataAddress)) {
                bl = true;
            }
            if (inetAddressArray[n2].equals(this.localControlAddress)) {
                bl2 = true;
            }
            ++n2;
        }
        String string = "Does not belong to any of this hosts local interfaces";
        if (!bl) {
            throw new InvalidSessionAddressException("Local Data Address" + string);
        }
        if (!bl2) {
            throw new InvalidSessionAddressException("Local Control Address" + string);
        }
        this.cache = new SSRCCache(this);
        this.formatinfo.setCache(this.cache);
        this.cache.rtcp_bw_fraction = d2;
        this.cache.rtcp_sender_bw_fraction = d3;
        this.cache.ourssrc = this.cache.get((int)l2, inetAddress, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(sourceDescriptionArray)) {
            SourceDescription[] sourceDescriptionArray2 = this.setCNAME(sourceDescriptionArray);
            this.cache.ourssrc.setSourceDescription(sourceDescriptionArray2);
        } else {
            this.cache.ourssrc.setSourceDescription(sourceDescriptionArray);
        }
        this.cache.ourssrc.ssrc = (int)l2;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
        return 0;
    }

    public int initSession(SessionAddress sessionAddress, SourceDescription[] sourceDescriptionArray, double d2, double d3) throws InvalidSessionAddressException {
        long l2 = this.generateSSRC();
        return this.initSession(sessionAddress, l2, sourceDescriptionArray, d2, d3);
    }

    public int startSession(SessionAddress sessionAddress, int n2, EncryptionInfo encryptionInfo) throws IOException, InvalidSessionAddressException {
        RTPRawReceiver rTPRawReceiver;
        Object object;
        block32: {
            if (this.started) {
                return -1;
            }
            if (n2 < 1) {
                n2 = 1;
            }
            this.ttl = n2;
            this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
            this.controlport = sessionAddress.getControlPort();
            this.dataport = sessionAddress.getDataPort();
            this.CheckRTPPorts(this.dataport, this.controlport);
            this.dataaddress = sessionAddress.getDataAddress();
            this.controladdress = sessionAddress.getControlAddress();
            if (jmfSecurity != null) {
                object = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        object = "read property";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 1);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        object = "connect";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                        PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                    }
                }
                catch (Throwable throwable) {
                    if (((String)object).startsWith("read")) {
                        jmfSecurity.permissionFailureNotification(1);
                    }
                    jmfSecurity.permissionFailureNotification(128);
                }
            }
            this.CheckRTPAddress(this.dataaddress, this.controladdress);
            object = null;
            rTPRawReceiver = null;
            InetAddress inetAddress = null;
            try {
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    Constructor constructor = jdk12InetAddressAction.cons;
                    inetAddress = (InetAddress)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(null, "getLocalHost", null));
                } else {
                    inetAddress = InetAddress.getLocalHost();
                }
            }
            catch (Throwable throwable) {
                System.err.println("InitSession : UnknownHostExcpetion " + throwable.getMessage());
                throwable.printStackTrace();
                return -1;
            }
            if (this.dataaddress.equals(inetAddress)) {
                this.unicast = true;
            }
            if (!this.dataaddress.isMulticastAddress() && !this.dataaddress.equals(inetAddress)) {
                this.bindtome = !this.isBroadcast(this.dataaddress) || this.Win32();
            }
            if (!this.bindtome) {
                try {
                    block31: {
                        try {
                            object = new RTCPRawReceiver(this.controlport, this.controladdress.getHostAddress(), this.defaultstats, this.streamSynch);
                            if (this.dataaddress == null) break block31;
                            rTPRawReceiver = new RTPRawReceiver(this.dataport, this.dataaddress.getHostAddress(), this.defaultstats);
                        }
                        catch (SocketException socketException) {
                            throw new IOException(socketException.getMessage());
                        }
                    }
                    Object var9_12 = null;
                    if (this.dataaddress != null && rTPRawReceiver == null && object != null) {
                        System.err.println("could not create RTCP/RTP raw receivers");
                        ((PacketFilter)object).closeSource();
                    }
                    break block32;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    if (this.dataaddress != null && rTPRawReceiver == null && object != null) {
                        System.err.println("could not create RTCP/RTP raw receivers");
                        ((PacketFilter)object).closeSource();
                    }
                    throw throwable;
                }
            }
            try {
                block33: {
                    try {
                        object = new RTCPRawReceiver(this.controlport, inetAddress.getHostAddress(), this.defaultstats, this.streamSynch);
                        if (this.dataaddress == null) break block33;
                        rTPRawReceiver = new RTPRawReceiver(this.dataport, inetAddress.getHostAddress(), this.defaultstats);
                    }
                    catch (SocketException socketException) {
                        throw new IOException(socketException.getMessage());
                    }
                }
                Object var11_15 = null;
                if (this.dataaddress != null && rTPRawReceiver == null && object != null) {
                    System.err.println("could not create RTCP/RTP raw receivers");
                    ((PacketFilter)object).closeSource();
                }
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                if (this.dataaddress != null && rTPRawReceiver == null && object != null) {
                    System.err.println("could not create RTCP/RTP raw receivers");
                    ((PacketFilter)object).closeSource();
                }
                throw throwable;
            }
        }
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, rTPRawReceiver, this.streamSynch);
        this.rtcpForwarder = new PacketForwarder((PacketSource)object, new RTCPReceiver(this.cache));
        if (rTPRawReceiver != null) {
            this.rtpForwarder = new PacketForwarder(rTPRawReceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        }
        this.rtcpForwarder.startPF("RTCP Forwarder for address" + this.controladdress.toString() + "port " + this.controlport);
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder for address " + this.dataaddress.toString() + "port " + this.dataport);
        }
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (!this.nonparticipating && !this.unicast && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startParticipating(this.controlport, this.dataaddress.getHostAddress(), this.cache.ourssrc);
        }
        this.started = true;
        return 0;
    }

    public int startSession(SessionAddress sessionAddress, SessionAddress sessionAddress2, SessionAddress sessionAddress3, EncryptionInfo encryptionInfo) throws IOException, InvalidSessionAddressException {
        Object object;
        if (this.started) {
            return -1;
        }
        this.localSenderAddress = sessionAddress2;
        this.cache.sessionbandwidth = 384000;
        this.controlport = sessionAddress.getControlPort();
        this.dataport = sessionAddress.getDataPort();
        this.CheckRTPPorts(this.dataport, this.controlport);
        this.dataaddress = sessionAddress.getDataAddress();
        this.controladdress = sessionAddress.getControlAddress();
        if (jmfSecurity != null) {
            object = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    object = "read property";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 1);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    object = "connect";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable throwable) {
                if (((String)object).startsWith("read")) {
                    jmfSecurity.permissionFailureNotification(1);
                }
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        if (this.dataaddress.isMulticastAddress() || this.controladdress.isMulticastAddress() || this.isBroadcast(this.dataaddress) || this.isBroadcast(this.controladdress)) {
            throw new InvalidSessionAddressException("Local Address must be UNICAST IP addresses");
        }
        this.CheckRTPAddress(this.dataaddress, this.controladdress);
        object = null;
        RTPRawReceiver rTPRawReceiver = null;
        InetAddress inetAddress = null;
        try {
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor constructor = jdk12InetAddressAction.cons;
                inetAddress = (InetAddress)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(null, "getLocalHost", null));
            } else {
                inetAddress = InetAddress.getLocalHost();
            }
        }
        catch (Throwable throwable) {
            System.err.println("InitSession : UnknownHostExcpetion " + throwable.getMessage());
            throwable.printStackTrace();
            return -1;
        }
        try {
            block23: {
                try {
                    object = new RTCPRawReceiver(this.controlport, this.controladdress.getHostAddress(), this.defaultstats, this.streamSynch);
                    if (this.dataaddress == null) break block23;
                    rTPRawReceiver = new RTPRawReceiver(this.dataport, this.dataaddress.getHostAddress(), this.defaultstats);
                }
                catch (SocketException socketException) {
                    throw new IOException(socketException.getMessage());
                }
            }
            Object var10_12 = null;
            if (this.dataaddress != null && rTPRawReceiver == null && object != null) {
                System.err.println("could not create RTCP/RTP raw receivers");
                ((PacketFilter)object).closeSource();
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (this.dataaddress != null && rTPRawReceiver == null && object != null) {
                System.err.println("could not create RTCP/RTP raw receivers");
                ((PacketFilter)object).closeSource();
            }
            throw throwable;
        }
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, rTPRawReceiver, this.streamSynch);
        this.rtcpForwarder = new PacketForwarder((PacketSource)object, new RTCPReceiver(this.cache));
        if (rTPRawReceiver != null) {
            this.rtpForwarder = new PacketForwarder(rTPRawReceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        }
        this.rtcpForwarder.startPF("RTCP Forwarder for address" + this.controladdress.toString() + "port " + this.controlport);
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder for address " + this.dataaddress.toString() + "port " + this.dataport);
        }
        this.controlport = sessionAddress3.getControlPort();
        this.dataport = sessionAddress3.getDataPort();
        this.CheckRTPPorts(this.dataport, this.controlport);
        this.dataaddress = sessionAddress3.getDataAddress();
        this.controladdress = sessionAddress3.getControlAddress();
        if (this.dataaddress.isMulticastAddress() || this.controladdress.isMulticastAddress() || this.isBroadcast(this.dataaddress) || this.isBroadcast(this.controladdress)) {
            throw new InvalidSessionAddressException("Remote Address must be UNICAST IP addresses");
        }
        this.CheckRTPAddress(this.dataaddress, this.controladdress);
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (!this.nonparticipating && !this.unicast && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startParticipating(sessionAddress, sessionAddress2, this.cache.ourssrc, ((RTCPRawReceiver)object).socket);
        }
        this.started = true;
        return 0;
    }

    public void addSessionListener(SessionListener sessionListener) {
        if (!this.sessionlistener.contains(sessionListener)) {
            this.sessionlistener.addElement(sessionListener);
        }
    }

    public void addRemoteListener(RemoteListener remoteListener) {
        if (!this.remotelistener.contains(remoteListener)) {
            this.remotelistener.addElement(remoteListener);
        }
    }

    public void addReceiveStreamListener(ReceiveStreamListener receiveStreamListener) {
        if (!this.streamlistener.contains(receiveStreamListener)) {
            this.streamlistener.addElement(receiveStreamListener);
        }
    }

    public void addSendStreamListener(SendStreamListener sendStreamListener) {
        if (!this.sendstreamlistener.contains(sendStreamListener)) {
            this.sendstreamlistener.addElement(sendStreamListener);
        }
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.sessionlistener.removeElement(sessionListener);
    }

    public void removeRemoteListener(RemoteListener remoteListener) {
        this.remotelistener.removeElement(remoteListener);
    }

    public void removeReceiveStreamListener(ReceiveStreamListener receiveStreamListener) {
        this.streamlistener.removeElement(receiveStreamListener);
    }

    public void removeSendStreamListener(SendStreamListener sendStreamListener) {
    }

    public long getDefaultSSRC() {
        return this.defaultSSRC;
    }

    public Vector getRemoteParticipants() {
        Vector<Participant> vector = new Vector<Participant>();
        RTPSourceInfoCache rTPSourceInfoCache = this.cache.getRTPSICache();
        Hashtable hashtable = rTPSourceInfoCache.getCacheTable();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Participant participant = (Participant)enumeration.nextElement();
            if (participant == null || !(participant instanceof RemoteParticipant)) continue;
            vector.addElement(participant);
        }
        return vector;
    }

    public Vector getActiveParticipants() {
        Vector<Participant> vector = new Vector<Participant>();
        RTPSourceInfoCache rTPSourceInfoCache = this.cache.getRTPSICache();
        Hashtable hashtable = rTPSourceInfoCache.getCacheTable();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2;
            Participant participant = (Participant)enumeration.nextElement();
            if (participant != null && participant instanceof LocalParticipant && this.nonparticipating || (vector2 = participant.getStreams()).size() <= 0) continue;
            vector.addElement(participant);
        }
        return vector;
    }

    public Vector getPassiveParticipants() {
        Vector<Participant> vector = new Vector<Participant>();
        RTPSourceInfoCache rTPSourceInfoCache = this.cache.getRTPSICache();
        Hashtable hashtable = rTPSourceInfoCache.getCacheTable();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2;
            Participant participant = (Participant)enumeration.nextElement();
            if (participant != null && participant instanceof LocalParticipant && this.nonparticipating || (vector2 = participant.getStreams()).size() != 0) continue;
            vector.addElement(participant);
        }
        return vector;
    }

    public LocalParticipant getLocalParticipant() {
        RTPSourceInfoCache rTPSourceInfoCache = this.cache.getRTPSICache();
        Hashtable hashtable = rTPSourceInfoCache.getCacheTable();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Participant participant = (Participant)enumeration.nextElement();
            if (participant == null || this.nonparticipating || !(participant instanceof LocalParticipant)) continue;
            return (LocalParticipant)participant;
        }
        return null;
    }

    public Vector getAllParticipants() {
        Vector<Participant> vector = new Vector<Participant>();
        RTPSourceInfoCache rTPSourceInfoCache = this.cache.getRTPSICache();
        Hashtable hashtable = rTPSourceInfoCache.getCacheTable();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Participant participant = (Participant)enumeration.nextElement();
            if (participant == null || participant instanceof LocalParticipant && this.nonparticipating) continue;
            vector.addElement(participant);
        }
        return vector;
    }

    public Vector getReceiveStreams() {
        Vector<RTPStream> vector = new Vector<RTPStream>();
        Vector vector2 = this.getAllParticipants();
        int n2 = 0;
        while (n2 < vector2.size()) {
            Participant participant = (Participant)vector2.elementAt(n2);
            Vector vector3 = participant.getStreams();
            int n3 = 0;
            while (n3 < vector3.size()) {
                RTPStream rTPStream = (RTPStream)vector3.elementAt(n3);
                if (rTPStream instanceof ReceiveStream) {
                    vector.addElement(rTPStream);
                }
                ++n3;
            }
            ++n2;
        }
        vector.trimToSize();
        return vector;
    }

    public Vector getSendStreams() {
        return null;
    }

    public RTPStream getStream(long l2) {
        Vector vector = null;
        vector = this.getAllParticipants();
        if (vector == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            RTPSourceInfo rTPSourceInfo = (RTPSourceInfo)vector.elementAt(n2);
            RTPStream rTPStream = rTPSourceInfo.getSSRCStream(l2);
            if (rTPStream != null) {
                return rTPStream;
            }
            ++n2;
        }
        return null;
    }

    public int getMulticastScope() {
        return this.ttl;
    }

    public void setMulticastScope(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        this.ttl = n2;
        this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
        if (this.udpsender != null) {
            try {
                this.udpsender.setttl(this.ttl);
            }
            catch (IOException iOException) {
                System.err.println("setMulticastScope Exception " + iOException.getMessage());
                iOException.printStackTrace();
            }
        }
    }

    public void closeSession(String string) {
        Object object;
        this.stopParticipating(string, this.cache.ourssrc);
        if (this.defaultsource != null) {
            this.defaultsource.disconnect();
        }
        if (this.cache != null) {
            Enumeration enumeration = this.cache.cache.elements();
            while (enumeration.hasMoreElements()) {
                object = (SSRCInfo)enumeration.nextElement();
                if (((SSRCInfo)object).dstream != null) {
                    ((SSRCInfo)object).dstream.close();
                }
                if (object instanceof SendSSRCInfo) {
                    ((SendSSRCInfo)object).close();
                }
                this.stopParticipating(string, (SSRCInfo)object);
            }
        }
        int n2 = 0;
        while (n2 < this.sendstreamlist.size()) {
            this.removeSendStream((SendStream)this.sendstreamlist.elementAt(n2));
            ++n2;
        }
        if (this.rtpTransmitter != null) {
            this.rtpTransmitter.close();
        }
        if (this.rtcpForwarder != null) {
            object = (RTCPRawReceiver)this.rtcpForwarder.getSource();
            this.rtcpForwarder.close();
            if (object != null) {
                ((RTCPRawReceiver)object).close();
            }
        }
        if (this.cleaner != null) {
            this.cleaner.stop();
        }
        if (this.cache != null) {
            this.cache.destroy();
        }
        if (this.rtpForwarder != null) {
            object = (RTPRawReceiver)this.rtpForwarder.getSource();
            this.rtpForwarder.close();
            if (object != null) {
                ((RTPRawReceiver)object).close();
            }
        }
        if (this.multi_unicast) {
            this.removeAllPeers();
        }
    }

    public String generateCNAME() {
        return SourceDescription.generateCNAME();
    }

    public long generateSSRC() {
        long l2 = TrueRandom.rand();
        return l2;
    }

    public SessionAddress getSessionAddress() {
        SessionAddress sessionAddress = new SessionAddress(this.dataaddress, this.dataport, this.controladdress, this.controlport);
        return sessionAddress;
    }

    public SessionAddress getLocalSessionAddress() {
        if (this.newRtpInterface) {
            return this.localAddress;
        }
        SessionAddress sessionAddress = new SessionAddress(this.localDataAddress, this.localDataPort, this.localControlAddress, this.localControlPort);
        return sessionAddress;
    }

    public SessionAddress getLocalReceiverAddress() {
        return this.localReceiverAddress;
    }

    public GlobalReceptionStats getGlobalReceptionStats() {
        return this.defaultstats;
    }

    public GlobalTransmissionStats getGlobalTransmissionStats() {
        return this.transstats;
    }

    public void addFormat(Format format, int n2) {
        if (this.formatinfo != null) {
            this.formatinfo.add(n2, format);
        }
        if (format != null) {
            addedList.addElement(format);
        }
    }

    public static boolean formatSupported(Format format) {
        if (supportedList == null) {
            supportedList = new FormatInfo();
        }
        if (supportedList.getPayload(format) != -1) {
            return true;
        }
        int n2 = 0;
        while (n2 < addedList.size()) {
            Format format2 = (Format)addedList.elementAt(n2);
            if (format2.matches(format)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public SendStream createSendStream(int n2, DataSource dataSource, int n3) throws UnsupportedFormatException, IOException, SSRCInUseException {
        Serializable serializable;
        SSRCInfo sSRCInfo = this.cache.lookup(n2);
        if (sSRCInfo != null) {
            throw new SSRCInUseException("SSRC supplied is already in use");
        }
        int n4 = n2;
        if (this.cache.rtcp_bw_fraction == 0.0) {
            throw new IOException("Initialized with zero RTP/RTCP outgoing bandwidth. Cannot create a sending stream ");
        }
        PushBufferStream[] pushBufferStreamArray = ((PushBufferDataSource)dataSource).getStreams();
        PushBufferStream pushBufferStream = pushBufferStreamArray[n3];
        Format format = pushBufferStream.getFormat();
        int n5 = this.formatinfo.getPayload(format);
        if (n5 == -1) {
            throw new UnsupportedFormatException("Format of Stream not supported in RTP Session Manager", format);
        }
        SSRCInfo sSRCInfo2 = null;
        if (this.sendercount == 0) {
            sSRCInfo2 = new SendSSRCInfo(this.cache.ourssrc);
            sSRCInfo2.ours = true;
            this.cache.ourssrc = sSRCInfo2;
            this.cache.getMainCache().put(sSRCInfo2.ssrc, sSRCInfo2);
        } else {
            sSRCInfo2 = this.cache.get(n4, this.dataaddress, this.dataport, 3);
            sSRCInfo2.ours = true;
            sSRCInfo2.reporter = !this.nosockets ? this.startParticipating(this.controlport, this.controladdress.getHostAddress(), sSRCInfo2) : this.startParticipating(this.rtcpsource, sSRCInfo2);
        }
        sSRCInfo2.payloadType = n5;
        sSRCInfo2.sinkstream.setSSRCInfo((SendSSRCInfo)sSRCInfo2);
        ((SendSSRCInfo)sSRCInfo2).setFormat(format);
        if (format instanceof VideoFormat) {
            sSRCInfo2.clockrate = 90000;
        } else if (format instanceof AudioFormat) {
            sSRCInfo2.clockrate = (int)((AudioFormat)format).getSampleRate();
        } else {
            throw new UnsupportedFormatException("Format not supported", format);
        }
        sSRCInfo2.pds = dataSource;
        pushBufferStream.setTransferHandler(sSRCInfo2.sinkstream);
        if (this.multi_unicast) {
            if (this.peerlist.size() > 0) {
                serializable = (SessionAddress)this.peerlist.firstElement();
                this.dataport = serializable.getDataPort();
                this.dataaddress = serializable.getDataAddress();
            } else {
                throw new IOException("At least one peer must be added");
            }
        }
        if (this.rtpTransmitter == null) {
            if (this.rtpConnector != null) {
                this.rtpTransmitter = this.startDataTransmission(this.rtpConnector);
            } else if (this.nosockets) {
                this.rtpTransmitter = this.startDataTransmission(this.rtpsource);
            } else {
                if (this.newRtpInterface) {
                    this.dataport = this.remoteAddress.getDataPort();
                    this.dataaddress = this.remoteAddress.getDataAddress();
                }
                this.rtpTransmitter = this.startDataTransmission(this.dataport, this.dataaddress.getHostAddress());
            }
            if (this.rtpTransmitter == null) {
                throw new IOException("Cannot create a transmitter");
            }
        }
        sSRCInfo2.sinkstream.setTransmitter(this.rtpTransmitter);
        this.addSendStream((SendStream)((Object)sSRCInfo2));
        if (this.multi_unicast) {
            int n6 = 0;
            while (n6 < this.peerlist.size()) {
                SessionAddress sessionAddress = (SessionAddress)this.peerlist.elementAt(n6);
                if (sSRCInfo2.sinkstream.transmitter.sender.peerlist == null) {
                    sSRCInfo2.sinkstream.transmitter.sender.peerlist = new Vector();
                }
                sSRCInfo2.sinkstream.transmitter.sender.peerlist.addElement(sessionAddress);
                if (this.cache != null) {
                    Enumeration enumeration = this.cache.cache.elements();
                    while (enumeration.hasMoreElements()) {
                        SSRCInfo sSRCInfo3 = (SSRCInfo)enumeration.nextElement();
                        if (!(sSRCInfo3 instanceof SendSSRCInfo)) continue;
                        sSRCInfo3.reporter.transmit.sender.control = true;
                        if (sSRCInfo3.reporter.transmit.sender.peerlist == null) {
                            sSRCInfo3.reporter.transmit.sender.peerlist = new Vector();
                        }
                        sSRCInfo3.reporter.transmit.sender.peerlist.addElement(sessionAddress);
                    }
                }
                ++n6;
            }
        }
        sSRCInfo2.sinkstream.startStream();
        serializable = new NewSendStreamEvent(this, (SendStream)((Object)sSRCInfo2));
        this.cache.eventhandler.postEvent((RTPEvent)serializable);
        return (SendStream)((Object)sSRCInfo2);
    }

    public SSRCInfo getSSRCInfo(int n2) {
        SSRCInfo sSRCInfo = this.cache.lookup(n2);
        return sSRCInfo;
    }

    public SendStream createSendStream(DataSource dataSource, int n2) throws IOException, UnsupportedFormatException {
        int n3 = 0;
        while (this.cache.lookup(n3 = (int)this.generateSSRC()) != null) {
        }
        SendStream sendStream = null;
        try {
            sendStream = this.createSendStream(n3, dataSource, n2);
            if (this.newRtpInterface) {
                this.setRemoteAddresses();
            }
        }
        catch (SSRCInUseException sSRCInUseException) {
            // empty catch block
        }
        return sendStream;
    }

    public int startSession(int n2, EncryptionInfo encryptionInfo) throws IOException {
        this.multi_unicast = true;
        if (n2 < 1) {
            n2 = 1;
        }
        this.ttl = n2;
        this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        return 0;
    }

    public void addPeer(SessionAddress sessionAddress) throws IOException, InvalidSessionAddressException {
        SSRCInfo sSRCInfo;
        Enumeration enumeration;
        Object object;
        int n2;
        int n3;
        InetAddress inetAddress;
        InetAddress inetAddress2;
        RTPRawReceiver rTPRawReceiver;
        Object object2;
        block37: {
            int n4 = 0;
            while (n4 < this.peerlist.size()) {
                object2 = (SessionAddress)this.peerlist.elementAt(n4);
                if (((SessionAddress)object2).equals(sessionAddress)) {
                    return;
                }
                ++n4;
            }
            this.peerlist.addElement(sessionAddress);
            this.CheckRTPPorts(sessionAddress.getDataPort(), sessionAddress.getControlPort());
            if (jmfSecurity != null) {
                object2 = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        object2 = "read property";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 1);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        object2 = "connect";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                        PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                    }
                }
                catch (Throwable throwable) {
                    if (((String)object2).startsWith("read")) {
                        jmfSecurity.permissionFailureNotification(1);
                    }
                    jmfSecurity.permissionFailureNotification(128);
                }
            }
            object2 = null;
            rTPRawReceiver = null;
            inetAddress2 = sessionAddress.getDataAddress();
            inetAddress = sessionAddress.getControlAddress();
            n3 = sessionAddress.getDataPort();
            n2 = sessionAddress.getControlPort();
            this.CheckRTPAddress(inetAddress2, inetAddress);
            InetAddress inetAddress3 = null;
            try {
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    object = jdk12InetAddressAction.cons;
                    inetAddress3 = (InetAddress)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(null, "getLocalHost", null));
                } else {
                    inetAddress3 = InetAddress.getLocalHost();
                }
            }
            catch (Throwable throwable) {
                System.err.println("InitSession : UnknownHostExcpetion " + throwable.getMessage());
                throwable.printStackTrace();
            }
            if (!inetAddress2.isMulticastAddress() && !inetAddress2.equals(inetAddress3)) {
                this.bindtome = !this.isBroadcast(inetAddress2) || this.Win32();
            }
            if (!this.bindtome) {
                try {
                    block36: {
                        try {
                            object2 = new RTCPRawReceiver(n2, inetAddress.getHostAddress(), this.defaultstats, this.streamSynch);
                            if (inetAddress2 == null) break block36;
                            rTPRawReceiver = new RTPRawReceiver(n3, inetAddress2.getHostAddress(), this.defaultstats);
                        }
                        catch (SocketException socketException) {
                            throw new IOException(socketException.getMessage());
                        }
                    }
                    enumeration = null;
                    if (inetAddress2 != null && rTPRawReceiver == null && object2 != null) {
                        System.err.println("could not create RTCP/RTP raw receivers");
                        ((PacketFilter)object2).closeSource();
                    }
                    break block37;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    if (inetAddress2 != null && rTPRawReceiver == null && object2 != null) {
                        System.err.println("could not create RTCP/RTP raw receivers");
                        ((PacketFilter)object2).closeSource();
                    }
                    throw throwable;
                }
            }
            try {
                block38: {
                    try {
                        object2 = new RTCPRawReceiver(n2, inetAddress3.getHostAddress(), this.defaultstats, this.streamSynch);
                        if (inetAddress2 == null) break block38;
                        rTPRawReceiver = new RTPRawReceiver(n3, inetAddress3.getHostAddress(), this.defaultstats);
                    }
                    catch (SocketException socketException) {
                        throw new IOException(socketException.getMessage());
                    }
                }
                Object var14_20 = null;
                if (inetAddress2 != null && rTPRawReceiver == null && object2 != null) {
                    System.err.println("could not create RTCP/RTP raw receivers");
                    ((PacketFilter)object2).closeSource();
                }
            }
            catch (Throwable throwable) {
                Object var14_21 = null;
                if (inetAddress2 != null && rTPRawReceiver == null && object2 != null) {
                    System.err.println("could not create RTCP/RTP raw receivers");
                    ((PacketFilter)object2).closeSource();
                }
                throw throwable;
            }
        }
        object = new PacketForwarder((PacketSource)object2, new RTCPReceiver(this.cache));
        PacketForwarder packetForwarder = null;
        if (rTPRawReceiver != null) {
            packetForwarder = new PacketForwarder(rTPRawReceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        }
        ((PacketForwarder)object).startPF("RTCP Forwarder for address" + inetAddress.toString() + "port " + n2);
        if (packetForwarder != null) {
            packetForwarder.startPF("RTP Forwarder for address " + inetAddress2.toString() + "port " + n3);
        }
        this.peerrtplist.put(sessionAddress, packetForwarder);
        this.peerrtcplist.put(sessionAddress, object);
        if (this.cache.ourssrc != null) {
            if (this.cache.ourssrc.reporter == null) {
                this.controladdress = inetAddress;
                this.controlport = n2;
                this.cache.ourssrc.reporter = this.startParticipating(n2, inetAddress2.getHostAddress(), this.cache.ourssrc);
            }
            if (this.cache.ourssrc.reporter.transmit.sender.peerlist == null) {
                this.cache.ourssrc.reporter.transmit.sender.peerlist = new Vector();
            }
        }
        this.cache.ourssrc.reporter.transmit.sender.peerlist.addElement(sessionAddress);
        if (this.cache != null) {
            enumeration = this.cache.cache.elements();
            while (enumeration.hasMoreElements()) {
                sSRCInfo = (SSRCInfo)enumeration.nextElement();
                if (!(sSRCInfo instanceof SendSSRCInfo)) continue;
                sSRCInfo.reporter.transmit.sender.control = true;
                if (sSRCInfo.reporter.transmit.sender.peerlist != null) continue;
                sSRCInfo.reporter.transmit.sender.peerlist = new Vector();
                sSRCInfo.reporter.transmit.sender.peerlist.addElement(sessionAddress);
            }
        }
        int n5 = 0;
        while (n5 < this.sendstreamlist.size()) {
            sSRCInfo = (SendSSRCInfo)this.sendstreamlist.elementAt(n5);
            if (sSRCInfo.sinkstream.transmitter.sender.peerlist == null) {
                sSRCInfo.sinkstream.transmitter.sender.peerlist = new Vector();
                sSRCInfo.sinkstream.transmitter.sender.peerlist.addElement(sessionAddress);
            }
            ++n5;
        }
    }

    public void removePeer(SessionAddress sessionAddress) {
        PacketForwarder packetForwarder = (PacketForwarder)this.peerrtplist.get(sessionAddress);
        PacketForwarder packetForwarder2 = (PacketForwarder)this.peerrtplist.get(sessionAddress);
        if (packetForwarder != null) {
            packetForwarder.close();
        }
        if (packetForwarder2 != null) {
            packetForwarder2.close();
        }
        int n2 = 0;
        while (n2 < this.peerlist.size()) {
            SessionAddress sessionAddress2 = (SessionAddress)this.peerlist.elementAt(n2);
            if (sessionAddress2.equals(sessionAddress)) {
                this.peerlist.removeElementAt(n2);
            }
            ++n2;
        }
    }

    public void removeAllPeers() {
        int n2 = 0;
        while (n2 < this.peerlist.size()) {
            this.removePeer((SessionAddress)this.peerlist.elementAt(n2));
            ++n2;
        }
    }

    public Vector getPeers() {
        return this.peerlist;
    }

    void addSendStream(SendStream sendStream) {
        this.sendstreamlist.addElement(sendStream);
    }

    void removeSendStream(SendStream sendStream) {
        Object object;
        this.sendstreamlist.removeElement(sendStream);
        if (((SendSSRCInfo)sendStream).sinkstream != null) {
            ((SendSSRCInfo)sendStream).sinkstream.close();
            object = new StreamClosedEvent(this, sendStream);
            this.cache.eventhandler.postEvent((RTPEvent)object);
            this.stopParticipating("Closed Stream", (SendSSRCInfo)sendStream);
        }
        if (this.sendstreamlist.size() == 0 && this.cache.ourssrc != null) {
            this.cache.ourssrc = object = new PassiveSSRCInfo(this.getSSRCCache().ourssrc);
            this.cache.getMainCache().put(((SSRCInfo)object).ssrc, object);
        }
    }

    private RTPTransmitter startDataTransmission(int n2, String string) throws IOException {
        RTPTransmitter rTPTransmitter = null;
        RTPRawSender rTPRawSender = null;
        if (this.localDataPort == -1) {
            this.udpsender = new UDPPacketSender(this.dataaddress, this.dataport);
        } else if (this.newRtpInterface) {
            this.udpsender = new UDPPacketSender(this.rtpRawReceiver.socket);
        } else {
            int n3 = this.localSenderAddress.getDataPort();
            InetAddress inetAddress = this.localSenderAddress.getDataAddress();
            this.udpsender = new UDPPacketSender(n3, inetAddress, this.dataaddress, this.dataport);
        }
        if (this.ttl != 1) {
            this.udpsender.setttl(this.ttl);
        }
        rTPRawSender = new RTPRawSender(this.dataport, string, this.udpsender);
        rTPTransmitter = new RTPTransmitter(this.cache, rTPRawSender);
        return rTPTransmitter;
    }

    private RTPTransmitter startDataTransmission(RTPPushDataSource rTPPushDataSource) {
        RTPRawSender rTPRawSender = null;
        RTPTransmitter rTPTransmitter = null;
        this.rtpsender = new RTPPacketSender(rTPPushDataSource);
        rTPRawSender = new RTPRawSender(this.rtpsender);
        rTPTransmitter = new RTPTransmitter(this.cache, rTPRawSender);
        return rTPTransmitter;
    }

    private RTPTransmitter startDataTransmission(RTPConnector rTPConnector) {
        try {
            RTPRawSender rTPRawSender = null;
            RTPTransmitter rTPTransmitter = null;
            this.rtpsender = new RTPPacketSender(rTPConnector);
            rTPRawSender = new RTPRawSender(this.rtpsender);
            rTPTransmitter = new RTPTransmitter(this.cache, rTPRawSender);
            return rTPTransmitter;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void UpdateEncodings(DataSource dataSource) {
        RTPControlImpl rTPControlImpl = (RTPControlImpl)dataSource.getControl("javax.media.rtp.RTPControl");
        if (rTPControlImpl != null && rTPControlImpl.codeclist != null) {
            Enumeration enumeration = rTPControlImpl.codeclist.keys();
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                this.formatinfo.add(n2, (Format)rTPControlImpl.codeclist.get(n2));
            }
        }
    }

    private int startSession(RTPPushDataSource rTPPushDataSource, RTPPushDataSource rTPPushDataSource2, EncryptionInfo encryptionInfo) {
        if (!this.initialized) {
            return -1;
        }
        if (this.started) {
            return -1;
        }
        this.cache.sessionbandwidth = 384000;
        RTPRawReceiver rTPRawReceiver = new RTPRawReceiver(rTPPushDataSource, this.defaultstats);
        RTCPRawReceiver rTCPRawReceiver = new RTCPRawReceiver(rTPPushDataSource2, this.defaultstats, this.streamSynch);
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, rTPRawReceiver, this.streamSynch);
        this.rtpForwarder = new PacketForwarder(rTPRawReceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder " + rTPPushDataSource);
        }
        this.rtcpForwarder = new PacketForwarder(rTCPRawReceiver, new RTCPReceiver(this.cache));
        if (this.rtcpForwarder != null) {
            this.rtcpForwarder.startPF("RTCP Forwarder " + rTPPushDataSource);
        }
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (!this.nonparticipating && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startParticipating(rTPPushDataSource2, this.cache.ourssrc);
        }
        this.started = true;
        return 0;
    }

    public RTPSessionMgr(RTPPushDataSource rTPPushDataSource) {
        this.nosockets = true;
        this.rtpsource = rTPPushDataSource;
        if (this.rtpsource instanceof RTPSocket) {
            this.rtcpsource = ((RTPSocket)this.rtpsource).getControlChannel();
        }
        this.formatinfo = new FormatInfo();
        this.buffercontrol = new BufferControlImpl();
        this.defaultstats = new OverallStats();
        this.transstats = new OverallTransStats();
        com.sun.media.protocol.rtp.DataSource dataSource = this.createNewDS(null);
        this.UpdateEncodings(rTPPushDataSource);
        RTPControl rTPControl = (RTPControl)rTPPushDataSource.getControl("javax.media.rtp.RTPControl");
        dataSource.setControl(rTPControl);
        this.initSession(this.setSDES(), 0.05, 0.25);
        this.startSession(this.rtpsource, this.rtcpsource, null);
    }

    public RTPSessionMgr(com.sun.media.protocol.rtp.DataSource dataSource) throws IOException {
        Object object;
        this.formatinfo = new FormatInfo();
        this.buffercontrol = new BufferControlImpl();
        this.defaultstats = new OverallStats();
        this.transstats = new OverallTransStats();
        this.UpdateEncodings(dataSource);
        RTPMediaLocator rTPMediaLocator = null;
        try {
            rTPMediaLocator = new RTPMediaLocator(dataSource.getLocator().toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("RTP URL is Malformed " + malformedURLException.getMessage());
        }
        com.sun.media.protocol.rtp.DataSource dataSource2 = this.createNewDS(rTPMediaLocator);
        RTPControl rTPControl = (RTPControl)dataSource.getControl("javax.media.rtp.RTPControl");
        dataSource2.setControl(rTPControl);
        String string = rTPMediaLocator.getSessionAddress();
        this.dataport = rTPMediaLocator.getSessionPort();
        this.controlport = this.dataport + 1;
        this.ttl = rTPMediaLocator.getTTL();
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable throwable) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                object = jdk12InetAddressAction.cons;
                this.dataaddress = (InetAddress)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(null, "getByName", string));
            } else {
                this.dataaddress = InetAddress.getByName(string);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.controladdress = this.dataaddress;
        object = new SessionAddress();
        try {
            this.initSession((SessionAddress)object, this.setSDES(), 0.05, 0.25);
        }
        catch (SessionManagerException sessionManagerException) {
            throw new IOException("SessionManager exception " + sessionManagerException.getMessage());
        }
    }

    public void addMRL(RTPMediaLocator rTPMediaLocator) {
        int n2 = (int)rTPMediaLocator.getSSRC();
        if (n2 == 0) {
            return;
        }
        com.sun.media.protocol.rtp.DataSource dataSource = (com.sun.media.protocol.rtp.DataSource)this.dslist.get(n2);
        if (dataSource != null) {
            return;
        }
        com.sun.media.protocol.rtp.DataSource dataSource2 = this.createNewDS(rTPMediaLocator);
    }

    public boolean isDefaultDSassigned() {
        return this.bds;
    }

    public Format getFormat(int n2) {
        return this.formatinfo.get(n2);
    }

    public void setDefaultDSassigned(int n2) {
        this.bds = true;
        this.defaultsourceid = n2;
        this.dslist.put(n2, this.defaultsource);
        this.defaultsource.setSSRC(n2);
        this.defaultsource.setMgr(this);
    }

    public com.sun.media.protocol.rtp.DataSource createNewDS(int n2) {
        com.sun.media.protocol.rtp.DataSource dataSource = new com.sun.media.protocol.rtp.DataSource();
        dataSource.setContentType("raw");
        try {
            dataSource.connect();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        RTPSourceStream rTPSourceStream = new RTPSourceStream(dataSource);
        ((BufferControlImpl)this.buffercontrol).addSourceStream(rTPSourceStream);
        this.dslist.put(n2, dataSource);
        dataSource.setSSRC(n2);
        dataSource.setMgr(this);
        return dataSource;
    }

    public com.sun.media.protocol.rtp.DataSource createNewDS(RTPMediaLocator rTPMediaLocator) {
        com.sun.media.protocol.rtp.DataSource dataSource = new com.sun.media.protocol.rtp.DataSource();
        dataSource.setContentType("raw");
        try {
            dataSource.connect();
        }
        catch (IOException iOException) {
            System.err.println("IOException in createNewDS() " + iOException.getMessage());
            iOException.printStackTrace();
        }
        RTPSourceStream rTPSourceStream = new RTPSourceStream(dataSource);
        ((BufferControlImpl)this.buffercontrol).addSourceStream(rTPSourceStream);
        if (rTPMediaLocator != null && (int)rTPMediaLocator.getSSRC() != 0) {
            this.dslist.put((int)rTPMediaLocator.getSSRC(), dataSource);
            dataSource.setSSRC((int)rTPMediaLocator.getSSRC());
            dataSource.setMgr(this);
        } else {
            this.defaultsource = dataSource;
            this.defaultstream = rTPSourceStream;
        }
        return dataSource;
    }

    public com.sun.media.protocol.rtp.DataSource getDataSource(RTPMediaLocator rTPMediaLocator) {
        if (rTPMediaLocator == null) {
            return this.defaultsource;
        }
        int n2 = (int)rTPMediaLocator.getSSRC();
        if (n2 == 0) {
            return this.defaultsource;
        }
        return (com.sun.media.protocol.rtp.DataSource)this.dslist.get(n2);
    }

    public String toString() {
        String string;
        if (this.newRtpInterface) {
            int n2 = 0;
            int n3 = 0;
            String string2 = "";
            if (this.localAddress != null) {
                n2 = this.localAddress.getControlPort();
                n3 = this.localAddress.getDataPort();
                string2 = this.localAddress.getDataHostAddress();
            }
            string = "RTPManager \n\tSSRCCache  " + this.cache + "\n\tDataport  " + n3 + "\n\tControlport  " + n2 + "\n\tAddress  " + string2 + "\n\tRTPForwarder  " + this.rtpForwarder + "\n\tRTPDemux  " + this.rtpDemultiplexer;
        } else {
            string = "RTPSession Manager  \n\tSSRCCache  " + this.cache + "\n\tDataport  " + this.dataport + "\n\tControlport  " + this.controlport + "\n\tAddress  " + this.dataaddress + "\n\tRTPForwarder  " + this.rtpForwarder + "\n\tRTPDEmux  " + this.rtpDemultiplexer;
        }
        return string;
    }

    public boolean IsNonParticipating() {
        return this.nonparticipating;
    }

    public void startSession() throws IOException {
        SessionAddress sessionAddress = new SessionAddress(this.dataaddress, this.dataport, this.controladdress, this.controlport);
        try {
            this.startSession(sessionAddress, this.ttl, null);
        }
        catch (SessionManagerException sessionManagerException) {
            throw new IOException("SessionManager exception " + sessionManagerException.getMessage());
        }
    }

    public void closeSession() {
        if (this.dslist.isEmpty() || this.nosockets) {
            this.closeSession("DataSource disconnected");
        }
    }

    public void removeDataSource(com.sun.media.protocol.rtp.DataSource dataSource) {
        if (dataSource == this.defaultsource) {
            this.defaultsource = null;
            this.defaultstream = null;
            this.defaultsourceid = 0;
            this.bds = false;
        }
        this.dslist.removeObj(dataSource);
    }

    void startRTCPReports(InetAddress inetAddress) {
        if (!this.nonparticipating && !this.startedparticipating) {
            try {
                if (this.cache.ourssrc != null) {
                    this.cache.ourssrc.reporter = this.startParticipating(this.controlport, inetAddress.getHostAddress(), this.cache.ourssrc);
                }
            }
            catch (IOException iOException) {
                System.err.println("startRTCPReports " + iOException.getMessage());
                iOException.printStackTrace();
            }
        }
    }

    boolean isUnicast() {
        return this.unicast;
    }

    public void addUnicastAddr(InetAddress inetAddress) {
        if (this.sender != null) {
            this.sender.addDestAddr(inetAddress);
        }
    }

    public boolean isSenderDefaultAddr(InetAddress inetAddress) {
        if (this.sender == null) {
            return false;
        }
        InetAddress inetAddress2 = this.sender.getRemoteAddr();
        return inetAddress2.equals(inetAddress);
    }

    SSRCCache getSSRCCache() {
        return this.cache;
    }

    void setSessionBandwidth(int n2) {
        this.cache.sessionbandwidth = n2;
    }

    private String getProperty(String string) {
        String string2 = null;
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 1);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                }
            }
            catch (Throwable throwable) {
                jmfSecurity.permissionFailureNotification(1);
            }
        }
        try {
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor constructor = jdk12PropertyAction.cons;
                string2 = (String)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(string));
            } else {
                string2 = System.getProperty(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string2;
    }

    private SourceDescription[] setSDES() {
        SourceDescription[] sourceDescriptionArray = new SourceDescription[3];
        if (sourceDescriptionArray == null) {
            return null;
        }
        sourceDescriptionArray[0] = new SourceDescription(2, this.getProperty("user.name"), 1, false);
        sourceDescriptionArray[1] = new SourceDescription(1, SourceDescription.generateCNAME(), 1, false);
        sourceDescriptionArray[2] = new SourceDescription(6, "JMF RTP Player v1.0", 1, false);
        return sourceDescriptionArray;
    }

    private SourceDescription[] setCNAME(SourceDescription[] sourceDescriptionArray) {
        String string = null;
        boolean bl = false;
        if (sourceDescriptionArray == null) {
            sourceDescriptionArray = new SourceDescription[1];
            string = SourceDescription.generateCNAME();
            sourceDescriptionArray[0] = new SourceDescription(1, string, 1, false);
            return sourceDescriptionArray;
        }
        int n2 = 0;
        while (n2 < sourceDescriptionArray.length) {
            int n3 = sourceDescriptionArray[n2].getType();
            string = sourceDescriptionArray[n2].getDescription();
            if (n3 == 1 && string == null) {
                string = SourceDescription.generateCNAME();
                bl = true;
                break;
            }
            ++n2;
        }
        if (bl) {
            return sourceDescriptionArray;
        }
        SourceDescription[] sourceDescriptionArray2 = new SourceDescription[sourceDescriptionArray.length + 1];
        sourceDescriptionArray2[0] = new SourceDescription(1, SourceDescription.generateCNAME(), 1, false);
        int n4 = 1;
        int n5 = 0;
        while (n5 < sourceDescriptionArray.length) {
            sourceDescriptionArray2[n4] = new SourceDescription(sourceDescriptionArray[n5].getType(), sourceDescriptionArray[n5].getDescription(), 1, false);
            ++n4;
            ++n5;
        }
        return sourceDescriptionArray2;
    }

    private boolean isCNAME(SourceDescription[] sourceDescriptionArray) {
        String string = null;
        boolean bl = false;
        if (sourceDescriptionArray == null) {
            return bl;
        }
        int n2 = 0;
        while (n2 < sourceDescriptionArray.length) {
            try {
                int n3 = sourceDescriptionArray[n2].getType();
                string = sourceDescriptionArray[n2].getDescription();
                if (n3 == 1 && string != null) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return bl;
    }

    private void CheckRTPPorts(int n2, int n3) throws InvalidSessionAddressException {
        if (n2 == 0 || n2 == -1) {
            n2 = n3 - 1;
        }
        if (n3 == 0 || n3 == -1) {
            n3 = n2 + 1;
        }
        if (n2 != 0 && n2 % 2 != 0) {
            throw new InvalidSessionAddressException("Data Port must be valid and even");
        }
        if (n3 != 0 && n3 % 2 != 1) {
            throw new InvalidSessionAddressException("Control Port must be valid and odd");
        }
        if (n3 != n2 + 1) {
            throw new InvalidSessionAddressException("Control Port must be one higher than the Data Port");
        }
    }

    private void CheckRTPAddress(InetAddress inetAddress, InetAddress inetAddress2) throws InvalidSessionAddressException {
        if (inetAddress == null && inetAddress2 == null) {
            throw new InvalidSessionAddressException("Data and control addresses are null");
        }
        if (inetAddress2 == null && inetAddress != null) {
            inetAddress2 = inetAddress;
        }
        if (inetAddress == null && inetAddress2 != null) {
            inetAddress = inetAddress2;
        }
    }

    private synchronized RTCPReporter startParticipating(RTPPushDataSource rTPPushDataSource, SSRCInfo sSRCInfo) {
        this.startedparticipating = true;
        this.rtpsender = new RTPPacketSender(rTPPushDataSource);
        RTCPRawSender rTCPRawSender = new RTCPRawSender(this.rtpsender);
        RTCPTransmitter rTCPTransmitter = new RTCPTransmitter(this.cache, rTCPRawSender);
        rTCPTransmitter.setSSRCInfo(sSRCInfo);
        RTCPReporter rTCPReporter = new RTCPReporter(this.cache, rTCPTransmitter);
        return rTCPReporter;
    }

    private synchronized RTCPReporter startParticipating(RTPConnector rTPConnector, SSRCInfo sSRCInfo) {
        this.startedparticipating = true;
        try {
            this.rtpsender = new RTPPacketSender(rTPConnector.getControlOutputStream());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        RTCPRawSender rTCPRawSender = new RTCPRawSender(this.rtpsender);
        RTCPTransmitter rTCPTransmitter = new RTCPTransmitter(this.cache, rTCPRawSender);
        rTCPTransmitter.setSSRCInfo(sSRCInfo);
        RTCPReporter rTCPReporter = new RTCPReporter(this.cache, rTCPTransmitter);
        return rTCPReporter;
    }

    private synchronized RTCPReporter startParticipating(int n2, String string, SSRCInfo sSRCInfo) throws IOException {
        this.startedparticipating = true;
        UDPPacketSender uDPPacketSender = null;
        if (this.localControlPort == -1) {
            uDPPacketSender = new UDPPacketSender(this.controladdress, this.controlport);
            this.localControlPort = uDPPacketSender.getLocalPort();
            this.localControlAddress = uDPPacketSender.getLocalAddress();
        } else {
            uDPPacketSender = new UDPPacketSender(this.localControlPort, this.localControlAddress, this.controladdress, this.controlport);
        }
        if (this.ttl != 1) {
            uDPPacketSender.setttl(this.ttl);
        }
        RTCPRawSender rTCPRawSender = new RTCPRawSender(n2, string, uDPPacketSender);
        RTCPTransmitter rTCPTransmitter = new RTCPTransmitter(this.cache, rTCPRawSender);
        rTCPTransmitter.setSSRCInfo(sSRCInfo);
        RTCPReporter rTCPReporter = new RTCPReporter(this.cache, rTCPTransmitter);
        return rTCPReporter;
    }

    private synchronized RTCPReporter startParticipating(SessionAddress sessionAddress, SessionAddress sessionAddress2, SSRCInfo sSRCInfo, DatagramSocket datagramSocket) throws IOException {
        this.localReceiverAddress = sessionAddress;
        this.startedparticipating = true;
        UDPPacketSender uDPPacketSender = null;
        int n2 = sessionAddress2.getControlPort();
        InetAddress inetAddress = sessionAddress2.getControlAddress();
        int n3 = sessionAddress.getControlPort();
        InetAddress inetAddress2 = sessionAddress.getControlAddress();
        uDPPacketSender = n2 == -1 ? new UDPPacketSender(inetAddress, n2) : (n2 == n3 ? new UDPPacketSender(datagramSocket) : new UDPPacketSender(n2, inetAddress, this.controladdress, this.controlport));
        if (this.ttl != 1) {
            uDPPacketSender.setttl(this.ttl);
        }
        RTCPRawSender rTCPRawSender = new RTCPRawSender(this.controlport, this.controladdress.getHostName(), uDPPacketSender);
        RTCPTransmitter rTCPTransmitter = new RTCPTransmitter(this.cache, rTCPRawSender);
        rTCPTransmitter.setSSRCInfo(sSRCInfo);
        RTCPReporter rTCPReporter = new RTCPReporter(this.cache, rTCPTransmitter);
        return rTCPReporter;
    }

    private synchronized void stopParticipating(String string, SSRCInfo sSRCInfo) {
        if (sSRCInfo.reporter != null) {
            sSRCInfo.reporter.close(string);
            sSRCInfo.reporter = null;
        }
    }

    private int initSession(SourceDescription[] sourceDescriptionArray, double d2, double d3) {
        SourceDescription[] sourceDescriptionArray2;
        if (this.initialized) {
            return -1;
        }
        InetAddress inetAddress = null;
        if (d2 == 0.0) {
            this.nonparticipating = true;
        }
        this.defaultSSRC = this.generateSSRC();
        this.cache = new SSRCCache(this);
        this.formatinfo.setCache(this.cache);
        this.cache.rtcp_bw_fraction = d2;
        this.cache.rtcp_sender_bw_fraction = d3;
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable throwable) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                sourceDescriptionArray2 = jdk12InetAddressAction.cons;
                inetAddress = (InetAddress)jdk12.doPrivM.invoke((Object)jdk12.ac, sourceDescriptionArray2.newInstance(null, "getLocalHost", null));
            } else {
                inetAddress = InetAddress.getLocalHost();
            }
        }
        catch (Throwable throwable) {
            System.err.println("InitSession : UnknownHostExcpetion " + throwable.getMessage());
            throwable.printStackTrace();
            return -1;
        }
        this.cache.ourssrc = this.cache.get((int)this.defaultSSRC, null, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(sourceDescriptionArray)) {
            sourceDescriptionArray2 = this.setCNAME(sourceDescriptionArray);
            this.cache.ourssrc.setSourceDescription(sourceDescriptionArray2);
        } else {
            this.cache.ourssrc.setSourceDescription(sourceDescriptionArray);
        }
        this.cache.ourssrc.ssrc = (int)this.defaultSSRC;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
        return 0;
    }

    boolean isBroadcast(InetAddress inetAddress) {
        InetAddress inetAddress2 = null;
        try {
            inetAddress2 = InetAddress.getLocalHost();
            byte[] byArray = inetAddress2.getAddress();
            int n2 = byArray[3] & 0xFF;
            n2 |= byArray[2] << 8 & 0xFF00;
            n2 |= byArray[1] << 16 & 0xFF0000;
            byte[] byArray2 = inetAddress.getAddress();
            int n3 = byArray2[3] & 0xFF;
            n3 |= byArray2[2] << 8 & 0xFF00;
            n3 |= byArray2[1] << 16 & 0xFF0000;
            if (((n2 |= byArray[0] << 24 & 0xFF000000) | 0xFF) == (n3 |= byArray2[0] << 24 & 0xFF000000)) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println(unknownHostException.getMessage());
        }
        return false;
    }

    private boolean Win32() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public void initialize(RTPConnector rTPConnector) {
        this.rtpConnector = rTPConnector;
        this.newRtpInterface = true;
        String string = SourceDescription.generateCNAME();
        SourceDescription[] sourceDescriptionArray = new SourceDescription[]{new SourceDescription(3, "jmf-user@sun.com", 1, false), new SourceDescription(1, string, 1, false), new SourceDescription(6, "JMF RTP Player v2.0", 1, false)};
        int n2 = (int)this.generateSSRC();
        this.ttl = 1;
        this.participating = this.rtpConnector.getRTCPBandwidthFraction() != 0.0;
        this.cache = new SSRCCache(this);
        this.cache.sessionbandwidth = 384000;
        this.formatinfo.setCache(this.cache);
        this.cache.rtcp_bw_fraction = this.rtpConnector.getRTCPBandwidthFraction() > 0.0 ? this.rtpConnector.getRTCPBandwidthFraction() : 0.05;
        this.cache.rtcp_sender_bw_fraction = this.rtpConnector.getRTCPSenderBandwidthFraction() > 0.0 ? this.rtpConnector.getRTCPSenderBandwidthFraction() : 0.25;
        this.cache.ourssrc = this.cache.get(n2, null, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(sourceDescriptionArray)) {
            SourceDescription[] sourceDescriptionArray2 = this.setCNAME(sourceDescriptionArray);
            this.cache.ourssrc.setSourceDescription(sourceDescriptionArray2);
        } else {
            this.cache.ourssrc.setSourceDescription(sourceDescriptionArray);
        }
        this.cache.ourssrc.ssrc = n2;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
        this.rtpRawReceiver = new RTPRawReceiver(this.rtpConnector, this.defaultstats);
        this.rtcpRawReceiver = new RTCPRawReceiver(this.rtpConnector, this.defaultstats, this.streamSynch);
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, this.rtpRawReceiver, this.streamSynch);
        this.rtpForwarder = new PacketForwarder(this.rtpRawReceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder: " + this.rtpConnector);
        }
        this.rtcpForwarder = new PacketForwarder(this.rtcpRawReceiver, new RTCPReceiver(this.cache));
        if (this.rtcpForwarder != null) {
            this.rtcpForwarder.startPF("RTCP Forwarder: " + this.rtpConnector);
        }
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (this.participating && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startParticipating(this.rtpConnector, this.cache.ourssrc);
        }
    }

    public void initialize(SessionAddress sessionAddress) throws InvalidSessionAddressException {
        String string = SourceDescription.generateCNAME();
        SourceDescription[] sourceDescriptionArray = new SourceDescription[]{new SourceDescription(3, "jmf-user@sun.com", 1, false), new SourceDescription(1, string, 1, false), new SourceDescription(6, "JMF RTP Player v2.0", 1, false)};
        double d2 = 0.05;
        double d3 = 0.25;
        SessionAddress[] sessionAddressArray = new SessionAddress[]{sessionAddress};
        this.initialize(sessionAddressArray, sourceDescriptionArray, d2, d3, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(SessionAddress[] sessionAddressArray, SourceDescription[] sourceDescriptionArray, double d2, double d3, EncryptionInfo encryptionInfo) throws InvalidSessionAddressException {
        InetAddress inetAddress;
        if (this.initialized) {
            return;
        }
        this.newRtpInterface = true;
        this.remoteAddresses = new Vector();
        int n2 = (int)this.generateSSRC();
        this.ttl = 1;
        this.participating = d2 != 0.0;
        if (sessionAddressArray.length == 0) {
            throw new InvalidSessionAddressException("At least one local address is required!");
        }
        this.localAddress = sessionAddressArray[0];
        if (this.localAddress == null) {
            throw new InvalidSessionAddressException("Invalid local address: null");
        }
        InetAddress[] inetAddressArray = null;
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable throwable) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            String string;
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor constructor = jdk12InetAddressAction.cons;
                inetAddress = (InetAddress)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(null, "getLocalHost", null));
                string = (String)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(inetAddress, "getHostName", null));
                inetAddressArray = (InetAddress[])jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(null, "getAllByName", string));
            } else {
                inetAddress = InetAddress.getLocalHost();
                string = inetAddress.getHostName();
                inetAddressArray = InetAddress.getAllByName(string);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Initialize : UnknownHostExcpetion " + throwable.getMessage());
            throwable.printStackTrace();
            return;
        }
        if (this.localAddress.getDataAddress() == null) {
            this.localAddress.setDataHostAddress(inetAddress);
        }
        if (this.localAddress.getControlAddress() == null) {
            this.localAddress.setControlHostAddress(inetAddress);
        }
        if (this.localAddress.getDataAddress().isMulticastAddress()) {
            if (!this.localAddress.getControlAddress().isMulticastAddress()) throw new InvalidSessionAddressException("Invalid multicast address");
            this.ttl = this.localAddress.getTimeToLive();
        } else {
            boolean bl = false;
            boolean bl2 = false;
            int n3 = 0;
            while (!(n3 >= inetAddressArray.length || bl && bl2)) {
                if (inetAddressArray[n3].equals(this.localAddress.getDataAddress())) {
                    bl = true;
                }
                if (inetAddressArray[n3].equals(this.localAddress.getControlAddress())) {
                    bl2 = true;
                }
                ++n3;
            }
            if (!bl) {
                String string = "Does not belong to any of this hosts local interfaces";
                throw new InvalidSessionAddressException("Local Data Address" + string);
            }
            if (!bl2) {
                String string = "Does not belong to any of this hosts local interfaces";
                throw new InvalidSessionAddressException("Local Control Address" + string);
            }
            if (this.localAddress.getDataPort() == -1) {
                int n4 = this.findLocalPorts();
                this.localAddress.setDataPort(n4);
                this.localAddress.setControlPort(n4 + 1);
            }
            if (!this.localAddress.getDataAddress().isMulticastAddress()) {
                try {
                    this.dataSocket = new DatagramSocket(this.localAddress.getDataPort(), this.localAddress.getDataAddress());
                }
                catch (SocketException socketException) {
                    throw new InvalidSessionAddressException("Can't open local data port: " + this.localAddress.getDataPort());
                }
            }
            if (!this.localAddress.getControlAddress().isMulticastAddress()) {
                try {
                    this.controlSocket = new DatagramSocket(this.localAddress.getControlPort(), this.localAddress.getControlAddress());
                }
                catch (SocketException socketException) {
                    if (this.dataSocket == null) throw new InvalidSessionAddressException("Can't open local control port: " + this.localAddress.getControlPort());
                    this.dataSocket.close();
                    throw new InvalidSessionAddressException("Can't open local control port: " + this.localAddress.getControlPort());
                }
            }
        }
        this.cache = new SSRCCache(this);
        this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
        this.formatinfo.setCache(this.cache);
        this.cache.rtcp_bw_fraction = d2;
        this.cache.rtcp_sender_bw_fraction = d3;
        this.cache.ourssrc = this.cache.get(n2, inetAddress, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(sourceDescriptionArray)) {
            SourceDescription[] sourceDescriptionArray2 = this.setCNAME(sourceDescriptionArray);
            this.cache.ourssrc.setSourceDescription(sourceDescriptionArray2);
        } else {
            this.cache.ourssrc.setSourceDescription(sourceDescriptionArray);
        }
        this.cache.ourssrc.ssrc = n2;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
    }

    public void addTarget(SessionAddress sessionAddress) throws IOException {
        this.remoteAddresses.addElement(sessionAddress);
        if (this.remoteAddresses.size() > 1) {
            this.setRemoteAddresses();
            return;
        }
        this.remoteAddress = sessionAddress;
        if (jmfSecurity != null) {
            String string = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    string = "read property";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 1);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    string = "connect";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable throwable) {
                if (string.startsWith("read")) {
                    jmfSecurity.permissionFailureNotification(1);
                }
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            this.rtcpRawReceiver = new RTCPRawReceiver(this.localAddress, sessionAddress, this.defaultstats, this.streamSynch, this.controlSocket);
            this.rtpRawReceiver = new RTPRawReceiver(this.localAddress, sessionAddress, this.defaultstats, this.dataSocket);
        }
        catch (SocketException socketException) {
            throw new IOException(socketException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            throw new IOException(unknownHostException.getMessage());
        }
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, this.rtpRawReceiver, this.streamSynch);
        this.rtcpForwarder = new PacketForwarder(this.rtcpRawReceiver, new RTCPReceiver(this.cache));
        if (this.rtpRawReceiver != null) {
            this.rtpForwarder = new PacketForwarder(this.rtpRawReceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        }
        this.rtcpForwarder.startPF("RTCP Forwarder for address" + sessionAddress.getControlHostAddress() + " port " + sessionAddress.getControlPort());
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder for address " + sessionAddress.getDataHostAddress() + " port " + sessionAddress.getDataPort());
        }
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (this.cache.ourssrc != null && this.participating) {
            this.cache.ourssrc.reporter = this.startParticipating(this.rtcpRawReceiver.socket);
        }
    }

    private synchronized RTCPReporter startParticipating(DatagramSocket datagramSocket) throws IOException {
        UDPPacketSender uDPPacketSender;
        this.udpPacketSender = uDPPacketSender = new UDPPacketSender(datagramSocket);
        if (this.ttl != 1) {
            uDPPacketSender.setttl(this.ttl);
        }
        RTCPRawSender rTCPRawSender = new RTCPRawSender(this.remoteAddress.getControlPort(), this.remoteAddress.getControlAddress().getHostName(), uDPPacketSender);
        this.rtcpTransmitter = new RTCPTransmitter(this.cache, rTCPRawSender);
        this.rtcpTransmitter.setSSRCInfo(this.cache.ourssrc);
        RTCPReporter rTCPReporter = new RTCPReporter(this.cache, this.rtcpTransmitter);
        this.startedparticipating = true;
        return rTCPReporter;
    }

    public void removeTargets(String string) {
        if (this.cache != null) {
            this.stopParticipating(string, this.cache.ourssrc);
        }
        if (this.remoteAddresses != null) {
            this.remoteAddresses.removeAllElements();
        }
        this.setRemoteAddresses();
    }

    public void removeTarget(SessionAddress sessionAddress, String string) {
        this.remoteAddresses.removeElement(sessionAddress);
        this.setRemoteAddresses();
        if (this.remoteAddresses.size() == 0 && this.cache != null) {
            this.stopParticipating(string, this.cache.ourssrc);
        }
    }

    private void setRemoteAddresses() {
        PacketFilter packetFilter;
        if (this.rtpTransmitter != null) {
            packetFilter = this.rtpTransmitter.getSender();
            ((RTPRawSender)packetFilter).setDestAddresses(this.remoteAddresses);
        }
        if (this.rtcpTransmitter != null) {
            packetFilter = this.rtcpTransmitter.getSender();
            ((RTCPRawSender)packetFilter).setDestAddresses(this.remoteAddresses);
        }
    }

    public void dispose() {
        Object object;
        if (this.rtpConnector != null) {
            this.rtpConnector.close();
        }
        if (this.defaultsource != null) {
            this.defaultsource.disconnect();
        }
        if (this.cache != null) {
            Enumeration enumeration = this.cache.cache.elements();
            while (enumeration.hasMoreElements()) {
                object = (SSRCInfo)enumeration.nextElement();
                if (((SSRCInfo)object).dstream != null) {
                    ((SSRCInfo)object).dstream.close();
                }
                if (object instanceof SendSSRCInfo) {
                    ((SendSSRCInfo)object).close();
                }
                this.stopParticipating("dispose", (SSRCInfo)object);
            }
        }
        int n2 = 0;
        while (n2 < this.sendstreamlist.size()) {
            this.removeSendStream((SendStream)this.sendstreamlist.elementAt(n2));
            ++n2;
        }
        if (this.rtpTransmitter != null) {
            this.rtpTransmitter.close();
        }
        if (this.rtcpTransmitter != null) {
            this.rtcpTransmitter.close();
        }
        if (this.rtcpForwarder != null) {
            object = (RTCPRawReceiver)this.rtcpForwarder.getSource();
            this.rtcpForwarder.close();
            if (object != null) {
                ((RTCPRawReceiver)object).close();
            }
        }
        if (this.cleaner != null) {
            this.cleaner.stop();
        }
        if (this.cache != null) {
            this.cache.destroy();
        }
        if (this.rtpForwarder != null) {
            object = (RTPRawReceiver)this.rtpForwarder.getSource();
            this.rtpForwarder.close();
            if (object != null) {
                ((RTPRawReceiver)object).close();
            }
        }
    }

    public SessionAddress getRemoteSessionAddress() {
        return this.remoteAddress;
    }

    public int getSSRC() {
        return 0;
    }

    private int findLocalPorts() {
        boolean bl = false;
        int n2 = -1;
        while (!bl) {
            do {
                double d2;
                if ((n2 = (int)((d2 = Math.random()) * 65535.0)) % 2 == 0) continue;
                ++n2;
            } while (n2 < 1024 || n2 > 65534);
            try {
                DatagramSocket datagramSocket = new DatagramSocket(n2);
                datagramSocket.close();
                datagramSocket = new DatagramSocket(n2 + 1);
                datagramSocket.close();
                bl = true;
            }
            catch (SocketException socketException) {
                bl = false;
            }
        }
        return n2;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        supportedList = null;
        addedList = new Vector();
    }
}

