/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.AdaptiveCoding;
import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Coding;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Histogram;
import com.sun.java.util.jar.pack.PopulationCoding;
import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

class CodingChooser
implements Constants {
    int verbose;
    int effort;
    boolean optUseHistogram = true;
    boolean optUsePopulationCoding = true;
    boolean optUseAdaptiveCoding = true;
    boolean disablePopCoding;
    boolean disableRunCoding;
    boolean topLevel = true;
    double fuzz;
    Coding[] allCodingChoices;
    Choice[] choices;
    ByteArrayOutputStream context;
    CodingChooser popHelper;
    CodingChooser runHelper;
    private int[] values;
    private int start;
    private int end;
    private int[] deltas;
    private int min;
    private int max;
    private Histogram vHist;
    private Histogram dHist;
    private int searchOrder;
    private Choice regularChoice;
    private Choice bestChoice;
    private CodingMethod bestMethod;
    private int bestByteSize;
    private int bestZipSize;
    private int targetSize;
    public static final int MIN_EFFORT = 1;
    public static final int MID_EFFORT = 5;
    public static final int MAX_EFFORT = 9;
    public static final int POP_EFFORT = 4;
    public static final int RUN_EFFORT = 3;
    public static final int BYTE_SIZE = 0;
    public static final int ZIP_SIZE = 1;
    private Sizer zipSizer = new Sizer();
    private Deflater zipDef = new Deflater();
    private DeflaterOutputStream zipOut = new DeflaterOutputStream(this.zipSizer, this.zipDef);
    private Sizer byteSizer = new Sizer(this.zipOut);
    private Sizer byteOnlySizer = new Sizer();

    CodingChooser(int n2, Coding[] codingArray) {
        Object object;
        int n3;
        PropMap propMap = Utils.currentPropMap();
        if (propMap != null) {
            this.verbose = Math.max(propMap.getInteger("com.sun.java.util.jar.pack.verbose"), propMap.getInteger("com.sun.java.util.jar.pack.verbose.coding"));
            this.optUseHistogram = !propMap.getBoolean("com.sun.java.util.jar.pack.no.histogram");
            this.optUsePopulationCoding = !propMap.getBoolean("com.sun.java.util.jar.pack.no.population.coding");
            this.optUseAdaptiveCoding = !propMap.getBoolean("com.sun.java.util.jar.pack.no.adaptive.coding");
        }
        this.effort = n2;
        this.allCodingChoices = codingArray;
        this.fuzz = 1.0 + 0.0025 * (double)(n2 - 5);
        int n4 = 0;
        for (n3 = 0; n3 < codingArray.length; ++n3) {
            if (codingArray[n3] == null) continue;
            ++n4;
        }
        this.choices = new Choice[n4];
        n4 = 0;
        for (n3 = 0; n3 < codingArray.length; ++n3) {
            if (codingArray[n3] == null) continue;
            object = new int[this.choices.length];
            this.choices[n4++] = new Choice(codingArray[n3], n3, (int[])object);
        }
        for (n3 = 0; n3 < this.choices.length; ++n3) {
            object = this.choices[n3].coding;
            assert (((Coding)object).distanceFrom((Coding)object) == 0);
            for (int i2 = 0; i2 < n3; ++i2) {
                Coding coding = this.choices[i2].coding;
                int n5 = ((Coding)object).distanceFrom(coding);
                assert (n5 > 0);
                assert (n5 == coding.distanceFrom((Coding)object));
                this.choices[n3].distance[i2] = n5;
                this.choices[i2].distance[n3] = n5;
            }
        }
    }

    Choice makeExtraChoice(Coding coding) {
        int[] nArray = new int[this.choices.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Coding coding2 = this.choices[i2].coding;
            int n2 = coding.distanceFrom(coding2);
            assert (n2 > 0);
            assert (n2 == coding2.distanceFrom(coding));
            nArray[i2] = n2;
        }
        Choice choice = new Choice(coding, -1, nArray);
        choice.reset();
        return choice;
    }

    ByteArrayOutputStream getContext() {
        if (this.context == null) {
            this.context = new ByteArrayOutputStream(65536);
        }
        return this.context;
    }

    private void reset(int[] nArray, int n2, int n3) {
        this.values = nArray;
        this.start = n2;
        this.end = n3;
        this.deltas = null;
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        this.vHist = null;
        this.dHist = null;
        this.searchOrder = 0;
        this.regularChoice = null;
        this.bestChoice = null;
        this.bestMethod = null;
        this.bestZipSize = Integer.MAX_VALUE;
        this.bestByteSize = Integer.MAX_VALUE;
        this.targetSize = Integer.MAX_VALUE;
    }

    CodingMethod choose(int[] nArray, int n2, int n3, Coding coding, int[] nArray2) {
        int n4;
        int n5;
        int n6;
        this.reset(nArray, n2, n3);
        if (this.effort <= 1 || n2 >= n3) {
            if (nArray2 != null) {
                int[] nArray3 = this.computeSizePrivate(coding);
                nArray2[0] = nArray3[0];
                nArray2[1] = nArray3[1];
            }
            return coding;
        }
        if (this.optUseHistogram) {
            this.getValueHistogram();
            this.getDeltaHistogram();
        }
        for (n6 = n2; n6 < n3; ++n6) {
            int n7 = nArray[n6];
            if (this.min > n7) {
                this.min = n7;
            }
            if (this.max >= n7) continue;
            this.max = n7;
        }
        n6 = this.markUsableChoices(coding);
        double d2 = 1.0;
        for (n5 = this.effort; n5 < 9; ++n5) {
            d2 /= 1.414;
        }
        n5 = (int)Math.ceil((double)n6 * d2);
        this.bestChoice = this.regularChoice;
        this.evaluate(this.regularChoice);
        int n8 = this.updateDistances(this.regularChoice);
        int n9 = this.bestZipSize;
        int n10 = this.bestByteSize;
        if (this.regularChoice.coding == coding && this.topLevel && coding.canRepresent(n4 = BandStructure.encodeEscapeValue(115, coding))) {
            int n11 = coding.getLength(n4);
            this.regularChoice.zipSize -= n11;
            this.bestByteSize = this.regularChoice.byteSize;
            this.bestZipSize = this.regularChoice.zipSize;
        }
        n4 = 1;
        while (this.searchOrder < n5) {
            int n12;
            int n13;
            Choice choice;
            if (n4 > n8) {
                n4 = 1;
            }
            if ((choice = this.findChoiceNear(this.bestChoice, n13 = n8 / n4, n12 = n8 / (n4 *= 2) + 1)) == null) continue;
            assert (choice.coding.canRepresent(this.min, this.max));
            this.evaluate(choice);
            int n14 = this.updateDistances(choice);
            if (choice != this.bestChoice) continue;
            n8 = n14;
            if (this.verbose <= 5) continue;
            Utils.log.info("maxd = " + n8);
        }
        Coding coding2 = this.bestChoice.coding;
        assert (coding2 == this.bestMethod);
        if (this.verbose > 2) {
            Utils.log.info("chooser: plain result=" + this.bestChoice + " after " + this.bestChoice.searchOrder + " rounds, " + (this.regularChoice.zipSize - this.bestZipSize) + " fewer bytes than regular " + coding);
        }
        this.bestChoice = null;
        if (!this.disablePopCoding && this.optUsePopulationCoding && this.effort >= 4 && this.bestMethod instanceof Coding) {
            this.tryPopulationCoding(coding2);
        }
        if (!this.disableRunCoding && this.optUseAdaptiveCoding && this.effort >= 3 && this.bestMethod instanceof Coding) {
            this.tryAdaptiveCoding(coding2);
        }
        if (nArray2 != null) {
            nArray2[0] = this.bestByteSize;
            nArray2[1] = this.bestZipSize;
        }
        if (this.verbose > 1) {
            Utils.log.info("chooser: result=" + this.bestMethod + " " + (n9 - this.bestZipSize) + " fewer bytes than regular " + coding + "; win=" + CodingChooser.pct(n9 - this.bestZipSize, n9));
        }
        CodingMethod codingMethod = this.bestMethod;
        this.reset(null, 0, 0);
        return codingMethod;
    }

    CodingMethod choose(int[] nArray, int n2, int n3, Coding coding) {
        return this.choose(nArray, n2, n3, coding, null);
    }

    CodingMethod choose(int[] nArray, Coding coding, int[] nArray2) {
        return this.choose(nArray, 0, nArray.length, coding, nArray2);
    }

    CodingMethod choose(int[] nArray, Coding coding) {
        return this.choose(nArray, 0, nArray.length, coding, null);
    }

    private int markUsableChoices(Coding coding) {
        Choice choice;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.choices.length; ++n2) {
            choice = this.choices[n2];
            choice.reset();
            if (!choice.coding.canRepresent(this.min, this.max)) {
                choice.searchOrder = -1;
                if (this.verbose <= 1 || choice.coding != coding) continue;
                Utils.log.info("regular coding cannot represent [" + this.min + ".." + this.max + "]: " + coding);
                continue;
            }
            if (choice.coding == coding) {
                this.regularChoice = choice;
            }
            ++n3;
        }
        if (this.regularChoice == null && coding.canRepresent(this.min, this.max)) {
            this.regularChoice = this.makeExtraChoice(coding);
            if (this.verbose > 1) {
                Utils.log.info("*** regular choice is extra: " + this.regularChoice.coding);
            }
        }
        if (this.regularChoice == null) {
            for (n2 = 0; n2 < this.choices.length; ++n2) {
                choice = this.choices[n2];
                if (choice.searchOrder == -1) continue;
                this.regularChoice = choice;
                break;
            }
            if (this.verbose > 1) {
                Utils.log.info("*** regular choice does not apply " + coding);
                Utils.log.info("    using instead " + this.regularChoice.coding);
            }
        }
        if (this.verbose > 2) {
            Utils.log.info("chooser: #choices=" + n3 + " [" + this.min + ".." + this.max + "]");
            if (this.verbose > 4) {
                for (n2 = 0; n2 < this.choices.length; ++n2) {
                    choice = this.choices[n2];
                    if (choice.searchOrder < 0) continue;
                    Utils.log.info("  " + choice);
                }
            }
        }
        return n3;
    }

    private Choice findChoiceNear(Choice choice, int n2, int n3) {
        if (this.verbose > 5) {
            Utils.log.info("findChoice " + n2 + ".." + n3 + " near: " + choice);
        }
        int[] nArray = choice.distance;
        Choice choice2 = null;
        for (int i2 = 0; i2 < this.choices.length; ++i2) {
            Choice choice3 = this.choices[i2];
            if (choice3.searchOrder < this.searchOrder || nArray[i2] < n3 || nArray[i2] > n2) continue;
            if (choice3.minDistance >= n3 && choice3.minDistance <= n2) {
                if (this.verbose > 5) {
                    Utils.log.info("findChoice => good " + choice3);
                }
                return choice3;
            }
            choice2 = choice3;
        }
        if (this.verbose > 5) {
            Utils.log.info("findChoice => found " + choice2);
        }
        return choice2;
    }

    private void evaluate(Choice choice) {
        Object object;
        boolean bl2;
        assert (choice.searchOrder == Integer.MAX_VALUE);
        choice.searchOrder = this.searchOrder++;
        if (choice == this.bestChoice || choice.isExtra()) {
            bl2 = true;
        } else if (this.optUseHistogram) {
            object = this.getHistogram(choice.coding.isDelta());
            choice.byteSize = choice.histSize = (int)Math.ceil(((Histogram)object).getBitLength(choice.coding) / 8.0);
            bl2 = choice.byteSize <= this.targetSize;
        } else {
            bl2 = true;
        }
        if (bl2) {
            object = this.computeSizePrivate(choice.coding);
            choice.byteSize = object[0];
            choice.zipSize = (int)object[1];
            if (this.noteSizes(choice.coding, choice.byteSize, choice.zipSize)) {
                this.bestChoice = choice;
            }
        }
        if (choice.histSize >= 0) assert (choice.byteSize == choice.histSize);
        if (this.verbose > 4) {
            Utils.log.info("evaluated " + choice);
        }
    }

    private boolean noteSizes(CodingMethod codingMethod, int n2, int n3) {
        boolean bl2;
        assert (n3 > 0 && n2 > 0);
        boolean bl3 = bl2 = n3 < this.bestZipSize;
        if (this.verbose > 3) {
            Utils.log.info("computed size " + codingMethod + " " + n2 + "/zs=" + n3 + (bl2 && this.bestMethod != null ? " better by " + CodingChooser.pct(this.bestZipSize - n3, n3) : ""));
        }
        if (bl2) {
            this.bestMethod = codingMethod;
            this.bestZipSize = n3;
            this.bestByteSize = n2;
            this.targetSize = (int)((double)n2 * this.fuzz);
            return true;
        }
        return false;
    }

    private int updateDistances(Choice choice) {
        int[] nArray = choice.distance;
        int n2 = 0;
        for (int i2 = 0; i2 < this.choices.length; ++i2) {
            int n3;
            Choice choice2 = this.choices[i2];
            if (choice2.searchOrder < this.searchOrder) continue;
            int n4 = nArray[i2];
            if (this.verbose > 5) {
                Utils.log.info("evaluate dist " + n4 + " to " + choice2);
            }
            if ((n3 = choice2.minDistance) > n4) {
                choice2.minDistance = n3 = n4;
            }
            if (n2 >= n4) continue;
            n2 = n4;
        }
        if (this.verbose > 5) {
            Utils.log.info("evaluate maxd => " + n2);
        }
        return n2;
    }

    public void computeSize(CodingMethod codingMethod, int[] nArray, int n2, int n3, int[] nArray2) {
        if (n3 <= n2) {
            nArray2[1] = 0;
            nArray2[0] = 0;
            return;
        }
        try {
            this.resetData();
            codingMethod.writeArrayTo(this.byteSizer, nArray, n2, n3);
            nArray2[0] = this.getByteSize();
            nArray2[1] = this.getZipSize();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void computeSize(CodingMethod codingMethod, int[] nArray, int[] nArray2) {
        this.computeSize(codingMethod, nArray, 0, nArray.length, nArray2);
    }

    public int[] computeSize(CodingMethod codingMethod, int[] nArray, int n2, int n3) {
        int[] nArray2 = new int[]{0, 0};
        this.computeSize(codingMethod, nArray, n2, n3, nArray2);
        return nArray2;
    }

    public int[] computeSize(CodingMethod codingMethod, int[] nArray) {
        return this.computeSize(codingMethod, nArray, 0, nArray.length);
    }

    private int[] computeSizePrivate(CodingMethod codingMethod) {
        int[] nArray = new int[]{0, 0};
        this.computeSize(codingMethod, this.values, this.start, this.end, nArray);
        return nArray;
    }

    public int computeByteSize(CodingMethod codingMethod, int[] nArray, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            return 0;
        }
        if (codingMethod instanceof Coding) {
            int n5;
            Coding coding = (Coding)codingMethod;
            int n6 = coding.getLength(nArray, n2, n3);
            assert (n6 == (n5 = this.countBytesToSizer(codingMethod, nArray, n2, n3))) : codingMethod + " : " + n6 + " != " + n5;
            return n6;
        }
        return this.countBytesToSizer(codingMethod, nArray, n2, n3);
    }

    private int countBytesToSizer(CodingMethod codingMethod, int[] nArray, int n2, int n3) {
        try {
            this.byteOnlySizer.reset();
            codingMethod.writeArrayTo(this.byteOnlySizer, nArray, n2, n3);
            return this.byteOnlySizer.getSize();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    int[] getDeltas() {
        if (this.deltas == null) {
            this.deltas = Coding.makeDeltas(this.values, this.start, this.end, null);
        }
        return this.deltas;
    }

    Histogram getValueHistogram() {
        if (this.vHist == null) {
            this.vHist = new Histogram(this.values, this.start, this.end);
            if (this.verbose > 3) {
                this.vHist.print("vHist", System.out);
            } else if (this.verbose > 1) {
                this.vHist.print("vHist", null, System.out);
            }
        }
        return this.vHist;
    }

    Histogram getDeltaHistogram() {
        if (this.dHist == null) {
            this.dHist = new Histogram(this.getDeltas());
            if (this.verbose > 3) {
                this.dHist.print("dHist", System.out);
            } else if (this.verbose > 1) {
                this.dHist.print("dHist", null, System.out);
            }
        }
        return this.dHist;
    }

    Histogram getHistogram(boolean bl2) {
        return bl2 ? this.getDeltaHistogram() : this.getValueHistogram();
    }

    private void tryPopulationCoding(Coding coding) {
        Iterator iterator;
        CodingMethod codingMethod;
        int n2;
        Histogram histogram = this.getValueHistogram();
        Coding coding2 = coding.getValueCoding();
        Coding coding3 = BandStructure.UNSIGNED5.setL(64);
        Coding coding4 = coding.getValueCoding();
        int n3 = 4 + Math.max(coding2.getLength(this.min), coding2.getLength(this.max));
        int n4 = coding3.getLength(0);
        int n5 = n4 * (this.end - this.start);
        int n6 = (int)Math.ceil(histogram.getBitLength(coding4) / 8.0);
        int n7 = n3 + n5 + n6;
        int n8 = 0;
        int[] nArray = new int[1 + histogram.getTotalLength()];
        int n9 = -1;
        int n10 = -1;
        int[][] nArray2 = histogram.getMatrix();
        int n11 = -1;
        int n12 = 1;
        int n13 = 0;
        for (n2 = 1; n2 <= histogram.getTotalLength(); ++n2) {
            int n14;
            if (n12 == 1) {
                n13 = nArray2[++n11][0];
                n12 = nArray2[n11].length;
            }
            nArray[n2] = n14 = nArray2[n11][--n12];
            int n15 = coding2.getLength(n14);
            int n16 = n13;
            int n17 = n2;
            int n18 = (n3 += n15) + (n5 += (coding3.getLength(n17) - n4) * n16) + (n6 -= n15 * n16);
            if (n7 <= n18) continue;
            if (n18 <= this.targetSize) {
                n10 = n2;
                if (n9 < 0) {
                    n9 = n2;
                }
                if (this.verbose > 4) {
                    Utils.log.info("better pop-size at fvc=" + n2 + " by " + CodingChooser.pct(n7 - n18, n7));
                }
            }
            n7 = n18;
            n8 = n2;
        }
        if (n9 < 0) {
            if (this.verbose > 1 && this.verbose > 1) {
                Utils.log.info("no good pop-size; best was " + n7 + " at " + n8 + " worse by " + CodingChooser.pct(n7 - this.bestByteSize, this.bestByteSize));
            }
            return;
        }
        if (this.verbose > 1) {
            Utils.log.info("initial best pop-size at fvc=" + n8 + " in [" + n9 + ".." + n10 + "]" + " by " + CodingChooser.pct(this.bestByteSize - n7, this.bestByteSize));
        }
        n2 = this.bestZipSize;
        int[] nArray3 = PopulationCoding.LValuesCoded;
        ArrayList<Coding> arrayList = new ArrayList<Coding>();
        ArrayList<Coding> arrayList2 = new ArrayList<Coding>();
        ArrayList<Coding> arrayList3 = new ArrayList<Coding>();
        if (n8 <= 255) {
            arrayList.add(BandStructure.BYTE1);
        } else {
            boolean bl2;
            int n19 = 5;
            boolean bl3 = bl2 = this.effort > 4;
            if (bl2) {
                arrayList2.add(BandStructure.BYTE1.setS(1));
            }
            for (int i2 = nArray3.length - 1; i2 >= 1; --i2) {
                int n20 = nArray3[i2];
                Coding coding5 = PopulationCoding.fitTokenCoding(n9, n20);
                Coding coding6 = PopulationCoding.fitTokenCoding(n8, n20);
                codingMethod = PopulationCoding.fitTokenCoding(n10, n20);
                if (coding6 != null) {
                    if (!arrayList.contains(coding6)) {
                        arrayList.add(coding6);
                    }
                    if (n19 > coding6.B()) {
                        n19 = coding6.B();
                    }
                }
                if (!bl2) continue;
                if (codingMethod == null) {
                    codingMethod = coding6;
                }
                for (int i3 = coding5.B(); i3 <= ((Coding)codingMethod).B(); ++i3) {
                    Coding coding7;
                    if (i3 == coding6.B() || i3 == 1 || arrayList2.contains(coding7 = ((Coding)codingMethod).setB(i3).setS(1))) continue;
                    arrayList2.add(coding7);
                }
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Coding coding8 = (Coding)iterator.next();
                if (coding8.B() <= n19) continue;
                iterator.remove();
                arrayList3.add(0, coding8);
            }
        }
        ArrayList arrayList4 = new ArrayList();
        Iterator iterator2 = arrayList.iterator();
        iterator = arrayList2.iterator();
        Object object2 = arrayList3.iterator();
        while (iterator2.hasNext() || iterator.hasNext() || object2.hasNext()) {
            if (iterator2.hasNext()) {
                arrayList4.add(iterator2.next());
            }
            if (iterator.hasNext()) {
                arrayList4.add(iterator.next());
            }
            if (!object2.hasNext()) continue;
            arrayList4.add(object2.next());
        }
        arrayList.clear();
        arrayList2.clear();
        arrayList3.clear();
        int n21 = arrayList4.size();
        if (this.effort == 4) {
            n21 = 2;
        } else if (n21 > 4) {
            n21 -= 4;
            n21 = n21 * (this.effort - 4) / 5;
            n21 += 4;
        }
        if (arrayList4.size() > n21) {
            if (this.verbose > 4) {
                Utils.log.info("allFits before clip: " + arrayList4);
            }
            arrayList4.subList(n21, arrayList4.size()).clear();
        }
        if (this.verbose > 3) {
            Utils.log.info("allFits: " + arrayList4);
        }
        for (Object object2 : arrayList4) {
            int n22;
            boolean bl4 = false;
            if (((Coding)object2).S() == 1) {
                bl4 = true;
                object2 = ((Coding)object2).setS(0);
            }
            if (!bl4) {
                n22 = n8;
                assert (((Coding)object2).umax() >= n22);
                assert (((Coding)object2).B() == 1 || ((Coding)object2).setB(((Coding)object2).B() - 1).umax() < n22);
            } else {
                n22 = Math.min(((Coding)object2).umax(), n10);
                if (n22 < n9 || n22 == n8) continue;
            }
            codingMethod = new PopulationCoding();
            ((PopulationCoding)codingMethod).setHistogram(histogram);
            ((PopulationCoding)codingMethod).setL(((Coding)object2).L());
            ((PopulationCoding)codingMethod).setFavoredValues(nArray, n22);
            assert (((PopulationCoding)codingMethod).tokenCoding == object2);
            ((PopulationCoding)codingMethod).resortFavoredValues();
            int[] nArray4 = this.computePopSizePrivate((PopulationCoding)codingMethod, coding2, coding4);
            this.noteSizes(codingMethod, nArray4[0], 4 + nArray4[1]);
        }
        if (this.verbose > 3) {
            Utils.log.info("measured best pop, size=" + this.bestByteSize + "/zs=" + this.bestZipSize + " better by " + CodingChooser.pct(n2 - this.bestZipSize, n2));
            if (this.bestZipSize < n2) {
                Utils.log.info(">>> POP WINS BY " + (n2 - this.bestZipSize));
            }
        }
    }

    private int[] computePopSizePrivate(PopulationCoding populationCoding, Coding coding, Coding coding2) {
        Object object;
        if (this.popHelper == null) {
            this.popHelper = new CodingChooser(this.effort, this.allCodingChoices);
            this.popHelper.topLevel = false;
            --this.popHelper.verbose;
            this.popHelper.disablePopCoding = true;
            this.popHelper.disableRunCoding = this.disableRunCoding;
            if (this.effort < 5) {
                this.popHelper.disableRunCoding = true;
            }
        }
        int n2 = populationCoding.fVlen;
        if (this.verbose > 2) {
            Utils.log.info("computePopSizePrivate fvlen=" + n2 + " tc=" + populationCoding.tokenCoding);
            Utils.log.info("{ //BEGIN");
        }
        int[] nArray = populationCoding.fValues;
        int[][] nArray2 = populationCoding.encodeValues(this.values, this.start, this.end);
        int[] nArray3 = nArray2[0];
        int[] nArray4 = nArray2[1];
        if (this.verbose > 2) {
            Utils.log.info("-- refine on fv[" + n2 + "] fc=" + coding);
        }
        populationCoding.setFavoredCoding(this.popHelper.choose(nArray, 1, 1 + n2, coding));
        if (populationCoding.tokenCoding instanceof Coding) {
            if (this.verbose > 2) {
                Utils.log.info("-- refine on tv[" + nArray3.length + "] tc=" + populationCoding.tokenCoding);
            }
            if ((object = this.popHelper.choose(nArray3, (Coding)populationCoding.tokenCoding)) != populationCoding.tokenCoding) {
                if (this.verbose > 2) {
                    Utils.log.info(">>> refined tc=" + object);
                }
                populationCoding.setTokenCoding((CodingMethod)object);
            }
        }
        if (nArray4.length == 0) {
            populationCoding.setUnfavoredCoding(null);
        } else {
            if (this.verbose > 2) {
                Utils.log.info("-- refine on uv[" + nArray4.length + "] uc=" + populationCoding.unfavoredCoding);
            }
            populationCoding.setUnfavoredCoding(this.popHelper.choose(nArray4, coding2));
        }
        if (this.verbose > 3) {
            Utils.log.info("finish computePopSizePrivate fvlen=" + n2 + " fc=" + populationCoding.favoredCoding + " tc=" + populationCoding.tokenCoding + " uc=" + populationCoding.unfavoredCoding);
            object = new StringBuffer();
            ((StringBuffer)object).append("fv = {");
            for (int i2 = 1; i2 <= n2; ++i2) {
                if (i2 % 10 == 0) {
                    ((StringBuffer)object).append('\n');
                }
                ((StringBuffer)object).append(" ").append(nArray[i2]);
            }
            ((StringBuffer)object).append('\n');
            ((StringBuffer)object).append("}");
            Utils.log.info(((StringBuffer)object).toString());
        }
        if (this.verbose > 2) {
            Utils.log.info("} //END");
        }
        try {
            this.resetData();
            populationCoding.writeSequencesTo(this.byteSizer, nArray3, nArray4);
            object = new int[]{this.getByteSize(), this.getZipSize()};
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        int[] nArray5 = null;
        assert ((nArray5 = this.computeSizePrivate(populationCoding)) != null);
        assert (nArray5[0] == object[0]) : nArray5[0] + " != " + (int)object[0];
        return object;
    }

    private void tryAdaptiveCoding(Coding coding) {
        int n2;
        int n3;
        int n4 = this.bestZipSize;
        int n5 = this.start;
        int n6 = this.end;
        int[] nArray = this.values;
        int n7 = n6 - n5;
        if (coding.isDelta()) {
            nArray = this.getDeltas();
            n5 = 0;
            n6 = nArray.length;
        }
        int[] nArray2 = new int[n7 + 1];
        int n8 = 0;
        int n9 = 0;
        for (int i2 = n5; i2 < n6; ++i2) {
            int n10 = nArray[i2];
            nArray2[n8++] = n9;
            int n11 = coding.getLength(n10);
            assert (n11 < Integer.MAX_VALUE);
            n9 += n11;
        }
        nArray2[n8++] = n9;
        assert (n8 == nArray2.length);
        double d2 = (double)n9 / (double)n7;
        double d3 = this.effort >= 5 ? (this.effort > 6 ? 1.001 : 1.003) : (this.effort > 3 ? 1.01 : 1.03);
        d3 *= d3;
        double d4 = d3 * d3;
        double d5 = d3 * d3 * d3;
        double[] dArray = new double[1 + (this.effort - 3)];
        double d6 = Math.log(n7);
        for (int i3 = 0; i3 < dArray.length; ++i3) {
            dArray[i3] = Math.exp(d6 * (double)(i3 + 1) / (double)(dArray.length + 1));
        }
        int[] nArray3 = new int[dArray.length];
        int n12 = 0;
        for (int i4 = 0; i4 < dArray.length; ++i4) {
            int n13 = (int)Math.round(dArray[i4]);
            if ((n13 = AdaptiveCoding.getNextK(n13 - 1)) <= 0 || n13 >= n7 || n12 > 0 && n13 == nArray3[n12 - 1]) continue;
            nArray3[n12++] = n13;
        }
        nArray3 = BandStructure.realloc(nArray3, n12);
        int[] nArray4 = new int[nArray3.length];
        double[] dArray2 = new double[nArray3.length];
        for (n3 = 0; n3 < nArray3.length; ++n3) {
            n2 = nArray3[n3];
            double d7 = n2 < 10 ? d5 : (n2 < 100 ? d4 : d3);
            dArray2[n3] = d7;
            nArray4[n3] = 4 + (int)Math.ceil((double)n2 * d2 * d7);
        }
        if (this.verbose > 1) {
            System.out.print("tryAdaptiveCoding [" + n7 + "]" + " avgS=" + d2 + " fuzz=" + d3 + " meshes: {");
            for (n3 = 0; n3 < nArray3.length; ++n3) {
                System.out.print(" " + nArray3[n3] + "(" + nArray4[n3] + ")");
            }
            Utils.log.info(" }");
        }
        if (this.runHelper == null) {
            this.runHelper = new CodingChooser(this.effort, this.allCodingChoices);
            this.runHelper.topLevel = false;
            --this.runHelper.verbose;
            this.runHelper.disableRunCoding = true;
            this.runHelper.disablePopCoding = this.disablePopCoding;
            if (this.effort < 5) {
                this.runHelper.disablePopCoding = true;
            }
        }
        block5: for (n3 = 0; n3 < n7; ++n3) {
            if ((n3 = AdaptiveCoding.getNextK(n3 - 1)) > n7) {
                n3 = n7;
            }
            for (n2 = nArray3.length - 1; n2 >= 0; --n2) {
                CodingMethod codingMethod;
                CodingMethod codingMethod2;
                CodingMethod codingMethod3;
                int n14;
                int n15;
                int n16 = nArray3[n2];
                int n17 = nArray4[n2];
                if (n3 + n16 > n7 || (n15 = nArray2[n3 + n16] - nArray2[n3]) < n17) continue;
                int n18 = n3 + n16;
                int n19 = n15;
                double d8 = d2 * dArray2[n2];
                while (n18 < n7 && n18 - n3 <= n7 / 2) {
                    n14 = n18;
                    int n20 = n19;
                    n18 += n16;
                    if ((n18 = n3 + AdaptiveCoding.getNextK(n18 - n3 - 1)) < 0 || n18 > n7) {
                        n18 = n7;
                    }
                    if (!((double)(n19 = nArray2[n18] - nArray2[n3]) < 4.0 + (double)(n18 - n3) * d8)) continue;
                    n19 = n20;
                    n18 = n14;
                    break;
                }
                n14 = n18;
                if (this.verbose > 2) {
                    Utils.log.info("bulge at " + n3 + "[" + (n18 - n3) + "] of " + CodingChooser.pct((double)n19 - d2 * (double)(n18 - n3), d2 * (double)(n18 - n3)));
                    Utils.log.info("{ //BEGIN");
                }
                if ((codingMethod3 = this.runHelper.choose(this.values, this.start + n3, this.start + n18, coding)) == coding) {
                    codingMethod2 = coding;
                    codingMethod = coding;
                } else {
                    codingMethod2 = this.runHelper.choose(this.values, this.start, this.start + n3, coding);
                    codingMethod = this.runHelper.choose(this.values, this.start + n18, this.start + n7, coding);
                }
                if (this.verbose > 2) {
                    Utils.log.info("} //END");
                }
                if (codingMethod2 == codingMethod3 && n3 > 0 && AdaptiveCoding.isCodableLength(n18)) {
                    n3 = 0;
                }
                if (codingMethod3 == codingMethod && n18 < n7) {
                    n18 = n7;
                }
                if (codingMethod2 != coding || codingMethod3 != coding || codingMethod != coding) {
                    CodingMethod codingMethod4;
                    int n21 = 0;
                    if (n18 == n7) {
                        codingMethod4 = codingMethod3;
                    } else {
                        codingMethod4 = new AdaptiveCoding(n18 - n3, codingMethod3, codingMethod);
                        n21 += 4;
                    }
                    if (n3 > 0) {
                        codingMethod4 = new AdaptiveCoding(n3, codingMethod2, codingMethod4);
                        n21 += 4;
                    }
                    int[] nArray5 = this.computeSizePrivate(codingMethod4);
                    this.noteSizes(codingMethod4, nArray5[0], nArray5[1] + n21);
                }
                n3 = n14;
                continue block5;
            }
        }
        if (this.verbose > 3 && this.bestZipSize < n4) {
            Utils.log.info(">>> RUN WINS BY " + (n4 - this.bestZipSize));
        }
    }

    private static String pct(double d2, double d3) {
        return (double)Math.round(d2 / d3 * 10000.0) / 100.0 + "%";
    }

    private void resetData() {
        this.flushData();
        this.zipDef.reset();
        if (this.context != null) {
            try {
                this.context.writeTo(this.byteSizer);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zipSizer.reset();
        this.byteSizer.reset();
    }

    private void flushData() {
        try {
            this.zipOut.finish();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private int getByteSize() {
        return this.byteSizer.getSize();
    }

    private int getZipSize() {
        this.flushData();
        return this.zipSizer.getSize();
    }

    static class Choice {
        final Coding coding;
        final int index;
        final int[] distance;
        int searchOrder;
        int minDistance;
        int zipSize;
        int byteSize;
        int histSize;

        Choice(Coding coding, int n2, int[] nArray) {
            this.coding = coding;
            this.index = n2;
            this.distance = nArray;
        }

        void reset() {
            this.searchOrder = Integer.MAX_VALUE;
            this.minDistance = Integer.MAX_VALUE;
            this.histSize = -1;
            this.byteSize = -1;
            this.zipSize = -1;
        }

        boolean isExtra() {
            return this.index < 0;
        }

        public String toString() {
            return this.stringForDebug();
        }

        private String stringForDebug() {
            String string = "";
            if (this.searchOrder < Integer.MAX_VALUE) {
                string = string + " so: " + this.searchOrder;
            }
            if (this.minDistance < Integer.MAX_VALUE) {
                string = string + " md: " + this.minDistance;
            }
            if (this.zipSize > 0) {
                string = string + " zs: " + this.zipSize;
            }
            if (this.byteSize > 0) {
                string = string + " bs: " + this.byteSize;
            }
            if (this.histSize > 0) {
                string = string + " hs: " + this.histSize;
            }
            return "Choice[" + this.index + "] " + string + " " + this.coding;
        }
    }

    static class Sizer
    extends OutputStream {
        final OutputStream out;
        private int count;

        Sizer(OutputStream outputStream) {
            this.out = outputStream;
        }

        Sizer() {
            this(null);
        }

        public void write(int n2) throws IOException {
            ++this.count;
            if (this.out != null) {
                this.out.write(n2);
            }
        }

        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.count += n3;
            if (this.out != null) {
                this.out.write(byArray, n2, n3);
            }
        }

        public void reset() {
            this.count = 0;
        }

        public int getSize() {
            return this.count;
        }

        public String toString() {
            String string = super.toString();
            assert ((string = this.stringForDebug()) != null);
            return string;
        }

        String stringForDebug() {
            return "<Sizer " + this.getSize() + ">";
        }
    }
}

