/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Toolkit;
import java.awt.VKCollection;
import java.awt.event.KeyEvent;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWTKeyStroke
implements Serializable {
    static final long serialVersionUID = -6430539691155161871L;
    private static Map cache;
    private static AWTKeyStroke cacheKey;
    private static Constructor ctor;
    private static Map modifierKeywords;
    private static VKCollection vks;
    private char keyChar = (char)65535;
    private int keyCode = 0;
    private int modifiers;
    private boolean onKeyRelease;

    protected AWTKeyStroke() {
    }

    protected AWTKeyStroke(char c2, int n2, int n3, boolean bl2) {
        this.keyChar = c2;
        this.keyCode = n2;
        this.modifiers = n3;
        this.onKeyRelease = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerSubclass(Class<?> clazz) {
        Object object;
        if (clazz == null) {
            throw new IllegalArgumentException("subclass cannot be null");
        }
        if (ctor.getDeclaringClass().equals(clazz)) {
            return;
        }
        if (!AWTKeyStroke.class.isAssignableFrom(clazz)) {
            throw new ClassCastException("subclass is not derived from AWTKeyStroke");
        }
        Constructor constructor = AWTKeyStroke.getCtor(clazz);
        String string = "subclass could not be instantiated";
        if (constructor == null) {
            throw new IllegalArgumentException(string);
        }
        try {
            object = (AWTKeyStroke)constructor.newInstance(null);
            if (object == null) {
                throw new IllegalArgumentException(string);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new IllegalArgumentException(string);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new IllegalArgumentException(string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException(string);
        }
        object = AWTKeyStroke.class;
        synchronized (AWTKeyStroke.class) {
            ctor = constructor;
            cache = null;
            cacheKey = null;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static Constructor getCtor(final Class clazz) {
        Object t2 = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Constructor constructor = clazz.getDeclaredConstructor(null);
                    if (constructor != null) {
                        constructor.setAccessible(true);
                    }
                    return constructor;
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return null;
            }
        });
        return (Constructor)t2;
    }

    private static synchronized AWTKeyStroke getCachedStroke(char c2, int n2, int n3, boolean bl2) {
        block9: {
            if (cache == null) {
                cache = new HashMap();
            }
            if (cacheKey == null) {
                try {
                    cacheKey = (AWTKeyStroke)ctor.newInstance(null);
                }
                catch (InstantiationException instantiationException) {
                    assert (false);
                }
                catch (IllegalAccessException illegalAccessException) {
                    assert (false);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError();
                }
            }
        }
        AWTKeyStroke.cacheKey.keyChar = c2;
        AWTKeyStroke.cacheKey.keyCode = n2;
        AWTKeyStroke.cacheKey.modifiers = AWTKeyStroke.mapNewModifiers(AWTKeyStroke.mapOldModifiers(n3));
        AWTKeyStroke.cacheKey.onKeyRelease = bl2;
        AWTKeyStroke aWTKeyStroke = (AWTKeyStroke)cache.get(cacheKey);
        if (aWTKeyStroke == null) {
            aWTKeyStroke = cacheKey;
            cache.put(aWTKeyStroke, aWTKeyStroke);
            cacheKey = null;
        }
        return aWTKeyStroke;
    }

    public static AWTKeyStroke getAWTKeyStroke(char c2) {
        return AWTKeyStroke.getCachedStroke(c2, 0, 0, false);
    }

    public static AWTKeyStroke getAWTKeyStroke(Character c2, int n2) {
        if (c2 == null) {
            throw new IllegalArgumentException("keyChar cannot be null");
        }
        return AWTKeyStroke.getCachedStroke(c2.charValue(), 0, n2, false);
    }

    public static AWTKeyStroke getAWTKeyStroke(int n2, int n3, boolean bl2) {
        return AWTKeyStroke.getCachedStroke('\uffff', n2, n3, bl2);
    }

    public static AWTKeyStroke getAWTKeyStroke(int n2, int n3) {
        return AWTKeyStroke.getCachedStroke('\uffff', n2, n3, false);
    }

    public static AWTKeyStroke getAWTKeyStrokeForEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getID();
        switch (n2) {
            case 401: 
            case 402: {
                return AWTKeyStroke.getCachedStroke('\uffff', keyEvent.getKeyCode(), keyEvent.getModifiers(), n2 == 402);
            }
            case 400: {
                return AWTKeyStroke.getCachedStroke(keyEvent.getKeyChar(), 0, keyEvent.getModifiers(), false);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static AWTKeyStroke getAWTKeyStroke(String string) {
        if (string == null) {
            throw new IllegalArgumentException("String cannot be null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (modifierKeywords == null) {
            Class<AWTKeyStroke> clazz = AWTKeyStroke.class;
            // MONITORENTER : java.awt.AWTKeyStroke.class
            if (modifierKeywords == null) {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>(8, 1.0f);
                hashMap.put("shift", new Integer(65));
                hashMap.put("control", new Integer(130));
                hashMap.put("ctrl", new Integer(130));
                hashMap.put("meta", new Integer(260));
                hashMap.put("alt", new Integer(520));
                hashMap.put("altGraph", new Integer(8224));
                hashMap.put("button1", new Integer(1024));
                hashMap.put("button2", new Integer(2048));
                hashMap.put("button3", new Integer(4096));
                modifierKeywords = Collections.synchronizedMap(hashMap);
            }
            // MONITOREXIT : clazz
        }
        int n3 = stringTokenizer.countTokens();
        int n4 = 1;
        while (n4 <= n3) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            if (bl3) {
                if (string2.length() != 1) throw new IllegalArgumentException("String formatted incorrectly");
                if (n4 == n3) return AWTKeyStroke.getCachedStroke(string2.charAt(0), 0, n2, false);
                throw new IllegalArgumentException("String formatted incorrectly");
            }
            if (bl4 || bl2 || n4 == n3) {
                if (n4 != n3) {
                    throw new IllegalArgumentException("String formatted incorrectly");
                }
                object = "VK_" + string2;
                int n5 = AWTKeyStroke.getVKValue((String)object);
                return AWTKeyStroke.getCachedStroke('\uffff', n5, n2, bl2);
            }
            if (string2.equals("released")) {
                bl2 = true;
            } else if (string2.equals("pressed")) {
                bl4 = true;
            } else if (string2.equals("typed")) {
                bl3 = true;
            } else {
                object = (Integer)modifierKeywords.get(string2);
                if (object == null) throw new IllegalArgumentException("String formatted incorrectly");
                n2 |= ((Integer)object).intValue();
            }
            ++n4;
        }
        throw new IllegalArgumentException("String formatted incorrectly");
    }

    private static VKCollection getVKCollection() {
        if (vks == null) {
            vks = new VKCollection();
        }
        return vks;
    }

    private static int getVKValue(String string) {
        VKCollection vKCollection = AWTKeyStroke.getVKCollection();
        Integer n2 = vKCollection.findCode(string);
        if (n2 == null) {
            int n3 = 0;
            try {
                n3 = KeyEvent.class.getField(string).getInt(KeyEvent.class);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalArgumentException("String formatted incorrectly");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException("String formatted incorrectly");
            }
            n2 = new Integer(n3);
            vKCollection.put(string, n2);
        }
        return n2;
    }

    public final char getKeyChar() {
        return this.keyChar;
    }

    public final int getKeyCode() {
        return this.keyCode;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final boolean isOnKeyRelease() {
        return this.onKeyRelease;
    }

    public final int getKeyEventType() {
        if (this.keyCode == 0) {
            return 400;
        }
        return this.onKeyRelease ? 402 : 401;
    }

    public int hashCode() {
        return (this.keyChar + '\u0001') * (2 * (this.keyCode + 1)) * (this.modifiers + 1) + (this.onKeyRelease ? 1 : 2);
    }

    public final boolean equals(Object object) {
        if (object instanceof AWTKeyStroke) {
            AWTKeyStroke aWTKeyStroke = (AWTKeyStroke)object;
            return aWTKeyStroke.keyChar == this.keyChar && aWTKeyStroke.keyCode == this.keyCode && aWTKeyStroke.onKeyRelease == this.onKeyRelease && aWTKeyStroke.modifiers == this.modifiers;
        }
        return false;
    }

    public String toString() {
        if (this.keyCode == 0) {
            return AWTKeyStroke.getModifiersText(this.modifiers) + "typed " + this.keyChar;
        }
        return AWTKeyStroke.getModifiersText(this.modifiers) + (this.onKeyRelease ? "released" : "pressed") + " " + AWTKeyStroke.getVKText(this.keyCode);
    }

    static String getModifiersText(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n2 & 0x40) != 0) {
            stringBuffer.append("shift ");
        }
        if ((n2 & 0x80) != 0) {
            stringBuffer.append("ctrl ");
        }
        if ((n2 & 0x100) != 0) {
            stringBuffer.append("meta ");
        }
        if ((n2 & 0x200) != 0) {
            stringBuffer.append("alt ");
        }
        if ((n2 & 0x2000) != 0) {
            stringBuffer.append("altGraph ");
        }
        if ((n2 & 0x400) != 0) {
            stringBuffer.append("button1 ");
        }
        if ((n2 & 0x800) != 0) {
            stringBuffer.append("button2 ");
        }
        if ((n2 & 0x1000) != 0) {
            stringBuffer.append("button3 ");
        }
        return stringBuffer.toString();
    }

    static String getVKText(int n2) {
        Integer n3;
        VKCollection vKCollection = AWTKeyStroke.getVKCollection();
        String string = vKCollection.findName(n3 = new Integer(n2));
        if (string != null) {
            return string.substring(3);
        }
        int n4 = 25;
        Field[] fieldArray = KeyEvent.class.getDeclaredFields();
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            try {
                if (fieldArray[i2].getModifiers() != n4 || fieldArray[i2].getType() != Integer.TYPE || !fieldArray[i2].getName().startsWith("VK_") || fieldArray[i2].getInt(KeyEvent.class) != n2) continue;
                string = fieldArray[i2].getName();
                vKCollection.put(string, n3);
                return string.substring(3);
            }
            catch (IllegalAccessException illegalAccessException) {
                assert (false);
                continue;
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object readResolve() throws ObjectStreamException {
        Class<AWTKeyStroke> clazz = AWTKeyStroke.class;
        synchronized (AWTKeyStroke.class) {
            Class<? extends Object> clazz2 = this.getClass();
            if (!clazz2.equals(ctor.getDeclaringClass())) {
                AWTKeyStroke.registerSubclass(clazz2);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return AWTKeyStroke.getCachedStroke(this.keyChar, this.keyCode, this.modifiers, this.onKeyRelease);
        }
    }

    private static int mapOldModifiers(int n2) {
        if ((n2 & 1) != 0) {
            n2 |= 0x40;
        }
        if ((n2 & 8) != 0) {
            n2 |= 0x200;
        }
        if ((n2 & 0x20) != 0) {
            n2 |= 0x2000;
        }
        if ((n2 & 2) != 0) {
            n2 |= 0x80;
        }
        if ((n2 & 4) != 0) {
            n2 |= 0x100;
        }
        return n2 &= 0x3FC0;
    }

    private static int mapNewModifiers(int n2) {
        if ((n2 & 0x40) != 0) {
            n2 |= 1;
        }
        if ((n2 & 0x200) != 0) {
            n2 |= 8;
        }
        if ((n2 & 0x2000) != 0) {
            n2 |= 0x20;
        }
        if ((n2 & 0x80) != 0) {
            n2 |= 2;
        }
        if ((n2 & 0x100) != 0) {
            n2 |= 4;
        }
        return n2;
    }

    static {
        ctor = AWTKeyStroke.getCtor(AWTKeyStroke.class);
        Toolkit.loadLibraries();
    }
}

