/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageOutputStreamImpl;

public class FileImageOutputStream
extends ImageOutputStreamImpl {
    private RandomAccessFile raf;

    public FileImageOutputStream(File file) throws FileNotFoundException, IOException {
        this(file == null ? null : new RandomAccessFile(file, "rw"));
    }

    public FileImageOutputStream(RandomAccessFile randomAccessFile) {
        if (randomAccessFile == null) {
            throw new IllegalArgumentException("raf == null!");
        }
        this.raf = randomAccessFile;
    }

    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int n2 = this.raf.read();
        if (n2 != -1) {
            ++this.streamPos;
        }
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int n4 = this.raf.read(byArray, n2, n3);
        if (n4 != -1) {
            this.streamPos += (long)n4;
        }
        return n4;
    }

    public void write(int n2) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.raf.write(n2);
        ++this.streamPos;
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.raf.write(byArray, n2, n3);
        this.streamPos += (long)n3;
    }

    public long length() {
        try {
            this.checkClosed();
            return this.raf.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public void seek(long l2) throws IOException {
        this.checkClosed();
        if (l2 < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        this.bitOffset = 0;
        this.raf.seek(l2);
        this.streamPos = this.raf.getFilePointer();
    }

    public void close() throws IOException {
        super.close();
        this.raf.close();
    }
}

