/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.gsm;

import com.ibm.media.codec.audio.gsm.GsmEncoder_ms;
import com.ibm.media.codec.audio.gsm.JavaEncoder;
import com.sun.media.format.WavAudioFormat;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class JavaEncoder_ms
extends JavaEncoder {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1999.";

    public JavaEncoder_ms() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)};
        this.defaultOutputFormats = new AudioFormat[]{new WavAudioFormat("gsm/ms")};
        this.PLUGIN_NAME = "MS GSM Encoder";
        this.historySize = 640;
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        this.supportedOutputFormats = new AudioFormat[]{new WavAudioFormat("gsm/ms", af.getSampleRate(), 0, af.getChannels(), 520, (int)(af.getSampleRate() * (double)af.getChannels() / 320.0 * 65.0), -1, -1, -1.0f, Format.byteArray, new byte[]{64, 1})};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        this.encoder = new GsmEncoder_ms();
        this.encoder.gsm_encoder_reset();
    }

    protected int calculateOutputSize(int inputSize) {
        return this.calculateFramesNumber(inputSize) * 65;
    }

    protected int calculateFramesNumber(int inputSize) {
        return inputSize / 640;
    }

    protected boolean codecProcess(byte[] inpData, int readPtr, byte[] outData, int writePtr, int inpLength, int[] readBytes, int[] writeBytes, int[] frameNumber, int[] regions, int[] regionsTypes) {
        int inCount = 0;
        int outCount = 0;
        int channels = this.inputFormat.getChannels();
        boolean isStereo = channels == 2;
        int frames = inpLength / 640;
        regions[0] = writePtr;
        for (int frameCounter = 0; frameCounter < frames; ++frameCounter) {
            this.encoder.gsm_encode_frame(inpData, readPtr, outData, writePtr);
            readPtr += 640;
            inCount += 640;
            regions[frameCounter + 1] = (outCount += 65) + (writePtr += 65);
            regionsTypes[frameCounter] = 0;
        }
        readBytes[0] = inCount;
        writeBytes[0] = outCount;
        frameNumber[0] = frames;
        return true;
    }
}

