/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.protocol;

import com.ibm.media.protocol.SourceStreamSlave;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullBufferStream;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceStream;
import javax.media.protocol.SourceTransferHandler;

public class CloneableSourceStreamAdapter {
    SourceStream master;
    SourceStream adapter = null;
    Vector slaves = new Vector();
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    protected int numTracks = 0;
    protected Format[] trackFormats;
    static /* synthetic */ Class class$com$sun$media$util$MediaThread;

    CloneableSourceStreamAdapter(SourceStream master) {
        this.master = master;
        if (master instanceof PullSourceStream) {
            this.adapter = new PullSourceStreamAdapter();
        }
        if (master instanceof PullBufferStream) {
            this.adapter = new PullBufferStreamAdapter();
        }
        if (master instanceof PushSourceStream) {
            this.adapter = new PushSourceStreamAdapter();
        }
        if (master instanceof PushBufferStream) {
            this.adapter = new PushBufferStreamAdapter();
        }
    }

    SourceStream getAdapter() {
        return this.adapter;
    }

    SourceStream createSlave() {
        PushStreamSlave slave = null;
        if (this.master instanceof PullSourceStream || this.master instanceof PushSourceStream) {
            slave = new PushSourceStreamSlave();
        }
        if (this.master instanceof PullBufferStream || this.master instanceof PushBufferStream) {
            slave = new PushBufferStreamSlave();
        }
        this.slaves.addElement(slave);
        return slave;
    }

    void copyAndRead(Buffer b2) throws IOException {
        if (this.master instanceof PullBufferStream) {
            ((PullBufferStream)this.master).read(b2);
        }
        if (this.master instanceof PushBufferStream) {
            ((PushBufferStream)this.master).read(b2);
        }
        Enumeration e2 = this.slaves.elements();
        while (e2.hasMoreElements()) {
            Object stream = e2.nextElement();
            ((PushBufferStreamSlave)stream).setBuffer((Buffer)b2.clone());
            Thread.yield();
        }
    }

    int copyAndRead(byte[] buffer, int offset, int length) throws IOException {
        int totalRead = 0;
        if (this.master instanceof PullSourceStream) {
            totalRead = ((PullSourceStream)this.master).read(buffer, offset, length);
        }
        if (this.master instanceof PushSourceStream) {
            totalRead = ((PushSourceStream)this.master).read(buffer, offset, length);
        }
        Enumeration e2 = this.slaves.elements();
        while (e2.hasMoreElements()) {
            Object stream = e2.nextElement();
            byte[] copyBuffer = new byte[totalRead];
            System.arraycopy(buffer, offset, copyBuffer, 0, totalRead);
            ((PushSourceStreamSlave)stream).setBuffer(copyBuffer);
        }
        return totalRead;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    class PushBufferStreamAdapter
    extends SourceStreamAdapter
    implements PushBufferStream,
    BufferTransferHandler {
        BufferTransferHandler handler;

        PushBufferStreamAdapter() {
        }

        public Format getFormat() {
            return ((PushBufferStream)CloneableSourceStreamAdapter.this.master).getFormat();
        }

        public void read(Buffer buffer) throws IOException {
            CloneableSourceStreamAdapter.this.copyAndRead(buffer);
        }

        public void setTransferHandler(BufferTransferHandler transferHandler) {
            this.handler = transferHandler;
            ((PushBufferStream)CloneableSourceStreamAdapter.this.master).setTransferHandler(this);
        }

        public void transferData(PushBufferStream stream) {
            if (this.handler != null) {
                this.handler.transferData(this);
            }
        }
    }

    class PushSourceStreamAdapter
    extends SourceStreamAdapter
    implements PushSourceStream,
    SourceTransferHandler {
        SourceTransferHandler handler;

        PushSourceStreamAdapter() {
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            return CloneableSourceStreamAdapter.this.copyAndRead(buffer, offset, length);
        }

        public int getMinimumTransferSize() {
            return ((PushSourceStream)CloneableSourceStreamAdapter.this.master).getMinimumTransferSize();
        }

        public void setTransferHandler(SourceTransferHandler transferHandler) {
            this.handler = transferHandler;
            ((PushSourceStream)CloneableSourceStreamAdapter.this.master).setTransferHandler(this);
        }

        public void transferData(PushSourceStream stream) {
            if (this.handler != null) {
                this.handler.transferData(this);
            }
        }
    }

    class PullBufferStreamAdapter
    extends SourceStreamAdapter
    implements PullBufferStream {
        PullBufferStreamAdapter() {
        }

        public boolean willReadBlock() {
            return ((PullBufferStream)CloneableSourceStreamAdapter.this.master).willReadBlock();
        }

        public void read(Buffer buffer) throws IOException {
            CloneableSourceStreamAdapter.this.copyAndRead(buffer);
        }

        public Format getFormat() {
            return ((PullBufferStream)CloneableSourceStreamAdapter.this.master).getFormat();
        }
    }

    class PullSourceStreamAdapter
    extends SourceStreamAdapter
    implements PullSourceStream {
        PullSourceStreamAdapter() {
        }

        public boolean willReadBlock() {
            return ((PullSourceStream)CloneableSourceStreamAdapter.this.master).willReadBlock();
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            return CloneableSourceStreamAdapter.this.copyAndRead(buffer, offset, length);
        }
    }

    class PushBufferStreamSlave
    extends PushStreamSlave
    implements PushBufferStream,
    Runnable {
        BufferTransferHandler handler;
        private Buffer b;

        PushBufferStreamSlave() {
        }

        synchronized void setBuffer(Buffer b2) {
            this.b = b2;
            this.notifyAll();
        }

        public Format getFormat() {
            return ((PushBufferStream)CloneableSourceStreamAdapter.this.master).getFormat();
        }

        public synchronized void read(Buffer buffer) throws IOException {
            while (this.b == null && this.connected) {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException e2) {
                    System.out.println("Exception: " + e2);
                }
            }
            if (!this.connected) {
                throw new IOException("DataSource is not connected");
            }
            buffer.copy(this.b);
            this.b = null;
        }

        public int getMinimumTransferSize() {
            return ((PushSourceStream)CloneableSourceStreamAdapter.this.master).getMinimumTransferSize();
        }

        public void setTransferHandler(BufferTransferHandler transferHandler) {
            this.handler = transferHandler;
        }

        BufferTransferHandler getTransferHandler() {
            return this.handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.endOfStream() && this.connected) {
                try {
                    PushBufferStreamSlave pushBufferStreamSlave = this;
                    synchronized (pushBufferStreamSlave) {
                        this.wait();
                    }
                }
                catch (InterruptedException e2) {
                    System.out.println("Exception: " + e2);
                }
                if (!this.connected || this.handler == null) continue;
                this.handler.transferData(this);
            }
        }
    }

    class PushSourceStreamSlave
    extends PushStreamSlave
    implements PushSourceStream,
    Runnable {
        SourceTransferHandler handler;
        private byte[] buffer;

        PushSourceStreamSlave() {
        }

        synchronized void setBuffer(byte[] buffer) {
            this.buffer = buffer;
            this.notifyAll();
        }

        public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
            if (length + offset > buffer.length) {
                throw new IOException("buffer is too small");
            }
            while (this.buffer == null && this.connected) {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException e2) {
                    System.out.println("Exception: " + e2);
                }
            }
            if (!this.connected) {
                throw new IOException("DataSource is not connected");
            }
            int copyLength = length > this.buffer.length ? this.buffer.length : length;
            System.arraycopy(this.buffer, 0, buffer, offset, copyLength);
            this.buffer = null;
            return copyLength;
        }

        public int getMinimumTransferSize() {
            return ((PushSourceStream)CloneableSourceStreamAdapter.this.master).getMinimumTransferSize();
        }

        public void setTransferHandler(SourceTransferHandler transferHandler) {
            this.handler = transferHandler;
        }

        SourceTransferHandler getTransferHandler() {
            return this.handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.endOfStream() && this.connected) {
                try {
                    PushSourceStreamSlave pushSourceStreamSlave = this;
                    synchronized (pushSourceStreamSlave) {
                        this.wait();
                    }
                }
                catch (InterruptedException e2) {
                    System.out.println("Exception: " + e2);
                }
                if (!this.connected || this.handler == null) continue;
                this.handler.transferData(this);
            }
        }
    }

    abstract class PushStreamSlave
    extends SourceStreamAdapter
    implements SourceStreamSlave,
    Runnable {
        MediaThread notifyingThread;
        boolean connected;

        PushStreamSlave() {
            this.connected = false;
        }

        public synchronized void connect() {
            if (this.connected) {
                return;
            }
            this.connected = true;
            if (jmfSecurity != null) {
                String permission = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        permission = "thread";
                        jmfSecurity.requestPermission(CloneableSourceStreamAdapter.this.m, CloneableSourceStreamAdapter.this.cl, CloneableSourceStreamAdapter.this.args, 16);
                        CloneableSourceStreamAdapter.this.m[0].invoke((Object)CloneableSourceStreamAdapter.this.cl[0], CloneableSourceStreamAdapter.this.args[0]);
                        permission = "thread group";
                        jmfSecurity.requestPermission(CloneableSourceStreamAdapter.this.m, CloneableSourceStreamAdapter.this.cl, CloneableSourceStreamAdapter.this.args, 32);
                        CloneableSourceStreamAdapter.this.m[0].invoke((Object)CloneableSourceStreamAdapter.this.cl[0], CloneableSourceStreamAdapter.this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                    }
                }
                catch (Throwable e2) {
                    securityPrivelege = false;
                }
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                try {
                    Constructor cons = jdk12CreateThreadRunnableAction.cons;
                    this.notifyingThread = (MediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$util$MediaThread == null ? (class$com$sun$media$util$MediaThread = CloneableSourceStreamAdapter.class$("com.sun.media.util.MediaThread")) : class$com$sun$media$util$MediaThread, this));
                }
                catch (Exception exception) {}
            } else {
                this.notifyingThread = new MediaThread(this);
            }
            if (this.notifyingThread != null) {
                if (CloneableSourceStreamAdapter.this.master instanceof PushBufferStream) {
                    if (((PushBufferStream)CloneableSourceStreamAdapter.this.master).getFormat() instanceof VideoFormat) {
                        this.notifyingThread.useVideoPriority();
                    } else {
                        this.notifyingThread.useAudioPriority();
                    }
                }
                this.notifyingThread.start();
            }
        }

        public synchronized void disconnect() {
            this.connected = false;
            this.notifyAll();
        }
    }

    class SourceStreamAdapter
    implements SourceStream {
        SourceStreamAdapter() {
        }

        public ContentDescriptor getContentDescriptor() {
            return CloneableSourceStreamAdapter.this.master.getContentDescriptor();
        }

        public long getContentLength() {
            return CloneableSourceStreamAdapter.this.master.getContentLength();
        }

        public boolean endOfStream() {
            return CloneableSourceStreamAdapter.this.master.endOfStream();
        }

        public Object[] getControls() {
            return CloneableSourceStreamAdapter.this.master.getControls();
        }

        public Object getControl(String controlType) {
            return CloneableSourceStreamAdapter.this.master.getControl(controlType);
        }
    }
}

