/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mpa;

import com.sun.media.codec.audio.AudioCodec;
import com.sun.media.codec.audio.mpa.MPAHeader;
import com.sun.media.codec.audio.mpa.MPAParse;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class DePacketizer
extends AudioCodec {
    private static int OUT_BUF_SIZE = 4096;
    private static int MAX_SEQ = 65535;
    private static Format[] defaultSupportedOutputFormats = new Format[]{new AudioFormat("mpegaudio", 44100.0, 16, -1, 1, 1), new AudioFormat("mpegaudio", 48000.0, 16, -1, 1, 1), new AudioFormat("mpegaudio", 32000.0, 16, -1, 1, 1), new AudioFormat("mpegaudio", 22050.0, 16, -1, 1, 1), new AudioFormat("mpegaudio", 24000.0, 16, -1, 1, 1), new AudioFormat("mpegaudio", 16000.0, 16, -1, 1, 1), new AudioFormat("mpegaudio", 11025.0, 16, -1, 1, 1), new AudioFormat("mpegaudio", 12000.0, 16, -1, 1, 1), new AudioFormat("mpegaudio", 8000.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 44100.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 48000.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 32000.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 22050.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 24000.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 16000.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 11025.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 12000.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 8000.0, 16, -1, 1, 1)};
    private boolean bufferContinued = false;
    private boolean frameContinued = false;
    private int frameSize = 0;
    private int frameBegin = 0;
    private int frameOffset = 0;
    private long frameTimeStamp = 0L;
    private long bufTimeStamp = 0L;
    private long prevSeq = -1L;
    private long outSeq = 0L;
    private MPAParse mpaParse = new MPAParse();
    private MPAHeader mpaHeader = new MPAHeader();
    private static final boolean debug = false;

    public DePacketizer() {
        this.inputFormats = new Format[]{new AudioFormat("mpegaudio/rtp")};
    }

    public String getName() {
        return "MPEG Audio DePacketizer";
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return defaultSupportedOutputFormats;
        }
        if (DePacketizer.matches(in, this.inputFormats) == null) {
            return new Format[1];
        }
        if (!(in instanceof AudioFormat)) {
            return defaultSupportedOutputFormats;
        }
        if (this.outputFormat != null) {
            return new Format[]{this.outputFormat};
        }
        AudioFormat af = (AudioFormat)in;
        AudioFormat of = new AudioFormat("mpegaudio", af.getSampleRate() == -1.0 ? 44100.0 : af.getSampleRate(), af.getSampleSizeInBits() == -1 ? 16 : af.getSampleSizeInBits(), af.getChannels() == -1 ? 2 : af.getChannels());
        return new Format[]{of};
    }

    public void open() {
    }

    public void close() {
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        try {
            return this.doProcess(inputBuffer, outputBuffer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 1;
        }
    }

    public int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            this.mpaParse.reset();
            return 0;
        }
        byte[] inData = (byte[])inputBuffer.getData();
        int inOffset = inputBuffer.getOffset();
        int inLength = inputBuffer.getLength();
        int packetOffset = ((inData[inOffset + 2] & 0xFF) << 8) + (inData[inOffset + 3] & 0xFF);
        inOffset += 4;
        inLength -= 4;
        if (packetOffset > 0) {
            if (!this.frameContinued) {
                return 4;
            }
            if (inputBuffer.getTimeStamp() != this.frameTimeStamp) {
                this.dropFrame(outputBuffer);
                return 4;
            }
            if (this.getSequenceDiff(this.prevSeq, inputBuffer.getSequenceNumber()) != 1) {
                this.dropFrame(outputBuffer);
                return 4;
            }
            this.prevSeq = inputBuffer.getSequenceNumber();
            if (!this.copyBuffer(inData, inOffset, inLength, outputBuffer, this.frameBegin + this.frameOffset)) {
                this.dropFrame(outputBuffer);
                return 4;
            }
            this.frameOffset += inLength;
            if (this.frameOffset < this.frameSize) {
                return 4;
            }
            this.frameContinued = false;
            this.frameOffset = 0;
            if (this.mpaHeader.layer == 3 && this.frameBegin == 0) {
                return 4;
            }
            outputBuffer.setTimeStamp(this.bufTimeStamp);
            outputBuffer.setFlags(outputBuffer.getFlags() | 0x20);
            this.bufferContinued = false;
            return 0;
        }
        if (this.frameContinued) {
            this.dropFrame(outputBuffer);
        }
        this.frameContinued = false;
        this.prevSeq = inputBuffer.getSequenceNumber();
        this.frameTimeStamp = inputBuffer.getTimeStamp();
        int rc = this.mpaParse.getHeader(this.mpaHeader, inData, inOffset, inLength);
        if (rc != MPAParse.MPA_OK) {
            if (rc != MPAParse.MPA_HDR_DOUBTED) {
                return 1;
            }
        }
        String encoding = this.mpaHeader.layer == 3 ? "mpeglayer3" : "mpegaudio";
        AudioFormat af = (AudioFormat)this.outputFormat;
        if (af == null || !encoding.equalsIgnoreCase(af.getEncoding()) || af.getSampleRate() != (double)this.mpaHeader.samplingRate || af.getChannels() != this.mpaHeader.nChannels) {
            this.outputFormat = new AudioFormat(encoding, this.mpaHeader.samplingRate, 16, this.mpaHeader.nChannels, 1, 1);
        }
        this.frameSize = this.mpaHeader.bitsInFrame >> 3;
        if (this.frameSize > inLength) {
            if (!this.bufferContinued) {
                outputBuffer.setLength(0);
                outputBuffer.setOffset(0);
                this.bufTimeStamp = this.frameTimeStamp;
                outputBuffer.setFormat(this.outputFormat);
                outputBuffer.setSequenceNumber(this.outSeq++);
            }
            this.bufferContinued = true;
            this.frameContinued = true;
            this.frameBegin = outputBuffer.getLength();
            this.frameOffset = inLength;
            this.copyBuffer(inData, inOffset, inLength, outputBuffer, outputBuffer.getLength());
            return 4;
        }
        if (this.mpaHeader.layer == 3 && inLength < this.frameSize * 2 - 2) {
            if (!this.bufferContinued) {
                outputBuffer.setLength(0);
                outputBuffer.setOffset(0);
                this.bufTimeStamp = this.frameTimeStamp;
                byte[] outData = (byte[])outputBuffer.getData();
                if (outData == null || outData.length < OUT_BUF_SIZE) {
                    outData = new byte[OUT_BUF_SIZE];
                    outputBuffer.setData(outData);
                }
            }
            if (!this.copyBuffer(inData, inOffset, inLength, outputBuffer, outputBuffer.getLength())) {
                outputBuffer.setFormat(this.outputFormat);
                outputBuffer.setSequenceNumber(this.outSeq++);
                outputBuffer.setTimeStamp(this.bufTimeStamp);
                outputBuffer.setFlags(outputBuffer.getFlags() | 0x20);
                this.bufferContinued = false;
                return 2;
            }
            if (outputBuffer.getLength() + this.frameSize + 4 > OUT_BUF_SIZE) {
                outputBuffer.setFormat(this.outputFormat);
                outputBuffer.setSequenceNumber(this.outSeq++);
                outputBuffer.setTimeStamp(this.bufTimeStamp);
                outputBuffer.setFlags(outputBuffer.getFlags() | 0x20);
                this.bufferContinued = false;
                return 0;
            }
            this.bufferContinued = true;
            return 4;
        }
        Object outData = outputBuffer.getData();
        outputBuffer.setData(inputBuffer.getData());
        inputBuffer.setData(outData);
        outputBuffer.setLength(inLength);
        outputBuffer.setFormat(this.outputFormat);
        outputBuffer.setOffset(inOffset);
        outputBuffer.setSequenceNumber(this.outSeq++);
        outputBuffer.setTimeStamp(this.frameTimeStamp);
        outputBuffer.setFlags(outputBuffer.getFlags() | 0x20);
        return 0;
    }

    private boolean copyBuffer(byte[] inData, int inOff, int inLen, Buffer outputBuffer, int outOff) {
        byte[] outData = (byte[])outputBuffer.getData();
        if (outData == null || outOff + inLen > outData.length) {
            if (outOff + inLen > OUT_BUF_SIZE) {
                return false;
            }
            byte[] newData = new byte[OUT_BUF_SIZE];
            if (outOff > 0) {
                System.arraycopy(outData, 0, newData, 0, outData.length);
            }
            outData = newData;
            outputBuffer.setData(outData);
        }
        System.arraycopy(inData, inOff, outData, outOff, inLen);
        outputBuffer.setLength(outputBuffer.getLength() + inLen);
        return true;
    }

    private int getSequenceDiff(long p, long c2) {
        if (c2 > p) {
            return (int)(c2 - p);
        }
        if (c2 == p) {
            return 0;
        }
        if (p > (long)(MAX_SEQ - 100) && c2 < 100L) {
            return (int)((long)MAX_SEQ - p + c2 + 1L);
        }
        return (int)(c2 - p);
    }

    private void dropFrame(Buffer outputBuffer) {
        outputBuffer.setLength(this.frameBegin - outputBuffer.getOffset());
        this.frameBegin = outputBuffer.getLength() + outputBuffer.getOffset();
        this.frameSize = 0;
        this.frameOffset = 0;
        this.frameContinued = false;
    }
}

