/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.ulaw;

import com.sun.media.codec.audio.AudioCodec;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class DePacketizer
extends AudioCodec {
    public DePacketizer() {
        this.inputFormats = new Format[]{new AudioFormat("ULAW/rtp")};
    }

    public String getName() {
        return "ULAW DePacketizer";
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return new Format[]{new AudioFormat("ULAW")};
        }
        if (DePacketizer.matches(in, this.inputFormats) == null) {
            return new Format[1];
        }
        if (!(in instanceof AudioFormat)) {
            return new Format[]{new AudioFormat("ULAW")};
        }
        AudioFormat af = (AudioFormat)in;
        return new Format[]{new AudioFormat("ULAW", af.getSampleRate(), af.getSampleSizeInBits(), af.getChannels())};
    }

    public void open() {
    }

    public void close() {
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        Object outData = outputBuffer.getData();
        outputBuffer.setData(inputBuffer.getData());
        inputBuffer.setData(outData);
        outputBuffer.setLength(inputBuffer.getLength());
        outputBuffer.setFormat(this.outputFormat);
        outputBuffer.setOffset(inputBuffer.getOffset());
        return 0;
    }
}

