/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jmpx;

import com.sun.media.BasicController;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.MediaTimeBase;
import com.sun.media.SeekFailedEvent;
import com.sun.media.SimpleGraphBuilder;
import com.sun.media.codec.video.jmpx.DataThread;
import com.sun.media.codec.video.jmpx.JmpxAckNotifyEvent;
import com.sun.media.codec.video.jmpx.JmpxAudio;
import com.sun.media.codec.video.jmpx.JmpxEvent;
import com.sun.media.codec.video.jmpx.JmpxListener;
import com.sun.media.codec.video.jmpx.MpxCmd;
import com.sun.media.codec.video.jmpx.MpxThread;
import com.sun.media.controls.BitRateAdapter;
import com.sun.media.controls.FrameRateAdapter;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.protocol.file.DataSource;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.media.AudioDeviceUnavailableEvent;
import javax.media.Buffer;
import javax.media.ConnectionErrorEvent;
import javax.media.Control;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.MediaLocator;
import javax.media.NotRealizedError;
import javax.media.RestartingEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.StopByRequestEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.BitRateControl;
import javax.media.control.FrameRateControl;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;
import javax.media.protocol.SourceTransferHandler;
import javax.media.renderer.VideoRenderer;

public final class Jmpx
extends BasicController
implements Runnable {
    private PipedInputStream cmdPipe;
    protected PipedOutputStream mpxCmdPipe;
    protected boolean killCommandThread = false;
    private Vector listeners;
    private MpxThread mpxThread;
    private DataThread dataThread;
    private int audioRate = 0;
    private int audioChannels = 0;
    private boolean sourceIsOn = false;
    private Component monitor;
    private long lastStatTime = 0L;
    private VideoRenderer renderer = null;
    private VideoFormat videoformat = null;
    protected JmpxAudio audio = null;
    public static boolean BIG_ENDIAN = true;
    public static boolean LITTLE_ENDIAN = false;
    public static final int MpxStrm_11172 = 1;
    public static final int MpxStrm_VSEQ = 2;
    public static final int MpxStrm_ASEQ = 4;
    public static final int MpxStrm_Unknown = 0;
    public static final int MpxAudioLeft = 1;
    public static final int MpxAudioRight = 2;
    public static final int MpxAudioStereo = 3;
    public static final int MpxAudioLowQ = 8;
    public static final int MpxAudioMedQ = 16;
    public static final int MpxAudioHiQ = 24;
    protected static final int MCMD_NULL = 0;
    protected static final int MCMD_EXIT = 1;
    protected static final int MCMD_OPENSRC = 2;
    protected static final int MCMD_CLOSESRC = 3;
    protected static final int MCMD_REENTER = 4;
    protected static final int MCMD_PLAYCTR = 5;
    protected static final int MCMD_PRESCTR = 6;
    protected static final int MCMD_STREAM = 7;
    protected static final int MCMD_SENDSTAT = 8;
    protected static final int MCMD_STATUS = 9;
    protected static final int MCMD_ACK = 10;
    protected static final int MCMD_SETRSRC = 11;
    protected static final int MCMD_CAPTURE = 12;
    protected static final int MCMD_CDOP = 13;
    protected static final int MCMD_TEST = 255;
    protected static final int MCMD_QSIZE = 30;
    protected static final int MCMD_QSTATS = 31;
    protected static final double MULF = 65535.0;
    protected static final int MCFL_SNDACK = 1;
    protected static final int MCFL_NOACK = 2;
    protected static final int MCFL_ORGMPX = 4;
    protected static final int MCFL_MPXRSV1 = 65536;
    protected static final int MSC_NONE = 0;
    protected static final int MSC_FNAME = 1;
    protected static final int MSC_CDFILE = 2;
    protected static final int MSC_NETWORK = 3;
    protected static final int MSC_FDSCP = 4;
    protected static final int MSC_JAVASTRM = 5;
    protected static final int MRE_FOFS = 1;
    protected static final int MRE_RELOFS = 2;
    protected static final int MRE_ASOPEN = 4;
    protected static final int MRE_STRMS = 8;
    protected static final int MRE_SEEKVSEQ = 16;
    public static final int PC_PLAY = 1;
    public static final int PC_FWDSPEED = 2;
    public static final int PC_FWDSTEP = 4;
    public static final int PC_PAUSE = 8;
    public static final int PC_AUDMSK = 13;
    protected static final int STRM_IGNOREID = 128;
    protected static final int STRM_SBCOFF = 64;
    protected static final int STRM_AUTOSBC = 32;
    protected static final int STRM_IDBITS = 63;
    protected static final int PCTR_VMD = 1;
    protected static final int PCTR_AMD = 2;
    protected static final int PCTR_AVOL = 4;
    protected static final int PCTR_LUM = 8;
    protected static final int PCTR_SAT = 16;
    protected static final int PCTR_GAM = 32;
    protected static final int PCTR_LSG = 56;
    protected static final int VDM_NONE = 0;
    protected static final int VDM_COL = 1;
    protected static final int VDM_COLB = 2;
    protected static final int VDM_COL8 = 3;
    protected static final int TRYSET_DONE = 0;
    protected static final int TRYSET_CANT = 1;
    protected static final int TRYSET_PASTEOM = 2;
    protected MediaThread cmdInputThread;
    protected int ackSeq = 0;
    protected int strmType;
    protected float fwdSpeed = 1.0f;
    protected int width;
    protected int height;
    protected int outWidth;
    protected int outHeight;
    protected int zoom;
    protected float java_zoom;
    protected int cmap;
    protected boolean interleaved;
    protected boolean muted = false;
    protected boolean reloaded = false;
    protected float fps;
    protected float kbps;
    protected float loc;
    protected float oldLoc;
    protected long time;
    protected long size;
    protected long frames;
    private long peer = 0L;
    protected int possibleLength = -1;
    protected int possibleWidth = -1;
    protected int possibleHeight = -1;
    protected int useJavaRenderer = 1;
    protected Object rgbBuffer = null;
    protected FrameRateControl frameRateControl = null;
    protected BitRateControl bitRateControl = null;
    protected GainControl gainControl = null;
    protected Control[] controls;
    protected int needYUVBuffer = 0;
    protected int needXBGR = 1;
    protected boolean windowAvailable = false;
    protected javax.media.protocol.DataSource source;
    protected TimeBase timeBase;
    protected String filename;
    protected SourceStream sourceStream;
    protected byte[] tempArray = new byte[65536];
    protected MemoryImageSource sourceImage = null;
    protected Image displayImage = null;
    int rMask = 255;
    int gMask = 65280;
    int bMask = 0xFF0000;
    protected Time knownDuration = Duration.DURATION_UNKNOWN;
    protected Time eomDuration = Duration.DURATION_UNKNOWN;
    protected Time requestedMediaTime = new Time(0L);
    protected boolean mediaTimeChanged = false;
    protected boolean outputSizeSet = false;
    protected int contentLength = -1;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] mSecurity = new Method[1];
    private Class[] clSecurity = new Class[1];
    private Object[][] argsSecurity = new Object[1][0];
    private Buffer outBuffer = new Buffer();

    private native boolean initMPX(Component var1);

    private native void sendMPX(byte[] var1);

    private native void broadcastMPX(byte[] var1);

    private native void setStream(SourceStream var1);

    private native int checkMpegFile(String var1);

    private native int getMediaDuration(String var1);

    private native int checkMpegStream(SourceStream var1);

    private native boolean bigEndian();

    public Jmpx() {
        this(0);
    }

    public Jmpx(int type) {
        this.strmType = type;
        this.width = 320;
        this.height = 240;
        this.outWidth = 320;
        this.outHeight = 240;
        this.zoom = 1;
        this.java_zoom = 1.0f;
        this.cmap = 0;
        this.interleaved = true;
        this.fps = 0.0f;
        this.kbps = 0.0f;
        this.loc = 0.0f;
        this.time = 0L;
        this.size = 0L;
        this.frames = 0L;
        this.listeners = new Vector();
    }

    public void setSource(javax.media.protocol.DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PullDataSource) && !(source instanceof PushDataSource)) {
            System.out.println("Unsupported data source: " + source);
            throw new IncompatibleSourceException(this + ": doesn't support " + source);
        }
        this.source = source;
    }

    protected boolean isConfigurable() {
        return false;
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.isInitialized()) {
            this.close();
        }
    }

    protected int readFromStream(int offset, int nbytes) {
        if (this.tempArray == null) {
            this.tempArray = new byte[65536];
        }
        return this.readFromStream(this.tempArray, offset, nbytes);
    }

    protected int readFromStream(byte[] buf, int offset, int nbytes) {
        if (this.sourceStream == null) {
            this.sendEvent(new ConnectionErrorEvent(this, "No source stream specified!"));
            return -1;
        }
        try {
            if (this.sourceStream instanceof PullSourceStream) {
                return ((PullSourceStream)this.sourceStream).read(buf, offset, nbytes);
            }
            if (this.sourceStream instanceof PushSourceStream) {
                return this.readFromPushStream(buf, offset, nbytes);
            }
        }
        catch (IOException e2) {
            this.sendEvent(new ConnectionErrorEvent(this, e2.getMessage()));
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readFromPushStream(byte[] buf, int offset, int nbytes) throws IOException {
        int n2;
        PushSourceStream pss = (PushSourceStream)this.sourceStream;
        boolean starved = false;
        boolean paused = false;
        Jmpx jmpx = this;
        synchronized (jmpx) {
            while ((n2 = pss.read(buf, offset, nbytes)) == 0) {
                if (!starved) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    starved = true;
                    continue;
                }
                super.stop();
                this.pause();
                this.sendEvent(new RestartingEvent(this, 600, 400, 600, this.getMediaTime()));
                paused = true;
                try {
                    this.wait();
                }
                catch (InterruptedException e3) {}
            }
        }
        if (paused) {
            this.sendEvent(new StartEvent(this, 500, 600, 600, this.getMediaTime(), this.getTimeBase().getTime()));
        }
        if (n2 == -1) {
            return 0;
        }
        return n2;
    }

    protected synchronized void notifyPushDataArrival() {
        this.notifyAll();
    }

    protected boolean doRealize() {
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmmpx");
        }
        catch (UnsatisfiedLinkError e2) {
            return false;
        }
        if (this.bigEndian()) {
            BIG_ENDIAN = true;
            LITTLE_ENDIAN = false;
        } else {
            BIG_ENDIAN = false;
            LITTLE_ENDIAN = true;
        }
        if (this.source == null) {
            return false;
        }
        this.mediaTimeChanged = false;
        this.startSource(true);
        this.sourceStream = null;
        this.filename = null;
        if (this.source instanceof PullDataSource) {
            PullDataSource pds = (PullDataSource)this.source;
            URL url = null;
            String protocol = null;
            MediaLocator ml = pds.getLocator();
            if (ml != null) {
                protocol = ml.getProtocol();
                try {
                    url = ml.getURL();
                }
                catch (MalformedURLException mue) {
                    url = null;
                }
            }
            if (this.source instanceof DataSource && protocol != null && protocol.equals("file") && url != null) {
                this.filename = url.getFile();
            } else {
                PullSourceStream[] ss = pds.getStreams();
                if (ss.length >= 1) {
                    this.sourceStream = ss[0];
                }
                this.contentLength = (int)this.sourceStream.getContentLength();
                if (this.contentLength <= 0) {
                    this.contentLength = -1;
                }
            }
        } else {
            PushDataSource pds = (PushDataSource)this.source;
            PushSourceStream[] ss = pds.getStreams();
            if (ss.length >= 1) {
                this.sourceStream = ss[0];
                ((PushSourceStream)this.sourceStream).setTransferHandler(new PushStreamHandler());
            }
        }
        if (this.sourceStream == null && this.filename == null) {
            System.err.println("No source stream");
            return false;
        }
        if (!this.checkStreamType()) {
            System.err.println("The data is not an MPEG stream.\n");
            return false;
        }
        this.reloaded = true;
        this.timeBase = new MPXTimeBase();
        this.monitor = this.createMonitor(this.width, this.height);
        this.startSource(false);
        return true;
    }

    protected void abortRealize() {
        this.startSource(false);
    }

    protected boolean doPrefetch() {
        boolean gotAudio;
        if (this.isInitialized()) {
            return true;
        }
        if (this.strmType != 2 && !(gotAudio = this.audioRate == 0 || this.audioChannels == 0 ? this.setAudio(22050, 1) : this.setAudio(this.audioRate, this.audioChannels))) {
            this.sendEvent(new AudioDeviceUnavailableEvent(this));
            if (this.strmType == 4) {
                return false;
            }
        }
        this.cmdPipe = new PipedInputStream();
        this.mpxCmdPipe = new PipedOutputStream();
        try {
            this.cmdPipe.connect(this.mpxCmdPipe);
        }
        catch (IOException e2) {
            System.err.println("Failed to connect the command pipes " + e2);
            return false;
        }
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 16);
                    this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 32);
                    this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                }
            }
            catch (Throwable e3) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                Constructor cons = jdk12CreateThreadRunnableAction.cons;
                this.mpxThread = (MpxThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(MpxThread.class, this));
                this.dataThread = (DataThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(DataThread.class, this));
                if (!this.initMPX(this.monitor)) {
                    return false;
                }
                this.cmdInputThread = (MediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(MediaThread.class, this));
                this.cmdInputThread.setName("Jmpx command input thread");
                cons = jdk12PriorityAction.cons;
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = this.cmdInputThread;
                Jmpx jmpx = this;
                objectArray2[1] = new Integer(jmpx.cmdInputThread.getControlPriority());
                objectArray[0] = cons.newInstance(objectArray2);
                jdk12.doPrivM.invoke((Object)jdk12.ac, objectArray);
                this.cmdInputThread.start();
            }
            catch (Exception exception) {}
        } else {
            this.mpxThread = new MpxThread(this);
            this.dataThread = new DataThread(this);
            if (!this.initMPX(this.monitor)) {
                return false;
            }
            this.cmdInputThread = new MediaThread(this);
            this.cmdInputThread.setName("Jmpx command input thread");
            this.cmdInputThread.useControlPriority();
            this.cmdInputThread.start();
        }
        return true;
    }

    protected void abortPrefetch() {
        this.closeMPX();
        this.reloaded = true;
        this.startSource(false);
    }

    protected void doStart() {
        this.oldLoc = 0.0f;
        if (this.timeBase instanceof MPXTimeBase) {
            ((MPXTimeBase)this.timeBase).reset();
        }
        this.startSource(true);
        if (this.reloaded) {
            if (this.filename != null) {
                this.openFile(this.filename);
            } else if (this.sourceStream != null) {
                this.openStream(this.sourceStream);
            }
            this.reloaded = false;
        }
        if (!this.mediaTimeChanged) {
            this.play();
            return;
        }
        int returnVal = this.trySetMediaTime(this.requestedMediaTime);
        if (returnVal == 0) {
            this.play();
            this.mediaTimeChanged = false;
        } else if (returnVal == 1) {
            super.stop();
            this.sendEvent(new SeekFailedEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
        } else if (returnVal == 2) {
            super.stop();
            this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
        }
    }

    public void stop() {
        super.stop();
        this.pause();
        this.startSource(false);
        if (this.timeBase instanceof MPXTimeBase) {
            ((MPXTimeBase)this.timeBase).reset();
        }
        this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    public boolean startSource(boolean on) {
        if (this.sourceIsOn == on) {
            return true;
        }
        try {
            if (on) {
                this.source.start();
            } else {
                this.source.stop();
            }
        }
        catch (Exception ge) {
            System.err.println("Couldn't stop the data source");
            return false;
        }
        this.sourceIsOn = on;
        return true;
    }

    protected void closeMPX() {
        if (this.isInitialized()) {
            this.killCommandThread = true;
            this.exit();
            try {
                this.mpxCmdPipe.flush();
                this.mpxCmdPipe.close();
                this.cmdPipe.close();
            }
            catch (IOException e2) {
                System.err.println("closing command pipe: " + e2);
            }
        }
    }

    public synchronized void doClose() {
        if (this.isInitialized()) {
            this.windowAvailable = false;
            this.closeMPX();
            this.mpxThread = null;
            this.dataThread = null;
            this.cmdInputThread = null;
            this.monitor = null;
        }
        if (this.source != null) {
            try {
                this.source.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        super.setTimeBase(tb);
        if (tb == null || tb != this.timeBase) {
            // empty if block
        }
        this.timeBase = tb;
    }

    public TimeBase getTimeBase() {
        super.getTimeBase();
        return this.timeBase;
    }

    public void setMediaTime(Time t) {
        if (this.getState() == 100 || this.getState() == 200) {
            throw new NotRealizedError("Cannot set media time on an unrealized controller");
        }
        Time currentMediaTime = this.getMediaTime();
        this.requestedMediaTime = t;
        this.mediaTimeChanged = true;
        super.setMediaTime(t);
    }

    protected int trySetMediaTime(Time t) {
        Time duration = this.getDuration();
        double secGoto = t.getSeconds();
        double secDuration = duration.getSeconds();
        if (duration != DURATION_UNKNOWN) {
            if (secGoto > secDuration) {
                return 2;
            }
        } else if (secGoto != 0.0) {
            return 1;
        }
        if (this.sourceStream != null) {
            if (this.sourceStream instanceof Seekable) {
                Seekable seeker = (Seekable)((Object)this.sourceStream);
                if (secGoto == 0.0) {
                    seeker.seek(0L);
                    this.seek(0.0);
                    return 0;
                }
                if (seeker.isRandomAccess() && this.getContentLength() > 0) {
                    double newLoc = secGoto / secDuration;
                    long seekLoc = (long)(newLoc * (double)this.getContentLength());
                    seeker.seek(seekLoc);
                    this.seek(newLoc);
                    return 0;
                }
                return 1;
            }
            return 0;
        }
        if (secGoto == 0.0) {
            this.seek(0.0);
            return 0;
        }
        double newloc = secGoto / secDuration;
        if (newloc > 1.0) {
            newloc = 1.0;
        }
        this.seek(newloc);
        return 0;
    }

    public long getMediaNanoseconds() {
        return this.getMediaTime().getNanoseconds();
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public Time getDuration() {
        Time d2;
        if (this.eomDuration != Duration.DURATION_UNKNOWN) {
            return this.eomDuration;
        }
        if (this.source instanceof Duration && (d2 = this.source.getDuration()) != null && d2 != Duration.DURATION_UNKNOWN && d2 != Duration.DURATION_UNBOUNDED) {
            return d2;
        }
        if (this.mediaTimeChanged) {
            return this.knownDuration;
        }
        long jtime = this.getMediaNanoseconds();
        double loc = this.getLoc();
        if (loc == 0.0 || jtime < 3000000000L) {
            return this.knownDuration;
        }
        long nanoseconds = (long)((double)jtime / loc);
        long knownNanoseconds = this.knownDuration.getNanoseconds();
        if ((double)Math.abs(nanoseconds - knownNanoseconds) > 5.0E9) {
            this.knownDuration = new Time(nanoseconds);
            this.sendEvent(new DurationUpdateEvent(this, this.knownDuration));
        }
        return this.knownDuration;
    }

    public Component getVisualComponent() {
        if (this.strmType == 4) {
            return null;
        }
        return this.monitor;
    }

    public Control[] getControls() {
        if (this.strmType != 4 && this.frameRateControl == null) {
            this.frameRateControl = new FrameRateAdapter(this, 0.0f, 0.0f, 30.0f, false){

                public float setFrameRate(float rate) {
                    this.value = rate;
                    return this.value;
                }

                public Component getControlComponent() {
                    return null;
                }

                public Object getOwner() {
                    return Jmpx.this;
                }
            };
        }
        if (this.strmType != 2 && this.gainControl == null) {
            this.gainControl = new GCA(this);
        }
        if (this.bitRateControl == null) {
            this.bitRateControl = new BitRateAdapter(0, -1, -1, false){

                public int setBitRate(int rate) {
                    this.value = rate;
                    return this.value;
                }

                public Component getControlComponent() {
                    return null;
                }
            };
        }
        int size = 0;
        if (this.frameRateControl != null) {
            ++size;
        }
        if (this.gainControl != null) {
            ++size;
        }
        if (this.bitRateControl != null) {
            ++size;
        }
        this.controls = new Control[size];
        size = 0;
        if (this.frameRateControl != null) {
            this.controls[size++] = this.frameRateControl;
        }
        if (this.gainControl != null) {
            this.controls[size++] = this.gainControl;
        }
        if (this.bitRateControl != null) {
            this.controls[size++] = this.bitRateControl;
        }
        return this.controls;
    }

    public void play() {
        if (this.fwdSpeed == 1.0f) {
            this.setAction(1);
        } else {
            this.setAction(2);
        }
    }

    public void pause() {
        this.setAction(8);
    }

    protected float doSetRate(float r) {
        if (this.strmType == 4) {
            return 1.0f;
        }
        if (r < 0.1f) {
            r = 0.1f;
        } else if (r > 10.0f) {
            r = 10.0f;
        }
        this.fwdSpeed = r;
        return this.fwdSpeed;
    }

    public boolean checkStreamType() {
        if (this.strmType != 0) {
            this.possibleLength = -1;
            if (this.filename != null) {
                this.getMediaDuration(this.filename);
            }
            if (this.possibleLength > 0) {
                this.eomDuration = new Time((double)this.possibleLength);
            }
            return true;
        }
        this.possibleLength = -1;
        if (this.filename != null) {
            this.strmType = this.checkMpegFile(this.filename);
            if (this.strmType == 0) {
                return false;
            }
        } else if (this.sourceStream != null) {
            this.strmType = this.checkMpegStream(this.sourceStream);
            if (this.strmType == 0) {
                return false;
            }
            if (this.sourceStream instanceof Seekable) {
                ((Seekable)((Object)this.sourceStream)).seek(0L);
            }
        } else {
            return false;
        }
        if (this.possibleWidth != -1 && this.possibleHeight != -1) {
            this.width = this.possibleWidth;
            this.height = this.possibleHeight;
            this.outWidth = this.width;
            this.outHeight = this.height;
        }
        if (this.possibleLength > 0) {
            this.eomDuration = new Time((double)this.possibleLength);
        }
        return true;
    }

    protected boolean initAudio() {
        return this.audio != null;
    }

    protected void closeAudio() {
        if (this.audio != null) {
            this.audio.pause();
            this.audio.flush();
            this.audio.dispose();
            this.audio = null;
        }
    }

    protected boolean setAudio(int rate, int channels) {
        boolean isMuted = false;
        float gain = -1.0f;
        if (this.audio != null) {
            if (this.audioRate == rate && this.audioChannels == channels) {
                this.audio.flush();
                this.audio.resetSamples();
                return true;
            }
            isMuted = this.audio.getMute();
            gain = (float)this.audio.getGain();
            this.audio.pause();
            this.audio.flush();
            this.audio.dispose();
        }
        AudioFormat format = new AudioFormat("LINEAR", rate, 16, channels, BIG_ENDIAN ? 1 : 0, 1);
        this.audioRate = rate;
        this.audioChannels = channels;
        this.audio = new JmpxAudio();
        if (!this.audio.initialize(format)) {
            this.audio = null;
            return false;
        }
        this.audio.resume();
        if (this.timeBase instanceof MPXTimeBase) {
            ((MPXTimeBase)this.timeBase).reset();
        }
        if (this.gainControl != null) {
            this.audio.setMute(this.gainControl.getMute());
            if (this.gainControl.getDB() != -1.0f) {
                this.audio.setGain(this.gainControl.getDB());
            }
        } else {
            if (isMuted) {
                this.audio.setMute(isMuted);
            }
            if (gain != -1.0f) {
                this.audio.setGain(gain);
            }
        }
        return true;
    }

    public boolean isInitialized() {
        return this.peer != 0L;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getStreamType() {
        return this.strmType;
    }

    public int getDisplayWidth() {
        if (this.useJavaRenderer == 1) {
            return this.outWidth;
        }
        return this.width * this.zoom;
    }

    public int getDisplayHeight() {
        if (this.useJavaRenderer == 1) {
            return this.outHeight;
        }
        return this.height * this.zoom;
    }

    public double getLoc() {
        return this.loc;
    }

    public void setMute(boolean m2) {
        if (this.audio != null) {
            this.audio.setMute(m2);
        }
    }

    public void setGain(float g2) {
        if (this.audio != null) {
            this.audio.setGain(g2);
        }
    }

    private synchronized void exit() {
        MpxCmd cmd = new MpxCmd();
        cmd.packInt(7, -859045887);
        cmd.packInt(9, 1);
        this.sendMPX(cmd.getBytes());
        this.peer = 0L;
    }

    private synchronized void openFile(String path) {
        MpxCmd cmd = new MpxCmd();
        cmd.packInt(9, 2);
        cmd.packInt(10, 0);
        cmd.packInt(11, 0);
        cmd.packInt(12, this.strmType);
        cmd.packInt(13, 0);
        cmd.packInt(14, 1);
        cmd.packInt(15, 1);
        cmd.packStr(16, path);
        this.sendMPX(cmd.getBytes());
    }

    public synchronized void openStream(SourceStream is) {
        this.setStream(is);
        MpxCmd cmd = new MpxCmd();
        cmd.packInt(9, 2);
        cmd.packInt(10, 0);
        cmd.packInt(11, 0);
        cmd.packInt(12, this.strmType);
        cmd.packInt(13, 0);
        cmd.packInt(14, 1);
        cmd.packInt(15, 5);
        this.sendMPX(cmd.getBytes());
    }

    public synchronized void setAction(int act) {
        MpxCmd cmd = new MpxCmd();
        cmd.packInt(9, 5);
        cmd.packInt(10, act);
        cmd.packInt(11, (int)((double)this.fwdSpeed * 65535.0));
        this.sendMPX(cmd.getBytes());
    }

    public synchronized void seek(double loc) {
        MpxCmd cmd = new MpxCmd();
        cmd.packInt(9, 4);
        cmd.packInt(10, 0);
        cmd.packInt(11, (int)(loc * 65535.0));
        cmd.packInt(12, this.strmType);
        cmd.packInt(13, 0);
        cmd.packInt(14, 1);
        this.sendMPX(cmd.getBytes());
    }

    public synchronized void flush() {
        MpxCmd cmd = new MpxCmd();
        cmd.packInt(9, 4);
        cmd.packInt(10, 0);
        cmd.packInt(11, 0);
        cmd.packInt(12, this.strmType);
        cmd.packInt(13, 8224);
        cmd.packInt(14, 4);
        this.sendMPX(cmd.getBytes());
    }

    public synchronized void mute(boolean m2) {
        MpxCmd cmd = new MpxCmd();
        cmd.packInt(9, 7);
        if (m2) {
            cmd.packInt(10, 192);
        } else {
            cmd.packInt(10, 0);
        }
        this.sendMPX(cmd.getBytes());
        this.muted = m2;
    }

    public synchronized void muteAll(boolean m2) {
        MpxCmd cmd = new MpxCmd();
        cmd.packInt(9, 7);
        if (m2) {
            cmd.packInt(10, 192);
        } else {
            cmd.packInt(10, 0);
        }
        this.broadcastMPX(cmd.getBytes());
    }

    public synchronized void zoom(int z) {
        if (this.useJavaRenderer != 1) {
            MpxCmd cmd = new MpxCmd();
            cmd.packInt(9, 6);
            cmd.packInt(10, 1);
            int arg = this.interleaved ? 2 : 1;
            arg <<= 8;
            cmd.packInt(11, arg |= z);
            this.sendMPX(cmd.getBytes());
        } else {
            this.java_zoom = z;
        }
    }

    public synchronized void zoomIn() {
        if (this.useJavaRenderer == 1) {
            if (this.java_zoom >= 2.0f) {
                return;
            }
            this.java_zoom *= 2.0f;
            this.updateSizeChanged(this.width, this.height);
        } else {
            this.zoom(this.zoom + 1);
        }
    }

    public synchronized void zoomOut() {
        if (this.useJavaRenderer == 1) {
            if (this.java_zoom <= 0.25f) {
                return;
            }
            this.java_zoom /= 2.0f;
            this.updateSizeChanged(this.width, this.height);
        } else {
            if (this.zoom <= 1) {
                return;
            }
            this.zoom(this.zoom - 1);
        }
    }

    public void updateSizeChanged(int width, int height) {
        this.sendEvent(new SizeChangeEvent(this, width, height, 1.0f));
    }

    public synchronized void setInterleave(boolean l2) {
        MpxCmd cmd = new MpxCmd();
        cmd.packInt(9, 6);
        cmd.packInt(10, 1);
        int arg = l2 ? 2 : 1;
        arg <<= 8;
        arg = this.useJavaRenderer == 1 ? (arg |= 1) : (arg |= this.zoom);
        cmd.packInt(11, arg);
        this.sendMPX(cmd.getBytes());
    }

    public synchronized void setAudioMode(int m2) {
        MpxCmd cmd = new MpxCmd();
        cmd.packInt(9, 6);
        cmd.packInt(10, 2);
        if ((m2 & 3) == 3) {
            cmd.packInt(12, 56);
        } else if ((m2 & 2) == 2) {
            cmd.packInt(12, 48);
        } else {
            cmd.packInt(12, 40);
        }
        this.sendMPX(cmd.getBytes());
    }

    public synchronized void setAudioQuality(int q) {
        MpxCmd cmd = new MpxCmd();
        cmd.packInt(9, 6);
        cmd.packInt(10, 2);
        if ((q & 0x18) == 24) {
            cmd.packInt(12, 4);
        } else if ((q & 0x10) == 16) {
            cmd.packInt(12, 5);
        } else {
            cmd.packInt(12, 6);
        }
        this.sendMPX(cmd.getBytes());
    }

    public synchronized void setGamma(double g2) {
        MpxCmd cmd = new MpxCmd();
        cmd.packInt(9, 6);
        cmd.packInt(10, 32);
        cmd.packInt(16, (int)(g2 * 65535.0));
        this.sendMPX(cmd.getBytes());
    }

    public synchronized void sendAck() {
        MpxCmd cmd = new MpxCmd();
        cmd.packInt(7, -859045887);
        cmd.packInt(9, 10);
        cmd.packInt(6, this.ackSeq);
        this.sendMPX(cmd.getBytes());
    }

    public void addJmpxListener(JmpxListener cl) {
        this.listeners.addElement(cl);
    }

    public void removeJmpxListener(JmpxListener cl) {
        this.listeners.removeElement(cl);
    }

    public void updateListeners(JmpxEvent evt) {
        for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
            ((JmpxListener)this.listeners.elementAt(i2)).jmpxUpdate(evt);
        }
    }

    protected void listenCommand() {
        byte[] command = new byte[128];
        int len = 0;
        try {
            if (!this.killCommandThread) {
                len = this.cmdPipe.read(command);
            }
        }
        catch (IOException e2) {
            return;
        }
        if (len > 0) {
            this.processCommand(command, len);
        }
    }

    protected int processCommand(byte[] cmd, int len) {
        int i2;
        int[] cb = new int[len /= 4];
        if (BIG_ENDIAN) {
            for (i2 = 0; i2 < len; ++i2) {
                cb[i2] = 0;
                int n2 = i2;
                cb[n2] = cb[n2] | cmd[i2 * 4] & 0x7F;
                int n3 = i2;
                cb[n3] = cb[n3] | cmd[i2 * 4] & 0x80;
                int n4 = i2;
                cb[n4] = cb[n4] << 8;
                int n5 = i2;
                cb[n5] = cb[n5] | cmd[i2 * 4 + 1] & 0x7F;
                int n6 = i2;
                cb[n6] = cb[n6] | cmd[i2 * 4 + 1] & 0x80;
                int n7 = i2;
                cb[n7] = cb[n7] << 8;
                int n8 = i2;
                cb[n8] = cb[n8] | cmd[i2 * 4 + 2] & 0x7F;
                int n9 = i2;
                cb[n9] = cb[n9] | cmd[i2 * 4 + 2] & 0x80;
                int n10 = i2;
                cb[n10] = cb[n10] << 8;
                int n11 = i2;
                cb[n11] = cb[n11] | cmd[i2 * 4 + 3] & 0x7F;
                int n12 = i2;
                cb[n12] = cb[n12] | cmd[i2 * 4 + 3] & 0x80;
            }
        } else {
            for (i2 = 0; i2 < len; ++i2) {
                cb[i2] = 0;
                int n13 = i2;
                cb[n13] = cb[n13] | cmd[i2 * 4 + 3] & 0x7F;
                int n14 = i2;
                cb[n14] = cb[n14] | cmd[i2 * 4 + 3] & 0x80;
                int n15 = i2;
                cb[n15] = cb[n15] << 8;
                int n16 = i2;
                cb[n16] = cb[n16] | cmd[i2 * 4 + 2] & 0x7F;
                int n17 = i2;
                cb[n17] = cb[n17] | cmd[i2 * 4 + 2] & 0x80;
                int n18 = i2;
                cb[n18] = cb[n18] << 8;
                int n19 = i2;
                cb[n19] = cb[n19] | cmd[i2 * 4 + 1] & 0x7F;
                int n20 = i2;
                cb[n20] = cb[n20] | cmd[i2 * 4 + 1] & 0x80;
                int n21 = i2;
                cb[n21] = cb[n21] << 8;
                int n22 = i2;
                cb[n22] = cb[n22] | cmd[i2 * 4 + 0] & 0x7F;
                int n23 = i2;
                cb[n23] = cb[n23] | cmd[i2 * 4 + 0] & 0x80;
            }
        }
        for (i2 = 0; i2 < 4; ++i2) {
            if (cb[i2] == MpxCmd.SyncPat[i2]) continue;
            return 0;
        }
        if (cb[4] != -1431699455) {
            return 0;
        }
        if (cb[7] >>> 16 != 52428) {
            return 0;
        }
        int flags = cb[7] & 0xFFFF;
        if ((flags & 4) == 0) {
            return 0;
        }
        if (cb[8] >>> 16 != 56797) {
            return 0;
        }
        int type = cb[8] & 0xFFFF;
        if (type != 1 && type != 2) {
            return 0;
        }
        if (type == 1 && len != 32 || type == 2 && len != 128) {
            return 0;
        }
        int seq = cb[6];
        int id = cb[9];
        switch (id & 0xFF) {
            case 30: {
                this.width = cb[10];
                this.height = cb[11];
                if (this.useJavaRenderer != 1) {
                    this.zoom = cb[12];
                }
                this.cmap = cb[13];
                this.updateSize(this.width, this.height);
                this.sendEvent(new SizeChangeEvent(this, this.width, this.height, 1.0f));
                break;
            }
            case 31: {
                long now = System.currentTimeMillis();
                float delta = (float)(now - this.lastStatTime) / 1000.0f;
                this.lastStatTime = now;
                this.size = cb[10];
                this.loc = (float)((double)cb[11] / 65535.0);
                this.time = cb[12];
                long frameCount = cb[13] + cb[14] + cb[15];
                this.fps = (float)(cb[13] + cb[14] + cb[15]) / delta;
                this.fps = (float)((int)(this.fps * 10.0f)) / 10.0f;
                this.kbps = (float)(cb[16] * 8) / delta / 1000.0f;
                this.kbps = (float)((int)(this.kbps * 10.0f)) / 10.0f;
                this.frames += (long)(cb[13] + cb[14] + cb[15]);
                if (this.frameRateControl != null) {
                    this.frameRateControl.setFrameRate(this.fps);
                }
                if (this.bitRateControl != null) {
                    this.bitRateControl.setBitRate((int)(this.kbps * 1000.0f));
                }
                if ((double)this.loc >= 1.0 && (this.frames != 0L || this.strmType == 4)) {
                    this.pause();
                    super.stop();
                    this.startSource(false);
                    if ((double)this.oldLoc < 1.0) {
                        this.knownDuration = this.eomDuration = this.getMediaTime();
                        this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                        this.sendEvent(new DurationUpdateEvent(this, this.eomDuration));
                    }
                }
                this.oldLoc = this.loc;
                this.getDuration();
                break;
            }
            case 10: {
                if (this.listeners.size() <= 0) break;
                JmpxAckNotifyEvent ack = new JmpxAckNotifyEvent();
                ack.sequence = seq;
                this.updateListeners(ack);
                break;
            }
        }
        return id;
    }

    public void run() {
        while (!this.killCommandThread) {
            this.listenCommand();
        }
    }

    public synchronized void resizeWindow(int w, int h2) {
        if (this.monitor == null) {
            return;
        }
        this.width = w;
        this.height = h2;
        if (this.videoformat instanceof RGBFormat) {
            this.rgbBuffer = new int[this.width * this.height];
            this.videoformat = new RGBFormat(new Dimension(this.width, this.height), this.width * this.height, Format.intArray, 30.0f, 32, this.rMask, this.gMask, this.bMask, 1, this.width, 0, 0);
            this.outWidth = this.width;
            this.outHeight = this.height;
            this.monitor.setSize(this.outWidth, this.outHeight);
        } else {
            this.videoformat = new YUVFormat(new Dimension(this.width, this.height), this.width * this.height * 2, Format.byteArray, -1.0f, 4, this.width, this.width / 2, 0, this.width * this.height, this.width * this.height + this.width * this.height / 4);
            this.rgbBuffer = new byte[this.width * this.height * 2];
            this.monitor.setSize(this.outWidth, this.outHeight);
        }
    }

    public Component getImage(int w, int h2) {
        if (this.width != w || this.height != h2 || this.rgbBuffer == null) {
            this.resizeWindow(w, h2);
        }
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void displayImage() {
        if (this.monitor == null) {
            return;
        }
        Component component = this.monitor;
        synchronized (component) {
            if (this.videoformat instanceof RGBFormat) {
                this.outBuffer.setData((int[])this.rgbBuffer);
                this.outBuffer.setLength(this.width * this.height);
            } else {
                this.outBuffer.setData((byte[])this.rgbBuffer);
                this.outBuffer.setLength(this.width * this.height + this.width * this.height / 2);
            }
            this.outBuffer.setFormat(this.videoformat);
            this.outBuffer.setTimeStamp(-1L);
            this.outBuffer.setFlags(0);
            this.outBuffer.setHeader(null);
            this.renderer.process(this.outBuffer);
        }
    }

    private Component createMonitor(int width, int height) {
        ColorModel cm;
        Dimension size = new Dimension(width, height);
        this.videoformat = new YUVFormat(size, width * height * 2, Format.byteArray, -1.0f, 4, width, width / 2, 0, width * height, width * height + width * height / 4);
        this.renderer = (VideoRenderer)SimpleGraphBuilder.findRenderer(this.videoformat);
        if (this.renderer != null) {
            this.needYUVBuffer = 1;
            this.rgbBuffer = new byte[width * height * 2];
            return this.renderer.getComponent();
        }
        this.needXBGR = 1;
        if (LITTLE_ENDIAN) {
            this.rMask = 0xFF0000;
            this.bMask = 255;
        }
        if ((cm = Toolkit.getDefaultToolkit().getColorModel()) instanceof DirectColorModel) {
            DirectColorModel dcm = (DirectColorModel)cm;
            if (dcm.getPixelSize() > 16) {
                this.rMask = dcm.getRedMask();
                this.gMask = dcm.getGreenMask();
                this.bMask = dcm.getBlueMask();
            }
            if (this.rMask != 255 && !LITTLE_ENDIAN) {
                this.needXBGR = 0;
            }
        }
        this.videoformat = new RGBFormat(size, size.width * size.height, Format.intArray, 30.0f, 32, this.rMask, this.gMask, this.bMask, 1, size.width + 7 & 0xFFFFFFF8, 0, -1);
        this.rgbBuffer = new int[width * height];
        this.renderer = (VideoRenderer)SimpleGraphBuilder.findRenderer(this.videoformat);
        if (this.renderer == null) {
            System.err.println("No renderer");
            return null;
        }
        return this.renderer.getComponent();
    }

    private void updateSize(int width, int height) {
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    class GCA
    extends GainControlAdapter {
        Jmpx jmpx;

        protected GCA(Jmpx jmpx2) {
            super(false);
            this.jmpx = jmpx2;
        }

        public void setMute(boolean mute) {
            if (Jmpx.this.audio != null) {
                Jmpx.this.audio.setMute(mute);
            }
            super.setMute(mute);
        }

        public float setLevel(float g2) {
            if (this.jmpx == null) {
                return g2;
            }
            float level = super.setLevel(g2);
            if (Jmpx.this.audio != null) {
                Jmpx.this.audio.setGain(this.getDB());
            }
            return level;
        }
    }

    class PushStreamHandler
    implements SourceTransferHandler {
        PushStreamHandler() {
        }

        public void transferData(PushSourceStream stream) {
            Jmpx.this.notifyPushDataArrival();
        }
    }

    class Monitor
    extends Canvas {
        public Monitor(int w, int h2) {
            super.setSize(w, h2);
        }

        public void updateSize(int w, int h2) {
            if (Jmpx.this.outputSizeSet) {
                return;
            }
            Component parent = this;
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
            super.setSize(w, h2);
            if (parent != null) {
                parent.validate();
            }
            this.repaint();
        }

        public Dimension getMinimumSize() {
            return new Dimension(1, 1);
        }

        public Dimension getPreferredSize() {
            return new Dimension(Jmpx.this.getWidth(), Jmpx.this.getHeight());
        }

        public synchronized void removeNotify() {
            Jmpx.this.windowAvailable = false;
            super.removeNotify();
        }

        public synchronized void addNotify() {
            super.addNotify();
            Jmpx.this.windowAvailable = true;
        }

        public synchronized void paint(Graphics g2) {
            if (Jmpx.this.getTargetState() == 600) {
                return;
            }
        }

        public void update(Graphics g2) {
            if (Jmpx.this.getTargetState() == 600) {
                return;
            }
        }
    }

    class MPXTimeBase
    extends MediaTimeBase {
        MPXTimeBase() {
        }

        public long getMediaTime() {
            return Jmpx.this.audio != null ? Jmpx.this.audio.getMediaNanoseconds() : 0L;
        }

        protected void reset() {
            if (Jmpx.this.audio == null || Jmpx.this.getState() != 600) {
                this.mediaStopped();
            } else {
                this.mediaStarted();
            }
        }
    }
}

