/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jpeg;

import com.sun.media.BasicCodec;
import com.sun.media.codec.video.jpeg.RTPDePacketizer;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.JPEGFormat;
import javax.media.format.VideoFormat;

public class DePacketizer
extends BasicCodec {
    private VideoFormat inputFormat = null;
    private JPEGFormat outputFormat = null;
    private int decimation = -1;
    private int quality = -1;
    private RTPDePacketizer rtpdp = null;
    int DEFAULT_WIDTH = 320;
    int DEFAULT_HEIGHT = 240;

    public DePacketizer() {
        this.inputFormats = new Format[]{new VideoFormat("jpeg/rtp")};
        this.outputFormats = new Format[]{new VideoFormat("jpeg")};
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return this.outputFormats;
        }
        if (DePacketizer.matches(in, this.inputFormats) == null) {
            return new Format[0];
        }
        Format[] out = new Format[]{this.makeJPEGFormat(in)};
        return out;
    }

    public Format setInputFormat(Format input) {
        this.inputFormat = (VideoFormat)input;
        if (this.opened) {
            this.outputFormat = this.makeJPEGFormat(this.inputFormat);
        }
        return input;
    }

    public Format setOutputFormat(Format output) {
        if (!(output instanceof VideoFormat)) {
            return null;
        }
        this.outputFormat = this.makeJPEGFormat(output);
        return this.outputFormat;
    }

    private final JPEGFormat makeJPEGFormat(Format in) {
        VideoFormat vf = (VideoFormat)in;
        return new JPEGFormat(vf.getSize() != null ? vf.getSize() : new Dimension(this.DEFAULT_WIDTH, this.DEFAULT_HEIGHT), -1, Format.byteArray, vf.getFrameRate(), this.quality, this.decimation);
    }

    public void open() throws ResourceUnavailableException {
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Incorrect formats set on JPEG converter");
        }
        this.rtpdp = new RTPDePacketizer();
        super.open();
    }

    public synchronized void close() {
        this.rtpdp = null;
        super.close();
    }

    public void reset() {
    }

    public synchronized int process(Buffer inBuffer, Buffer outBuffer) {
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            return 0;
        }
        if (inBuffer.isDiscard()) {
            this.updateOutput(outBuffer, this.outputFormat, 0, 0);
            outBuffer.setDiscard(true);
            return 4;
        }
        int retVal = this.rtpdp.process(inBuffer, outBuffer);
        if (retVal != 0) {
            return retVal;
        }
        int type = this.rtpdp.getType();
        int q = this.rtpdp.getQuality();
        if (type != this.decimation || q != this.quality) {
            this.decimation = type;
            this.quality = q;
            this.outputFormat = this.makeJPEGFormat(inBuffer.getFormat());
        }
        outBuffer.setFormat(this.outputFormat);
        outBuffer.setOffset(0);
        outBuffer.setTimeStamp(inBuffer.getTimeStamp());
        inBuffer.setLength(0);
        outBuffer.setFlags(outBuffer.getFlags() | 0x10);
        return 0;
    }

    public void finalize() {
        this.close();
    }

    public String getName() {
        return "JPEG DePacketizer";
    }
}

