/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.mpeg;

import com.sun.media.BasicCodec;
import com.sun.media.codec.video.mpeg.RTPDePacketizer;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;

public class DePacketizer
extends BasicCodec {
    private VideoFormat inputFormat = null;
    private VideoFormat outputFormat = null;
    private RTPDePacketizer rtpdp = null;

    public DePacketizer() {
        this.inputFormats = new Format[]{new VideoFormat("mpeg/rtp")};
        this.outputFormats = new Format[]{new VideoFormat("mpeg")};
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return this.outputFormats;
        }
        if (DePacketizer.matches(in, this.inputFormats) == null) {
            return new Format[0];
        }
        Format[] out = new Format[]{this.makeMPEGFormat(in)};
        return out;
    }

    public Format setInputFormat(Format input) {
        this.inputFormat = (VideoFormat)input;
        return input;
    }

    public Format setOutputFormat(Format output) {
        if (!(output instanceof VideoFormat)) {
            return null;
        }
        this.outputFormat = this.makeMPEGFormat(output);
        return output;
    }

    private final VideoFormat makeMPEGFormat(Format in) {
        VideoFormat vf = (VideoFormat)in;
        return new VideoFormat("mpeg", vf.getSize(), -1, Format.byteArray, vf.getFrameRate());
    }

    public void open() throws ResourceUnavailableException {
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Incorrect formats set on MPEG video depacketizer");
        }
        this.rtpdp = new RTPDePacketizer();
    }

    public synchronized void close() {
        this.rtpdp = null;
    }

    public void reset() {
    }

    public synchronized int process(Buffer inBuffer, Buffer outBuffer) {
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            return 0;
        }
        if (inBuffer.isDiscard()) {
            this.updateOutput(outBuffer, this.outputFormat, 0, 0);
            outBuffer.setDiscard(true);
            return 4;
        }
        int retVal = this.rtpdp.process(inBuffer, outBuffer);
        if (retVal != 0) {
            return retVal;
        }
        if (this.outputFormat == null) {
            this.outputFormat = (VideoFormat)outBuffer.getFormat();
        }
        return 0;
    }

    public void finalize() {
        this.close();
    }

    public String getName() {
        return "MPEG Video DePacketizer";
    }
}

