/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.rtsp;

import com.sun.media.BasicPlayer;
import com.sun.media.Log;
import com.sun.media.content.rtsp.RtspUtil;
import com.sun.media.controls.RtspAdapter;
import com.sun.media.protocol.BufferListener;
import com.sun.media.rtsp.Timer;
import com.sun.media.rtsp.TimerListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;
import javax.media.ClockStartedError;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.SystemTimeBase;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.BufferControl;
import javax.media.protocol.DataSource;
import javax.media.renderer.VisualContainer;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;

public class Handler
extends BasicPlayer
implements ReceiveStreamListener,
TimerListener,
BufferListener {
    private final int INITIALIZED = 0;
    private final int REALIZED = 1;
    private final int PLAYING = 2;
    private final int PAUSING = 3;
    private RtspUtil rtspUtil;
    private Player[] players;
    private Vector playerList;
    private boolean dataReceived;
    private com.sun.media.protocol.rtp.DataSource[] data_sources;
    private boolean[] track_ready;
    private String url;
    private Object readySync = new Object();
    private Object stateSync = new Object();
    private boolean waitFailed;
    private int state;
    private boolean first_pass = true;
    private Timer timer;
    private Container container = null;

    public Handler() {
        this.rtspUtil = new RtspUtil(this);
        this.framePositioning = false;
        this.playerList = new Vector();
        this.state = 0;
        this.stopThreadEnabled = true;
    }

    protected synchronized boolean doRealize() {
        boolean realized = super.doRealize();
        if (realized) {
            realized = this.initRtspSession();
            if (!realized) {
                this.processError = this.rtspUtil.getProcessError();
            } else {
                long duration = this.rtspUtil.getDuration();
                if (duration > 0L) {
                    this.sendEvent(new DurationUpdateEvent(this, new Time(duration)));
                }
            }
        }
        return realized;
    }

    private boolean initRtspSession() {
        boolean realized = false;
        this.rtspUtil.setUrl(this.url);
        String ipAddress = this.rtspUtil.getServerIpAddress();
        if (ipAddress == null) {
            Log.error("Invalid server address");
            this.rtspUtil.setProcessError("Invalid server address");
            realized = false;
        } else {
            realized = this.rtspUtil.createConnection();
            if (realized) {
                realized = this.rtspUtil.rtspSetup();
                try {
                    InetAddress destaddr = InetAddress.getByName(ipAddress);
                    int numberOfTracks = this.rtspUtil.getNumberOfTracks();
                    int[] server_ports = this.rtspUtil.getServerPorts();
                    for (int i2 = 0; i2 < numberOfTracks; ++i2) {
                        SessionAddress remoteAddress = new SessionAddress(destaddr, server_ports[i2]);
                        RTPManager mgr = this.rtspUtil.getRTPManager(i2);
                        mgr.addTarget(remoteAddress);
                        BufferControl bc = (BufferControl)mgr.getControl("javax.media.control.BufferControl");
                        String mediaType = this.rtspUtil.getMediaType(i2);
                        if (mediaType.equals("audio")) {
                            bc.setBufferLength(250L);
                            bc.setMinimumThreshold(125L);
                            continue;
                        }
                        if (!mediaType.equals("video")) continue;
                        bc.setBufferLength(1500L);
                        bc.setMinimumThreshold(250L);
                    }
                }
                catch (Exception e2) {
                    Log.error(e2.getMessage());
                    return realized;
                }
            }
        }
        if (realized) {
            this.state = 1;
            int size = this.rtspUtil.getNumberOfTracks();
            this.players = new Player[size];
            this.data_sources = new com.sun.media.protocol.rtp.DataSource[size];
            this.track_ready = new boolean[size];
            this.dataReceived = false;
            if (!this.rtspUtil.rtspStart()) {
                if (this.first_pass && this.rtspUtil.getStatusCode() == 454) {
                    this.first_pass = false;
                    this.playerList = new Vector();
                    return this.initRtspSession();
                }
                return false;
            }
            this.waitForData();
            if (this.playerList.size() > 0) {
                this.rtspStop();
                this.rtspUtil.setStartPos(0.0);
                for (int i3 = 0; i3 < this.rtspUtil.getNumberOfTracks(); ++i3) {
                    this.data_sources[i3].flush();
                }
            } else {
                this.rtspUtil.setProcessError("Media tracks not supported");
                realized = false;
            }
        }
        return realized;
    }

    public boolean doPrefetch() {
        boolean prefetched = super.doPrefetch();
        return prefetched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        if (this.state >= 1 && this.state != 2) {
            for (int i2 = 0; i2 < this.rtspUtil.getNumberOfTracks(); ++i2) {
                this.track_ready[i2] = this.rtspUtil.getRTPManager(i2) == null;
                this.data_sources[i2].prebuffer();
            }
            boolean success = this.rtspUtil.rtspStart();
            Object object = this.readySync;
            synchronized (object) {
                boolean ready = true;
                for (int i3 = 0; i3 < this.rtspUtil.getNumberOfTracks(); ++i3) {
                    if (this.track_ready[i3]) continue;
                    ready = false;
                    break;
                }
                if (!ready) {
                    try {
                        this.readySync.wait(3000L);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
            }
            if (success) {
                super.doStart();
                this.startPlayers();
                this.state = 2;
                long duration = this.rtspUtil.getDuration();
                if (duration > 0L) {
                    this.timer = new Timer(this, duration + 500000000L - this.getMediaTime().getNanoseconds());
                    this.timer.start();
                }
            }
        }
    }

    public void doSetMediaTime(Time now) {
        super.doSetMediaTime(now);
        this.rtspUtil.setStartPos(now.getNanoseconds());
        for (int i2 = 0; i2 < this.rtspUtil.getNumberOfTracks(); ++i2) {
            this.data_sources[i2].flush();
        }
    }

    public Time getMediaTime() {
        Time time = super.getMediaTime();
        return time;
    }

    public void timerExpired() {
        this.timer = null;
        this.processEndOfMedia();
    }

    public void doStop() {
        if (this.state == 2) {
            super.doStop();
            if (this.timer != null) {
                this.timer.stopTimer();
                this.timer.removeListener(this);
                this.timer = null;
            }
            this.stopPlayers();
            this.rtspStop();
            this.state = 3;
        }
    }

    public void rtspStop() {
        this.rtspUtil.setStartPos(this.getMediaTime().getNanoseconds());
        this.rtspUtil.rtspStop();
    }

    public void doClose() {
        this.stopPlayers();
        this.closePlayers();
        if (this.timer != null) {
            this.timer.stopTimer();
            this.timer.removeListener(this);
            this.timer = null;
        }
        if (this.state == 2) {
            this.rtspUtil.rtspTeardown();
        }
        this.state = 0;
        this.rtspUtil.closeConnection();
        for (int i2 = 0; i2 < this.rtspUtil.getNumberOfTracks(); ++i2) {
            RTPManager mgr = this.rtspUtil.getRTPManager(i2);
            mgr.removeTargets("server down.");
            mgr.dispose();
        }
        super.doClose();
    }

    public float setRate(float rate) {
        if (this.getState() < 300) {
            this.throwError(new NotRealizedError("Cannot set rate on an unrealized Player."));
        }
        return 1.0f;
    }

    public void setStopTime(Time t) {
        this.controllerSetStopTime(t);
    }

    protected void stopAtTime() {
        this.controllerStopAtTime();
    }

    public synchronized void addController(Controller newController) throws IncompatibleTimeBaseException {
        int playerState = this.getState();
        if (playerState == 600) {
            this.throwError(new ClockStartedError("Cannot add controller to a started player"));
        }
        if (playerState == 100 || playerState == 200) {
            this.throwError(new NotRealizedError("A Controller cannot be added to an Unrealized Player"));
        }
        throw new IncompatibleTimeBaseException();
    }

    public boolean audioEnabled() {
        boolean enabled = true;
        return enabled;
    }

    public boolean videoEnabled() {
        boolean enabled = true;
        return enabled;
    }

    public void updateStats() {
    }

    protected TimeBase getMasterTimeBase() {
        return new SystemTimeBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(ReceiveStreamEvent event) {
        RTPManager source = (RTPManager)event.getSource();
        if (event instanceof NewReceiveStreamEvent) {
            ReceiveStream stream = ((NewReceiveStreamEvent)event).getReceiveStream();
            Participant part = stream.getParticipant();
            int numberOfTracks = this.rtspUtil.getNumberOfTracks();
            for (int i2 = 0; i2 < numberOfTracks; ++i2) {
                if (source != this.rtspUtil.getRTPManager(i2)) continue;
                com.sun.media.protocol.rtp.DataSource ds = (com.sun.media.protocol.rtp.DataSource)stream.getDataSource();
                try {
                    this.players[i2] = Manager.createPlayer(ds);
                }
                catch (Exception e2) {
                    System.err.println("Failed to create a player from the given Data Source: " + e2);
                }
                try {
                    this.waitFailed = false;
                    this.players[i2].addControllerListener(new StateListener());
                    this.players[i2].realize();
                    this.waitForState(this.players[i2], 300);
                }
                catch (Exception e3) {
                    // empty catch block
                }
                if (this.players[i2].getState() == 300) {
                    this.playerList.addElement(this.players[i2]);
                    ds.setBufferListener(this);
                    this.data_sources[i2] = ds;
                    break;
                }
                this.players[i2].close();
                this.players[i2] = null;
                this.rtspUtil.removeTrack(i2);
                break;
            }
            if (this.playerList.size() == this.rtspUtil.getNumberOfTracks()) {
                this.dataReceived = true;
                Handler handler = this;
                synchronized (handler) {
                    this.notifyAll();
                }
            }
        } else if (event instanceof ByeEvent) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void minThresholdReached(DataSource ds) {
        Object object = this.readySync;
        synchronized (object) {
            for (int i2 = 0; i2 < this.rtspUtil.getNumberOfTracks(); ++i2) {
                if (ds != this.data_sources[i2]) continue;
                this.track_ready[i2] = true;
                break;
            }
            boolean all_ready = true;
            for (int i3 = 0; i3 < this.rtspUtil.getNumberOfTracks(); ++i3) {
                if (this.track_ready[i3]) continue;
                all_ready = false;
                break;
            }
            if (all_ready) {
                this.readySync.notifyAll();
            }
        }
    }

    public long getMediaNanoseconds() {
        long value = super.getMediaNanoseconds();
        return value;
    }

    public Time getDuration() {
        long t = this.rtspUtil.getDuration();
        if (t <= 0L) {
            return Duration.DURATION_UNKNOWN;
        }
        return new Time(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void waitForState(Player p, int state) {
        while (p.getState() < state && !this.waitFailed) {
            Object object = this.stateSync;
            synchronized (object) {
                try {
                    this.stateSync.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean waitForData() {
        try {
            Handler handler = this;
            synchronized (handler) {
                while (!this.dataReceived) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        return this.dataReceived;
    }

    public Component getVisualComponent() {
        Vector<Component> visuals = new Vector<Component>(1);
        for (int i2 = 0; i2 < this.rtspUtil.getNumberOfTracks(); ++i2) {
            Component comp;
            if (this.players[i2] == null || (comp = this.players[i2].getVisualComponent()) == null) continue;
            visuals.addElement(comp);
        }
        if (visuals.size() == 0) {
            return null;
        }
        if (visuals.size() == 1) {
            return (Component)visuals.elementAt(0);
        }
        return this.createVisualContainer(visuals);
    }

    protected Component createVisualContainer(Vector visuals) {
        Boolean hint = (Boolean)Manager.getHint(3);
        if (this.container == null) {
            this.container = hint == null || hint == false ? new HeavyPanel(visuals) : new LightPanel(visuals);
            this.container.setLayout(new FlowLayout());
            this.container.setBackground(Color.black);
            for (int i2 = 0; i2 < visuals.size(); ++i2) {
                Component c2 = (Component)visuals.elementAt(i2);
                this.container.add(c2);
                c2.setSize(c2.getPreferredSize());
            }
        }
        return this.container;
    }

    public GainControl getGainControl() {
        Player player;
        GainControl gainControl = null;
        for (int i2 = 0; i2 < this.playerList.size() && (gainControl = (player = (Player)this.playerList.elementAt(i2)).getGainControl()) == null; ++i2) {
        }
        return gainControl;
    }

    public Control[] getControls() {
        int size = 0;
        for (int i2 = 0; i2 < this.playerList.size(); ++i2) {
            Control[] controls = ((Player)this.playerList.elementAt(i2)).getControls();
            size += controls.length;
        }
        Control[] rtspControls = new Control[++size];
        RtspAdapter rtspAdapter = new RtspAdapter();
        rtspAdapter.setRTPManagers(this.rtspUtil.getRTPManagers());
        rtspAdapter.setMediaTypes(this.rtspUtil.getMediaTypes());
        int counter = 0;
        rtspControls[counter++] = rtspAdapter;
        for (int i3 = 0; i3 < this.playerList.size(); ++i3) {
            Control[] controls = ((Player)this.playerList.elementAt(i3)).getControls();
            for (int k2 = 0; k2 < controls.length; ++k2) {
                rtspControls[counter++] = controls[k2];
            }
        }
        return rtspControls;
    }

    private void startPlayers() {
        for (int i2 = 0; i2 < this.playerList.size(); ++i2) {
            Player player = (Player)this.playerList.elementAt(i2);
            player.start();
        }
    }

    private void stopPlayers() {
        for (int i2 = 0; i2 < this.playerList.size(); ++i2) {
            Player player = (Player)this.playerList.elementAt(i2);
            player.stop();
        }
    }

    private void closePlayers() {
        for (int i2 = 0; i2 < this.playerList.size(); ++i2) {
            Player player = (Player)this.playerList.elementAt(i2);
            player.close();
        }
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (source instanceof com.sun.media.protocol.rtsp.DataSource) {
            MediaLocator ml = source.getLocator();
            try {
                this.url = ml.toString();
            }
            catch (Exception e2) {
                throw new IncompatibleSourceException();
            }
        } else {
            throw new IncompatibleSourceException();
        }
    }

    class LightPanel
    extends Container
    implements VisualContainer {
        public LightPanel(Vector visuals) {
        }
    }

    class HeavyPanel
    extends Panel
    implements VisualContainer {
        public HeavyPanel(Vector visuals) {
        }
    }

    class StateListener
    implements ControllerListener {
        StateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void controllerUpdate(ControllerEvent ce) {
            Object object;
            if (ce instanceof ControllerClosedEvent) {
                // empty if block
            }
            if (ce instanceof ResourceUnavailableEvent) {
                Handler.this.waitFailed = true;
                object = Handler.this.stateSync;
                synchronized (object) {
                    Handler.this.stateSync.notify();
                }
            }
            if (ce instanceof RealizeCompleteEvent) {
                object = Handler.this.stateSync;
                synchronized (object) {
                    Handler.this.stateSync.notify();
                }
            }
            if (ce instanceof ControllerEvent) {
                object = Handler.this.stateSync;
                synchronized (object) {
                    Handler.this.stateSync.notify();
                }
            }
            if (ce instanceof EndOfMediaEvent) {
                // empty if block
            }
        }
    }
}

