/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser.audio;

import com.sun.media.parser.BasicPullParser;
import com.sun.media.parser.BasicTrack;
import com.sun.media.util.SettableTime;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Duration;
import javax.media.Format;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;

public class AiffParser
extends BasicPullParser {
    private Time duration = Duration.DURATION_UNKNOWN;
    private Format format = null;
    private Track[] tracks = new Track[1];
    private int numBuffers = 4;
    private int bufferSize = -1;
    private int dataSize;
    private SettableTime mediaTime = new SettableTime(0L);
    private PullSourceStream stream = null;
    private int maxFrame;
    private int blockSize = 0;
    private double sampleRate = -1.0;
    private long minLocation;
    private long maxLocation;
    private String encodingString = null;
    private int samplesPerBlock = 1;
    private double timePerBlockNano = -1.0;
    private double locationToMediaTime = -1.0;
    public static final String FormID = "FORM";
    public static final String FormatVersionID = "FVER";
    public static final String CommonID = "COMM";
    public static final String SoundDataID = "SSND";
    private static ContentDescriptor[] supportedFormat = new ContentDescriptor[]{new ContentDescriptor("audio.x_aiff")};
    public static final int CommonIDSize = 18;
    private boolean isAIFC = false;
    private boolean commonChunkSeen = false;
    private boolean soundDataChunkSeen = false;
    private boolean formatVersionChunkSeen = false;

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return supportedFormat;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.tracks[0] != null) {
            return this.tracks;
        }
        this.stream = (PullSourceStream)this.streams[0];
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(false);
        }
        this.readHeader();
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(true);
        }
        this.tracks[0] = new AiffTrack((AudioFormat)this.format, true, new Time(0L), this.numBuffers, this.bufferSize, this.minLocation, this.maxLocation);
        return this.tracks;
    }

    private void readHeader() throws IOException, BadHeaderException {
        int size;
        boolean signed = true;
        String magic = this.readString(this.stream);
        if (!magic.equals(FormID)) {
            throw new BadHeaderException("AIFF Parser: expected string FORM, got " + magic);
        }
        int fileLength = this.readInt(this.stream) + 8;
        String formType = this.readString(this.stream);
        if (formType.equals("AIFC")) {
            this.isAIFC = true;
        } else {
            this.encodingString = "LINEAR";
        }
        String compressionType = null;
        int offset = 0;
        int channels = -1;
        int sampleSizeInBits = -1;
        for (int remainingLength = fileLength - 12; remainingLength >= 8; remainingLength -= size) {
            String type = this.readString(this.stream);
            size = this.readInt(this.stream);
            remainingLength -= 8;
            if (type.equals(FormatVersionID)) {
                if (!this.isAIFC) {
                    // empty if block
                }
                int timestamp = this.readInt(this.stream);
                if (size != 4) {
                    throw new BadHeaderException("Illegal FormatVersionID: chunk size is not 4 but " + size);
                }
                this.formatVersionChunkSeen = true;
                continue;
            }
            if (type.equals(CommonID)) {
                if (size < 18) {
                    throw new BadHeaderException("Size of COMM chunk should be atleast 18");
                }
                channels = this.readShort(this.stream);
                if (channels < 1) {
                    throw new BadHeaderException("Number of channels is " + channels);
                }
                this.maxFrame = this.readInt(this.stream);
                sampleSizeInBits = this.readShort(this.stream);
                if (sampleSizeInBits <= 0) {
                    throw new BadHeaderException("Illegal sampleSize " + sampleSizeInBits);
                }
                this.sampleRate = this.readIeeeExtended(this.stream);
                if (this.sampleRate < 0.0) {
                    throw new BadHeaderException("Negative Sample Rate " + this.sampleRate);
                }
                int remainingCommSize = size - 18;
                if (this.isAIFC) {
                    if (remainingCommSize < 4) {
                        throw new BadHeaderException("COMM chunk in AIFC doesn't have compressionType info");
                    }
                    compressionType = this.readString(this.stream);
                    if (compressionType == null) {
                        throw new BadHeaderException("Compression type for AIFC is null");
                    }
                    this.skip(this.stream, remainingCommSize - 4);
                }
                this.commonChunkSeen = true;
                continue;
            }
            if (type.equals(SoundDataID)) {
                if (this.soundDataChunkSeen) {
                    throw new BadHeaderException("Cannot have more than 1 Sound Data Chunk");
                }
                offset = this.readInt(this.stream);
                this.blockSize = this.readInt(this.stream);
                this.minLocation = this.getLocation(this.stream);
                this.dataSize = size - 8;
                this.maxLocation = this.minLocation + (long)this.dataSize;
                this.soundDataChunkSeen = true;
                if (this.commonChunkSeen) {
                    remainingLength -= 8;
                    break;
                }
                this.skip(this.stream, size - 8);
                continue;
            }
            this.skip(this.stream, size);
        }
        if (!this.commonChunkSeen) {
            throw new BadHeaderException("Mandatory chunk COMM missing");
        }
        if (!this.soundDataChunkSeen) {
            throw new BadHeaderException("Mandatory chunk SSND missing");
        }
        double durationSeconds = -1.0;
        if (this.isAIFC) {
            String c2 = compressionType;
            if (c2.equalsIgnoreCase("NONE")) {
                this.encodingString = "LINEAR";
            } else if (c2.equalsIgnoreCase("twos")) {
                this.encodingString = "LINEAR";
            } else if (c2.equalsIgnoreCase("raw")) {
                this.encodingString = "LINEAR";
                signed = false;
            } else if (c2.equalsIgnoreCase("ULAW")) {
                this.encodingString = "ULAW";
                sampleSizeInBits = 8;
                signed = false;
            } else if (c2.equalsIgnoreCase("ALAW")) {
                this.encodingString = "alaw";
                sampleSizeInBits = 8;
                signed = false;
            } else if (c2.equalsIgnoreCase("G723")) {
                this.encodingString = "g723";
            } else if (c2.equalsIgnoreCase("MAC3")) {
                this.encodingString = "MAC3";
                this.blockSize = 2;
                this.samplesPerBlock = 6;
                this.timePerBlockNano = (double)this.samplesPerBlock * 1.0E9 / this.sampleRate;
            } else if (c2.equalsIgnoreCase("MAC6")) {
                this.encodingString = "MAC6";
                this.blockSize = 1;
                this.samplesPerBlock = 6;
                this.timePerBlockNano = (double)this.samplesPerBlock * 1.0E9 / this.sampleRate;
            } else if (c2.equalsIgnoreCase("IMA4")) {
                this.encodingString = "ima4";
                this.blockSize = 34 * channels;
                this.samplesPerBlock = 64;
                this.timePerBlockNano = (double)this.samplesPerBlock * 1.0E9 / this.sampleRate;
            } else {
                throw new BadHeaderException("Unsupported encoding" + c2);
            }
        }
        if (this.blockSize == 0) {
            this.blockSize = channels * sampleSizeInBits / 8;
        }
        this.bufferSize = this.blockSize * (int)(this.sampleRate / (double)this.samplesPerBlock);
        durationSeconds = (double)(this.maxFrame * this.samplesPerBlock) / this.sampleRate;
        if (durationSeconds > 0.0) {
            this.duration = new Time(durationSeconds);
        }
        this.locationToMediaTime = (double)this.samplesPerBlock / (this.sampleRate * (double)this.blockSize);
        this.format = new AudioFormat(this.encodingString, this.sampleRate, sampleSizeInBits, channels, 1, signed ? 1 : 0, this.blockSize * 8, -1.0, Format.byteArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time setPosition(Time where, int rounding) {
        long newPos;
        if (!this.seekable) {
            return this.getMediaTime();
        }
        long time = where.getNanoseconds();
        if (time < 0L) {
            time = 0L;
        }
        if (this.timePerBlockNano == -1.0) {
            int bytesPerSecond = (int)this.sampleRate * this.blockSize;
            double newPosd = (double)time * this.sampleRate * (double)this.blockSize / 1.0E9;
            double remainder = newPosd % (double)this.blockSize;
            newPos = (long)(newPosd - remainder);
            if (remainder > 0.0) {
                switch (rounding) {
                    case 1: {
                        newPos += (long)this.blockSize;
                        break;
                    }
                    case 3: {
                        if (!(remainder > (double)this.blockSize / 2.0)) break;
                        newPos += (long)this.blockSize;
                    }
                }
            }
        } else {
            double blockNum = (double)time / this.timePerBlockNano;
            int blockNumInt = (int)blockNum;
            double remainder = blockNum - (double)blockNumInt;
            if (remainder > 0.0) {
                switch (rounding) {
                    case 1: {
                        ++blockNumInt;
                        break;
                    }
                    case 3: {
                        if (!(remainder > 0.5)) break;
                        ++blockNumInt;
                    }
                }
            }
            newPos = blockNumInt * this.blockSize;
        }
        ((BasicTrack)this.tracks[0]).setSeekLocation(newPos += this.minLocation);
        if (this.cacheStream != null) {
            AiffParser aiffParser = this;
            synchronized (aiffParser) {
                this.cacheStream.abortRead();
            }
        }
        return where;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getMediaTime() {
        long seekLocation = ((BasicTrack)this.tracks[0]).getSeekLocation();
        long location = seekLocation != -1L ? seekLocation - this.minLocation : this.getLocation(this.stream) - this.minLocation;
        SettableTime settableTime = this.mediaTime;
        synchronized (settableTime) {
            this.mediaTime.set((double)location * this.locationToMediaTime);
        }
        return this.mediaTime;
    }

    public Time getDuration() {
        long mediaSizeAtEOM;
        if (this.maxFrame <= 0 && this.tracks[0] != null && (mediaSizeAtEOM = ((BasicTrack)this.tracks[0]).getMediaSizeAtEOM()) > 0L) {
            this.maxFrame = (int)(mediaSizeAtEOM / (long)this.blockSize);
            double durationSeconds = (double)(this.maxFrame * this.samplesPerBlock) / this.sampleRate;
            if (durationSeconds > 0.0) {
                this.duration = new Time(durationSeconds);
            }
        }
        return this.duration;
    }

    public String getName() {
        return "Parser for AIFF file format";
    }

    private double readIeeeExtended(PullSourceStream stream) throws IOException {
        double f2 = 0.0;
        int expon = 0;
        long hiMant = 0L;
        long loMant = 0L;
        double huge = 3.4028234663852886E38;
        expon = this.readShort(stream);
        hiMant = this.readInt(stream);
        if (hiMant < 0L) {
            hiMant += 0x100000000L;
        }
        if ((loMant = (long)this.readInt(stream)) < 0L) {
            loMant += 0x100000000L;
        }
        if (expon == 0 && hiMant == 0L && loMant == 0L) {
            f2 = 0.0;
        } else if (expon == Short.MAX_VALUE) {
            f2 = huge;
        } else {
            expon -= 16383;
            f2 = (double)hiMant * Math.pow(2.0, expon -= 31);
            f2 += (double)loMant * Math.pow(2.0, expon -= 32);
        }
        return f2;
    }

    class AiffTrack
    extends BasicTrack {
        private double sampleRate;
        private float timePerFrame;
        private SettableTime frameToTime;

        AiffTrack(AudioFormat format, boolean enabled, Time startTime, int numBuffers, int bufferSize, long minLocation, long maxLocation) {
            super(AiffParser.this, format, enabled, AiffParser.this.duration, startTime, numBuffers, bufferSize, AiffParser.this.stream, minLocation, maxLocation);
            this.frameToTime = new SettableTime();
            double sampleRate = format.getSampleRate();
            int channels = format.getChannels();
            int sampleSizeInBits = format.getSampleSizeInBits();
            if (AiffParser.this.timePerBlockNano == -1.0) {
                float bytesPerSecond = (float)(sampleRate * (double)AiffParser.this.blockSize);
                this.timePerFrame = (float)bufferSize / bytesPerSecond;
            } else {
                float blocksPerFrame = (float)bufferSize / (float)AiffParser.this.blockSize;
                float samplesPerFrame = blocksPerFrame * (float)AiffParser.this.samplesPerBlock;
                this.timePerFrame = (float)((double)samplesPerFrame / sampleRate);
            }
        }

        AiffTrack(AudioFormat format, boolean enabled, Time startTime, int numBuffers, int bufferSize) {
            this(format, enabled, startTime, numBuffers, bufferSize, 0L, Long.MAX_VALUE);
        }
    }
}

