/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.JMFI18N;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12ConnectionAction;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class BasicPullSourceStream
implements PullSourceStream,
Seekable {
    protected InputStream stream;
    protected long location;
    protected boolean eofReached;
    protected long contentLength;
    protected URL url;
    protected URLConnection urlC;
    private boolean needConnectPermission;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    public BasicPullSourceStream(URL url, InputStream stream, long contentLength, boolean needConnectPermission) throws IOException {
        this.needConnectPermission = needConnectPermission;
        if (stream != null) {
            this.stream = stream;
            this.contentLength = contentLength;
        } else {
            try {
                this.urlC = url.openConnection();
                this.contentLength = this.urlC.getContentLength();
                this.stream = this.urlC.getInputStream();
                if (this.stream == null) {
                    throw new IOException("Got null input stream from url connection");
                }
            }
            catch (IOException ie) {
                throw new IOException("error in connection");
            }
        }
        this.location = 0L;
        this.eofReached = false;
        this.url = url;
    }

    public ContentDescriptor getContentDescriptor() {
        return null;
    }

    public boolean endOfStream() {
        return this.eofReached;
    }

    public boolean willReadBlock() {
        try {
            return this.stream.available() == 0;
        }
        catch (IOException e2) {
            System.err.println("Exception PullSourceStream::willReadBlock " + e2.toString());
            return true;
        }
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int bytesRead;
        int len = length;
        int off = offset;
        do {
            if ((bytesRead = this.stream.read(buffer, off, len)) == -1) {
                this.eofReached = true;
                int totalBytesRead = length - len;
                return totalBytesRead > 0 ? totalBytesRead : -1;
            }
            this.location += (long)bytesRead;
            off += bytesRead;
        } while ((len -= bytesRead) != 0);
        return length;
    }

    public Object[] getControls() {
        Object[] objects = new Object[]{};
        return objects;
    }

    public Object getControl(String controlType) {
        return null;
    }

    public long seek(long where) {
        long oldLocation = this.location;
        this.location = where;
        try {
            if (where < oldLocation) {
                this.reopenStream();
                this.eofReached = false;
                return this.skip(this.stream, where);
            }
            return this.skip(this.stream, where - oldLocation);
        }
        catch (IOException e2) {
            return 0L;
        }
    }

    void reopenStream() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
            if (this.needConnectPermission && jmfSecurity != null) {
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                    }
                }
                catch (Throwable e2) {
                    securityPrivelege = false;
                    throw new IOException(JMFI18N.getResource("error.connectionerror") + e2.getMessage());
                }
            }
            this.urlC = this.url.openConnection();
            try {
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    Constructor cons = jdk12ConnectionAction.cons;
                    this.stream = (InputStream)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(this.urlC));
                } else {
                    this.stream = this.urlC.getInputStream();
                }
            }
            catch (Exception e3) {
                System.err.println("Unable to re-open a URL connection " + e3);
                throw new IOException(JMFI18N.getResource("error.connectionerror") + e3.getMessage());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public long tell() {
        return this.location;
    }

    public boolean isRandomAccess() {
        return true;
    }

    public void close() {
        try {
            this.stream.close();
            this.stream = null;
        }
        catch (Exception e2) {
            System.out.println("BasicPullSourceStream close - IOException");
        }
    }

    public long getContentLength() {
        return this.contentLength;
    }

    private long skip(InputStream istream, long amount) throws IOException {
        long actual;
        for (long remaining = amount; remaining > 0L; remaining -= actual) {
            actual = istream.skip(remaining);
        }
        return amount;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

