/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.BasicComp;
import com.sun.media.ui.PopupThread;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;

class GainSlider
extends Window
implements GainChangeListener,
MouseListener,
MouseMotionListener,
FocusListener {
    private GainControl gainControl;
    private Image imageGrabber = null;
    private Dimension dimGrabber = new Dimension();
    private Button buttonFocus;
    private boolean boolFocus = false;
    private boolean pressed = false;
    private PopupThread threadPopup = null;
    private Image imageBackground = null;
    private static final int WIDTH = 80;
    private static final int HEIGHT = 20;

    public GainSlider(GainControl gainControl) {
        this(gainControl, new Frame());
    }

    public GainSlider(GainControl gainControl, Frame frame) {
        super(frame);
        this.gainControl = gainControl;
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        this.gainControl = null;
    }

    public void addNotify() {
        super.addNotify();
        Insets insets = this.getInsets();
        this.setSize(80 + insets.left + insets.right, 20 + insets.top + insets.bottom);
    }

    private void init() throws Exception {
        this.gainControl.addGainChangeListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setLayout(null);
        this.imageBackground = BasicComp.fetchImage("texture3.gif");
        this.buttonFocus = new Button("Focus");
        this.buttonFocus.setBounds(-100, -100, 80, 24);
        this.add(this.buttonFocus);
        this.buttonFocus.addFocusListener(this);
        this.imageGrabber = BasicComp.fetchImage("grabber.gif");
        this.setBackground(Color.lightGray);
        this.setSize(80, 20);
    }

    public void setVisible(boolean boolVisible) {
        super.setVisible(boolVisible);
        if (boolVisible) {
            this.buttonFocus.requestFocus();
            if (this.threadPopup != null) {
                this.threadPopup.stopNormaly();
            }
            this.threadPopup = new PopupThread(this);
            this.threadPopup.resetCounter(3);
            this.threadPopup.start();
        } else if (this.threadPopup != null) {
            this.threadPopup.stopNormaly();
        }
    }

    public void update(Graphics g2) {
        Rectangle rectClient = this.getBounds();
        Image image = this.createImage(rectClient.width, rectClient.height);
        Graphics graphics = image != null ? image.getGraphics() : g2;
        this.paint(graphics);
        if (image != null) {
            g2.drawImage(image, 0, 0, this);
        }
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        Dimension dimSize = this.getSize();
        Insets insets = this.getInsets();
        Rectangle rect = new Rectangle(insets.left, insets.top, dimSize.width - insets.left - insets.right, dimSize.height - insets.top - insets.bottom);
        graphics.setColor(this.getBackground());
        graphics.draw3DRect(rect.x, rect.y, rect.width - 1, rect.height - 1, true);
        graphics.draw3DRect(rect.x + 4, rect.y + rect.height / 2 - 2, rect.width - 9, 3, false);
        if (this.dimGrabber.width < 1) {
            this.dimGrabber.width = this.imageGrabber.getWidth(this);
        }
        if (this.dimGrabber.height < 1) {
            this.dimGrabber.height = this.imageGrabber.getHeight(this);
        }
        float levelGain = this.gainControl.getLevel();
        int x = rect.x + (int)(2.0f + levelGain * (float)(rect.width - 5 - this.dimGrabber.width));
        int y = rect.y + (rect.height - this.dimGrabber.height) / 2;
        graphics.drawImage(this.imageGrabber, x, y, this);
    }

    private void paintBackground(Graphics graphics) {
        Dimension dimSize = this.getSize();
        if (this.imageBackground == null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimSize.width, dimSize.height);
        } else {
            Rectangle rectTile = new Rectangle(0, 0, this.imageBackground.getWidth(this), this.imageBackground.getHeight(this));
            Rectangle rectClip = graphics.getClipBounds();
            while (rectTile.y < dimSize.height) {
                while (rectTile.x < dimSize.width) {
                    if (rectClip == null || rectClip.intersects(rectTile)) {
                        graphics.drawImage(this.imageBackground, rectTile.x, rectTile.y, this);
                    }
                    rectTile.x += rectTile.width;
                }
                rectTile.x = 0;
                rectTile.y += rectTile.height;
            }
        }
    }

    public void gainChange(GainChangeEvent event) {
        this.repaint();
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (this.threadPopup != null) {
            this.threadPopup.resetCounter(3);
        }
        Point pointMouse = event.getPoint();
        this.setLevelToMouse(pointMouse);
        this.pressed = true;
    }

    public void mouseReleased(MouseEvent event) {
        this.pressed = false;
        if (!this.boolFocus) {
            this.setVisible(false);
        }
    }

    public void mouseEntered(MouseEvent event) {
        this.boolFocus = true;
        if (this.threadPopup != null) {
            this.threadPopup.stopNormaly();
        }
    }

    public void mouseExited(MouseEvent event) {
        if (this.boolFocus && !this.pressed) {
            this.setVisible(false);
        }
        this.boolFocus = false;
    }

    public void mouseDragged(MouseEvent event) {
        if (this.threadPopup != null) {
            this.threadPopup.resetCounter(3);
        }
        Point pointMouse = event.getPoint();
        this.setLevelToMouse(pointMouse);
    }

    public void mouseMoved(MouseEvent event) {
    }

    public void focusLost(FocusEvent event) {
    }

    public void focusGained(FocusEvent event) {
    }

    private void setLevelToMouse(Point pointMouse) {
        if (this.gainControl == null) {
            return;
        }
        Dimension dimSize = this.getSize();
        Insets insets = this.getInsets();
        int nPos = pointMouse.x - 2 - insets.left;
        int nWidth = dimSize.width - insets.left - insets.right - 5;
        if (nPos > nWidth) {
            nPos = nWidth;
        }
        if (nPos < 0) {
            nPos = 0;
        }
        float levelGain = (float)nPos / (float)nWidth;
        this.gainControl.setMute(false);
        this.gainControl.setLevel(levelGain);
    }
}

