/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.media.Control;
import javax.media.bean.playerbean.MediaPlayer;
import javax.media.control.MonitorControl;
import jmapps.ui.JMPanel;

public class VideoPanel
extends JMPanel
implements MouseListener,
ActionListener,
ComponentListener {
    private MediaPlayer mediaPlayer = null;
    private Component compVisual = null;
    private double dScale = 1.0;
    private PopupMenu menuZoom = null;
    private MenuItem menuItemZoom_1_2 = null;
    private MenuItem menuItemZoom_1_1 = null;
    private MenuItem menuItemZoom_2_1 = null;
    private MenuItem menuItemZoom_4_1 = null;
    public static final String MENU_ZOOM = JMFI18N.getResource("mediaplayer.menu.zoom");
    public static final String MENU_ZOOM_1_2 = JMFI18N.getResource("mediaplayer.zoom.1:2");
    public static final String MENU_ZOOM_1_1 = JMFI18N.getResource("mediaplayer.zoom.1:1");
    public static final String MENU_ZOOM_2_1 = JMFI18N.getResource("mediaplayer.zoom.2:1");
    public static final String MENU_ZOOM_4_1 = JMFI18N.getResource("mediaplayer.zoom.4:1");

    public VideoPanel(MediaPlayer mediaPlayer) {
        super(null);
        this.setBackground(Color.black);
        this.addComponentListener(this);
        this.createPopupMenuZoom();
        this.setMediaPlayer(mediaPlayer);
    }

    public void setMediaPlayer(MediaPlayer mediaPlayer) {
        this.removeAll();
        if (this.compVisual != null) {
            this.compVisual.removeMouseListener(this);
        }
        this.mediaPlayer = mediaPlayer;
        this.compVisual = mediaPlayer.getVisualComponent();
        if (this.compVisual == null) {
            MonitorControl mc = (MonitorControl)mediaPlayer.getControl("javax.media.control.MonitorControl");
            if (mc != null) {
                Panel mainPanel;
                Control[] controls = mediaPlayer.getControls();
                Panel currentPanel = mainPanel = new Panel(new BorderLayout());
                for (int i2 = 0; i2 < controls.length; ++i2) {
                    if (!(controls[i2] instanceof MonitorControl)) continue;
                    mc = (MonitorControl)controls[i2];
                    mc.setEnabled(true);
                    Component compControl = mc.getControlComponent();
                    if (compControl == null) continue;
                    currentPanel.add(compControl, "Center");
                    Panel newPanel = new Panel(new BorderLayout());
                    currentPanel.add((Component)newPanel, "South");
                    currentPanel = newPanel;
                }
                this.compVisual = mainPanel;
                this.add(mainPanel);
            }
        } else {
            this.add(mediaPlayer);
        }
        if (this.compVisual == null) {
            return;
        }
        this.resizeVisualComponent();
        this.addPopupMenuZoom();
    }

    public Component getMediaPlayer() {
        return this.mediaPlayer;
    }

    public Component getVisualComponent() {
        return this.mediaPlayer.getVisualComponent();
    }

    public void setZoom(double dScale) {
        this.dScale = dScale;
    }

    public double getZoom() {
        return this.dScale;
    }

    public Dimension getPreferredSize() {
        Dimension dim;
        if (this.compVisual == null || this.mediaPlayer == null) {
            dim = new Dimension(320, 0);
        } else {
            dim = this.compVisual.getPreferredSize();
            dim.width = (int)((double)dim.width * this.dScale);
            dim.height = (int)((double)dim.height * this.dScale);
        }
        return dim;
    }

    public void addMenuZoomActionListener(ActionListener listener) {
        if (this.menuItemZoom_1_2 != null) {
            this.menuItemZoom_1_2.addActionListener(listener);
        }
        if (this.menuItemZoom_1_1 != null) {
            this.menuItemZoom_1_1.addActionListener(listener);
        }
        if (this.menuItemZoom_2_1 != null) {
            this.menuItemZoom_2_1.addActionListener(listener);
        }
        if (this.menuItemZoom_4_1 != null) {
            this.menuItemZoom_4_1.addActionListener(listener);
        }
    }

    public void removeMenuZoomActionListener(ActionListener listener) {
        if (this.menuItemZoom_1_2 != null) {
            this.menuItemZoom_1_2.removeActionListener(listener);
        }
        if (this.menuItemZoom_1_1 != null) {
            this.menuItemZoom_1_1.removeActionListener(listener);
        }
        if (this.menuItemZoom_2_1 != null) {
            this.menuItemZoom_2_1.removeActionListener(listener);
        }
        if (this.menuItemZoom_4_1 != null) {
            this.menuItemZoom_4_1.removeActionListener(listener);
        }
    }

    private void createPopupMenuZoom() {
        if (this.menuZoom != null) {
            return;
        }
        this.menuZoom = new PopupMenu(MENU_ZOOM);
        this.menuItemZoom_1_2 = new MenuItem(MENU_ZOOM_1_2);
        this.menuZoom.add(this.menuItemZoom_1_2);
        this.menuItemZoom_1_2.addActionListener(this);
        this.menuItemZoom_1_1 = new MenuItem(MENU_ZOOM_1_1);
        this.menuZoom.add(this.menuItemZoom_1_1);
        this.menuItemZoom_1_1.addActionListener(this);
        this.menuItemZoom_2_1 = new MenuItem(MENU_ZOOM_2_1);
        this.menuZoom.add(this.menuItemZoom_2_1);
        this.menuItemZoom_2_1.addActionListener(this);
        this.menuItemZoom_4_1 = new MenuItem(MENU_ZOOM_4_1);
        this.menuZoom.add(this.menuItemZoom_4_1);
        this.menuItemZoom_4_1.addActionListener(this);
    }

    private void addPopupMenuZoom() {
        if (this.compVisual == null) {
            return;
        }
        this.createPopupMenuZoom();
        this.compVisual.add(this.menuZoom);
    }

    public void addNotify() {
        super.addNotify();
        if (this.compVisual != null) {
            this.compVisual.addMouseListener(this);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.compVisual != null) {
            this.compVisual.removeMouseListener(this);
        }
    }

    public void resizeVisualComponent() {
        Dimension dimThis = this.getSize();
        if (this.mediaPlayer != null && this.mediaPlayer.getParent() == this) {
            this.mediaPlayer.setBounds(0, 0, dimThis.width, dimThis.height);
        } else if (this.compVisual != null && this.compVisual.getParent() == this) {
            this.compVisual.setBounds(0, 0, dimThis.width, dimThis.height);
        }
        this.validate();
    }

    public void actionPerformed(ActionEvent event) {
        String strCmd = event.getActionCommand();
        if (strCmd.equals(MENU_ZOOM_1_2)) {
            this.dScale = 0.5;
        } else if (strCmd.equals(MENU_ZOOM_1_1)) {
            this.dScale = 1.0;
        } else if (strCmd.equals(MENU_ZOOM_2_1)) {
            this.dScale = 2.0;
        } else if (strCmd.equals(MENU_ZOOM_4_1)) {
            this.dScale = 4.0;
        }
        this.invalidate();
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.menuZoom.show(this.compVisual, event.getX(), event.getY());
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.menuZoom.show(this.compVisual, event.getX(), event.getY());
        }
    }

    public void mouseClicked(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.menuZoom.show(this.compVisual, event.getX(), event.getY());
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void componentResized(ComponentEvent event) {
        this.resizeVisualComponent();
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentShown(ComponentEvent event) {
    }

    public void componentHidden(ComponentEvent event) {
    }
}

