/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.awt.Cursor;
import java.awt.Graphics;

public class Line
extends Roi {
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    private int x1R = 0;
    private int y1R = 0;
    private int x2R;
    private int y2R;
    private static int lineWidth = 1;

    public Line(int ox1, int oy1, int ox2, int oy2) {
        this(ox1, oy1, null);
        this.grow(ox2, oy2);
        this.x1 = this.x + this.x1R;
        this.y1 = this.y + this.y1R;
        this.x2 = this.x + this.x2R;
        this.y2 = this.y + this.y2R;
        this.state = 3;
    }

    public Line(int ox, int oy, ImagePlus imp) {
        super(ox, oy, imp);
        this.type = 5;
    }

    public Line(int ox1, int oy1, int ox2, int oy2, ImagePlus imp) {
        this(ox1, oy1, ox2, oy2);
        this.setImage(imp);
    }

    protected void grow(int xend, int yend) {
        if (xend < 0) {
            xend = 0;
        }
        if (yend < 0) {
            yend = 0;
        }
        if (xend > this.xMax) {
            xend = this.xMax;
        }
        if (yend > this.yMax) {
            yend = this.yMax;
        }
        int xstart = this.x + this.x1R;
        int ystart = this.y + this.y1R;
        if (this.constrain) {
            int dy;
            int dx = Math.abs(xend - xstart);
            if (dx >= (dy = Math.abs(yend - ystart))) {
                yend = ystart;
            } else {
                xend = xstart;
            }
        }
        this.x = Math.min(this.x + this.x1R, xend);
        this.y = Math.min(this.y + this.y1R, yend);
        this.x1R = xstart - this.x;
        this.y1R = ystart - this.y;
        this.x2R = xend - this.x;
        this.y2R = yend - this.y;
        this.width = Math.abs(this.x2R - this.x1R);
        this.height = Math.abs(this.y2R - this.y1R);
        if (this.width < 1) {
            this.width = 1;
        }
        if (this.height < 1) {
            this.height = 1;
        }
        this.updateClipRect();
        if (this.imp != null) {
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    protected void moveHandle(int ox, int oy) {
        int dy;
        int dx;
        this.x1 = this.x + this.x1R;
        this.y1 = this.y + this.y1R;
        this.x2 = this.x + this.x2R;
        this.y2 = this.y + this.y2R;
        switch (this.activeHandle) {
            case 0: {
                this.x1 = ox;
                this.y1 = oy;
                break;
            }
            case 1: {
                this.x2 = ox;
                this.y2 = oy;
                break;
            }
            case 2: {
                dx = ox - (this.x1 + (this.x2 - this.x1) / 2);
                dy = oy - (this.y1 + (this.y2 - this.y1) / 2);
                this.x1 += dx;
                this.y1 += dy;
                this.x2 += dx;
                this.y2 += dy;
            }
        }
        if (this.constrain) {
            dx = Math.abs(this.x1 - this.x2);
            dy = Math.abs(this.y1 - this.y2);
            if (this.activeHandle == 0) {
                if (dx >= dy) {
                    this.y1 = this.y2;
                } else {
                    this.x1 = this.x2;
                }
            } else if (this.activeHandle == 1) {
                if (dx >= dy) {
                    this.y2 = this.y1;
                } else {
                    this.x2 = this.x1;
                }
            }
        }
        this.x = Math.min(this.x1, this.x2);
        this.y = Math.min(this.y1, this.y2);
        this.x1R = this.x1 - this.x;
        this.y1R = this.y1 - this.y;
        this.x2R = this.x2 - this.x;
        this.y2R = this.y2 - this.y;
        this.width = Math.abs(this.x2R - this.x1R);
        this.height = Math.abs(this.y2R - this.y1R);
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    protected void mouseDownInHandle(int handle, int sx, int sy) {
        this.state = 4;
        this.activeHandle = handle;
        this.ic.setCursor(new Cursor(1));
    }

    public void draw(Graphics g) {
        g.setColor(ROIColor);
        this.x1 = this.x + this.x1R;
        this.y1 = this.y + this.y1R;
        this.x2 = this.x + this.x2R;
        this.y2 = this.y + this.y2R;
        int sx1 = this.ic.screenX(this.x1);
        int sy1 = this.ic.screenY(this.y1);
        int sx2 = this.ic.screenX(this.x2);
        int sy2 = this.ic.screenY(this.y2);
        int sx3 = sx1 + (sx2 - sx1) / 2;
        int sy3 = sy1 + (sy2 - sy1) / 2;
        g.drawLine(sx1, sy1, sx2, sy2);
        if (this.state != 0) {
            int size2 = 2;
            if (this.ic != null) {
                this.mag = this.ic.getMagnification();
            }
            this.drawHandle(g, sx1 - size2, sy1 - size2);
            this.drawHandle(g, sx2 - size2, sy2 - size2);
            this.drawHandle(g, sx3 - size2, sy3 - size2);
        }
        IJ.showStatus(this.imp.getLocationAsString(this.x2, this.y2) + ", angle=" + IJ.d2s(this.getAngle(this.x1, this.y1, this.x2, this.y2)) + ", length=" + IJ.d2s(this.getLength()));
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    public double getLength() {
        Calibration cal = this.imp.getCalibration();
        return Math.sqrt((double)(this.x2 - this.x1) * cal.pixelWidth * (double)(this.x2 - this.x1) * cal.pixelWidth + (double)(this.y2 - this.y1) * cal.pixelHeight * (double)(this.y2 - this.y1) * cal.pixelHeight);
    }

    public double getRawLength() {
        return Math.sqrt((this.x2 - this.x1) * (this.x2 - this.x1) + (this.y2 - this.y1) * (this.y2 - this.y1));
    }

    public double[] getPixels() {
        ImageProcessor ip = this.imp.getProcessor();
        double[] line = ip.getLine(this.x1, this.y1, this.x2, this.y2);
        return line;
    }

    public void drawPixels() {
        ImageProcessor ip = this.imp.getProcessor();
        ip.moveTo(this.x1, this.y1);
        ip.lineTo(this.x2, this.y2);
        if (Line.getWidth() > 1) {
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int x, int y) {
        return false;
    }

    public int isHandle(int sx, int sy) {
        int size = 10;
        int halfSize = size / 2;
        int sx1 = this.ic.screenX(this.x + this.x1R) - halfSize;
        int sy1 = this.ic.screenY(this.y + this.y1R) - halfSize;
        int sx2 = this.ic.screenX(this.x + this.x2R) - halfSize;
        int sy2 = this.ic.screenY(this.y + this.y2R) - halfSize;
        int sx3 = sx1 + (sx2 - sx1) / 2 - 1;
        int sy3 = sy1 + (sy2 - sy1) / 2 - 1;
        if (sx >= sx1 && sx <= sx1 + size && sy >= sy1 && sy <= sy1 + size) {
            return 0;
        }
        if (sx >= sx2 && sx <= sx2 + size && sy >= sy2 && sy <= sy2 + size) {
            return 1;
        }
        if (sx >= sx3 && sx <= sx3 + size + 2 && sy >= sy3 && sy <= sy3 + size + 2) {
            return 2;
        }
        return -1;
    }

    public static int getWidth() {
        return lineWidth;
    }

    public static void setWidth(int w) {
        if (w < 1) {
            w = 1;
        }
        if (w > 99) {
            w = 99;
        }
        lineWidth = w;
    }

    public int getX() {
        return this.x1;
    }

    public void nudgeCorner(int key) {
        switch (key) {
            case 38: {
                --this.y2R;
                break;
            }
            case 40: {
                ++this.y2R;
                break;
            }
            case 37: {
                --this.x2R;
                break;
            }
            case 39: {
                ++this.x2R;
            }
        }
        this.grow(this.x + this.x2R, this.y + this.y2R);
    }
}

