/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class NewImage {
    public static final int GRAY8 = 0;
    public static final int GRAY16 = 1;
    public static final int GRAY32 = 2;
    public static final int RGB = 3;
    public static final int FILL_WHITE = 0;
    public static final int FILL_BLACK = 1;
    public static final int FILL_RAMP = 2;
    private static String name;
    private static int width;
    private static int height;
    private static int slices;
    private static int type;
    private static int fillWith;
    private static String[] typekeys;
    private static String[] fillkeys;
    private static String[] types;
    private static String[] fill;

    public NewImage() {
        this.openImage();
    }

    static void createStack(ImagePlus imp, ImageProcessor ip, int nSlices, int type) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        ImageStack stack = imp.createEmptyStack();
        int inc = nSlices / 40;
        if (inc < 1) {
            inc = 1;
        }
        try {
            stack.addSlice(null, ip);
            for (int i = 2; i <= nSlices; ++i) {
                if (i % inc == 0) {
                    IJ.showProgress(i, nSlices);
                }
                Object[] pixels2 = null;
                switch (type) {
                    case 0: {
                        pixels2 = new byte[width * height];
                        break;
                    }
                    case 1: {
                        pixels2 = new short[width * height];
                        break;
                    }
                    case 2: {
                        pixels2 = new float[width * height];
                        break;
                    }
                    case 3: {
                        pixels2 = new int[width * height];
                    }
                }
                System.arraycopy(ip.getPixels(), 0, pixels2, 0, width * height);
                stack.addSlice(null, pixels2);
            }
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory(imp.getTitle());
            stack.trim();
        }
        IJ.showProgress(nSlices, nSlices);
        if (stack.getSize() > 1) {
            imp.setStack(null, stack);
        }
    }

    static ImagePlus createImagePlus() {
        return new ImagePlus();
    }

    public static ImagePlus createByteImage(String title, int width, int height, int slices, int fill) {
        byte[] pixels = new byte[width * height];
        switch (fill) {
            case 0: {
                for (int i = 0; i < width * height; ++i) {
                    pixels[i] = -1;
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                byte[] ramp = new byte[width];
                for (int i = 0; i < width; ++i) {
                    ramp[i] = (byte)((double)i * 256.0 / (double)width + 0.5);
                }
                for (int y = 0; y < height; ++y) {
                    int offset = y * width;
                    for (int x = 0; x < width; ++x) {
                        pixels[offset++] = ramp[x];
                    }
                }
                break;
            }
        }
        ByteProcessor ip = new ByteProcessor(width, height, pixels, null);
        ImagePlus imp = NewImage.createImagePlus();
        imp.setProcessor(title, ip);
        if (slices > 1) {
            NewImage.createStack(imp, ip, slices, 0);
        }
        return imp;
    }

    public static ImagePlus createRGBImage(String title, int width, int height, int slices, int fill) {
        int[] pixels = new int[width * height];
        switch (fill) {
            case 0: {
                int i;
                for (i = 0; i < width * height; ++i) {
                    pixels[i] = -1;
                }
                break;
            }
            case 1: {
                int i;
                for (i = 0; i < width * height; ++i) {
                    pixels[i] = -16777216;
                }
                break;
            }
            case 2: {
                int[] ramp = new int[width];
                for (int i = 0; i < width; ++i) {
                    byte b;
                    byte g = b = (byte)((double)i * 256.0 / (double)width + 0.5);
                    byte r = b;
                    ramp[i] = 0xFF000000 | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
                }
                for (int y = 0; y < height; ++y) {
                    int offset = y * width;
                    for (int x = 0; x < width; ++x) {
                        pixels[offset++] = ramp[x];
                    }
                }
                break;
            }
        }
        ColorProcessor ip = new ColorProcessor(width, height, pixels);
        ImagePlus imp = NewImage.createImagePlus();
        imp.setProcessor(title, ip);
        if (slices > 1) {
            NewImage.createStack(imp, ip, slices, 3);
        }
        return imp;
    }

    public static ImagePlus createShortImage(String title, int width, int height, int slices, int fill) {
        short[] pixels = new short[width * height];
        switch (fill) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                short[] ramp = new short[width];
                for (int i = 0; i < width; ++i) {
                    ramp[i] = (short)((double)i * 65536.0 / (double)width + 0.5);
                }
                for (int y = 0; y < height; ++y) {
                    int offset = y * width;
                    for (int x = 0; x < width; ++x) {
                        pixels[offset++] = ramp[x];
                    }
                }
                break;
            }
        }
        ShortProcessor ip = new ShortProcessor(width, height, pixels, null);
        ImagePlus imp = NewImage.createImagePlus();
        imp.setProcessor(title, ip);
        if (slices > 1) {
            NewImage.createStack(imp, ip, slices, 1);
        }
        return imp;
    }

    public static ImagePlus createUnsignedShortImage(String title, int width, int height, int slices, int fill) {
        return NewImage.createShortImage(title, width, height, slices, fill);
    }

    public static ImagePlus createFloatImage(String title, int width, int height, int slices, int fill) {
        float[] pixels = new float[width * height];
        switch (fill) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                float[] ramp = new float[width];
                for (int i = 0; i < width; ++i) {
                    ramp[i] = (float)((double)i * 1.0 / (double)width);
                }
                for (int y = 0; y < height; ++y) {
                    int offset = y * width;
                    for (int x = 0; x < width; ++x) {
                        pixels[offset++] = ramp[x];
                    }
                }
                break;
            }
        }
        FloatProcessor ip = new FloatProcessor(width, height, pixels, null);
        ImagePlus imp = NewImage.createImagePlus();
        imp.setProcessor(title, ip);
        if (slices > 1) {
            NewImage.createStack(imp, ip, slices, 2);
        }
        return imp;
    }

    public static void open(String title, int width, int height, int nSlices, int type, int fill) {
        ImagePlus imp = null;
        switch (type) {
            case 0: {
                imp = NewImage.createByteImage(title, width, height, nSlices, fill);
                break;
            }
            case 1: {
                imp = NewImage.createShortImage(title, width, height, nSlices, fill);
                break;
            }
            case 2: {
                imp = NewImage.createFloatImage(title, width, height, nSlices, fill);
                break;
            }
            case 3: {
                imp = NewImage.createRGBImage(title, width, height, nSlices, fill);
            }
        }
        if (imp != null) {
            imp.show();
        }
    }

    void showClipboard() {
        ImagePlus clipboard = ImageWindow.getClipboard();
        if (clipboard != null) {
            clipboard.show();
        } else {
            IJ.error(IJ.getBundle().getString("EmptyClipErr"));
        }
    }

    boolean showDialog() {
        int i;
        GenericDialog gd = new GenericDialog(IJ.getBundle().getString("New"), IJ.getInstance());
        name = IJ.getBundle().getString("Untitled");
        gd.addStringField(IJ.getBundle().getString("Name") + ":", name, 12);
        types = new String[typekeys.length];
        for (i = 0; i < types.length; ++i) {
            NewImage.types[i] = IJ.getBundle().getString(typekeys[i]);
        }
        fill = new String[fillkeys.length];
        for (i = 0; i < fill.length; ++i) {
            NewImage.fill[i] = IJ.getColorBundle().getString(fillkeys[i]);
        }
        gd.addChoice(IJ.getBundle().getString("Type") + ":", types, types[type]);
        gd.addChoice(IJ.getBundle().getString("NewFill") + ":", fill, fill[fillWith]);
        gd.addNumericField(IJ.getBundle().getString("Width") + ":", width, 0, 5, IJ.getBundle().getString("Pixels"));
        gd.addNumericField(IJ.getBundle().getString("Height") + ":", height, 0, 5, IJ.getBundle().getString("Pixels"));
        gd.addNumericField(IJ.getBundle().getString("Slices") + ":", slices, 0, 5, "");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        name = gd.getNextString();
        String s = gd.getNextChoice();
        type = s.equals(IJ.getBundle().getString("8-bit")) ? 0 : (s.equals(IJ.getBundle().getString("16-bit")) ? 1 : (s.equals(IJ.getBundle().getString("RGBColor")) ? 3 : 2));
        fillWith = gd.getNextChoiceIndex();
        width = (int)gd.getNextNumber();
        height = (int)gd.getNextNumber();
        slices = (int)gd.getNextNumber();
        return true;
    }

    void openImage() {
        if (!this.showDialog()) {
            return;
        }
        if (fillWith > 2) {
            this.showClipboard();
            return;
        }
        try {
            NewImage.open(name, width, height, slices, type, fillWith);
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory(name);
        }
    }

    static {
        width = 400;
        height = 400;
        slices = 1;
        type = 0;
        fillWith = 0;
        typekeys = new String[]{"8-bit", "16-bit", "32-bit", "RGBColor"};
        fillkeys = new String[]{"WhiteColor", "BlackColor", "Ramp", "Clipboard"};
    }
}

