/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImageJ;
import ij.Macro;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.frame.Recorder;
import java.awt.FileDialog;
import java.awt.Frame;

public class SaveDialog {
    private String dir;
    private String name;
    private String title;

    public SaveDialog(String title, String defaultName, String extension) {
        String defaultDir;
        ImageJ ij;
        String macroOptions = Macro.getOptions();
        this.title = title;
        if (macroOptions != null) {
            String path = Macro.getValue(macroOptions, title, null);
            if (path == null) {
                path = Macro.getValue(macroOptions, "path", null);
            }
            if (path != null) {
                Opener o = new Opener();
                this.dir = o.getDir(path);
                this.name = o.getName(path);
                return;
            }
        }
        Frame parent = (ij = IJ.getInstance()) != null ? ij : new Frame();
        FileDialog fd = new FileDialog(parent, title, 1);
        if (defaultName != null) {
            if (defaultName != null) {
                int dotIndex = defaultName.lastIndexOf(".");
                defaultName = dotIndex >= 0 ? defaultName.substring(0, dotIndex) + extension : defaultName + extension;
            }
            fd.setFile(defaultName);
        }
        if ((defaultDir = OpenDialog.getDefaultDirectory()) != null) {
            fd.setDirectory(defaultDir);
        }
        fd.show();
        this.name = fd.getFile();
        this.dir = fd.getDirectory();
        if (this.name == null) {
            Macro.abort();
        }
        if (this.name != null && this.dir != null) {
            OpenDialog.setDefaultDirectory(this.dir);
        }
        fd.dispose();
        if (ij == null) {
            parent.dispose();
        }
        IJ.showStatus(title + ": " + this.dir + this.name);
    }

    public String getDirectory() {
        return this.dir;
    }

    public String getFileName() {
        if (Recorder.record) {
            Recorder.recordPath(this.title, this.dir + this.name);
        }
        return this.name;
    }
}

