/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class ThreadLocalCoders {
    private static final int CACHE_SIZE = 3;
    private static Cache decoderCache = new Cache(3){

        boolean hasName(Object object, Object object2) {
            if (object2 instanceof String) {
                return ((CharsetDecoder)object).charset().name().equals(object2);
            }
            if (object2 instanceof Charset) {
                return ((CharsetDecoder)object).charset().equals(object2);
            }
            return false;
        }

        Object create(Object object) {
            if (object instanceof String) {
                return Charset.forName((String)object).newDecoder();
            }
            if (object instanceof Charset) {
                return ((Charset)object).newDecoder();
            }
            assert (false);
            return null;
        }
    };
    private static Cache encoderCache = new Cache(3){

        boolean hasName(Object object, Object object2) {
            if (object2 instanceof String) {
                return ((CharsetEncoder)object).charset().name().equals(object2);
            }
            if (object2 instanceof Charset) {
                return ((CharsetEncoder)object).charset().equals(object2);
            }
            return false;
        }

        Object create(Object object) {
            if (object instanceof String) {
                return Charset.forName((String)object).newEncoder();
            }
            if (object instanceof Charset) {
                return ((Charset)object).newEncoder();
            }
            assert (false);
            return null;
        }
    };

    public static CharsetDecoder decoderFor(Object object) {
        CharsetDecoder charsetDecoder = (CharsetDecoder)decoderCache.forName(object);
        charsetDecoder.reset();
        return charsetDecoder;
    }

    public static CharsetEncoder encoderFor(Object object) {
        CharsetEncoder charsetEncoder = (CharsetEncoder)encoderCache.forName(object);
        charsetEncoder.reset();
        return charsetEncoder;
    }

    private static abstract class Cache {
        private ThreadLocal cache = new ThreadLocal();
        private final int size;

        Cache(int n2) {
            this.size = n2;
        }

        abstract Object create(Object var1);

        private void moveToFront(Object[] objectArray, int n2) {
            Object object = objectArray[n2];
            for (int i2 = n2; i2 > 0; --i2) {
                objectArray[i2] = objectArray[i2 - 1];
            }
            objectArray[0] = object;
        }

        abstract boolean hasName(Object var1, Object var2);

        Object forName(Object object) {
            Object object2;
            Object[] objectArray = (Object[])this.cache.get();
            if (objectArray == null) {
                objectArray = new Object[this.size];
                this.cache.set(objectArray);
            } else {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    Object object3 = objectArray[i2];
                    if (object3 == null || !this.hasName(object3, object)) continue;
                    if (i2 > 0) {
                        this.moveToFront(objectArray, i2);
                    }
                    return object3;
                }
            }
            objectArray[objectArray.length - 1] = object2 = this.create(object);
            this.moveToFront(objectArray, objectArray.length - 1);
            return object2;
        }
    }
}

