/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.LinkOutputImpl;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.doclets.internal.toolkit.util.links.LinkFactory;
import com.sun.tools.doclets.internal.toolkit.util.links.LinkInfo;
import com.sun.tools.doclets.internal.toolkit.util.links.LinkOutput;

public class LinkFactoryImpl
extends LinkFactory {
    private HtmlDocletWriter m_writer;

    public LinkFactoryImpl(HtmlDocletWriter htmlDocletWriter) {
        this.m_writer = htmlDocletWriter;
    }

    protected LinkOutput getOutputInstance() {
        return new LinkOutputImpl();
    }

    protected LinkOutput getClassLink(LinkInfo linkInfo) {
        LinkInfoImpl linkInfoImpl = (LinkInfoImpl)linkInfo;
        boolean bl = linkInfo.label == null || linkInfo.label.length() == 0;
        ClassDoc classDoc = linkInfoImpl.classDoc;
        String string = linkInfoImpl.where == null || linkInfoImpl.where.length() == 0 ? this.getClassToolTip(classDoc, linkInfoImpl.type != null && !classDoc.qualifiedTypeName().equals(linkInfoImpl.type.qualifiedTypeName())) : "";
        StringBuffer stringBuffer = new StringBuffer(linkInfoImpl.getClassLinkLabel(this.m_writer.configuration));
        linkInfoImpl.displayLength += stringBuffer.length();
        if (bl && linkInfoImpl.excludeTypeParameterLinks) {
            stringBuffer.append(this.getTypeParameterLinks(linkInfo).toString());
        }
        ConfigurationImpl configurationImpl = ConfigurationImpl.getInstance();
        LinkOutputImpl linkOutputImpl = new LinkOutputImpl();
        if (classDoc.isIncluded()) {
            if (configurationImpl.isGeneratedDoc(classDoc)) {
                String string2 = this.pathString(linkInfoImpl);
                linkOutputImpl.append(this.m_writer.getHyperLink(string2, linkInfoImpl.where, stringBuffer.toString(), linkInfoImpl.isBold, linkInfoImpl.styleName, string, linkInfoImpl.target));
                if (bl && !linkInfoImpl.excludeTypeParameterLinks) {
                    linkOutputImpl.append(this.getTypeParameterLinks(linkInfo).toString());
                }
                return linkOutputImpl;
            }
        } else {
            String string3 = this.m_writer.getCrossClassLink(classDoc.qualifiedName(), linkInfoImpl.where, stringBuffer.toString(), linkInfoImpl.isBold, linkInfoImpl.styleName, true);
            if (string3 != null) {
                linkOutputImpl.append(string3);
                if (bl && !linkInfoImpl.excludeTypeParameterLinks) {
                    linkOutputImpl.append(this.getTypeParameterLinks(linkInfo).toString());
                }
                return linkOutputImpl;
            }
        }
        linkOutputImpl.append(stringBuffer.toString());
        if (bl && !linkInfoImpl.excludeTypeParameterLinks) {
            linkOutputImpl.append(this.getTypeParameterLinks(linkInfo).toString());
        }
        return linkOutputImpl;
    }

    protected LinkOutput getTypeParameterLink(LinkInfo linkInfo, Type type) {
        LinkInfoImpl linkInfoImpl = new LinkInfoImpl(linkInfo.getContext(), type);
        linkInfoImpl.excludeTypeBounds = linkInfo.excludeTypeBounds;
        linkInfoImpl.excludeTypeParameterLinks = linkInfo.excludeTypeParameterLinks;
        LinkOutput linkOutput = this.getLinkOutput(linkInfoImpl);
        ((LinkInfoImpl)linkInfo).displayLength += linkInfoImpl.displayLength;
        return linkOutput;
    }

    private String getClassToolTip(ClassDoc classDoc, boolean bl) {
        ConfigurationImpl configurationImpl = ConfigurationImpl.getInstance();
        if (bl) {
            return configurationImpl.getText("doclet.Href_Type_Param_Title", classDoc.name());
        }
        if (classDoc.isInterface()) {
            return configurationImpl.getText("doclet.Href_Interface_Title", Util.getPackageName(classDoc.containingPackage()));
        }
        if (classDoc.isAnnotationType()) {
            return configurationImpl.getText("doclet.Href_Annotation_Title", Util.getPackageName(classDoc.containingPackage()));
        }
        if (classDoc.isEnum()) {
            return configurationImpl.getText("doclet.Href_Enum_Title", Util.getPackageName(classDoc.containingPackage()));
        }
        return configurationImpl.getText("doclet.Href_Class_Title", Util.getPackageName(classDoc.containingPackage()));
    }

    private String pathString(LinkInfoImpl linkInfoImpl) {
        if (linkInfoImpl.context == 13) {
            return linkInfoImpl.classDoc.name() + ".html";
        }
        StringBuffer stringBuffer = new StringBuffer(this.m_writer.relativePath);
        stringBuffer.append(DirectoryManager.getPathToPackage(linkInfoImpl.classDoc.containingPackage(), linkInfoImpl.classDoc.name() + ".html"));
        return stringBuffer.toString();
    }
}

