/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Type;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.MemberDocImpl;
import com.sun.tools.javadoc.SourcePositionImpl;
import com.sun.tools.javadoc.TypeMaker;
import java.lang.reflect.Modifier;

public class FieldDocImpl
extends MemberDocImpl
implements FieldDoc {
    protected final Symbol.VarSymbol sym;

    public FieldDocImpl(DocEnv docEnv, Symbol.VarSymbol varSymbol, String string, Tree.VarDef varDef) {
        super(docEnv, varSymbol, string, varDef);
        this.sym = varSymbol;
    }

    public FieldDocImpl(DocEnv docEnv, Symbol.VarSymbol varSymbol) {
        this(docEnv, varSymbol, null, null);
    }

    protected long getFlags() {
        return this.sym.flags();
    }

    protected Symbol.ClassSymbol getContainingClass() {
        return this.sym.enclClass();
    }

    public Type type() {
        return TypeMaker.getType(this.env, this.sym.type, false);
    }

    public Object constantValue() {
        Object object;
        if (this.sym.constValue != null) {
            this.env.attr.evalInit(this.sym);
        }
        if ((object = this.sym.constValue) != null && this.sym.type.tag == 8) {
            object = (Integer)object != 0;
        }
        return object;
    }

    public String constantValueExpression() {
        return FieldDocImpl.constantValueExpression(this.constantValue());
    }

    static String constantValueExpression(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Character) {
            return FieldDocImpl.sourceForm(((Character)object).charValue());
        }
        if (object instanceof Byte) {
            return FieldDocImpl.sourceForm((Byte)object);
        }
        if (object instanceof String) {
            return FieldDocImpl.sourceForm((String)object);
        }
        if (object instanceof Double) {
            return FieldDocImpl.sourceForm((Double)object, 'd');
        }
        if (object instanceof Float) {
            return FieldDocImpl.sourceForm(((Float)object).doubleValue(), 'f');
        }
        if (object instanceof Long) {
            return object + "L";
        }
        return object.toString();
    }

    private static String sourceForm(double d, char c) {
        if (Double.isNaN(d)) {
            return "0" + c + "/0" + c;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "1" + c + "/0" + c;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-1" + c + "/0" + c;
        }
        return d + (c == 'f' || c == 'F' ? "" + c : "");
    }

    private static String sourceForm(char c) {
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append('\'');
        FieldDocImpl.sourceChar(c, stringBuffer);
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    private static String sourceForm(byte by) {
        return "0x" + Integer.toString(by & 0xFF, 16);
    }

    private static String sourceForm(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 5);
        stringBuffer.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            FieldDocImpl.sourceChar(c, stringBuffer);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private static void sourceChar(char c, StringBuffer stringBuffer) {
        switch (c) {
            case '\b': {
                stringBuffer.append("\\b");
                return;
            }
            case '\t': {
                stringBuffer.append("\\t");
                return;
            }
            case '\n': {
                stringBuffer.append("\\n");
                return;
            }
            case '\f': {
                stringBuffer.append("\\f");
                return;
            }
            case '\r': {
                stringBuffer.append("\\r");
                return;
            }
            case '\"': {
                stringBuffer.append("\\\"");
                return;
            }
            case '\'': {
                stringBuffer.append("\\'");
                return;
            }
            case '\\': {
                stringBuffer.append("\\\\");
                return;
            }
        }
        if (FieldDocImpl.isPrintableAscii(c)) {
            stringBuffer.append(c);
            return;
        }
        FieldDocImpl.unicodeEscape(c, stringBuffer);
    }

    private static void unicodeEscape(char c, StringBuffer stringBuffer) {
        stringBuffer.append("\\u");
        stringBuffer.append("0123456789abcdef".charAt(0xF & c >> 12));
        stringBuffer.append("0123456789abcdef".charAt(0xF & c >> 8));
        stringBuffer.append("0123456789abcdef".charAt(0xF & c >> 4));
        stringBuffer.append("0123456789abcdef".charAt(0xF & c >> 0));
    }

    private static boolean isPrintableAscii(char c) {
        return c >= ' ' && c <= '~';
    }

    public boolean isIncluded() {
        return this.containingClass().isIncluded() && this.env.shouldDocument(this.sym);
    }

    public boolean isField() {
        return !this.isEnumConstant();
    }

    public boolean isEnumConstant() {
        return (this.getFlags() & 0x4000L) != 0L && !this.env.legacyDoclet;
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.getModifiers());
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.getModifiers());
    }

    public boolean isSynthetic() {
        return (this.getFlags() & 0x1000L) != 0L;
    }

    public SerialFieldTag[] serialFieldTags() {
        return this.comment().serialFieldTags();
    }

    public String name() {
        return this.sym.name.toString();
    }

    public String qualifiedName() {
        return this.sym.enclClass().fullName() + "." + this.name();
    }

    public SourcePosition position() {
        if (this.sym.enclClass().sourcefile == null) {
            return null;
        }
        return SourcePositionImpl.make(this.sym.enclClass().sourcefile.toString(), this.tree == null ? 0 : this.tree.pos);
    }
}

