/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.AssociationService;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.DialogFactory;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.WinRegistry;
import com.sun.javaws.Globals;
import com.sun.javaws.IcoEncoder;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.NativeLibrary;
import com.sun.javaws.WinBrowserSupport;
import com.sun.javaws.cache.Cache;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;

public class WinInstallHandler
extends LocalInstallHandler {
    private static final String INSTALLED_DESKTOP_SHORTCUT_KEY = "windows.installedDesktopShortcut";
    private static final String INSTALLED_START_MENU_KEY = "windows.installedStartMenuShortcut";
    private static final String UNINSTALLED_START_MENU_KEY = "windows.uninstalledStartMenuShortcut";
    private static final String RCONTENT_START_MENU_KEY = "windows.RContent.shortcuts";
    public static final int TYPE_DESKTOP = 1;
    public static final int TYPE_START_MENU = 2;
    private static final String REG_SHORTCUT_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
    private static final String REG_DESKTOP_PATH_KEY = "Desktop";
    private static final String REG_START_MENU_PATH_KEY = "Programs";
    private static final String SHORTCUT_EXTENSION = ".lnk";
    private static final int MAX_PATH = 200;
    private boolean _loadedPaths = false;
    private String _desktopPath;
    private String _startMenuPath;
    private static boolean useSystem;

    public String getDefaultIconPath() {
        return Config.getInstance().getSystemJavawsPath();
    }

    public String getAssociationOpenCommand(String string) {
        return "\"" + Config.getJavawsCommand() + "\"" + " \"-open\" \"%1\" " + "\"" + string + "\"";
    }

    public String getAssociationPrintCommand(String string) {
        return "\"" + Config.getJavawsCommand() + "\"" + " \"-print\" \"%1\" " + "\"" + string + "\"";
    }

    public void registerAssociationInternal(Association association) throws AssociationAlreadyRegisteredException, RegisterFailedException {
        AssociationService associationService = new AssociationService();
        if (Globals.isSystemCache() || useSystem) {
            associationService.registerSystemAssociation(association);
        } else {
            associationService.registerUserAssociation(association);
        }
    }

    public void unregisterAssociationInternal(Association association) throws AssociationNotRegisteredException, RegisterFailedException {
        AssociationService associationService = new AssociationService();
        if (Globals.isSystemCache() || useSystem) {
            associationService.unregisterSystemAssociation(association);
        } else {
            associationService.unregisterUserAssociation(association);
        }
    }

    public boolean isLocalInstallSupported() {
        return true;
    }

    public boolean isAssociationSupported() {
        return true;
    }

    public void associationCompleted() {
    }

    public void uninstall(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl) {
        String string;
        if (localApplicationProperties == null) {
            Trace.println((String)"No LAP for uninstall, bailing!", (TraceLevel)TraceLevel.TEMP);
            return;
        }
        String string2 = null;
        boolean bl2 = false;
        String string3 = localApplicationProperties.get(INSTALLED_START_MENU_KEY);
        if (string3 != null) {
            if (!this.uninstallShortcut(string3)) {
                bl2 = true;
            } else {
                localApplicationProperties.put(INSTALLED_START_MENU_KEY, null);
            }
            string2 = string3;
        }
        if ((string3 = localApplicationProperties.get(UNINSTALLED_START_MENU_KEY)) != null) {
            if (!this.uninstallShortcut(string3)) {
                bl2 = true;
            } else {
                localApplicationProperties.put(UNINSTALLED_START_MENU_KEY, null);
            }
            string2 = string3;
        }
        if ((string = localApplicationProperties.get(RCONTENT_START_MENU_KEY)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreElements()) {
                string3 = stringTokenizer.nextToken();
                if (string3 == null) continue;
                if (!this.uninstallShortcut(string3)) {
                    bl2 = true;
                }
                string2 = string3;
            }
            localApplicationProperties.put(RCONTENT_START_MENU_KEY, null);
        }
        if (string2 != null) {
            this.checkEmpty(string2);
        }
        if (bl && (string3 = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_KEY)) != null) {
            if (!this.uninstallShortcut(string3)) {
                bl2 = true;
            } else {
                localApplicationProperties.put(INSTALLED_DESKTOP_SHORTCUT_KEY, null);
            }
        }
        if (bl2) {
            Trace.println((String)"uninstall shortcut failed", (TraceLevel)TraceLevel.TEMP);
        }
        localApplicationProperties.setLocallyInstalled(false);
        WinInstallHandler.save(localApplicationProperties);
    }

    private void checkEmpty(String string) {
        try {
            File file = new File(string).getParentFile();
            if (file != null && file.isDirectory() && file.list().length == 0) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean hasValidTitle(LaunchDesc launchDesc) {
        if (launchDesc == null) {
            return false;
        }
        InformationDesc informationDesc = launchDesc.getInformation();
        if (informationDesc == null || informationDesc.getTitle().trim() == null) {
            Trace.println((String)"Invalid: No title!", (TraceLevel)TraceLevel.TEMP);
            return false;
        }
        return true;
    }

    public void install(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        boolean bl;
        boolean bl2;
        if (!this.hasValidTitle(launchDesc)) {
            return;
        }
        if (this.isApplicationInstalled(launchDesc) && !WinInstallHandler.shouldInstallOverExisting(launchDesc)) {
            return;
        }
        String string = null;
        try {
            string = Cache.getCachedLaunchedFile(launchDesc.getCanonicalHome()).getAbsolutePath();
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
        }
        if (string == null) {
            this.installFailed(launchDesc);
            return;
        }
        ShortcutDesc shortcutDesc = launchDesc.getInformation().getShortcut();
        boolean bl3 = bl2 = shortcutDesc == null ? true : shortcutDesc.getDesktop();
        if (bl2 && !this.handleInstall(launchDesc, localApplicationProperties, string, 1)) {
            this.installFailed(launchDesc);
            return;
        }
        boolean bl4 = bl = shortcutDesc == null ? true : shortcutDesc.getMenu();
        if (bl && !this.handleInstall(launchDesc, localApplicationProperties, string, 2)) {
            this.uninstall(launchDesc, localApplicationProperties, bl2);
            this.installFailed(launchDesc);
            return;
        }
        if (bl || bl2) {
            localApplicationProperties.setLocallyInstalled(true);
            WinInstallHandler.save(localApplicationProperties);
        }
    }

    private void installFailed(final LaunchDesc launchDesc) {
        Runnable runnable = new Runnable(){

            public void run() {
                DialogFactory.showErrorDialog((String)ResourceManager.getString((String)"install.installFailed", (String)WinInstallHandler.this.getInstallName(launchDesc)), (String)ResourceManager.getString((String)"install.installFailedTitle"));
            }
        };
        WinInstallHandler.invokeRunnable(runnable);
    }

    private void uninstallFailed(final LaunchDesc launchDesc) {
        Runnable runnable = new Runnable(){

            public void run() {
                DialogFactory.showErrorDialog((String)ResourceManager.getString((String)"install.uninstallFailed", (String)WinInstallHandler.this.getInstallName(launchDesc)), (String)ResourceManager.getString((String)"install.uninstallFailedTitle"));
            }
        };
        WinInstallHandler.invokeRunnable(runnable);
    }

    private boolean handleInstall(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, String string, int n) {
        InformationDesc informationDesc = launchDesc.getInformation();
        ShortcutDesc shortcutDesc = informationDesc.getShortcut();
        String string2 = null;
        String string3 = null;
        String string4 = IcoEncoder.getIconPath(launchDesc);
        String string5 = Config.getInstance().getSystemJavawsPath();
        String string6 = informationDesc.getDescription(1);
        boolean bl = true;
        if (string4 == null) {
            string4 = this.getDefaultIconPath();
        }
        boolean bl2 = !informationDesc.supportsOfflineOperation() || shortcutDesc == null || shortcutDesc.getOnline();
        String string7 = bl2 ? "" : "-offline ";
        String string8 = string7 + "\"" + string + "\"";
        int n2 = 0;
        if (n == 1) {
            string2 = this.getDesktopPath(launchDesc);
            n2 = this.installWrapper(string2, string3 = this.getDesktopName(launchDesc), string6, string5, string8, null, string4);
            if (n2 == 0) {
                localApplicationProperties.put(INSTALLED_DESKTOP_SHORTCUT_KEY, string2);
                Trace.println((String)("Installed desktop shortcut for: " + string3 + "."), (TraceLevel)TraceLevel.TEMP);
            } else {
                bl = false;
                Trace.println((String)("Installed desktop shortcut for: " + string3 + " failed (" + n2 + ")!!!"), (TraceLevel)TraceLevel.TEMP);
            }
        } else {
            File file = new File(this.getSubMenuPath(launchDesc));
            if (file.exists() || file.mkdirs()) {
                string2 = this.getStartMenuPath(launchDesc);
                n2 = this.installWrapper(string2, string3 = this.getStartMenuName(launchDesc), string6, string5, string8, null, string4);
                if (n2 == 0) {
                    localApplicationProperties.put(INSTALLED_START_MENU_KEY, string2);
                    Trace.println((String)("Installed menu shortcut for: " + string3 + "."), (TraceLevel)TraceLevel.TEMP);
                } else {
                    bl = false;
                    Trace.println((String)("Installed menu shortcut for: " + string3 + " failed (" + n2 + ")!!!"), (TraceLevel)TraceLevel.TEMP);
                }
                String string9 = this.getSubMenuDir(launchDesc);
                if ((string9 == null || !string9.equals("Startup")) && this.addUninstallShortcut()) {
                    string8 = "-uninstall \"" + string + "\"";
                    string2 = this.getUninstallPath(launchDesc);
                    n2 = this.installWrapper(string2, string3 = ResourceManager.getString((String)"install.startMenuUninstallShortcutName", (String)string3), string6, string5, string8, null, string4);
                    if (n2 == 0) {
                        localApplicationProperties.put(UNINSTALLED_START_MENU_KEY, string2);
                        Trace.println((String)("Installed menu shortcut for: " + string3 + "."), (TraceLevel)TraceLevel.TEMP);
                    } else {
                        bl = false;
                        Trace.println((String)("Installed menu shortcut for: " + string3 + " failed (" + n2 + ")!!!"), (TraceLevel)TraceLevel.TEMP);
                    }
                }
                RContentDesc[] rContentDescArray = informationDesc.getRelatedContent();
                StringBuffer stringBuffer = new StringBuffer(200 * rContentDescArray.length);
                if (rContentDescArray != null) {
                    for (int i = 0; i < rContentDescArray.length; ++i) {
                        string3 = rContentDescArray[i].getTitle().trim();
                        if (string3 == null || string3.length() == 0) {
                            string3 = this.getStartMenuName(launchDesc) + " #" + i;
                        }
                        string3 = this.getName(string3);
                        URL uRL = rContentDescArray[i].getHref();
                        if (uRL.toString().endsWith("jnlp")) continue;
                        string6 = rContentDescArray[i].getDescription();
                        URL uRL2 = rContentDescArray[i].getIcon();
                        String string10 = null;
                        if (uRL2 != null) {
                            string10 = IcoEncoder.getIconPath(uRL2, null);
                        }
                        if (string10 == null) {
                            string10 = string4;
                        }
                        string2 = this.getRCPath(launchDesc, string3);
                        File file2 = Cache.getCachedFile(uRL);
                        string5 = new WinBrowserSupport().getDefaultHandler(uRL);
                        if (file2 != null) {
                            string8 = "\"file:" + file2.getAbsolutePath() + "\"";
                            n2 = this.installWrapper(string2, string3, string6, string5, string8, null, string10);
                            if (n2 == 0) {
                                stringBuffer.append(string2);
                                stringBuffer.append(File.pathSeparator);
                                Trace.println((String)("Installed menu shortcut for: " + string3 + "."), (TraceLevel)TraceLevel.TEMP);
                                continue;
                            }
                            bl = false;
                            Trace.println((String)("Installed menu shortcut for: " + string3 + " failed (" + n2 + ")!!!"), (TraceLevel)TraceLevel.TEMP);
                            continue;
                        }
                        string8 = uRL.toString();
                        n2 = this.installWrapper(string2, string3, string6, string5, string8, null, string10);
                        if (n2 == 0) {
                            stringBuffer.append(string2);
                            stringBuffer.append(File.pathSeparator);
                            Trace.println((String)("Installed menu shortcut for: " + string3 + "."), (TraceLevel)TraceLevel.TEMP);
                            continue;
                        }
                        bl = false;
                        Trace.println((String)("Installed menu shortcut for: " + string3 + " failed (" + n2 + ")!!!"), (TraceLevel)TraceLevel.TEMP);
                    }
                }
                if (stringBuffer.length() > 0) {
                    localApplicationProperties.put(RCONTENT_START_MENU_KEY, stringBuffer.toString());
                } else {
                    localApplicationProperties.put(RCONTENT_START_MENU_KEY, null);
                }
            } else {
                bl = false;
                Trace.println((String)("Installed menu shortcut for: " + string3 + " failed (can't create directory \"" + file.getAbsolutePath() + "\")!!!"), (TraceLevel)TraceLevel.TEMP);
            }
        }
        return bl;
    }

    private boolean isApplicationInstalled(LaunchDesc launchDesc) {
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        string = this.getDesktopPath(launchDesc);
        Trace.println((String)("getDesktopPath(" + string + ").exists() = " + (string == null ? "N/A" : "" + new File(string).exists())), (TraceLevel)TraceLevel.TEMP);
        bl = string == null ? true : new File(string).exists();
        string = this.getStartMenuPath(launchDesc);
        Trace.println((String)("startMenuInstalled(" + string + ").exists() = " + (string == null ? "N/A" : "" + new File(string).exists())), (TraceLevel)TraceLevel.TEMP);
        bl2 = string == null ? true : new File(string).exists();
        return bl && bl2;
    }

    private String getInstallName(LaunchDesc launchDesc) {
        String string = launchDesc.getInformation().getTitle().trim();
        return this.getName(string);
    }

    private String getName(String string) {
        if (string.length() > 32) {
            string = string.substring(0, 32);
        }
        return string;
    }

    private String getDesktopName(LaunchDesc launchDesc) {
        return ResourceManager.getString((String)"install.desktopShortcutName", (String)this.getInstallName(launchDesc));
    }

    private String getStartMenuName(LaunchDesc launchDesc) {
        String string = ResourceManager.getString((String)"install.startMenuShortcutName", (String)this.getInstallName(launchDesc));
        return string;
    }

    private String getDesktopPath(LaunchDesc launchDesc) {
        String string = this.getDesktopPath();
        if (string != null) {
            String string2 = this.getDesktopName(launchDesc);
            if (string2 != null) {
                string = string + string2;
            }
            if (string.length() > 192) {
                string = string.substring(0, 192);
            }
            string = string + SHORTCUT_EXTENSION;
        }
        return string;
    }

    private String getStartMenuPath(LaunchDesc launchDesc) {
        String string = this.getSubMenuPath(launchDesc);
        if (string != null) {
            String string2 = this.getStartMenuName(launchDesc);
            if (string2 != null) {
                string = string + string2;
            }
            if (string.length() > 192) {
                string = string.substring(0, 192);
            }
            string = string + SHORTCUT_EXTENSION;
        }
        return string;
    }

    private String getRCPath(LaunchDesc launchDesc, String string) {
        String string2 = this.getSubMenuPath(launchDesc);
        if (string2 != null) {
            if ((string2 = string2 + string).length() > 192) {
                string2 = string2.substring(0, 192);
            }
            string2 = string2 + SHORTCUT_EXTENSION;
        }
        return string2;
    }

    private String getUninstallPath(LaunchDesc launchDesc) {
        String string = this.getSubMenuPath(launchDesc);
        if (string != null) {
            String string2 = "uninstall  " + this.getStartMenuName(launchDesc);
            if ((string = string + string2).length() > 192) {
                string = string.substring(0, 192);
            }
            string = string + SHORTCUT_EXTENSION;
        }
        return string;
    }

    private String getSubMenuPath(LaunchDesc launchDesc) {
        String string;
        String string2 = this.getStartMenuPath();
        if (string2 != null && (string = this.getSubMenuDir(launchDesc)) != null) {
            string2 = string2 + string + File.separator;
        }
        return string2;
    }

    private String getSubMenuDir(LaunchDesc launchDesc) {
        String string;
        String string2 = this.getStartMenuName(launchDesc);
        ShortcutDesc shortcutDesc = launchDesc.getInformation().getShortcut();
        if (shortcutDesc != null && (string = shortcutDesc.getSubmenu()) != null) {
            string2 = string;
        }
        if (string2 != null && string2.equalsIgnoreCase("startup")) {
            string2 = "Startup";
        }
        return string2;
    }

    private String getDesktopPath() {
        this.loadPathsIfNecessary();
        return this._desktopPath;
    }

    private String getStartMenuPath() {
        this.loadPathsIfNecessary();
        return this._startMenuPath;
    }

    private void loadPathsIfNecessary() {
        int n = -2147483647;
        String string = "";
        if (Globals.isSystemCache()) {
            n = -2147483646;
            string = "Common ";
        }
        if (!this._loadedPaths) {
            this._desktopPath = WinRegistry.getString((int)n, (String)REG_SHORTCUT_PATH, (String)(string + REG_DESKTOP_PATH_KEY));
            if (this._desktopPath != null && this._desktopPath.length() > 0 && this._desktopPath.charAt(this._desktopPath.length() - 1) != '\\') {
                this._desktopPath = this._desktopPath + '\\';
            }
            this._startMenuPath = WinRegistry.getString((int)n, (String)REG_SHORTCUT_PATH, (String)(string + REG_START_MENU_PATH_KEY));
            if (this._startMenuPath != null && this._startMenuPath.length() > 0 && this._startMenuPath.charAt(this._startMenuPath.length() - 1) != '\\') {
                this._startMenuPath = this._startMenuPath + '\\';
            }
            this._loadedPaths = true;
            Trace.println((String)("Start path: " + this._startMenuPath + " desktop " + this._desktopPath), (TraceLevel)TraceLevel.TEMP);
        }
    }

    private boolean uninstallShortcut(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    private int installWrapper(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        Trace.println((String)"installshortcut with args:", (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    path: " + string), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    name: " + string2), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    desc: " + string3), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    appP: " + string4), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    args: " + string5), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    dir : " + string6), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    icon: " + string7), (TraceLevel)TraceLevel.TEMP);
        Trace.flush();
        return Config.getInstance().installShortcut(string, string2, string3, string4, string5, string6, string7);
    }

    static {
        NativeLibrary.getInstance().load();
        String string = System.getProperty("os.name");
        useSystem = string.indexOf("2000") == -1 && string.indexOf("XP") == -1;
    }
}

