/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.gsm;

import com.ibm.media.codec.audio.BufferedEncoder;
import com.ibm.media.codec.audio.gsm.GsmEncoder;
import com.ibm.media.codec.audio.gsm.GsmVadEncoder;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class JavaEncoder
extends BufferedEncoder {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1999.";
    protected GsmEncoder encoder;
    private int sample_count = 160;
    private long currentSeq = (long)((double)System.currentTimeMillis() * Math.random());
    private long timestamp = 0L;
    byte[] pendingBuffer = null;

    public JavaEncoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("gsm")};
        this.PLUGIN_NAME = "GSM Encoder";
        this.historySize = 320;
        this.pendingFrames = 0;
        this.packetSize = 33;
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("gsm", af.getSampleRate(), 16, af.getChannels(), -1, -1, 264, -1.0, Format.byteArray)};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        this.encoder = new GsmVadEncoder();
        this.encoder.gsm_encoder_reset();
    }

    public void codecReset() {
        this.encoder.gsm_encoder_reset();
    }

    public void close() {
        this.encoder = null;
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        int retVal = super.process(inputBuffer, outputBuffer);
        if (!this.outputFormat.getEncoding().equals("gsm/rtp")) {
            return retVal;
        }
        if (this.outputFormat.getEncoding().equals("gsm/rtp")) {
            if (retVal == 1) {
                return retVal;
            }
            if (this.isEOM(inputBuffer)) {
                this.propagateEOM(outputBuffer);
                return 0;
            }
            if (this.pendingFrames == 0) {
                this.pendingBuffer = (byte[])outputBuffer.getData();
            }
            byte[] outData = new byte[this.packetSize];
            outputBuffer.setData(outData);
            this.updateOutput(outputBuffer, this.outputFormat, this.packetSize, 0);
            outputBuffer.setSequenceNumber(this.currentSeq++);
            outputBuffer.setTimeStamp(this.timestamp);
            this.timestamp += (long)this.sample_count;
            System.arraycopy(this.pendingBuffer, this.regions[this.pendingFrames], outData, 0, this.packetSize);
            if (this.pendingFrames + 1 == this.frameNumber[0]) {
                this.pendingFrames = 0;
                this.pendingBuffer = null;
                return 0;
            }
            ++this.pendingFrames;
            return 2;
        }
        return retVal;
    }

    protected int calculateOutputSize(int inputSize) {
        return this.calculateFramesNumber(inputSize) * 33;
    }

    protected int calculateFramesNumber(int inputSize) {
        return inputSize / 320;
    }

    protected boolean codecProcess(byte[] inpData, int readPtr, byte[] outData, int writePtr, int inpLength, int[] readBytes, int[] writeBytes, int[] frameNumber, int[] regions, int[] regionsTypes) {
        int inCount = 0;
        int outCount = 0;
        int channels = this.inputFormat.getChannels();
        boolean isStereo = channels == 2;
        int frames = inpLength / 320;
        regions[0] = writePtr;
        int frameCounter = 0;
        while (frameCounter < frames) {
            this.encoder.gsm_encode_frame(inpData, readPtr, outData, writePtr);
            readPtr += 320;
            inCount += 320;
            outCount += 33;
            regions[frameCounter + 1] = writePtr += 33;
            regionsTypes[frameCounter] = 0;
            ++frameCounter;
        }
        readBytes[0] = inCount;
        writeBytes[0] = outCount;
        frameNumber[0] = frames;
        return true;
    }

    static {
        a_copyright_notice = a_copyright_notice;
    }
}

