/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.video.h263;

import com.ibm.media.codec.video.VideoCodec;
import com.ibm.media.codec.video.h263.BitRateAdapter;
import com.ibm.media.codec.video.h263.EncodeControl;
import com.ibm.media.codec.video.h263.FrameProcessingAdapter;
import com.ibm.media.codec.video.h263.FrameRateAdapter;
import com.ibm.media.codec.video.h263.KeyFrameAdapter;
import com.ibm.media.codec.video.h263.PacketSizeAdapter;
import com.ibm.media.codec.video.h263.QualityAdapter;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.controls.H263Adapter;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class NativeEncoder
extends VideoCodec {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997, 1999.";
    static final int[] widths;
    static final int[] heights;
    private int videoWidth = 176;
    private int videoHeight = 144;
    int nativeFormat = 0;
    static final int DEFAULT_RTP_MTU = 984;
    static final int MAX_RTP_MTU = 1456;
    static final int DEFAULT_MAX_OUTPUT_LENGTH = 40960;
    public int maxOutputLength;
    public int targetOutputLength;
    long timeStamp = -1L;
    long sequenceNumber = 0L;
    long deltaFrames = 33366L;
    boolean useRtp = false;
    Control[] controls = null;
    float sourceFrameRate = 0.0f;
    float targetFrameRate = 0.0f;
    int minBitRate = 5000;
    int maxBitRate = 1000000;
    int useBitRate = 20000;
    int iFramePeriod = 15;
    int frameDecimation = 1;
    int frame2skip = 0;
    boolean initCompleted = false;
    boolean settingsChanged = false;
    boolean dropFrame = false;
    boolean okToDrop = false;
    EncodeControl encodeControl = null;
    private int nativeData = 0;
    private int prevTr = 0;
    private int tr;
    public boolean frameDone = true;
    private int outputLength;
    private boolean interFlag;

    private native boolean initNativeEncoder(int var1, int var2, float var3, float var4, int var5, int var6);

    private native boolean setFramesBehind(int var1);

    private native boolean setQuality(float var1);

    private native boolean encodeFrameNative(Buffer var1, Buffer var2);

    private native boolean closeNativeEncoder();

    public NativeEncoder() {
        this.supportedInputFormats = new VideoFormat[]{new YUVFormat(2)};
        this.defaultOutputFormats = new VideoFormat[]{new VideoFormat("h263"), new VideoFormat("h263/rtp")};
        this.PLUGIN_NAME = "H.263 Encoder";
    }

    public Format setInputFormat(Format format) {
        YUVFormat ivf = (YUVFormat)super.setInputFormat(format);
        if (ivf == null) {
            return null;
        }
        Dimension inSize = ivf.getSize();
        if (inSize == null) {
            return null;
        }
        if (ivf.getOffsetU() > ivf.getOffsetV()) {
            return null;
        }
        this.videoWidth = inSize.width;
        this.videoHeight = inSize.height;
        this.sourceFrameRate = ivf.getFrameRate();
        this.deltaFrames = (long)(1000000.0 / (double)ivf.getFrameRate());
        if (this.opened) {
            VideoFormat newOut = new VideoFormat(this.outputFormat.getEncoding(), new Dimension(inSize), -1, Format.byteArray, ivf.getFrameRate());
            this.close();
            this.setOutputFormat(newOut);
            try {
                this.open();
            }
            catch (ResourceUnavailableException re) {
                return null;
            }
        }
        return format;
    }

    public Format setOutputFormat(Format format) {
        VideoFormat f2 = (VideoFormat)super.setOutputFormat(format);
        if (f2.getMaxDataLength() == -1) {
            if (f2.getEncoding().equals("h263/rtp")) {
                this.useRtp = true;
                this.maxOutputLength = 1456;
                this.targetOutputLength = 984;
            } else {
                this.useRtp = false;
                this.maxOutputLength = 40960;
                this.targetOutputLength = 40960;
            }
            f2 = new VideoFormat(f2.getEncoding(), f2.getSize(), this.maxOutputLength, Format.byteArray, f2.getFrameRate());
            this.targetFrameRate = f2.getFrameRate();
            this.frameDecimation = (int)(this.sourceFrameRate / this.targetFrameRate);
            this.useBitRate = (int)(this.targetFrameRate * (float)f2.getSize().width * (float)f2.getSize().height / 5.0f);
            f2 = (VideoFormat)super.setOutputFormat(f2);
        }
        return f2;
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        VideoFormat ivf = (VideoFormat)in;
        Dimension inSize = ivf.getSize();
        if (inSize == null) {
            return null;
        }
        this.videoWidth = inSize.width;
        this.videoHeight = inSize.height;
        this.supportedOutputFormats = new VideoFormat[2];
        int i2 = 0;
        while (i2 < 2) {
            float useFrameRate = ivf.getFrameRate();
            if (i2 == 2) {
                useFrameRate /= 2.0f;
            }
            if (i2 == 4) {
                useFrameRate /= 3.0f;
            }
            this.supportedOutputFormats[i2++] = new VideoFormat("h263", new Dimension(inSize), -1, Format.byteArray, useFrameRate);
            this.supportedOutputFormats[i2++] = new VideoFormat("h263/rtp", new Dimension(inSize), -1, Format.byteArray, useFrameRate);
        }
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        if (this.videoWidth == 128 && this.videoHeight == 96) {
            this.nativeFormat = 0;
        } else if (this.videoWidth == 176 && this.videoHeight == 144) {
            this.nativeFormat = 1;
        } else if (this.videoWidth == 352 && this.videoHeight == 288) {
            this.nativeFormat = 2;
        } else {
            Log.error("Class: " + this);
            Log.error("  can only encode in sizes: 128x96, 176x144, 352x288.");
            throw new ResourceUnavailableException("could not load jmvh263");
        }
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmh263enc");
            super.open();
            if (this.encodeControl != null) {
                this.encodeControl.open(this.controls);
            }
            return;
        }
        catch (Throwable e2) {
            System.out.println(e2);
            throw new ResourceUnavailableException("could not load jmvh263");
        }
    }

    public synchronized void close() {
        if (this.encodeControl != null) {
            this.encodeControl.close();
        }
        this.closeNativeEncoder();
        super.close();
    }

    protected void finalize() {
        if (this.encodeControl != null) {
            this.encodeControl.frame.dispose();
            this.encodeControl = null;
        }
    }

    private synchronized void closeNative() {
        this.closeNativeEncoder();
    }

    public final synchronized void reset() {
        this.initEncoder();
        this.settingsChanged = false;
    }

    protected void videoResized() {
        this.initEncoder();
    }

    protected void initEncoder() {
        if (this.maxOutputLength != this.outputFormat.getMaxDataLength()) {
            VideoFormat f2 = this.outputFormat;
            this.outputFormat = new VideoFormat(f2.getEncoding(), f2.getSize(), this.maxOutputLength, Format.byteArray, f2.getFrameRate());
        }
        this.closeNative();
        if (this.useRtp) {
            this.initNativeEncoder(this.nativeFormat, this.targetOutputLength, this.sourceFrameRate, this.targetFrameRate, this.useBitRate, this.iFramePeriod);
        } else {
            this.initNativeEncoder(this.nativeFormat, 0, this.sourceFrameRate, this.targetFrameRate, this.useBitRate, this.iFramePeriod);
        }
    }

    public synchronized int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.initCompleted) {
            this.initCompleted = true;
            this.initEncoder();
        }
        if (this.okToDrop && this.dropFrame) {
            this.dropFrame = false;
            outputBuffer.setDiscard(true);
            if (this.settingsChanged) {
                this.reset();
            }
            return 0;
        }
        this.okToDrop = false;
        if (this.frameDone) {
            ++this.frame2skip;
            if (this.frame2skip != this.frameDecimation) {
                this.updateOutput(outputBuffer, this.outputFormat, 0, 0);
                return 4;
            }
            this.frame2skip = 0;
            if (!this.checkInputBuffer(inputBuffer)) {
                return 1;
            }
            if (this.isEOM(inputBuffer)) {
                this.propagateEOM(outputBuffer);
                this.okToDrop = true;
                if (this.settingsChanged) {
                    this.reset();
                }
                return 0;
            }
        }
        VideoFormat ivf = (VideoFormat)inputBuffer.getFormat();
        int inLength = inputBuffer.getLength();
        int inMaxLength = ivf.getMaxDataLength();
        int outMaxLength = this.outputFormat.getMaxDataLength();
        int inputOffset = inputBuffer.getOffset();
        if (outMaxLength < 1456) {
            outMaxLength = 1456;
        }
        byte[] inData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, outMaxLength);
        boolean ret = this.encodeFrameNative(inputBuffer, outputBuffer);
        if (this.outputLength >= 0) {
            outputBuffer.setLength(this.outputLength);
        }
        if (this.useRtp) {
            outputBuffer.setSequenceNumber(this.sequenceNumber);
            ++this.sequenceNumber;
            if (this.frameDone) {
                this.timeStamp = inputBuffer.getTimeStamp();
                this.prevTr = this.tr;
                int flags = outputBuffer.getFlags();
                outputBuffer.setFlags(flags |= 0x800);
            }
        } else {
            int flags = outputBuffer.getFlags();
            flags = !this.interFlag ? (flags |= 0x10) : (flags &= 0xFFFFFFEF);
            outputBuffer.setFlags(flags);
        }
        this.updateOutput(outputBuffer, this.outputFormat, outputBuffer.getLength(), 0);
        outputBuffer.setFormat(this.outputFormat);
        if (this.frameDone) {
            if (this.outputLength != -1) {
                this.okToDrop = true;
                if (this.settingsChanged) {
                    this.reset();
                }
                return 0;
            }
            return 4;
        }
        if (this.outputLength == -1) {
            return 6;
        }
        return 2;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[8];
            this.controls[0] = new H263Adapter(this, false, false, false, false, false, 0, 1000, false);
            this.controls[1] = new BitRateAdapter(this, this.useBitRate, this.minBitRate, this.maxBitRate, true);
            this.controls[2] = new KeyFrameAdapter(this, this.iFramePeriod, true);
            this.controls[3] = new QualityAdapter(this, 1.0f, 0.0f, 1.0f, false, true);
            this.controls[4] = new FrameRateAdapter(this, this.targetFrameRate, this.sourceFrameRate / 3.0f, this.sourceFrameRate, true);
            this.controls[5] = new FrameProcessingAdapter(this);
            this.controls[6] = new PacketSizeAdapter(this, this.targetOutputLength, true);
            this.encodeControl = new EncodeControl(this.controls);
            this.controls[7] = this.encodeControl;
        }
        return this.controls;
    }

    static {
        a_copyright_notice = a_copyright_notice;
        widths = new int[]{0, 128, 176, 352, 704, 1408, 0, 0};
        heights = new int[]{0, 96, 144, 288, 576, 1152, 0, 0};
        DEFAULT_RTP_MTU = 984;
        MAX_RTP_MTU = 1456;
        DEFAULT_MAX_OUTPUT_LENGTH = 40960;
    }
}

