/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.vcm;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.codec.video.vcm.ICInfo;
import com.sun.media.codec.video.vcm.VCM;
import com.sun.media.controls.QualityAdapter;
import com.sun.media.vfw.BitMapInfo;
import java.awt.Dimension;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.QualityControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public final class NativeEncoder
extends BasicCodec {
    protected RGBFormat inputFormat = null;
    protected VideoFormat outputFormat = null;
    private static String[] supportedEncodings;
    private static BitMapInfo[] supportedOutBMIs;
    private int vcmHandle = 0;
    private boolean debug = false;
    private BitMapInfo biIn = null;
    private BitMapInfo biOut = null;
    private BitMapInfo biPrev = null;
    private boolean dropFrame = false;
    private boolean hasQuality = false;
    private boolean hasCrunch = false;
    private boolean hasTemporal = false;
    private boolean hasFastCompress = false;
    private boolean begun = false;
    private QualityControl qc = null;
    private Control[] controls = null;
    private float quality = 9000.0f;
    static final int AVIF_KEYFRAME = 16;
    int seqNo = 0;
    int keyFrameInterval = 4;
    int[] outFlags = new int[1];
    int[] ckid = new int[1];
    byte[] dataPrev = null;

    public NativeEncoder() {
        this.inputFormats = new VideoFormat[1];
        this.inputFormats[0] = new RGBFormat();
        this.outputFormats = new VideoFormat[1];
        this.outputFormats[0] = new VideoFormat(null);
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public String getName() {
        return "VCM Encoder";
    }

    private static synchronized void querySupportedEncodings() {
        boolean result;
        int i2;
        ICInfo icinfo = new ICInfo();
        BitMapInfo biOut = new BitMapInfo();
        Vector<String> listEncoding = new Vector<String>();
        Vector<BitMapInfo> listBMI = new Vector<BitMapInfo>();
        for (i2 = 0; (result = VCM.icInfoEnum("vidc", i2, icinfo)) && i2 <= 30; ++i2) {
            int handle = VCM.icOpen("vidc", icinfo.fccHandler, 1);
            if (handle == 0) continue;
            BitMapInfo biIn = new BitMapInfo("RGB", 320, 240);
            biOut = new BitMapInfo("RGB", 320, 240);
            VCM.icCompressGetFormat(handle, biIn, biOut);
            if (biOut.fourcc.equalsIgnoreCase(icinfo.fccHandler) && !icinfo.fccHandler.equalsIgnoreCase("mjpg") && !icinfo.fccHandler.equalsIgnoreCase("dmb1")) {
                listEncoding.addElement(biOut.fourcc);
                listBMI.addElement(biOut);
            }
            VCM.icClose(handle);
        }
        supportedEncodings = new String[listEncoding.size()];
        supportedOutBMIs = new BitMapInfo[listEncoding.size()];
        i2 = 0;
        while (i2 < supportedEncodings.length) {
            NativeEncoder.supportedEncodings[i2] = (String)listEncoding.elementAt(i2);
            NativeEncoder.supportedOutBMIs[i2] = (BitMapInfo)listBMI.elementAt(i2);
            ++i2;
        }
    }

    public Format[] getSupportedInputFormats() {
        this.inputFormats[0] = new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, -1, 1, -1);
        return this.inputFormats;
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null || !(input instanceof RGBFormat)) {
            return new VideoFormat[]{new VideoFormat(null)};
        }
        if (input.matches(this.inputFormats[0])) {
            Dimension frameSize;
            if (supportedEncodings == null) {
                NativeEncoder.querySupportedEncodings();
            }
            if ((frameSize = ((VideoFormat)input).getSize()) == null) {
                frameSize = new Dimension(320, 240);
            }
            this.outputFormats = new VideoFormat[supportedEncodings.length];
            int i2 = 0;
            while (i2 < supportedEncodings.length) {
                int area = frameSize.width * frameSize.height;
                int outSize = area * NativeEncoder.supportedOutBMIs[i2].biBitCount / 8;
                if (outSize < area) {
                    outSize = area;
                }
                this.outputFormats[i2] = new VideoFormat(supportedEncodings[i2], frameSize, outSize, Format.byteArray, ((VideoFormat)input).getFrameRate());
                ++i2;
            }
            return this.outputFormats;
        }
        return new Format[0];
    }

    public Format setInputFormat(Format in) {
        if (in instanceof RGBFormat && BasicPlugIn.matches(in, this.inputFormats) != null) {
            this.inputFormat = (RGBFormat)in;
            if (this.begun) {
                this.close();
                try {
                    Dimension frameSize = ((RGBFormat)in).getSize();
                    int area = frameSize.width * frameSize.height;
                    int outSize = area * 24 / 8;
                    this.outputFormat = new VideoFormat(this.outputFormat.getEncoding(), frameSize, outSize, Format.byteArray, this.inputFormat.getFrameRate());
                    this.open();
                }
                catch (Exception e2) {
                    return null;
                }
            }
            return in;
        }
        return null;
    }

    public Format setOutputFormat(Format out) {
        if (out instanceof VideoFormat) {
            this.outputFormat = (VideoFormat)out;
            if (this.debug) {
                System.err.println("VCM.setOutputFormat : " + this.outputFormat);
            }
            return out;
        }
        return null;
    }

    public synchronized void open() throws ResourceUnavailableException {
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Unknown formats");
        }
        Dimension size = this.inputFormat.getSize();
        if (size == null || size.width % 4 != 0 || size.height % 4 != 0) {
            Log.error("Class: " + this);
            Log.error("  can only encode in sizes of multiple of 4 pixels.");
            throw new ResourceUnavailableException("Wrong size.");
        }
        if (this.vcmHandle != 0) {
            this.close();
        }
        this.biIn = new BitMapInfo(this.inputFormat);
        this.biOut = new BitMapInfo(this.outputFormat);
        this.vcmHandle = VCM.icLocate("vidc", "rgb", this.biIn, this.biOut, 1);
        if (this.vcmHandle == 0) {
            throw new ResourceUnavailableException("Couldn't create compressor");
        }
        ICInfo icinfo = new ICInfo();
        VCM.icGetInfo(this.vcmHandle, icinfo);
        int flags = icinfo.dwFlags;
        this.hasQuality = (flags & 1) != 0;
        this.hasCrunch = (flags & 2) != 0;
        this.hasTemporal = (flags & 4) != 0;
        this.hasFastCompress = (flags & 0x20) != 0;
        this.begun = false;
        BitMapInfo testBMI = new BitMapInfo();
        VCM.icCompressGetFormat(this.vcmHandle, this.biIn, testBMI);
        this.biOut = testBMI;
        if (!VCM.icCompressBegin(this.vcmHandle, this.biIn, this.biOut)) {
            VCM.icClose(this.vcmHandle);
            throw new ResourceUnavailableException("Couldn't create compressor");
        }
        this.begun = true;
        this.seqNo = this.seqNo + 3 & 0xFFFFFFFC;
    }

    public synchronized void close() {
        if (this.vcmHandle != 0) {
            if (this.begun) {
                VCM.icCompressEnd(this.vcmHandle);
            }
            VCM.icClose(this.vcmHandle);
            this.begun = false;
        }
        this.vcmHandle = 0;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            if (this.qc == null) {
                this.qc = new QualityAdapter(this.quality, 0.0f, 10000.0f, true){

                    public float setQuality(float newValue) {
                        NativeEncoder.this.quality = newValue;
                        return super.setQuality(newValue);
                    }

                    protected String getName() {
                        return "Video Encoder Quality";
                    }
                };
                this.controls = new Control[1];
                this.controls[0] = this.qc;
            } else {
                this.controls = new Control[0];
            }
        }
        return this.controls;
    }

    public int process(Buffer inBuffer, Buffer outBuffer) {
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            return 0;
        }
        int inFlags = 0;
        int outBufFlags = 0;
        Object outData = outBuffer.getData();
        if (outData == null || !(outData instanceof byte[]) || ((byte[])outData).length < this.outputFormat.getMaxDataLength()) {
            outData = new byte[this.outputFormat.getMaxDataLength()];
        }
        outBuffer.setData(outData);
        outBuffer.setFormat(this.outputFormat);
        if (this.dataPrev == null && this.hasTemporal) {
            this.dataPrev = new byte[this.inputFormat.getMaxDataLength()];
        }
        if (this.seqNo % this.keyFrameInterval == 0) {
            inFlags |= 1;
        }
        ++this.seqNo;
        int returnVal = VCM.icCompress(this.vcmHandle, inFlags, this.biOut, outData, this.biIn, inBuffer.getData(), this.ckid, this.outFlags, this.seqNo, this.outputFormat.getMaxDataLength(), (int)this.quality, this.biIn, this.dataPrev);
        if ((this.outFlags[0] & 0x10) != 0) {
            outBufFlags |= 0x10;
        }
        byte[] tempdata = this.dataPrev;
        if (this.hasTemporal) {
            this.dataPrev = (byte[])inBuffer.getData();
            inBuffer.setData(tempdata);
        }
        if (returnVal < 0) {
            return 1;
        }
        outBuffer.setFormat(this.outputFormat);
        outBuffer.setSequenceNumber(this.seqNo);
        outBuffer.setLength(this.biOut.biSizeImage);
        outBufFlags = outBuffer.getFlags() & 0xFFFFFFEF | outBufFlags | 0x60;
        outBuffer.setFlags(outBufFlags);
        return 0;
    }

    static {
        JMFSecurityManager.loadLibrary("jmvcm");
        supportedEncodings = null;
        supportedOutBMIs = null;
        AVIF_KEYFRAME = 16;
    }
}

