/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.rtp;

import com.sun.media.BasicPlayer;
import com.sun.media.JMFSecurity;
import com.sun.media.Log;
import com.sun.media.protocol.BufferListener;
import com.sun.media.rtp.RTPMediaLocator;
import com.sun.media.rtp.RTPSessionMgr;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Vector;
import javax.media.ClockStartedError;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NotRealizedError;
import javax.media.Owned;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.SystemTimeBase;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.FormatChangeEvent;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.rtp.RTPControl;
import javax.media.rtp.RTPManager;
import javax.media.rtp.RTPSocket;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;

public class Handler
extends BasicPlayer
implements ReceiveStreamListener,
BufferListener {
    RTPSessionMgr[] mgrs = null;
    DataSource[] sources = null;
    Player[] players = null;
    Format[] formats = null;
    Format[] formatChanged = null;
    boolean[] realized = null;
    boolean[] dataReady = null;
    Vector locators = null;
    ControllerListener listener = new PlayerListener(this);
    boolean playersRealized = false;
    Object realizedSync = new Object();
    Object closeSync = new Object();
    Object dataSync = new Object();
    Object stateLock = new Object();
    private boolean closed = false;
    private boolean audioEnabled = false;
    private boolean videoEnabled = false;
    private boolean prebuffer = false;
    private boolean dataAllReady = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    String sessionError = "cannot create and initialize the RTP session.";

    public Handler() {
        this.framePositioning = false;
        this.bufferControl = new BC();
        this.stopThreadEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRealize() {
        super.doRealize();
        try {
            if (this.source instanceof RTPSocket) {
                this.mgrs = new RTPSessionMgr[1];
                this.mgrs[1] = new RTPSessionMgr((RTPSocket)this.source);
                this.mgrs[1].addReceiveStreamListener(this);
                this.sources = new DataSource[1];
                this.players = new Player[1];
                this.formats = new Format[1];
                this.realized = new boolean[1];
                this.dataReady = new boolean[1];
                this.formatChanged = new Format[1];
                this.sources[0] = this.source;
                this.dataReady[0] = false;
            } else {
                SessionAddress localAddr = new SessionAddress();
                this.mgrs = new RTPSessionMgr[this.locators.size()];
                this.sources = new DataSource[this.locators.size()];
                this.players = new Player[this.locators.size()];
                this.formats = new Format[this.locators.size()];
                this.realized = new boolean[this.locators.size()];
                this.dataReady = new boolean[this.locators.size()];
                this.formatChanged = new Format[this.locators.size()];
                int i2 = 0;
                while (i2 < this.locators.size()) {
                    SessionAddress destAddr;
                    RTPMediaLocator rml = (RTPMediaLocator)this.locators.elementAt(i2);
                    this.realized[i2] = false;
                    this.mgrs[i2] = (RTPSessionMgr)RTPManager.newInstance();
                    this.mgrs[i2].addReceiveStreamListener(this);
                    InetAddress ipAddr = InetAddress.getByName(rml.getSessionAddress());
                    if (ipAddr.isMulticastAddress()) {
                        localAddr = new SessionAddress(ipAddr, rml.getSessionPort(), rml.getTTL());
                        destAddr = new SessionAddress(ipAddr, rml.getSessionPort(), rml.getTTL());
                    } else {
                        localAddr = new SessionAddress(InetAddress.getLocalHost(), rml.getSessionPort());
                        destAddr = new SessionAddress(ipAddr, rml.getSessionPort());
                    }
                    this.mgrs[i2].initialize(localAddr);
                    if (this.prebuffer) {
                        BufferControl bc = (BufferControl)this.mgrs[i2].getControl("javax.media.control.BufferControl");
                        bc.setBufferLength(this.bufferControl.getBufferLength());
                        bc.setMinimumThreshold(this.bufferControl.getMinimumThreshold());
                    }
                    this.mgrs[i2].addTarget(destAddr);
                    ++i2;
                }
            }
        }
        catch (Exception e2) {
            Log.error("Cannot create the RTP Session: " + e2.getMessage());
            this.processError = this.sessionError;
            return false;
        }
        try {
            Object e2 = this.realizedSync;
            synchronized (e2) {
                while (!(this.playersRealized || this.isInterrupted() || this.closed)) {
                    this.realizedSync.wait();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.closed || this.isInterrupted()) {
            this.resetInterrupt();
            this.processError = "no RTP data was received.";
            return false;
        }
        return true;
    }

    protected void completeRealize() {
        this.state = 300;
        super.completeRealize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        int i2;
        super.doStart();
        Object object = this.dataSync;
        synchronized (object) {
            if (this.prebuffer) {
                this.dataAllReady = false;
                i2 = 0;
                while (i2 < this.dataReady.length) {
                    this.dataReady[i2] = false;
                    ((com.sun.media.protocol.rtp.DataSource)this.sources[i2]).flush();
                    ((com.sun.media.protocol.rtp.DataSource)this.sources[i2]).prebuffer();
                    ++i2;
                }
                if (!this.dataAllReady && !this.closed) {
                    try {
                        this.dataSync.wait(3000L);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
            }
        }
        i2 = 0;
        while (i2 < this.players.length) {
            try {
                if (this.players[i2] != null) {
                    this.waitForStart(this.players[i2]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        super.doStop();
        Object object = this.dataSync;
        synchronized (object) {
            if (this.prebuffer) {
                this.dataSync.notify();
            }
        }
        int i2 = 0;
        while (i2 < this.players.length) {
            try {
                if (this.players[i2] != null) {
                    this.waitForStop(this.players[i2]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeallocate() {
        int i2 = 0;
        while (i2 < this.players.length) {
            try {
                if (this.players[i2] != null) {
                    this.players[i2].deallocate();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
        Object object = this.realizedSync;
        synchronized (object) {
            this.realizedSync.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFailedRealize() {
        Object object = this.closeSync;
        synchronized (object) {
            int i2 = 0;
            while (i2 < this.mgrs.length) {
                if (this.mgrs[i2] != null) {
                    this.mgrs[i2].removeTargets("Closing session from the RTP Handler");
                    this.mgrs[i2].dispose();
                    this.mgrs[i2] = null;
                }
                ++i2;
            }
        }
        super.doFailedRealize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        this.closed = true;
        Object object = this.realizedSync;
        synchronized (object) {
            this.realizedSync.notify();
        }
        Object object2 = this.dataSync;
        synchronized (object2) {
            this.dataSync.notifyAll();
        }
        this.stop();
        int i2 = 0;
        while (i2 < this.players.length) {
            try {
                if (this.players[i2] != null) {
                    this.players[i2].close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            ++i2;
        }
        Object object3 = this.closeSync;
        synchronized (object3) {
            int i3 = 0;
            while (i3 < this.mgrs.length) {
                if (this.mgrs[i3] != null) {
                    this.mgrs[i3].removeTargets("Closing session from the RTP Handler");
                    this.mgrs[i3].dispose();
                    this.mgrs[i3] = null;
                }
                ++i3;
            }
        }
        super.doClose();
    }

    public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
    }

    protected TimeBase getMasterTimeBase() {
        return new SystemTimeBase();
    }

    public float setRate(float rate) {
        if (this.getState() < 300) {
            this.throwError(new NotRealizedError("Cannot set rate on an unrealized Player."));
        }
        return 1.0f;
    }

    public void setStopTime(Time t) {
        this.controllerSetStopTime(t);
    }

    protected void stopAtTime() {
        this.controllerStopAtTime();
    }

    public synchronized void addController(Controller newController) throws IncompatibleTimeBaseException {
        int playerState = this.getState();
        if (playerState == 600) {
            this.throwError(new ClockStartedError("Cannot add controller to a started player"));
        }
        if (playerState == 100 || playerState == 200) {
            this.throwError(new NotRealizedError("A Controller cannot be added to an Unrealized Player"));
        }
        throw new IncompatibleTimeBaseException();
    }

    protected boolean audioEnabled() {
        return this.audioEnabled;
    }

    protected boolean videoEnabled() {
        return this.videoEnabled;
    }

    private void sendMyEvent(ControllerEvent e2) {
        super.sendEvent(e2);
    }

    public void update(ReceiveStreamEvent event) {
        RTPSessionMgr mgr = (RTPSessionMgr)event.getSource();
        int idx = 0;
        while (idx < this.mgrs.length) {
            if (this.mgrs[idx] == mgr) break;
            ++idx;
        }
        if (idx >= this.mgrs.length) {
            System.err.println("Unknown manager: " + mgr);
            return;
        }
        if (event instanceof RemotePayloadChangeEvent) {
            Log.comment("Received an RTP PayloadChangeEvent");
            RTPControl ctl = (RTPControl)this.sources[idx].getControl("javax.media.rtp.RTPControl");
            if (ctl != null) {
                this.formatChanged[idx] = ctl.getFormat();
            }
            if (this.players[idx] != null) {
                this.stop();
                this.waitForClose(this.players[idx]);
            }
            try {
                this.sources[idx].connect();
                this.players[idx] = Manager.createPlayer(this.sources[idx]);
                if (this.players[idx] == null) {
                    Log.error("Could not create player for the new RTP payload.");
                    return;
                }
                this.players[idx].addControllerListener(this.listener);
                this.players[idx].realize();
            }
            catch (Exception e2) {
                Log.error("Could not create player for the new payload.");
            }
        }
        if (event instanceof NewReceiveStreamEvent) {
            if (this.players[idx] != null) {
                return;
            }
            ReceiveStream stream = null;
            try {
                stream = ((NewReceiveStreamEvent)event).getReceiveStream();
                this.sources[idx] = stream.getDataSource();
                RTPControl ctl = (RTPControl)this.sources[idx].getControl("javax.media.rtp.RTPControl");
                if (ctl != null) {
                    this.formats[idx] = ctl.getFormat();
                    if (this.formats[idx] instanceof AudioFormat) {
                        this.audioEnabled = true;
                    } else if (this.formats[idx] instanceof VideoFormat) {
                        this.videoEnabled = true;
                    }
                }
                if (this.source instanceof RTPSocket) {
                    ((RTPSocket)this.source).setChild(this.sources[idx]);
                } else {
                    ((com.sun.media.protocol.rtp.DataSource)this.source).setChild((com.sun.media.protocol.rtp.DataSource)this.sources[idx]);
                }
                this.players[idx] = Manager.createPlayer(this.sources[idx]);
                if (this.players[idx] == null) {
                    return;
                }
                this.players[idx].addControllerListener(this.listener);
                this.players[idx].realize();
                if (this.prebuffer) {
                    ((com.sun.media.protocol.rtp.DataSource)this.sources[idx]).setBufferListener(this);
                }
            }
            catch (Exception e3) {
                Log.error("NewReceiveStreamEvent exception " + e3.getMessage());
                return;
            }
        }
    }

    private void waitForStart(Player p) {
        new StateWaiter().waitForStart(p, true);
    }

    private void waitForStop(Player p) {
        new StateWaiter().waitForStart(p, false);
    }

    private void waitForClose(Player p) {
        new StateWaiter().waitForClose(p);
    }

    /*
     * WARNING - void declaration
     */
    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        super.setSource(source);
        if (source instanceof com.sun.media.protocol.rtp.DataSource) {
            MediaLocator ml = source.getLocator();
            String mlStr = ml.getRemainder();
            int start = 0;
            while (mlStr.charAt(start) == '/') {
                ++start;
            }
            this.locators = new Vector();
            try {
                RTPMediaLocator rml;
                String str;
                int idx;
                while (start < mlStr.length() && (idx = mlStr.indexOf("&", start)) != -1) {
                    void var6_6;
                    str = mlStr.substring(start, (int)var6_6);
                    rml = new RTPMediaLocator("rtp://" + str);
                    this.locators.addElement(rml);
                    start = var6_6 + true;
                }
                str = start != 0 ? mlStr.substring(start) : mlStr;
                rml = new RTPMediaLocator("rtp://" + str);
                this.locators.addElement(rml);
            }
            catch (Exception e2) {
                throw new IncompatibleSourceException();
            }
            if (this.locators.size() > 1) {
                this.prebuffer = true;
            }
        } else if (!(source instanceof RTPSocket)) {
            throw new IncompatibleSourceException();
        }
        RTPControl ctl = (RTPControl)source.getControl("javax.media.rtp.RTPControl");
        if (ctl != null) {
            ctl.addFormat(new AudioFormat("dvi/rtp", 44100.0, 4, 1), 18);
        }
    }

    private void invalidateComp() {
        this.controlComp = null;
        this.controls = null;
    }

    public Component getVisualComponent() {
        super.getVisualComponent();
        int i2 = 0;
        while (i2 < this.players.length) {
            if (this.players[i2] != null && this.players[i2].getVisualComponent() != null) {
                return this.players[i2].getVisualComponent();
            }
            ++i2;
        }
        return null;
    }

    public Control[] getControls() {
        if (this.controls != null) {
            return this.controls;
        }
        Vector<Control> cv = new Vector<Control>();
        if (this.cachingControl != null) {
            cv.addElement(this.cachingControl);
        }
        if (this.bufferControl != null) {
            cv.addElement(this.bufferControl);
        }
        int size = this.players.length;
        int i2 = 0;
        while (i2 < size) {
            Player ctrller = this.players[i2];
            Control[] cs = ctrller.getControls();
            if (cs != null) {
                int j2 = 0;
                while (j2 < cs.length) {
                    cv.addElement(cs[j2]);
                    ++j2;
                }
            }
            ++i2;
        }
        size = cv.size();
        Control[] ctrls = new Control[size];
        i2 = 0;
        while (i2 < size) {
            ctrls[i2] = (Control)cv.elementAt(i2);
            ++i2;
        }
        if (this.getState() >= 300) {
            this.controls = ctrls;
        }
        return ctrls;
    }

    public void updateStats() {
        int i2 = 0;
        while (i2 < this.players.length) {
            if (this.players[i2] != null) {
                ((BasicPlayer)this.players[i2]).updateStats();
            }
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void minThresholdReached(DataSource ds) {
        boolean ready = true;
        Object object = this.dataSync;
        synchronized (object) {
            int i2 = 0;
            while (i2 < this.sources.length) {
                if (this.sources[i2] == ds) {
                    this.dataReady[i2] = true;
                } else if (!this.dataReady[i2]) {
                    ready = false;
                }
                ++i2;
            }
            if (!ready) {
                return;
            }
            this.dataAllReady = true;
            this.dataSync.notify();
        }
    }

    class BC
    implements BufferControl,
    Owned {
        long len = -1L;
        long min = -1L;

        BC() {
        }

        public long getBufferLength() {
            if (this.len < 0L) {
                return Handler.this.prebuffer ? 750L : 125L;
            }
            return this.len;
        }

        public long setBufferLength(long time) {
            this.len = time;
            Log.comment("RTP Handler buffer length set: " + this.len);
            return this.len;
        }

        public long getMinimumThreshold() {
            if (this.min < 0L) {
                return Handler.this.prebuffer ? 125L : 0L;
            }
            return this.min;
        }

        public long setMinimumThreshold(long time) {
            this.min = time;
            Log.comment("RTP Handler buffer minimum threshold: " + this.min);
            return this.min;
        }

        public void setEnabledThreshold(boolean b2) {
        }

        public boolean getEnabledThreshold() {
            return this.getMinimumThreshold() > 0L;
        }

        public Component getControlComponent() {
            return null;
        }

        public Object getOwner() {
            return Handler.this;
        }
    }

    class PlayerListener
    implements ControllerListener {
        Handler handler;

        public PlayerListener(Handler handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void controllerUpdate(ControllerEvent ce) {
            Player p = (Player)ce.getSourceController();
            if (p == null) {
                return;
            }
            int idx = 0;
            while (idx < Handler.this.players.length) {
                if (Handler.this.players[idx] == p) break;
                ++idx;
            }
            if (idx >= Handler.this.players.length) {
                System.err.println("Unknown player: " + p);
                return;
            }
            if (ce instanceof RealizeCompleteEvent) {
                if (Handler.this.formatChanged[idx] != null) {
                    try {
                        Handler.this.invalidateComp();
                        FormatChangeEvent f2 = new FormatChangeEvent(this.handler, Handler.this.formats[idx], Handler.this.formatChanged[idx]);
                        this.handler.sendMyEvent(f2);
                        Handler.this.formats[idx] = Handler.this.formatChanged[idx];
                        Handler.this.formatChanged[idx] = null;
                    }
                    catch (Exception e2) {
                        e2.getMessage();
                    }
                }
                Handler.this.realized[idx] = true;
                int i2 = 0;
                while (i2 < Handler.this.realized.length) {
                    if (!Handler.this.realized[i2]) {
                        return;
                    }
                    ++i2;
                }
                Object object = Handler.this.realizedSync;
                synchronized (object) {
                    Handler.this.playersRealized = true;
                    Handler.this.realizedSync.notifyAll();
                }
            }
            if (ce instanceof ControllerErrorEvent) {
                Handler.this.players[idx].removeControllerListener(this);
                Log.error("RTP Handler internal error: " + ce);
                Handler.this.players[idx] = null;
            }
        }
    }

    class StateWaiter
    implements ControllerListener {
        boolean closeDown = false;
        Object stateLock = new Object();

        StateWaiter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForStart(Player p, boolean startOn) {
            p.addControllerListener(this);
            if (startOn) {
                p.start();
            } else {
                p.stop();
            }
            Object object = this.stateLock;
            synchronized (object) {
                while ((startOn && p.getState() != 600 || !startOn && p.getState() == 600) && !this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
            }
            p.removeControllerListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForClose(Player p) {
            p.addControllerListener(this);
            p.close();
            Object object = this.stateLock;
            synchronized (object) {
                while (!this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
            }
            p.removeControllerListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof ControllerClosedEvent || ce instanceof ControllerErrorEvent) {
                this.closeDown = true;
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.notify();
            }
        }
    }
}

