/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VFlowLayout
implements LayoutManager {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1999.";
    private int gap;
    private int minWidth = 0;
    private int minHeight = 0;
    private int preferredWidth = 0;
    private int preferredHeight = 0;
    private boolean sizeUnknown = true;

    public VFlowLayout() {
        this(0);
    }

    public VFlowLayout(int v) {
        this.gap = v;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    private void setSizes(Container parent) {
        int nComps = parent.countComponents();
        Dimension d2 = null;
        this.preferredWidth = 0;
        this.preferredHeight = 0;
        this.minWidth = 0;
        this.minHeight = 0;
        int i2 = 0;
        while (i2 < nComps) {
            Component c2 = parent.getComponent(i2);
            if (c2.isVisible()) {
                d2 = c2.preferredSize();
                this.minWidth = Math.max(c2.minimumSize().width, this.minWidth);
                this.preferredWidth = Math.max(c2.preferredSize().width, this.preferredWidth);
                this.minHeight += c2.minimumSize().height + this.gap;
                this.preferredHeight += c2.preferredSize().height + this.gap;
            }
            ++i2;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        int nComps = parent.countComponents();
        this.setSizes(parent);
        Insets insets = parent.insets();
        dim.width = this.preferredWidth + insets.left + insets.right;
        dim.height = this.preferredHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dim;
    }

    public Dimension minimumLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        int nComps = parent.countComponents();
        this.setSizes(parent);
        Insets insets = parent.insets();
        dim.width = this.minWidth + insets.left + insets.right;
        dim.height = this.minHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dim;
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.insets();
        int maxWidth = parent.size().width - (insets.left + insets.right);
        int maxHeight = parent.size().height - (insets.top + insets.bottom);
        int nComps = parent.countComponents();
        if (this.sizeUnknown) {
            this.setSizes(parent);
        }
        int previousWidth = 0;
        int previousHeight = 0;
        boolean x = false;
        int y = insets.top + this.gap / 2;
        boolean rowh = false;
        boolean start = false;
        int yFudge = 0;
        boolean oneColumn = false;
        if (this.sizeUnknown) {
            this.setSizes(parent);
        }
        if (maxHeight > this.preferredHeight) {
            yFudge = (maxHeight - this.preferredHeight) / nComps;
        }
        int i2 = 0;
        while (i2 < nComps) {
            Component c2 = parent.getComponent(i2);
            if (c2.isVisible()) {
                Dimension d2 = c2.preferredSize();
                y = i2 != 0 ? (y += previousHeight + yFudge + this.gap) : (y += previousHeight + (yFudge + this.gap) / 2);
                c2.reshape(0, y, maxWidth, d2.height);
                previousWidth = d2.width;
                previousHeight = d2.height;
            }
            ++i2;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[gap=" + this.gap + "]";
    }

    static {
        a_copyright_notice = a_copyright_notice;
    }
}

