/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.util.MediaThread;
import com.sun.media.util.Registry;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12DeleteFileAction;
import com.sun.media.util.jdk12MakeDirectoryAction;
import com.sun.media.util.jdk12PriorityAction;
import com.sun.media.util.jdk12RandomAccessFileAction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.DownloadProgressListener;
import javax.media.protocol.CachedStream;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class CachedPullSourceStream
implements Runnable,
PullSourceStream,
Seekable,
CachedStream {
    private InputStream stream;
    private RandomAccessFile readRAF;
    private RandomAccessFile writeRAF;
    private String fileName;
    private int bufferSize;
    private byte[] buffer;
    private boolean eosReached;
    private boolean ioException;
    private long length;
    private File file;
    private String protocol;
    private boolean readAborted;
    private boolean paused;
    private boolean abort;
    private MediaThread downloadThread;
    private long contentLength;
    private int highMarkFactor;
    private boolean blockRead;
    private static int MAX_HIGH_MARK = 2000000;
    private static int DEFAULT_HIGH_MARK = 1000000;
    private static int MIN_HIGH_MARK = 8192;
    private int highMark;
    private int lowMark;
    private boolean enabled;
    private boolean jitterEnabled;
    private DownloadProgressListener listener;
    private int numKiloBytesUpdateIncrement;
    private boolean closed;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m;
    private Class[] cl;
    private Object[][] args;
    private int maxCacheSize;
    static /* synthetic */ Class class$com$sun$media$util$MediaThread;

    public CachedPullSourceStream(InputStream stream, String fileName, long contentLength, String protocol) throws IOException {
        block13: {
            this.readRAF = null;
            this.writeRAF = null;
            this.bufferSize = 2048;
            this.buffer = new byte[this.bufferSize];
            this.eosReached = false;
            this.ioException = false;
            this.readAborted = false;
            this.paused = false;
            this.abort = false;
            this.highMarkFactor = 10;
            this.blockRead = true;
            this.highMark = DEFAULT_HIGH_MARK;
            this.lowMark = 0;
            this.enabled = true;
            this.jitterEnabled = true;
            this.listener = null;
            this.numKiloBytesUpdateIncrement = -1;
            this.closed = true;
            this.m = new Method[1];
            this.cl = new Class[1];
            this.args = new Object[1][0];
            this.maxCacheSize = Integer.MAX_VALUE;
            this.stream = stream;
            this.contentLength = contentLength;
            this.fileName = fileName;
            this.protocol = protocol;
            if (jmfSecurity != null) {
                String permission = null;
                int permissionid = 0;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        try {
                            permission = "thread";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                            permission = "thread group";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        permission = "read file";
                        permissionid = 2;
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 2);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        permission = "write file";
                        permissionid = 4;
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 4);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        permission = "delete file";
                        permissionid = 8;
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 8);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        break block13;
                    }
                    if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                        try {
                            PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                        }
                        catch (Throwable t) {}
                    }
                }
                catch (Exception e2) {
                    if (permissionid > 0) {
                        jmfSecurity.permissionFailureNotification(permissionid);
                    }
                    securityPrivelege = false;
                }
            }
        }
        if (!securityPrivelege) {
            throw new IOException("No security privilege for caching");
        }
        this.createFilesAndThread(fileName);
        Object cdir = Registry.get("secure.maxCacheSizeMB");
        if (cdir != null && cdir instanceof Integer) {
            int size = (Integer)cdir;
            if (size < 1) {
                size = 1;
            }
            this.maxCacheSize = size * 1000000;
        }
        this.highMark = this.getHighMark(contentLength);
        this.closed = false;
    }

    private int getHighMark(long contentLength) {
        if (contentLength <= 0L) {
            return DEFAULT_HIGH_MARK;
        }
        long tryHighMark = contentLength / (long)this.highMarkFactor;
        if (tryHighMark < (long)MIN_HIGH_MARK) {
            tryHighMark = MIN_HIGH_MARK;
        } else if (tryHighMark > (long)MAX_HIGH_MARK) {
            tryHighMark = MAX_HIGH_MARK;
        }
        return (int)tryHighMark;
    }

    public void setEnabledBuffering(boolean b2) {
        this.jitterEnabled = b2;
    }

    public boolean getEnabledBuffering() {
        return this.jitterEnabled;
    }

    private void createFilesAndThread(String fileName) throws IOException {
        try {
            this.file = new File(fileName);
            String parent = this.file.getParent();
            File parentFile = null;
            if (parent != null) {
                parentFile = new File(parent);
            }
            if (securityPrivelege && jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor cons;
                Boolean success;
                if (!(parentFile == null || (success = (Boolean)jdk12.doPrivM.invoke((Object)jdk12.ac, (cons = jdk12MakeDirectoryAction.cons).newInstance(parentFile))) != null && success.booleanValue())) {
                    throw new IOException("Unable to create directory " + parentFile);
                }
                cons = jdk12RandomAccessFileAction.cons;
                this.writeRAF = (RandomAccessFile)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(this.file.getPath(), "rw"));
                if (this.writeRAF == null) {
                    throw new IOException("Cannot create cache file");
                }
                this.readRAF = (RandomAccessFile)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(this.file.getPath(), "r"));
                if (this.readRAF == null) {
                    throw new IOException("Cannot create cache file");
                }
                cons = jdk12CreateThreadRunnableAction.cons;
                this.downloadThread = (MediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$util$MediaThread == null ? (class$com$sun$media$util$MediaThread = CachedPullSourceStream.class$("com.sun.media.util.MediaThread")) : class$com$sun$media$util$MediaThread, this));
                this.downloadThread.setName("download");
                cons = jdk12PriorityAction.cons;
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = this.downloadThread;
                objectArray2[1] = new Integer(MediaThread.getVideoPriority());
                objectArray[0] = cons.newInstance(objectArray2);
                jdk12.doPrivM.invoke((Object)jdk12.ac, objectArray);
            } else {
                if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
                    throw new IOException("Unable to create directory " + parentFile);
                }
                this.writeRAF = new RandomAccessFile(this.file, "rw");
                this.readRAF = new RandomAccessFile(this.file, "r");
                this.downloadThread = new MediaThread(this, "download");
                this.downloadThread.useVideoPriority();
            }
        }
        catch (Throwable e2) {
            throw new IOException(e2.getMessage());
        }
    }

    private synchronized void setLength(long length) {
        this.length = length;
    }

    private synchronized long getLength() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        totalBytesRead = 0;
        nextUpdate = this.numKiloBytesUpdateIncrement;
        debugIndex = true;
        if (!this.ioException) ** GOTO lbl64
        return;
lbl-1000:
        // 1 sources

        {
            if (this.abort) {
                return;
            }
            try {
                if (this.contentLength > 0L && !this.protocol.equals("https")) {
                    while (this.stream.available() == 0) {
                        var4_5 = this;
                        synchronized (var4_5) {
                            try {
                                this.wait(25L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                        if (!this.abort) continue;
                        return;
                    }
                }
                while (this.paused) {
                    var4_6 = this;
                    synchronized (var4_6) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (this.abort) {
                            return;
                        }
                    }
                }
                bytesRead = this.stream.read(this.buffer, 0, this.buffer.length);
                if (bytesRead != -1) {
                    if (this.getLength() + (long)bytesRead > (long)this.maxCacheSize) {
                        Log.warning("MAX CACHESIZE of " + this.maxCacheSize + " reached ");
                        this.contentLength = totalBytesRead;
                        this.eosReached = true;
                    }
                    this.writeRAF.write(this.buffer, 0, bytesRead);
                    length = totalBytesRead += bytesRead;
                    this.setLength(length);
                    if (length == this.contentLength) {
                        this.eosReached = true;
                    }
                    if (this.listener != null && totalBytesRead >= nextUpdate) {
                        this.listener.downloadUpdate();
                        nextUpdate += this.numKiloBytesUpdateIncrement;
                    }
                } else {
                    this.setLength(totalBytesRead);
                    this.contentLength = totalBytesRead;
                    this.eosReached = true;
                }
                this.loadUpdate();
                continue;
            }
            catch (IOException e) {
                Log.warning(e + " : Check if you have enough space in the cache directory");
                this.ioException = true;
                this.eosReached = true;
                this.blockRead = false;
                break;
            }
lbl64:
            // 2 sources

            ** while (!this.eosReached)
        }
lbl65:
        // 2 sources

        if (this.listener != null) {
            this.listener.downloadUpdate();
        }
        if (this.writeRAF != null) {
            try {
                this.writeRAF.close();
                this.writeRAF = null;
            }
            catch (IOException e) {
                // empty catch block
            }
            this.writeRAF = null;
        }
    }

    void startDownload() {
        if (this.enabled && this.downloadThread != null) {
            this.downloadThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pauseDownload() {
        if (this.downloadThread != null && !this.downloadThread.isAlive()) {
            return;
        }
        if (this.enabled) {
            CachedPullSourceStream cachedPullSourceStream = this;
            synchronized (cachedPullSourceStream) {
                if (!this.paused) {
                    this.paused = true;
                    this.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeDownload() {
        if (this.downloadThread != null && !this.downloadThread.isAlive()) {
            return;
        }
        if (this.enabled) {
            CachedPullSourceStream cachedPullSourceStream = this;
            synchronized (cachedPullSourceStream) {
                if (this.paused) {
                    this.paused = false;
                    this.notify();
                }
            }
        }
    }

    public void abortDownload() {
        this.abort = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortRead() {
        CachedPullSourceStream cachedPullSourceStream = this;
        synchronized (cachedPullSourceStream) {
            this.readAborted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long seek(long where) {
        long l2;
        block25: {
            long l3;
            block24: {
                long l4;
                block23: {
                    long l5;
                    block21: {
                        long l6;
                        boolean debugTime = false;
                        CachedPullSourceStream cachedPullSourceStream = this;
                        synchronized (cachedPullSourceStream) {
                            this.readAborted = false;
                        }
                        try {
                            if (!(this.jitterEnabled && this.drainCondition(where) || where > this.getLength())) {
                                long l7 = this.doSeek(where);
                                Object var10_11 = null;
                                if (!this.jitterEnabled) return l7;
                                this.drainCondition(where);
                                return l7;
                            }
                            while (true) {
                                block22: {
                                    if (this.eosReached) {
                                        if (where <= this.getLength()) {
                                            l6 = this.doSeek(where);
                                            break;
                                        }
                                        l5 = -1L;
                                        break block21;
                                    }
                                    if (this.jitterEnabled) {
                                        CachedPullSourceStream cachedPullSourceStream2 = this;
                                        synchronized (cachedPullSourceStream2) {
                                            do {
                                                if (!this.blockRead) {
                                                    break block22;
                                                }
                                                try {
                                                    this.wait(100L);
                                                }
                                                catch (InterruptedException e2) {
                                                    // empty catch block
                                                }
                                            } while (!this.readAborted);
                                            this.readAborted = false;
                                            l4 = -2L;
                                        }
                                        break block23;
                                    }
                                }
                                if (this.readAborted) {
                                    this.readAborted = false;
                                    l3 = -2L;
                                    break block24;
                                }
                                if (where <= this.getLength()) {
                                    l2 = this.doSeek(where);
                                    break block25;
                                }
                                try {
                                    Thread.currentThread();
                                    Thread.sleep(250L);
                                }
                                catch (InterruptedException e3) {}
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_17 = null;
                            if (!this.jitterEnabled) throw throwable;
                            this.drainCondition(where);
                            throw throwable;
                        }
                        Object var10_12 = null;
                        if (!this.jitterEnabled) return l6;
                        this.drainCondition(where);
                        return l6;
                    }
                    Object var10_13 = null;
                    if (!this.jitterEnabled) return l5;
                    this.drainCondition(where);
                    return l5;
                }
                Object var10_14 = null;
                if (!this.jitterEnabled) return l4;
                this.drainCondition(where);
                return l4;
            }
            Object var10_15 = null;
            if (!this.jitterEnabled) return l3;
            this.drainCondition(where);
            return l3;
        }
        Object var10_16 = null;
        if (!this.jitterEnabled) return l2;
        this.drainCondition(where);
        return l2;
    }

    private long getWriteReadPtrOffset() {
        return this.getLength() - this.tell();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadUpdate() {
        if (this.blockRead && (this.eosReached || this.getWriteReadPtrOffset() >= (long)this.highMark)) {
            this.blockRead = false;
            CachedPullSourceStream cachedPullSourceStream = this;
            synchronized (cachedPullSourceStream) {
                this.notify();
            }
        }
    }

    private synchronized boolean drainCondition() {
        return this.drainCondition(this.tell());
    }

    private synchronized boolean drainCondition(long offset) {
        offset = this.getLength() - offset;
        if (this.eosReached) {
            if (this.blockRead) {
                this.blockRead = false;
                this.notify();
            }
            return false;
        }
        if (this.blockRead) {
            if (offset < (long)this.highMark) {
                return true;
            }
            this.blockRead = false;
            this.notify();
            return false;
        }
        if (offset < (long)this.lowMark) {
            this.blockRead = true;
            return true;
        }
        return false;
    }

    public boolean willReadBytesBlock(long offset, int numBytes) {
        if (this.jitterEnabled && this.drainCondition(offset)) {
            return true;
        }
        return offset + (long)numBytes > this.getLength();
    }

    public boolean willReadBytesBlock(int numBytes) {
        return this.willReadBytesBlock(this.tell(), numBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int waitUntilSeekWillSucceed(long where) throws IOException {
        boolean debugPrint = true;
        if (!(this.jitterEnabled && this.drainCondition(where) || where > this.getLength())) {
            return 0;
        }
        while (true) {
            if (this.eosReached) {
                if (where > this.getLength()) return -1;
                return 0;
            }
            if (this.jitterEnabled) {
                CachedPullSourceStream cachedPullSourceStream = this;
                synchronized (cachedPullSourceStream) {
                    while (this.blockRead) {
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException e2) {
                            // empty catch block
                        }
                        if (!this.readAborted) continue;
                        return -2;
                    }
                }
            }
            if (this.readAborted) {
                return -2;
            }
            if (where <= this.getLength()) {
                return 0;
            }
            try {
                Thread.currentThread();
                Thread.sleep(250L);
            }
            catch (InterruptedException e3) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long tell() {
        CachedPullSourceStream cachedPullSourceStream = this;
        synchronized (cachedPullSourceStream) {
            if (this.closed) {
                return -1L;
            }
            try {
                return this.readRAF.getFilePointer();
            }
            catch (IOException e2) {
                return -1L;
            }
        }
    }

    private synchronized long doSeek(long where) {
        if (this.closed) {
            return -1L;
        }
        try {
            this.readRAF.seek(where);
            return this.readRAF.getFilePointer();
        }
        catch (IOException e2) {
            return -1L;
        }
    }

    public synchronized int doRead(byte[] buffer, int offset, int length) throws IOException {
        if (this.closed) {
            return -1;
        }
        try {
            int actual = this.readRAF.read(buffer, offset, length);
            return actual;
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            e2.printStackTrace();
            return -2;
        }
    }

    private synchronized void doClose() {
        try {
            this.closed = true;
            if (this.readRAF != null) {
                this.readRAF.close();
            }
            if (this.writeRAF != null) {
                this.writeRAF.close();
            }
            if (this.file == null) {
                return;
            }
            this.deleteFile(this.file);
            this.file = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isRandomAccess() {
        if (this.enabled) {
            return true;
        }
        try {
            Seekable s = (Seekable)((Object)this.stream);
            return s.isRandomAccess();
        }
        catch (ClassCastException e2) {
            return false;
        }
    }

    public boolean willReadBlock() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int n2;
        block8: {
            int result;
            block6: {
                int n3;
                block7: {
                    block4: {
                        int n4;
                        block5: {
                            try {
                                result = this.waitUntilSeekWillSucceed(this.tell() + (long)length);
                                if (result != -1) break block4;
                                n4 = -1;
                                Object var8_6 = null;
                                if (!this.jitterEnabled) break block5;
                                this.drainCondition();
                            }
                            catch (Throwable throwable) {
                                block9: {
                                    Object var8_9 = null;
                                    if (!this.jitterEnabled) break block9;
                                    this.drainCondition();
                                }
                                throw throwable;
                            }
                        }
                        return n4;
                    }
                    if (result == -2) break block6;
                    n3 = this.doRead(buffer, offset, length);
                    Object var8_7 = null;
                    if (!this.jitterEnabled) break block7;
                    this.drainCondition();
                }
                return n3;
            }
            n2 = result;
            Object var8_8 = null;
            if (!this.jitterEnabled) break block8;
            this.drainCondition();
        }
        return n2;
    }

    public ContentDescriptor getContentDescriptor() {
        return null;
    }

    public boolean endOfStream() {
        return false;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String controlType) {
        return null;
    }

    void close() {
        if (!this.abort) {
            this.abortDownload();
        }
        if (this.downloadThread != null) {
            int i2 = 0;
            while (i2 < 20) {
                if (!this.downloadThread.isAlive()) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i2;
            }
        }
        this.doClose();
    }

    public long getContentLength() {
        return this.contentLength;
    }

    long getContentProgress() {
        return this.length;
    }

    void addDownloadProgressListener(DownloadProgressListener l2, int numKiloBytes) {
        this.listener = l2;
        if (numKiloBytes <= 0) {
            numKiloBytes = 1024;
        }
        this.numKiloBytesUpdateIncrement = numKiloBytes * 1024;
    }

    void removeDownloadProgressListener(DownloadProgressListener l2) {
        this.listener = null;
    }

    long getStartOffset() {
        return 0L;
    }

    long getEndOffset() {
        return this.length;
    }

    private boolean deleteFile(File file) {
        boolean fileDeleted = false;
        try {
            if (jmfSecurity != null) {
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 8);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                    }
                }
                catch (Exception e2) {
                    securityPrivelege = false;
                }
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor cons = jdk12DeleteFileAction.cons;
                Boolean success = (Boolean)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(file));
                fileDeleted = success;
            } else {
                fileDeleted = file.delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return fileDeleted;
    }

    boolean isDownloading() {
        if (this.eosReached) {
            return false;
        }
        return this.length != -1L;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

