/*
 * Decompiled with CFR 0.152.
 */
package jmapps.export;

import com.sun.media.rtp.RTPSessionMgr;
import com.sun.media.ui.PlayerWindow;
import com.sun.media.util.JMFI18N;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.Duration;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.Processor;
import javax.media.Time;
import javax.media.control.MonitorControl;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionManager;
import jmapps.export.PanelMediaSource;
import jmapps.export.PanelMediaTargetFile;
import jmapps.export.PanelMediaTargetFormat;
import jmapps.export.PanelMediaTargetNetwork;
import jmapps.export.PanelMediaTargetType;
import jmapps.export.TransmitPlayerWindow;
import jmapps.jmstudio.CaptureControlsDialog;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;
import jmapps.ui.ProgressDialog;
import jmapps.ui.ProgressThread;
import jmapps.ui.WizardDialog;
import jmapps.util.JMAppsCfg;
import jmapps.util.JMFUtils;

public class ExportWizard
extends WizardDialog
implements ControllerListener,
DataSinkListener {
    protected PanelMediaSource panelSource;
    protected PanelMediaTargetType panelTargetType;
    protected PanelMediaTargetFormat panelTargetFormat;
    protected PanelMediaTargetFile panelTargetFile;
    protected PanelMediaTargetNetwork panelTargetNetwork;
    protected String strTitle = JMFI18N.getResource("jmstudio.export.title");
    protected Processor processor = null;
    protected String strTargetType = null;
    protected boolean boolChangedProcessor = false;
    protected boolean boolChangedTargetType = false;
    protected String strFailMessage = null;
    protected DataSink dataSinkSave = null;
    protected ProgressDialog dlgProgressSave = null;
    protected ProgressThread threadProgressSave = null;
    protected TransmitPlayerWindow playerTransmit = null;
    protected CaptureControlsDialog dlgCaptureControls = null;
    protected Vector vectorWindowsLeft = new Vector();
    private JMAppsCfg cfgJMApps = null;
    Object stateLock = new Object();
    boolean stateFailed = false;

    public ExportWizard(String strTitle, Frame frame, String strSourceUrl, JMAppsCfg cfgJMApps) {
        super(frame, strTitle, true, "logo.gif");
        this.strTitle = strTitle;
        this.setTitle(strTitle);
        this.cfgJMApps = cfgJMApps;
        this.panelSource.setJMStudioCfg(cfgJMApps);
        this.panelSource.setSourceUrl(strSourceUrl);
        this.panelTargetNetwork.setJMStudioCfg(cfgJMApps);
    }

    public ExportWizard(Frame frame, String strSourceUrl, JMAppsCfg cfgJMApps) {
        this(JMFI18N.getResource("jmstudio.export.title"), frame, strSourceUrl, cfgJMApps);
    }

    public Vector getWindowsLeft() {
        return this.vectorWindowsLeft;
    }

    protected void init() throws Exception {
        super.init();
        this.panelSource = new PanelMediaSource(this.cfgJMApps);
        this.panelTargetType = new PanelMediaTargetType();
        this.panelTargetFormat = new PanelMediaTargetFormat();
        this.panelTargetFile = new PanelMediaTargetFile();
        this.panelTargetNetwork = new PanelMediaTargetNetwork(this.cfgJMApps);
        this.setSize(480, 480);
        this.setLocation(100, 100);
    }

    protected Panel getFirstPage() {
        return this.panelSource;
    }

    protected Panel getLastPage() {
        JMPanel panel = null;
        String strTargetType = this.panelTargetType.getType();
        if (strTargetType.equals(PanelMediaTargetType.TYPE_FILE)) {
            panel = this.panelTargetFile;
        } else if (strTargetType.equals(PanelMediaTargetType.TYPE_NETWORK)) {
            panel = this.panelTargetNetwork;
        } else if (strTargetType.equals(PanelMediaTargetType.TYPE_SCREEN)) {
            panel = this.panelTargetFormat;
        }
        return panel;
    }

    protected Panel getNextPage(Panel panelPage) {
        Panel panelPageNext = null;
        if (panelPage == null) {
            panelPageNext = this.getFirstPage();
        } else if (panelPage == this.panelSource) {
            panelPageNext = this.panelTargetType;
        } else if (panelPage == this.panelTargetType) {
            panelPageNext = this.panelTargetFormat;
        } else if (panelPage == this.panelTargetFormat) {
            String strTargetType = this.panelTargetType.getType();
            if (strTargetType.equals(PanelMediaTargetType.TYPE_FILE)) {
                panelPageNext = this.panelTargetFile;
            } else if (strTargetType.equals(PanelMediaTargetType.TYPE_NETWORK)) {
                panelPageNext = this.panelTargetNetwork;
            } else if (strTargetType.equals(PanelMediaTargetType.TYPE_SCREEN)) {
                panelPageNext = null;
            }
        } else {
            panelPageNext = null;
        }
        return panelPageNext;
    }

    protected Panel getPrevPage(Panel panelPage) {
        Panel panelPagePrev = null;
        panelPagePrev = panelPage == null ? this.getLastPage() : (panelPage == this.panelTargetNetwork ? this.panelTargetFormat : (panelPage == this.panelTargetFile ? this.panelTargetFormat : (panelPage == this.panelTargetFile ? this.panelTargetFormat : (panelPage == this.panelTargetFormat ? this.panelTargetType : (panelPage == this.panelTargetType ? this.panelSource : null)))));
        return panelPagePrev;
    }

    protected boolean onPageDone(Panel panelPage) {
        if (panelPage == this.panelSource) {
            this.setCursor(new Cursor(3));
            this.processor = this.panelSource.createProcessor();
            if (this.processor != null) {
                this.processor.addControllerListener(this);
                this.configureProcessor();
            }
            this.setCursor(Cursor.getDefaultCursor());
            if (this.processor == null) {
                this.panelSource.setDataSource(null);
                this.setTitle(this.strTitle);
                return false;
            }
            this.boolChangedProcessor = true;
            this.setTitle(this.strTitle + " " + this.panelSource.getSourceUrl());
            this.panelSource.SaveData();
        } else if (panelPage == this.panelTargetType) {
            if (this.strTargetType == null || !this.panelTargetType.getType().equals(this.strTargetType)) {
                this.strTargetType = this.panelTargetType.getType();
                this.boolChangedTargetType = true;
            }
        } else if (panelPage == this.panelTargetNetwork) {
            if (!this.panelTargetNetwork.checkValidFields(true)) {
                return false;
            }
            this.panelTargetNetwork.saveData();
        }
        return true;
    }

    protected boolean onPageActivate(Panel panelPage) {
        if (panelPage == this.panelSource) {
            this.setTitle(this.strTitle);
        } else if (panelPage == this.panelTargetFormat) {
            if (this.boolChangedProcessor || this.boolChangedTargetType) {
                this.setCursor(new Cursor(3));
                String strContentType = this.panelSource.getDefaultContentType();
                this.panelTargetFormat.setProcessor(this.processor, strContentType, this.strTargetType);
                this.boolChangedProcessor = false;
                this.boolChangedTargetType = false;
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else if (panelPage != this.panelTargetFile && panelPage == this.panelTargetNetwork) {
            this.panelTargetNetwork.setTracks(this.panelTargetFormat.getEnabledVideoTracks(), this.panelTargetFormat.getEnabledAudioTracks());
        }
        return true;
    }

    protected boolean onFinish() {
        this.setCursor(new Cursor(3));
        boolean boolResult = this.strTargetType == null ? false : (this.strTargetType.equals(PanelMediaTargetType.TYPE_FILE) ? this.doSaveFile() : (this.strTargetType.equals(PanelMediaTargetType.TYPE_NETWORK) ? this.doTransmit() : (this.strTargetType.equals(PanelMediaTargetType.TYPE_SCREEN) ? this.doPreview() : false)));
        this.setCursor(Cursor.getDefaultCursor());
        return boolResult;
    }

    private void configureProcessor() {
        if (this.processor == null) {
            return;
        }
        boolean boolResult = this.waitForState(this.processor, 180);
        if (!boolResult) {
            MessageDialog.createErrorDialog(this.frameOwner, this.strFailMessage);
            this.destroyProcessor();
        }
    }

    private void realizeProcessor() {
        if (this.processor == null) {
            return;
        }
        boolean boolResult = this.waitForState(this.processor, 300);
        if (!boolResult) {
            MessageDialog.createErrorDialog(this.frameOwner, this.strFailMessage);
            this.destroyProcessor();
        }
    }

    private void destroyProcessor() {
        if (this.processor == null) {
            return;
        }
        this.processor.removeControllerListener(this);
        this.processor.close();
        this.processor = null;
        this.panelSource.setDataSource(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean waitForState(Processor p, int state) {
        StateListener sl = new StateListener();
        p.addControllerListener(sl);
        this.stateFailed = false;
        if (state == 180) {
            p.configure();
        } else if (state == 300) {
            p.realize();
        }
        while (p.getState() < state && !this.stateFailed) {
            Object object = this.stateLock;
            synchronized (object) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException ie) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        p.removeControllerListener(sl);
        return !this.stateFailed;
    }

    private boolean doSaveFile() {
        MonitorControl monitorControl = null;
        Component monitor = null;
        if (this.processor == null) {
            return false;
        }
        this.panelTargetFormat.updateProcessorFormat();
        this.realizeProcessor();
        if (this.processor == null) {
            return false;
        }
        DataSource dsOutput = this.processor.getDataOutput();
        if (dsOutput == null) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.creatednooutput"));
            this.destroyProcessor();
            return false;
        }
        try {
            String strFileName = this.panelTargetFile.getFileName();
            MediaLocator mediaDest = new MediaLocator("file:" + strFileName);
            this.dataSinkSave = Manager.createDataSink(dsOutput, mediaDest);
        }
        catch (Exception exception) {
            this.stopSaving();
            MessageDialog.createErrorDialog(this.frameOwner, exception);
            return false;
        }
        try {
            this.dataSinkSave.addDataSinkListener(this);
            monitorControl = (MonitorControl)this.processor.getControl("javax.media.control.MonitorControl");
            if (monitorControl != null) {
                monitor = monitorControl.getControlComponent();
            }
            Time duration = this.processor.getDuration();
            int nMediaDuration = (int)duration.getSeconds();
            this.dataSinkSave.open();
            this.dataSinkSave.start();
            this.processor.start();
            this.dlgProgressSave = nMediaDuration > 0 && duration != Duration.DURATION_UNBOUNDED && duration != Duration.DURATION_UNKNOWN ? new ProgressDialog(this.frameOwner, JMFI18N.getResource("jmstudio.saveprogress.title"), 0, nMediaDuration, (ActionListener)this) : new ProgressDialog(this.frameOwner, JMFI18N.getResource("jmstudio.saveprogress.title"), JMFI18N.getResource("jmstudio.saveprogress.label"), monitor, (ActionListener)this);
            this.dlgProgressSave.setVisible(true);
            this.threadProgressSave = new ProgressThread(this.processor, this.dlgProgressSave);
            this.threadProgressSave.start();
            this.vectorWindowsLeft.addElement(this.dlgProgressSave);
        }
        catch (Exception exception) {
            this.stopSaving();
            MessageDialog.createErrorDialog(this.frameOwner, exception);
        }
        return true;
    }

    private boolean doTransmit() {
        String strAudio = JMFI18N.getResource("jmstudio.export.targetnw.audio");
        String strVideo = JMFI18N.getResource("jmstudio.export.targetnw.video");
        if (this.processor == null) {
            return false;
        }
        this.panelSource.setCaptureDlg(null);
        this.panelTargetFormat.updateProcessorFormat();
        this.realizeProcessor();
        if (this.processor == null) {
            return false;
        }
        DataSource dsOutput = this.processor.getDataOutput();
        if (dsOutput == null) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.creatednooutput"));
            this.destroyProcessor();
            return false;
        }
        if (!(dsOutput instanceof PushBufferDataSource)) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.outputincorrect"));
            this.destroyProcessor();
            return false;
        }
        PushBufferStream[] arrStreams = ((PushBufferDataSource)dsOutput).getStreams();
        if (arrStreams == null) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.outputempty"));
            this.destroyProcessor();
            return false;
        }
        boolean[] arrVideoEnabled = this.panelTargetFormat.getEnabledVideoTracks();
        boolean[] arrAudioEnabled = this.panelTargetFormat.getEnabledAudioTracks();
        String[] arrVideoAddresses = this.panelTargetNetwork.getVideoAddresses();
        String[] arrAudioAddresses = this.panelTargetNetwork.getAudioAddresses();
        String[] arrVideoPorts = this.panelTargetNetwork.getVideoPorts();
        String[] arrAudioPorts = this.panelTargetNetwork.getAudioPorts();
        String[] arrVideoTtls = this.panelTargetNetwork.getVideoTtls();
        String[] arrAudioTtls = this.panelTargetNetwork.getAudioTtls();
        TrackControl[] arrTrackControls = this.processor.getTrackControls();
        int nVideoIndex = 0;
        int nAudioIndex = 0;
        boolean boolSucceeded = false;
        int i2 = 0;
        while (i2 < arrStreams.length) {
            block19: {
                String strStreamLabel;
                String strTtl;
                String strPort;
                String strAddress;
                block20: {
                    Format format;
                    block18: {
                        format = arrStreams[i2].getFormat();
                        if (!(format instanceof VideoFormat)) break block18;
                        while (nVideoIndex < arrVideoEnabled.length && !arrVideoEnabled[nVideoIndex]) {
                            ++nVideoIndex;
                        }
                        if (nVideoIndex >= arrVideoEnabled.length) break block19;
                        strAddress = arrVideoAddresses[nVideoIndex];
                        strPort = arrVideoPorts[nVideoIndex];
                        strTtl = arrVideoTtls[nVideoIndex];
                        strStreamLabel = strVideo + " " + ++nVideoIndex;
                        break block20;
                    }
                    if (!(format instanceof AudioFormat)) break block19;
                    while (nAudioIndex < arrAudioEnabled.length && !arrAudioEnabled[nAudioIndex]) {
                        ++nAudioIndex;
                    }
                    if (nAudioIndex >= arrAudioEnabled.length) break block19;
                    strAddress = arrAudioAddresses[nAudioIndex];
                    strPort = arrAudioPorts[nAudioIndex];
                    strTtl = arrAudioTtls[nAudioIndex];
                    strStreamLabel = strAudio + " " + ++nAudioIndex;
                }
                try {
                    if (!strAddress.equals("...") && !strPort.equals("")) {
                        RTPSessionMgr managerSession = JMFUtils.createSessionManager(strAddress, strPort, strTtl, null);
                        if (managerSession == null) {
                            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.createsessionmanager"));
                            this.destroyProcessor();
                            return false;
                        }
                        SendStream streamSend = managerSession.createSendStream(dsOutput, i2);
                        streamSend.start();
                        if (!boolSucceeded) {
                            this.createTransmitWindow();
                        }
                        boolSucceeded = true;
                        this.addTransmitSessionManager(managerSession, streamSend, strStreamLabel);
                    }
                }
                catch (Exception exception) {
                    MessageDialog.createErrorDialog(this.frameOwner, exception);
                    this.destroyProcessor();
                    return false;
                }
            }
            ++i2;
        }
        this.dlgCaptureControls = this.panelSource.getCaptureControlsDialog();
        if (this.dlgCaptureControls != null && !this.dlgCaptureControls.isEmpty()) {
            this.dlgCaptureControls.setVisible(true);
        }
        if (!boolSucceeded) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.transmittracks"));
            this.destroyProcessor();
        }
        return boolSucceeded;
    }

    protected void createTransmitWindow() {
        if (this.processor == null) {
            return;
        }
        this.playerTransmit = new TransmitPlayerWindow(this.processor);
        this.playerTransmit.addWindowListener(this);
        this.vectorWindowsLeft.addElement(this.playerTransmit);
    }

    protected void addTransmitSessionManager(SessionManager mngrSession, SendStream streamSend, String strStreamLabel) {
        if (this.playerTransmit == null) {
            return;
        }
        this.playerTransmit.addSessionManager(mngrSession, streamSend, strStreamLabel);
    }

    private boolean doPreview() {
        if (this.processor == null) {
            return false;
        }
        this.panelTargetFormat.updateProcessorFormat();
        this.realizeProcessor();
        if (this.processor == null) {
            return false;
        }
        DataSource dsOutput = this.processor.getDataOutput();
        if (dsOutput == null) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.creatednooutput"));
            this.destroyProcessor();
            return false;
        }
        try {
            Player player = Manager.createPlayer(dsOutput);
            if (player == null) {
                MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.player.create"));
                this.destroyProcessor();
                return false;
            }
            PlayerWindow windowPlayer = new PlayerWindow(player, JMFI18N.getResource("jmstudio.playerwindow.preview"));
            this.vectorWindowsLeft.addElement(windowPlayer);
            windowPlayer = new PlayerWindow(this.processor, JMFI18N.getResource("jmstudio.playerwindow.transcoding"));
            this.vectorWindowsLeft.addElement(windowPlayer);
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.player.create"), exception);
            this.destroyProcessor();
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent event) {
        String strCmd = event.getActionCommand();
        if ((strCmd.equals(ProgressDialog.ACTION_ABORT) || strCmd.equals(ProgressDialog.ACTION_STOP)) && this.dataSinkSave != null) {
            this.stopSaving();
        } else if (strCmd.equals(ProgressDialog.ACTION_PAUSE) && this.dataSinkSave != null) {
            this.processor.stop();
            this.dlgProgressSave.setPauseButtonText(ProgressDialog.ACTION_RESUME);
            this.threadProgressSave.pauseThread();
        } else if (strCmd.equals(ProgressDialog.ACTION_RESUME) && this.dataSinkSave != null) {
            this.processor.start();
            this.dlgProgressSave.setPauseButtonText(ProgressDialog.ACTION_PAUSE);
            this.threadProgressSave.resumeThread();
        } else {
            super.actionPerformed(event);
        }
    }

    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof ControllerErrorEvent) {
            this.strFailMessage = JMFI18N.getResource("jmstudio.error.controller") + "\n" + ((ControllerErrorEvent)event).getMessage();
        } else if (event instanceof EndOfMediaEvent && this.strTargetType.equals(PanelMediaTargetType.TYPE_FILE)) {
            this.stopSaving();
        }
    }

    public void dataSinkUpdate(DataSinkEvent event) {
        if (event instanceof EndOfStreamEvent) {
            this.closeDataSink();
        } else if (event instanceof DataSinkErrorEvent) {
            this.stopSaving();
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.writefile"));
        }
    }

    public void windowClosed(WindowEvent event) {
        Object objSource = event.getSource();
        if (objSource == this.playerTransmit) {
            if (this.dlgCaptureControls != null) {
                this.dlgCaptureControls.dispose();
                this.dlgCaptureControls = null;
            }
            this.playerTransmit = null;
        }
        if (this.getAction().equals(WizardDialog.ACTION_CANCEL)) {
            this.destroyProcessor();
        }
    }

    private void stopSaving() {
        if (this.threadProgressSave != null) {
            this.threadProgressSave.terminateNormaly();
            this.threadProgressSave = null;
        }
        if (this.processor != null) {
            this.processor.stop();
            this.destroyProcessor();
        }
        if (this.dlgProgressSave != null) {
            this.dlgProgressSave.dispose();
            this.dlgProgressSave = null;
        }
    }

    private synchronized void closeDataSink() {
        if (this.dataSinkSave != null) {
            this.dataSinkSave.close();
            this.dataSinkSave = null;
        }
    }

    class StateListener
    implements ControllerListener {
        StateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof ControllerClosedEvent) {
                ExportWizard.this.stateFailed = true;
            }
            if (ce instanceof ControllerEvent) {
                Object object = ExportWizard.this.stateLock;
                synchronized (object) {
                    ExportWizard.this.stateLock.notifyAll();
                }
            }
        }
    }
}

