/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Executer;
import ij.History;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.EuHouToolbar;
import ij.gui.ImageWindow;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.io.Opener;
import ij.macro.Interpreter;
import ij.macro.MacroRunner;
import ij.plugin.MacroInstaller;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageProducer;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class ImageJ
extends Frame
implements ActionListener,
MouseListener,
KeyListener,
WindowListener,
ItemListener,
FocusListener,
AWTEventListener {
    public static final String VERSION = "1.1";
    public static Color backgroundColor = new Color(255, 255, 81);
    private static final String IJ_X = "ij.x";
    private static final String IJ_Y = "ij.y";
    private static final String RESULTS_X = "results.x";
    private static final String RESULTS_Y = "results.y";
    private static final String RESULTS_WIDTH = "results.width";
    private static final String RESULTS_HEIGHT = "results.height";
    private Toolbar toolbar;
    private Panel statusBar;
    private ProgressBar progressBar;
    private Label statusLine;
    private Panel euHouExtra;
    private EuHouToolbar euHouTool;
    private boolean firstTime = true;
    private Applet applet;
    private Vector classes = new Vector();
    private boolean exitWhenQuiting;
    boolean hotkey;
    private Locale lang;
    private ResourceBundle menubun;
    private ResourceBundle plgbun;
    private ResourceBundle colorbun;
    private ResourceBundle blitbun;
    private static History hist;
    public static long TMS;

    public ImageJ() {
        this((Applet)null);
    }

    public ImageJ(Applet applet) {
        super("SalsaJ");
        int nMacros;
        this.applet = applet;
        this.lang = Locale.getDefault();
        if (this.lang == null) {
            this.lang = Locale.ENGLISH;
        }
        this.menubun = ResourceBundle.getBundle("ij/i18n/MenusBundle", this.lang);
        this.plgbun = ResourceBundle.getBundle("ij/i18n/PluginBundle", this.lang);
        this.colorbun = ResourceBundle.getBundle("ij/i18n/ColorBundle", this.lang);
        this.blitbun = ResourceBundle.getBundle("ij/i18n/BlitterBundle", this.lang);
        IJ.setLocale(this.lang);
        IJ.setBundle(this.menubun);
        IJ.setPluginBundle(this.plgbun);
        IJ.setColorBundle(this.colorbun);
        IJ.setOpBundle(this.blitbun);
        String err1 = Prefs.load(this, applet);
        if (err1 != null) {
            IJ.error(err1);
        }
        IJ.setExecLevel(Prefs.getInt("ExecLevel", 2));
        Menus m = new Menus(this, applet);
        String err2 = m.addMenuBar();
        m.installPopupMenu(this);
        this.setLayout(new GridLayout(2, 1));
        ImageJ.createHistory(this);
        History.synchronizeHistory(m.getMenuBar().getMenu(0), true);
        this.toolbar = new Toolbar();
        this.toolbar.addKeyListener(this);
        this.toolbar.setBackground(new Color(255, 255, 81));
        Panel interPanel = new Panel();
        interPanel.setLayout(new BorderLayout());
        this.euHouTool = new EuHouToolbar();
        this.euHouTool.addKeyListener(this);
        int euHouWidth = (int)this.euHouTool.getSize().getWidth() + (int)this.toolbar.getSize().getWidth() + 10;
        interPanel.setSize(euHouWidth, this.toolbar.getSize().height + 1);
        interPanel.add((Component)this.euHouTool, "West");
        interPanel.add((Component)this.toolbar, "East");
        this.add(interPanel);
        this.statusBar = new Panel();
        this.statusBar.setLayout(new GridLayout(1, 3));
        this.statusBar.setForeground(Color.black);
        this.statusBar.setBackground(backgroundColor);
        this.statusLine = new Label();
        this.statusLine.addKeyListener(this);
        this.statusLine.addMouseListener(this);
        this.statusBar.add(this.statusLine);
        this.euHouExtra = new Panel();
        this.statusBar.add(this.euHouExtra);
        this.progressBar = new ProgressBar(100, 18);
        this.progressBar.addKeyListener(this);
        this.progressBar.addMouseListener(this);
        this.statusBar.add(this.progressBar);
        this.statusBar.setSize(euHouWidth, this.toolbar.getSize().height);
        this.add(this.statusBar);
        IJ.init(this, applet);
        this.addKeyListener(this);
        this.addWindowListener(this);
        this.addFocusListener(this);
        Point loc = new Point(5, 0);
        int ijWidth = euHouWidth;
        int ijHeight = 100;
        this.setCursor(Cursor.getDefaultCursor());
        this.setIcon();
        this.setBounds(loc.x, loc.y, ijWidth, ijHeight);
        this.setLocation(loc.x, loc.y);
        this.pack();
        this.setSize(ijWidth, this.getSize().height);
        this.setResizable(false);
        this.show();
        if (IJ.isMacOSX()) {
            this.setLocation(loc.x + 1, loc.y + 1);
            this.setLocation(loc.x, loc.y);
            this.pack();
        }
        if (err2 != null) {
            IJ.error(err2);
        }
        if (IJ.isMacintosh()) {
            IJ.runPlugIn("QuitHandler", "");
        }
        if (IJ.isJava2() && applet == null) {
            IJ.runPlugIn("ij.plugin.DragAndDrop", "");
        }
        String str = (nMacros = m.installMacros()) <= 1 ? this.menubun.getString("Mak") + ")" : this.menubun.getString("Mak") + "s)";
        IJ.showStatus(this.menubun.getString("Version") + VERSION + " (" + Menus.nPlugins + " " + this.menubun.getString("Cmd") + " " + nMacros + " " + str);
    }

    void showResults() {
        TextWindow resultsWindow = new TextWindow(this.menubun.getString("Results"), "", 300, 200);
        TextPanel textPanel = resultsWindow.getTextPanel();
        textPanel.addKeyListener(this);
        IJ.setTextPanel(textPanel);
    }

    void setIcon() {
        URL url = this.getClass().getClassLoader().getResource("image/ico3.png");
        if (url == null) {
            return;
        }
        Image img = null;
        try {
            img = this.createImage((ImageProducer)url.getContent());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (img != null) {
            this.setIconImage(img);
        }
    }

    public Point getPreferredLocation() {
        int windowWidth;
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int ijX = Prefs.getInt(IJ_X, -99);
        int ijY = Prefs.getInt(IJ_Y, -99);
        if (ijX != -99 && ijY != -99 && ijX < screenWidth - 75) {
            return new Point(ijX, ijY);
        }
        Dimension tbsize = this.toolbar.getPreferredSize();
        double percent = screenWidth > 832 ? 0.8 : 0.9;
        int windowX = (int)(percent * (double)(screenWidth - (windowWidth = tbsize.width + 10)));
        if (windowX < 10) {
            windowX = 10;
        }
        int windowY = 0;
        return new Point(windowX, windowY);
    }

    void showStatus(String s) {
        this.statusLine.setText(s);
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    void doCommand(String name) {
        new Executer(name, WindowManager.getCurrentImage());
    }

    void doCommand(String name, ImageWindow win) {
        new Executer(name, win.getImagePlus());
    }

    public void runFilterPlugIn(Object theFilter, String cmd, String arg) {
        IJ.runFilterPlugIn(theFilter, cmd, arg);
    }

    public Object runUserPlugIn(String commandName, String className, String arg, boolean createNewLoader) {
        return IJ.runUserPlugIn(commandName, className, arg, createNewLoader);
    }

    public static String modifiers(int flags) {
        String s = " [ ";
        if (flags == 0) {
            return "";
        }
        if ((flags & 1) != 0) {
            s = s + "Shift ";
        }
        if ((flags & 2) != 0) {
            s = s + "Control ";
        }
        if ((flags & 4) != 0) {
            s = s + "Meta ";
        }
        if ((flags & 8) != 0) {
            s = s + "Alt ";
        }
        s = s + "] ";
        return s;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof MenuItem) {
            MenuItem item = (MenuItem)e.getSource();
            String cmd = e.getActionCommand();
            this.hotkey = false;
            if (cmd != null) {
                Menu m;
                Menu menu_selected;
                if (cmd.equals(this.menubun.getString("Quit"))) {
                    WindowManager.prepareExit();
                }
                if ((menu_selected = (Menu)item.getParent()) == (m = this.getMenuBar().getMenu(0))) {
                    if (History.isHistoryMenuItem(item)) {
                        int which_menu_item = History.whichHistoryMenuItem(item);
                        new Opener().open(History.getFileHistoryCurrent(which_menu_item));
                    } else {
                        this.doCommand(cmd);
                    }
                } else {
                    this.doCommand(cmd);
                }
            }
            if (IJ.debugMode) {
                IJ.log("actionPerformed: " + e);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        MenuItem item = (MenuItem)e.getSource();
        MenuComponent parent = (MenuComponent)((Object)item.getParent());
        String cmd = e.getItem().toString();
        if ((Menu)parent == Menus.window) {
            WindowManager.activateWindow(cmd, item);
        } else {
            this.doCommand(cmd);
        }
    }

    public void mousePressed(MouseEvent e) {
        Undo.reset();
        IJ.showStatus(IJ.freeMemory());
        if (IJ.debugMode) {
            IJ.log("Windows: " + WindowManager.getWindowCount());
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        Roi roi;
        boolean isStack;
        int keyCode = e.getKeyCode();
        IJ.setKeyDown(keyCode);
        this.hotkey = false;
        if (keyCode == 17 || keyCode == 16) {
            return;
        }
        char keyChar = e.getKeyChar();
        int flags = e.getModifiers();
        if (IJ.debugMode) {
            IJ.log("keyCode=" + keyCode + " (" + KeyEvent.getKeyText(keyCode) + ") keyChar=\"" + keyChar + "\" (" + keyChar + ") " + KeyEvent.getKeyModifiersText(flags));
        }
        boolean shift = (flags & 1) != 0;
        boolean control = (flags & 2) != 0;
        boolean alt = (flags & 8) != 0;
        String c = "";
        Frame win = WindowManager.getFrontWindow();
        ImagePlus imp = win instanceof ImageWindow ? ((ImageWindow)win).getImagePlus() : WindowManager.getCurrentImage();
        boolean bl = isStack = imp != null && imp.getStackSize() > 1;
        if (imp != null && !control && (keyChar >= ' ' && keyChar <= '\u00ff' || keyChar == '\b' || keyChar == '\n') && (roi = imp.getRoi()) instanceof TextRoi) {
            if (alt) {
                switch (keyChar) {
                    case 'm': 
                    case 'u': {
                        keyChar = '\u00b5';
                        break;
                    }
                    case 'A': {
                        keyChar = '?';
                        break;
                    }
                }
            }
            ((TextRoi)roi).addChar(keyChar);
            return;
        }
        Hashtable shortcuts = Menus.getShortcuts();
        c = shift ? (String)shortcuts.get(new Integer(keyCode + 200)) : (String)shortcuts.get(new Integer(keyCode));
        if (c == null) {
            switch (keyChar) {
                case '\t': {
                    WindowManager.putBehind();
                    return;
                }
                case '\b': {
                    if (EuHouToolbar.photometerSelected()) {
                        c = null;
                        break;
                    }
                    c = Prefs.getString("popup07");
                    this.hotkey = true;
                    break;
                }
                case '=': 
                case '\u00bb': {
                    String srt = Prefs.getString("stacks15");
                    c = srt.substring(1, srt.lastIndexOf(44) - 1);
                    break;
                }
                case '/': 
                case '\u00bf': {
                    String srt = Prefs.getString("stacks10");
                    c = srt.substring(1, srt.lastIndexOf(44) - 1);
                    break;
                }
                case '\u0099': 
                case '\u00bc': {
                    String srt = Prefs.getString("stacks04");
                    c = srt.substring(1, srt.lastIndexOf(44) - 1);
                    break;
                }
                case '\u00a0': 
                case '\u00be': {
                    String srt = Prefs.getString("stacks03");
                    c = srt.substring(1, srt.lastIndexOf(44) - 1);
                    break;
                }
                case '%': 
                case '&': 
                case '\'': 
                case '(': {
                    Roi roi2 = null;
                    if (imp != null) {
                        roi2 = imp.getRoi();
                    }
                    if (roi2 == null || EuHouToolbar.photometerSelected()) {
                        return;
                    }
                    if ((flags & 8) != 0) {
                        roi2.nudgeCorner(keyCode);
                    } else {
                        roi2.nudge(keyCode);
                    }
                    return;
                }
                case '\u001b': {
                    if (imp != null) {
                        imp.getWindow().running = false;
                    }
                    Macro.abort();
                    Interpreter.abort();
                    if (Interpreter.getInstance() != null) {
                        IJ.beep();
                    }
                    return;
                }
                case '\n': {
                    this.toFront();
                    return;
                }
            }
        }
        if (c != null && !c.equals("")) {
            if (c.equals(Prefs.getString("popup08"))) {
                this.hotkey = true;
            }
            if (c.charAt(0) == '^') {
                MacroInstaller.doShortcut(c);
            } else {
                this.doCommand(c);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        IJ.setKeyUp(e.getKeyCode());
    }

    public void keyTyped(KeyEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        boolean quit = true;
        if (Menus.window.getItemCount() > 5) {
            quit = IJ.showMessageWithCancel("SalsaJ", this.menubun.getString("QuitMessage"));
        }
        if (quit) {
            this.doCommand(this.menubun.getString("Quit"));
        }
    }

    public void windowActivated(WindowEvent e) {
        if (IJ.isMacintosh()) {
            this.setMenuBar(Menus.getMenuBar());
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void eventDispatched(AWTEvent e) {
        if (((long)e.getID() & 4L) != 0L) {
            if (e.paramString().startsWith("FOCUS_LOST")) {
                TMS = System.currentTimeMillis();
            } else {
                for (Component c = (Component)e.getSource(); c != null; c = c.getParent()) {
                    for (Class<?> cc = c.getClass(); cc != null; cc = cc.getSuperclass()) {
                        String cn = cc.getName();
                        if (!cn.equals("Frame")) continue;
                        String name = ((Frame)c).getTitle();
                        int j = 4;
                        if (j >= Menus.window.getItemCount()) continue;
                        String ms = Menus.window.getItem(j).getLabel();
                        int k = ms.indexOf(32);
                        if (k > 0) {
                            ms = ms.substring(0, k - 1);
                        }
                        if (ms.equals(name)) {
                            WindowManager.activateWindow(name, Menus.window.getItem(j));
                        }
                        return;
                    }
                }
            }
        }
    }

    public void focusLost(FocusEvent e) {
        TMS = System.currentTimeMillis();
    }

    public void focusGained(FocusEvent e) {
    }

    public void register(Class c) {
        if (!this.classes.contains(c)) {
            this.classes.addElement(c);
        }
    }

    public void quit() {
        if (!WindowManager.closeAllWindows()) {
            return;
        }
        if (this.applet == null) {
            Prefs.savePreferences();
            hist.saveHistoryOfFiles();
        }
        this.setVisible(false);
        this.dispose();
        if (this.exitWhenQuiting) {
            System.exit(0);
        }
    }

    public void savePreferences(Properties prefs) {
        Point loc = this.getLocation();
        prefs.put(IJ_X, Integer.toString(loc.x));
        prefs.put(IJ_Y, Integer.toString(loc.y));
    }

    public Locale getLocale() {
        return this.lang;
    }

    public static void createHistory(ImageJ ij) {
        hist = new History(History.max_nb_files_history, ij);
    }

    public static void destroyHistory() {
        hist = null;
    }

    public static History getHistory() {
        return hist;
    }

    public static void main(String[] args) {
        ImageJ ij = IJ.getInstance();
        if (ij == null || ij != null && !ij.isShowing()) {
            ij = new ImageJ(null);
            ij.exitWhenQuiting = true;
        }
        boolean macroStarted = false;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].endsWith(".txt")) {
                    if (macroStarted) {
                        new Opener().open(args[i]);
                        continue;
                    }
                    new MacroRunner(new File(args[i]));
                    macroStarted = true;
                    continue;
                }
                Opener opener = new Opener();
                ImagePlus imp = opener.openImage(args[i]);
                if (imp == null) continue;
                imp.show();
            }
        }
    }
}

