/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.NewImage;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class PlotWindow
extends ImageWindow
implements ActionListener,
ClipboardOwner {
    public static final int CIRCLE = 0;
    public static final int X = 1;
    public static final int LINE = 2;
    private static final int LEFT_MARGIN = 50;
    private static final int RIGHT_MARGIN = 20;
    private static final int TOP_MARGIN = 20;
    private static final int BOTTOM_MARGIN = 30;
    private static final int WIDTH = 450;
    private static final int HEIGHT = 200;
    private static final String MIN = "pp.min";
    private static final String MAX = "pp.max";
    private static final String PLOT_WIDTH = "pp.width";
    private static final String PLOT_HEIGHT = "pp.height";
    private static final String OPTIONS = "pp.options";
    private static final int SAVE_X_VALUES = 1;
    private static final int AUTO_CLOSE = 2;
    private int frameWidth;
    private int frameHeight;
    private int xloc;
    private int yloc;
    private Rectangle frame = null;
    private float[] xValues;
    private float[] yValues;
    private float[] xInitValues;
    private float[] yInitValues;
    private float[] errorBars;
    private int nPoints;
    private double xScale;
    private double yScale;
    private double xMin;
    private double xMax;
    private double xInitMin;
    private double xInitMax;
    private double yMin;
    private double yMax;
    private Button list;
    private Button save;
    private Button copy;
    private Button setting;
    private Button setScale;
    private Button option;
    private Label Xcoord;
    private Label Ycoord;
    private static String defaultDirectory = null;
    private String xLabel;
    private String yLabel;
    private Font font = new Font("Helvetica", 0, 12);
    private boolean fixedYScale;
    private ImageProcessor ip;
    private static int options;
    private int lineWidth = Line.getWidth();
    private int defaultDigits = -1;
    private boolean realNumbers;
    private int xdigits;
    private int ydigits;
    private boolean modifListener = false;
    private int oldX = -1;
    private int oldY = -1;
    private int oldindex = -1;
    private int[] Xpoints;
    private int[] Ypoints;
    public static boolean saveXValues;
    public static boolean autoClose;
    public static int plotWidth;
    public static int plotHeight;
    private ImagePlus origin;
    private Roi region;
    private static boolean horizontal;
    private Vector labels = new Vector();
    private Vector xlabs = new Vector();
    private Vector ylabs = new Vector();

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, float[] xInitValues, float[] yInitValues) {
        super(NewImage.createByteImage(title, plotWidth + 50 + 20, plotHeight + 20 + 30, 1, 0), false);
        IJ.showProgress(0.1);
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.xValues = xValues;
        this.yValues = yValues;
        this.xInitValues = xInitValues;
        this.yInitValues = yInitValues;
        double[] a = Tools.getMinMax(xValues);
        this.xMin = a[0];
        this.xMax = a[1];
        a = Tools.getMinMax(xInitValues);
        this.xInitMin = a[0];
        this.xInitMax = a[1];
        a = Tools.getMinMax(yValues);
        this.yMin = a[0];
        this.yMax = a[1];
        this.fixedYScale = false;
        this.nPoints = xValues.length;
        Panel buttons = new Panel();
        buttons.setLayout(new GridLayout(3, 3));
        this.list = new Button(IJ.getBundle().getString("List"));
        this.list.addActionListener(this);
        buttons.add(this.list);
        this.save = new Button(IJ.getBundle().getString("Save"));
        this.save.addActionListener(this);
        buttons.add(this.save);
        this.copy = new Button(IJ.getBundle().getString("Copy"));
        this.copy.addActionListener(this);
        buttons.add(this.copy);
        this.setting = new Button(IJ.getBundle().getString("Prop"));
        this.setting.addActionListener(this);
        buttons.add(this.setting);
        this.setScale = new Button(IJ.getBundle().getString("Set_Scale"));
        this.setScale.addActionListener(this);
        buttons.add(this.setScale);
        this.option = new Button(IJ.getPluginBundle().getString("ProOptTitle"));
        this.option.addActionListener(this);
        buttons.add(this.option);
        buttons.add(new Label(""));
        this.Xcoord = new Label("     ");
        this.Xcoord.setFont(new Font("Monospaced", 0, 12));
        buttons.add(this.Xcoord);
        this.Ycoord = new Label("     ");
        this.Ycoord.setFont(new Font("Monospaced", 0, 12));
        buttons.add(this.Ycoord);
        this.add(buttons);
        this.pack();
        IJ.getTextPanel().setFont(new Font("Monospaced", 0, 12));
    }

    public PlotWindow(String title, String xLabel, String yLabel, double[] xValues, double[] yValues) {
        this(title, xLabel, yLabel, Tools.toFloat(xValues), Tools.toFloat(yValues), Tools.toFloat(xValues), Tools.toFloat(yValues));
        horizontal = false;
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        this(title, xLabel, yLabel, xValues, yValues, xValues, yValues);
        horizontal = false;
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, ImagePlus origin) {
        this(title, xLabel, yLabel, xValues, yValues);
        this.origin = origin;
        horizontal = false;
    }

    public PlotWindow(String title, String xLabel, String yLabel, double[] xValues, double[] yValues, ImagePlus origin) {
        this(title, xLabel, yLabel, Tools.toFloat(xValues), Tools.toFloat(yValues));
        horizontal = false;
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, boolean horiz, ImagePlus origin, Roi region) {
        this(title, xLabel, yLabel, xValues, yValues, origin);
        this.modifListener = true;
        this.region = (Roi)region.clone();
        horizontal = horiz;
        if (horizontal) {
            int xOrigine = ((Line)region).getX();
            int i = 0;
            while (i < xValues.length) {
                int n = i++;
                this.xValues[n] = this.xValues[n] + (float)xOrigine;
            }
            double[] a = Tools.getMinMax(xValues);
            this.xMin = a[0];
            this.xMax = a[1];
            a = Tools.getMinMax(this.xInitValues);
            this.xInitMin = a[0];
            this.xInitMax = a[1];
        }
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, float[] xInitValues, float[] yInitValues, boolean horiz, ImagePlus origin, Roi region) {
        this(title, xLabel, yLabel, xValues, yValues, false, origin, region);
        horizontal = horiz;
        this.xInitValues = xInitValues;
        this.yInitValues = yInitValues;
        double[] a = Tools.getMinMax(xInitValues);
        this.xInitMin = a[0];
        this.xInitMax = a[1];
    }

    public PlotWindow(String title, String xLabel, String yLabel, double[] xValues, double[] yValues, boolean horiz, ImagePlus origin, Roi region) {
        this(title, xLabel, yLabel, Tools.toFloat(xValues), Tools.toFloat(yValues), horiz, origin, region);
    }

    public void setLimits(double xMin, double xMax, double yMin, double yMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.fixedYScale = true;
    }

    public void addPoints(float[] x, float[] y, int shape) {
        this.setup();
        switch (shape) {
            case 0: 
            case 1: {
                for (int i = 0; i < x.length; ++i) {
                    int xt = 50 + (int)(((double)x[i] - this.xMin) * this.xScale);
                    int yt = 20 + this.frameHeight - (int)(((double)y[i] - this.yMin) * this.yScale);
                    this.drawShape(shape, xt, yt, 5);
                }
                break;
            }
            case 2: {
                int[] xts = new int[x.length];
                int[] yts = new int[y.length];
                for (int i = 0; i < x.length; ++i) {
                    xts[i] = 50 + (int)(((double)x[i] - this.xMin) * this.xScale);
                    yts[i] = 20 + this.frameHeight - (int)(((double)y[i] - this.yMin) * this.yScale);
                }
                this.drawPolyline(this.ip, xts, yts, x.length);
            }
        }
    }

    public void addPoints(double[] x, double[] y, int shape) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), shape);
    }

    void drawShape(int shape, int x, int y, int size) {
        int xbase = x - size / 2;
        int ybase = y - size / 2;
        if (shape == 1) {
            this.ip.drawLine(xbase, ybase, xbase + size, ybase + size);
            this.ip.drawLine(xbase + size, ybase, xbase, ybase + size);
        } else {
            this.ip.drawLine(x - 1, y - 2, x + 1, y - 2);
            this.ip.drawLine(x - 1, y + 2, x + 1, y + 2);
            this.ip.drawLine(x + 2, y + 1, x + 2, y - 1);
            this.ip.drawLine(x - 2, y + 1, x - 2, y - 1);
        }
    }

    public void addErrorBars(float[] errorBars) {
        if (errorBars.length != this.nPoints) {
            throw new IllegalArgumentException("errorBars.length != npoints");
        }
        this.errorBars = errorBars;
    }

    public void addLabel(double x, double y, String label) {
        this.setup();
        int xt = 50 + (int)(x * (double)this.frameWidth);
        int yt = 20 + (int)(y * (double)this.frameHeight);
        this.ip.drawString(label, xt, yt);
        this.labels.add(label);
        this.xlabs.add(new Integer(xt));
        this.ylabs.add(new Integer(yt));
    }

    public void setColor(Color c) {
        this.setup();
        if (!(this.ip instanceof ColorProcessor)) {
            this.ip = this.ip.convertToRGB();
            this.ip.setLineWidth(this.lineWidth);
            this.ip.setFont(this.font);
            this.ip.setAntialiasedText(true);
        }
        this.ip.setColor(c);
    }

    public void setLineWidth(int lineWidth) {
        this.setup();
        this.ip.setLineWidth(lineWidth);
        this.lineWidth = lineWidth;
    }

    public void changeFont(Font font) {
        this.setup();
        this.ip.setFont(font);
        this.font = font;
    }

    public void draw() {
        this.drawPlot();
        if (this.ip instanceof ColorProcessor) {
            this.imp.setProcessor(null, this.ip);
        } else {
            this.imp.updateAndDraw();
        }
        IJ.showProgress(1.1);
    }

    void setup() {
        if (this.ip != null) {
            return;
        }
        this.ip = this.imp.getProcessor();
        this.ip.setColor(Color.black);
        if (this.lineWidth > 3) {
            this.lineWidth = 3;
        }
        this.ip.setLineWidth(this.lineWidth);
        this.ip.setFont(this.font);
        this.ip.setAntialiasedText(true);
        if (this.frameWidth == 0) {
            this.frameWidth = plotWidth;
            this.frameHeight = plotHeight;
        }
        this.frame = new Rectangle(50, 20, this.frameWidth, this.frameHeight);
        this.xScale = this.xMax - this.xMin == 0.0 ? 1.0 : (double)this.frame.width / (this.xMax - this.xMin);
        this.yScale = this.yMax - this.yMin == 0.0 ? 1.0 : (double)this.frame.height / (this.yMax - this.yMin);
    }

    int getDigits(double n1, double n2) {
        if ((double)Math.round(n1) == n1 && (double)Math.round(n2) == n2) {
            return 0;
        }
        double n = (n1 = Math.abs(n1)) < (n2 = Math.abs(n2)) && n1 > 0.0 ? n1 : n2;
        double diff = Math.abs(n2 - n1);
        if (diff > 0.0 && diff < n) {
            n = diff;
        }
        int digits = 1;
        if (n < 10.0) {
            digits = 2;
        }
        if (n < 0.01) {
            digits = 3;
        }
        if (n < 0.001) {
            digits = 4;
        }
        if (n < 1.0E-4) {
            digits = 5;
        }
        return digits;
    }

    public void mouseClicked(int x, int y) {
        String xRB = "";
        String yRB = "";
        if (this.region != null) {
            int n = ((Line)this.region).getX();
        }
        if (this.frame == null) {
            return;
        }
        if (this.frame.contains(x, y)) {
            int index = (int)((double)(x - this.frame.x) / ((double)this.frame.width / (double)this.xValues.length));
            if (index > 0 && index < this.xValues.length) {
                double xv = this.xValues[index];
                double yv = this.yValues[index];
                if (horizontal) {
                    double inter = xv;
                    xRB = IJ.d2s(inter, this.getDigits(inter, 2.0));
                    yRB = IJ.d2s(yv, this.getDigits(yv, 2.0));
                } else {
                    xRB = IJ.d2s(xv, this.getDigits(xv, 2.0));
                    yRB = IJ.d2s(yv, this.getDigits(yv, 2.0));
                }
            }
            IJ.write("\t" + xRB + "\t" + yRB);
        }
    }

    public void mouseMoved(int x, int y) {
        if (this.frame == null) {
            return;
        }
        int xOrigine = 0;
        if (this.region != null && horizontal) {
            xOrigine = ((Line)this.region).getX();
        }
        if (this.frame.contains(this.oldX - 1, this.oldY)) {
            this.ip.setColor(Color.white);
            Roi region = this.imp.getRoi();
            this.imp.setRoi(this.frame);
            this.ip.fill();
            this.imp.setRoi(region);
            this.ip.setColor(Color.black);
            this.drawPolyline(this.ip, this.Xpoints, this.Ypoints, this.nPoints);
            this.ip.setColor(Color.black);
            this.ip.drawRect(this.frame.x, this.frame.y, this.frame.width + 1, this.frame.height + 1);
            this.ip.setAntialiasedText(true);
            Enumeration e = this.labels.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                int xxx = (Integer)this.xlabs.elementAt(i);
                int yyy = (Integer)this.ylabs.elementAt(i++);
                this.ip.drawString((String)e.nextElement(), xxx, yyy);
            }
            this.imp.updateAndDraw();
        }
        if (this.frame.contains(x, y)) {
            int index = (int)((double)(x - this.frame.x) / ((double)this.frame.width / (double)this.xValues.length));
            this.ip.setColor(Color.gray.brighter());
            this.ip.drawLine(x, this.frame.y, x, this.frame.y + this.frameHeight);
            this.ip.drawLine(this.frame.x, this.Ypoints[index], this.frame.x + this.frameWidth, this.Ypoints[index]);
            this.ip.setColor(Color.black);
            this.ip.drawRect(this.frame.x, this.frame.y, this.frame.width + 1, this.frame.height + 1);
            this.imp.updateAndDraw();
            if (index > 0 && index < this.xValues.length) {
                double xv = this.xValues[index];
                double yv = this.yValues[index];
                String lab = "X=" + IJ.d2s(xv, this.getDigits(xv, 2.0));
                this.Xcoord.setText(lab);
                lab = "Y=" + IJ.d2s(yv, this.getDigits(yv, 2.0));
                this.Ycoord.setText(lab);
                if (this.origin != null && this.region != null && this.region.getType() == 5) {
                    this.origin.getWindow().getCanvas().setRoi(this.region);
                    Line lr = (Line)this.region;
                    if (horizontal) {
                        xv -= (double)xOrigine;
                    }
                    double c = xv / this.origin.getRoi().getLength();
                    int xi = lr.x1 + (int)(c * (double)(lr.x2 - lr.x1));
                    int yi = lr.y1 + (int)(c * (double)(lr.y2 - lr.y1));
                    this.origin.getWindow().getCanvas().setPoint(xi, yi, this.region);
                }
                this.oldindex = index;
            }
        } else {
            this.Xcoord.setText("");
            this.Ycoord.setText("");
        }
        this.oldX = x;
        this.oldY = y;
    }

    public void mouseExited(MouseEvent e) {
        this.origin.getWindow().getCanvas().setPoint(-1, -1, null);
    }

    void drawPlot() {
        this.setup();
        int xOrigine = 0;
        if (this.region != null && horizontal) {
            xOrigine = ((Line)this.region).getX();
        }
        this.Xpoints = new int[this.nPoints];
        this.Ypoints = new int[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            double value = this.yValues[i];
            double xvalue = this.xValues[i];
            if (value < this.yMin) {
                value = this.yMin;
            }
            if (value > this.yMax) {
                value = this.yMax;
            }
            this.Xpoints[i] = 50 + (int)((xvalue - this.xMin) * this.xScale);
            this.Ypoints[i] = 20 + this.frame.height - (int)((value - this.yMin) * this.yScale);
        }
        this.drawPolyline(this.ip, this.Xpoints, this.Ypoints, this.nPoints);
        IJ.showProgress(0.4);
        if (this.errorBars != null) {
            int[] xpoints = new int[2];
            int[] ypoints = new int[2];
            for (int i = 0; i < this.nPoints; ++i) {
                xpoints[0] = xpoints[1] = 50 + (int)(((double)this.xValues[i] - this.xMin) * this.xScale);
                ypoints[0] = 20 + this.frame.height - (int)(((double)this.yValues[i] - this.yMin - (double)this.errorBars[i]) * this.yScale);
                ypoints[1] = 20 + this.frame.height - (int)(((double)this.yValues[i] - this.yMin + (double)this.errorBars[i]) * this.yScale);
                this.drawPolyline(this.ip, xpoints, ypoints, 2);
            }
        }
        if (this.ip instanceof ColorProcessor) {
            this.ip.setColor(Color.black);
        }
        this.ip.drawRect(this.frame.x, this.frame.y, this.frame.width + 1, this.frame.height + 1);
        int digits = this.getDigits(this.yMax, this.yMin);
        String s = IJ.d2s(this.yMax, digits);
        int sw = this.ip.getStringWidth(s);
        if (sw + 4 > 50) {
            this.ip.drawString(s, 4, 16);
        } else {
            this.ip.drawString(s, 50 - this.ip.getStringWidth(s) - 4, 30);
        }
        s = IJ.d2s(this.yMin, digits);
        sw = this.ip.getStringWidth(s);
        if (sw + 4 > 50) {
            this.ip.drawString(s, 4, 20 + this.frame.height);
        } else {
            this.ip.drawString(s, 50 - this.ip.getStringWidth(s) - 4, 20 + this.frame.height);
        }
        IJ.showProgress(0.8);
        FontMetrics fm = this.ip.getFontMetrics();
        int x = 50;
        int y = 20 + this.frame.height + fm.getAscent() + 6;
        digits = this.getDigits(this.xMin, this.xMax);
        this.ip.drawString(IJ.d2s(this.xMin, digits), x, y);
        s = IJ.d2s(this.xMax, digits);
        this.ip.drawString(s, x + this.frame.width - this.ip.getStringWidth(s) + 6, y);
        this.ip.drawString(this.xLabel, 50 + (this.frame.width - this.ip.getStringWidth(this.xLabel)) / 2, y + 3);
        this.drawYLabel(this.yLabel, 50, 20, this.frame.height, fm);
    }

    void drawPolyline(ImageProcessor ip, int[] x, int[] y, int n) {
        ip.moveTo(x[0], y[0]);
        for (int i = 0; i < n; ++i) {
            ip.lineTo(x[i], y[i]);
        }
    }

    void drawYLabel(String yLabel, int x, int y, int height, FontMetrics fm) {
        if (yLabel.equals("")) {
            return;
        }
        int w = fm.stringWidth(yLabel) + 5;
        int h = fm.getHeight() + 5;
        ImageProcessor label = new ByteProcessor(w, h);
        ((ImageProcessor)label).setColor(Color.white);
        label.fill();
        ((ImageProcessor)label).setColor(Color.black);
        label.setFont(this.font);
        label.setAntialiasedText(true);
        int descent = fm.getDescent();
        label.drawString(yLabel, 0, h - descent);
        label = label.rotateLeft();
        int y2 = y + (height - this.ip.getStringWidth(yLabel)) / 2;
        if (y2 < y) {
            y2 = y;
        }
        int x2 = x - h - 2;
        this.ip.insert(label, x2, y2);
    }

    void showList() {
        String headings;
        StringBuffer sb = new StringBuffer();
        this.initDigits();
        if (this.errorBars != null) {
            headings = saveXValues ? "X\tY\tErrorBar" : "Y\tErrorBar";
            for (int i = 0; i < this.nPoints; ++i) {
                if (saveXValues) {
                    sb.append(IJ.d2s(this.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.yValues[i], this.ydigits) + "\t" + IJ.d2s(this.errorBars[i], this.ydigits) + "\n");
                    continue;
                }
                sb.append(IJ.d2s(this.yValues[i], this.ydigits) + "\t" + IJ.d2s(this.errorBars[i], this.ydigits) + "\n");
            }
        } else {
            headings = saveXValues ? "X\tY" : "Y";
            for (int i = 0; i < this.nPoints; ++i) {
                if (saveXValues) {
                    sb.append(IJ.d2s(this.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.yValues[i], this.ydigits) + "\n");
                    continue;
                }
                sb.append(IJ.d2s(this.yValues[i], this.ydigits) + "\n");
            }
        }
        TextWindow tw = new TextWindow(IJ.getBundle().getString("PlotValues"), headings, sb.toString(), 200, 400);
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void saveAsText() {
        String directory;
        FileDialog fd = new FileDialog((Frame)this, IJ.getBundle().getString("SaveAsText"), 1);
        if (defaultDirectory != null) {
            fd.setDirectory(defaultDirectory);
        }
        fd.show();
        String name = fd.getFile();
        defaultDirectory = directory = fd.getDirectory();
        fd.dispose();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(directory + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            IJ.error("" + e);
            return;
        }
        IJ.wait(250);
        IJ.showStatus(IJ.getBundle().getString("SavePlotValues"));
        this.initDigits();
        for (int i = 0; i < this.nPoints; ++i) {
            if (saveXValues) {
                pw.println(IJ.d2s(this.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.yValues[i], this.ydigits));
                continue;
            }
            pw.println(IJ.d2s(this.yValues[i], this.ydigits));
        }
        pw.close();
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void copyToClipboard() {
        Clipboard systemClipboard = null;
        try {
            systemClipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            systemClipboard = null;
        }
        if (systemClipboard == null) {
            IJ.error(IJ.getBundle().getString("ClipCopyErr"));
            return;
        }
        IJ.showStatus(IJ.getBundle().getString("CopyPlotValues"));
        this.initDigits();
        CharArrayWriter aw = new CharArrayWriter(this.nPoints * 4);
        PrintWriter pw = new PrintWriter(aw);
        for (int i = 0; i < this.nPoints; ++i) {
            if (saveXValues) {
                pw.print(IJ.d2s(this.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.yValues[i], this.ydigits) + "\n");
                continue;
            }
            pw.print(IJ.d2s(this.yValues[i], this.ydigits) + "\n");
        }
        String text = aw.toString();
        pw.close();
        StringSelection contents = new StringSelection(text);
        systemClipboard.setContents(contents, this);
        IJ.showStatus(text.length() + " " + IJ.getBundle().getString("CharCopied"));
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void initDigits() {
        this.ydigits = Analyzer.getPrecision();
        if (this.ydigits == 0) {
            this.ydigits = 2;
        }
        if (this.ydigits != this.defaultDigits) {
            this.realNumbers = false;
            for (int i = 0; i < this.xValues.length; ++i) {
                if ((float)((int)this.xValues[i]) == this.xValues[i]) continue;
                this.realNumbers = true;
            }
            this.defaultDigits = this.ydigits;
        }
        this.xdigits = this.realNumbers ? this.ydigits : 0;
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        ImagePlus imp2 = WindowManager.getCurrentImage();
        if (b == this.list) {
            this.showList();
        } else if (b == this.save) {
            this.saveAsText();
        } else if (b == this.setting) {
            this.setPlotScale(imp2);
        } else if (b == this.setScale) {
            IJ.runPlugIn("ij.plugin.filter.ScaleDialog", "");
            IJ.runPlugIn("ij.plugin.filter.Profiler", "");
            if (imp2 != null) {
                this.close();
            }
        } else if (b == this.option) {
            IJ.runPlugIn("ij.plugin.filter.Profiler", "set");
            IJ.runPlugIn("ij.plugin.filter.Profiler", "");
            if (imp2 != null) {
                this.close();
            }
        } else {
            this.copyToClipboard();
        }
    }

    public float[] getYValues() {
        return this.yValues;
    }

    public static void savePreferences(Properties prefs) {
        double min = ProfilePlot.getFixedMin();
        double max = ProfilePlot.getFixedMax();
        if ((min != 0.0 || max != 0.0) && min < max) {
            prefs.put(MIN, Double.toString(min));
            prefs.put(MAX, Double.toString(max));
        }
        if (plotWidth != 450 || plotHeight != 200) {
            prefs.put(PLOT_WIDTH, Integer.toString(plotWidth));
            prefs.put(PLOT_HEIGHT, Integer.toString(plotHeight));
        }
        int options = 0;
        if (saveXValues) {
            options |= 1;
        }
        if (autoClose) {
            options |= 2;
        }
        prefs.put(OPTIONS, Integer.toString(options));
    }

    public boolean close() {
        boolean b = super.close();
        if (this.origin != null) {
            try {
                this.origin.getWindow().getCanvas().setPoint(-1, -1, null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return b;
    }

    void setPlotScale(ImagePlus imp2) {
        double xvalue;
        double yvalue;
        int i;
        GenericDialog gd = new GenericDialog(IJ.getBundle().getString("Properties"));
        gd.addStringField("     X label :", this.xLabel, this.xLabel.length());
        gd.addNumericField("             X min : ", this.xMin, 0);
        gd.addNumericField("             X max : ", this.xMax, 0);
        gd.addStringField("     Y label :", this.yLabel, this.yLabel.length());
        gd.addNumericField("             Y min : ", this.yMin, 0);
        gd.addNumericField("             Y max : ", this.yMax, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String xLab = gd.getNextString();
        double xMi = (int)gd.getNextNumber();
        double xMa = (int)gd.getNextNumber();
        String yLab = gd.getNextString();
        double yMi = (int)gd.getNextNumber();
        double yMa = (int)gd.getNextNumber();
        if (xMi < this.xInitMin) {
            xMi = this.xInitMin;
        }
        if (xMa > this.xInitMax) {
            xMa = this.xInitMax;
        }
        int ii = 0;
        int nInitPoints = this.xInitValues.length;
        for (i = 0; i < nInitPoints; ++i) {
            yvalue = this.yInitValues[i];
            xvalue = this.xInitValues[i];
            if (!(xvalue >= xMi) || !(xvalue <= xMa)) continue;
            ++ii;
        }
        double[] newxValues = new double[ii];
        double[] newyValues = new double[ii];
        ii = 0;
        for (i = 0; i < nInitPoints; ++i) {
            yvalue = this.yInitValues[i];
            xvalue = this.xInitValues[i];
            if (!(xvalue >= xMi) || !(xvalue <= xMa)) continue;
            newyValues[ii] = yvalue;
            newxValues[ii] = xvalue;
            ++ii;
        }
        PlotWindow pw = imp2 != null ? new PlotWindow(IJ.getBundle().getString("PlotWinTitle") + " " + this.origin.getShortTitle() + (this.origin.getStackSize() > 1 ? "#" + this.origin.getCurrentSlice() : ""), xLab, yLab, Tools.toFloat(newxValues), Tools.toFloat(newyValues), this.xInitValues, this.yInitValues, horizontal, this.origin, this.region) : new PlotWindow(this.getTitle(), xLab, yLab, Tools.toFloat(newxValues), Tools.toFloat(newyValues), this.xInitValues, this.yInitValues);
        pw.setLimits(xMi, xMa, yMi, yMa);
        pw.draw();
        this.close();
    }

    static {
        plotWidth = 450;
        plotHeight = 200;
        IJ.register(PlotWindow.class);
        options = Prefs.getInt(OPTIONS, 1);
        saveXValues = (options & 1) != 0;
        autoClose = (options & 2) != 0;
        plotWidth = Prefs.getInt(PLOT_WIDTH, 450);
        plotHeight = Prefs.getInt(PLOT_HEIGHT, 200);
    }
}

