/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import ij.util.Java2;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class TextRoi
extends Roi {
    static final int MAX_LINES = 50;
    private String[] theText = new String[50];
    private static String name = "SansSerif";
    private static int style = 0;
    private static int size = 18;
    private static Font font;
    private double previousMag;
    private boolean firstChar = true;
    private boolean firstMouseUp = true;
    private int cline = 0;

    public TextRoi(int x, int y, ImagePlus imp) {
        super(x, y, imp);
        double mag;
        ImageWindow win = imp.getWindow();
        double d = mag = win != null ? win.getCanvas().getMagnification() : 1.0;
        if (mag > 1.0) {
            mag = 1.0;
        }
        if ((double)size < 12.0 / mag) {
            size = (int)(12.0 / mag);
        }
        this.theText[0] = IJ.getBundle().getString("TextRoi1");
        this.theText[1] = IJ.getBundle().getString("TextRoi2");
        if (previousRoi != null && previousRoi instanceof TextRoi) {
            this.firstMouseUp = false;
            previousRoi = null;
        }
    }

    public void addChar(char c) {
        if (c < ' ' && c != '\b' && c != '\n') {
            return;
        }
        if (this.firstChar) {
            this.cline = 0;
            this.theText[this.cline] = new String("");
            for (int i = 1; i < 50; ++i) {
                this.theText[i] = null;
            }
        }
        if (c == '\b') {
            if (this.theText[this.cline].length() > 0) {
                this.theText[this.cline] = this.theText[this.cline].substring(0, this.theText[this.cline].length() - 1);
            } else if (this.cline > 0) {
                this.theText[this.cline] = null;
                --this.cline;
            }
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            this.firstChar = false;
            return;
        }
        if (c == '\n') {
            if (this.cline < 49) {
                ++this.cline;
            }
        } else {
            char[] chr = new char[]{c};
            int n = this.cline;
            this.theText[n] = this.theText[n] + new String(chr);
            this.adjustSize();
            this.updateClipRect();
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            this.firstChar = false;
            return;
        }
        this.theText[this.cline] = "";
        this.adjustSize();
    }

    Font getCurrentFont() {
        double mag = this.ic.getMagnification();
        if (font == null || mag != this.previousMag) {
            font = new Font(name, style, (int)((double)size * mag));
            this.previousMag = mag;
        }
        return font;
    }

    public void drawPixels() {
        if (this.imp == null) {
            return;
        }
        ImageProcessor ip = this.imp.getProcessor();
        Font font = new Font(name, style, size);
        ip.setFont(font);
        ip.setAntialiasedText(true);
        FontMetrics metrics = ip.getFontMetrics();
        int fontHeight = metrics.getHeight();
        int descent = metrics.getDescent();
        int i = 0;
        int yy = 0;
        while (i < 50 && this.theText[i] != null) {
            ip.drawString(this.theText[i], this.x, this.y + yy + fontHeight);
            ++i;
            yy += fontHeight;
        }
    }

    public void draw(Graphics g) {
        super.draw(g);
        g.setColor(ROIColor);
        double mag = this.ic.getMagnification();
        int sx = this.ic.screenX(this.x);
        int sy = this.ic.screenY(this.y);
        int swidth = (int)((double)this.width * mag);
        int sheight = (int)((double)this.height * mag);
        if (IJ.isJava2()) {
            Java2.setAntialiasedText(g, true);
        }
        if (font == null) {
            this.adjustSize();
        }
        Font font = this.getCurrentFont();
        FontMetrics metrics = g.getFontMetrics(font);
        int fontHeight = metrics.getHeight();
        int descent = metrics.getDescent();
        g.setFont(font);
        Rectangle r = g.getClipBounds();
        g.setClip(sx, sy, swidth, sheight);
        int i = 0;
        while (i < 50 && this.theText[i] != null) {
            g.drawString(this.theText[i], sx, sy + fontHeight - descent);
            ++i;
            sy += fontHeight;
        }
        if (r != null) {
            g.setClip(r.x, r.y, r.width, r.height);
        }
    }

    public static String getFont() {
        return name;
    }

    public static int getSize() {
        return size;
    }

    public static int getStyle() {
        return style;
    }

    public static void setFont(String fontName, int fontSize, int fontStyle) {
        Roi roi;
        name = fontName;
        size = fontSize;
        style = fontStyle;
        font = null;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && (roi = imp.getRoi()) instanceof TextRoi) {
            imp.draw();
        }
    }

    protected void handleMouseUp(int screenX, int screenY) {
        super.handleMouseUp(screenX, screenY);
        if (this.firstMouseUp) {
            this.adjustSize();
            this.firstMouseUp = false;
        } else if (this.width < 5 || this.height < 5) {
            this.imp.killRoi();
        }
    }

    void adjustSize() {
        if (this.ic == null) {
            return;
        }
        double mag = this.ic.getMagnification();
        Font font = this.getCurrentFont();
        Graphics g = this.ic.getGraphics();
        if (IJ.isJava2()) {
            Java2.setAntialiasedText(g, true);
        }
        FontMetrics metrics = g.getFontMetrics(font);
        int fontHeight = (int)((double)metrics.getHeight() / mag);
        int descent = metrics.getDescent();
        int nLines = 0;
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        this.width = 10;
        for (int i = 0; i < 50 && this.theText[i] != null; ++i) {
            ++nLines;
            int w = (int)((double)this.stringWidth(this.theText[i], metrics, g) / mag);
            if (w <= this.width) continue;
            this.width = w;
        }
        g.dispose();
        this.width += 2;
        if (this.x + this.width > this.xMax) {
            this.x = this.xMax - this.width;
        }
        this.height = nLines * fontHeight + 2;
        if (this.height > this.yMax) {
            this.height = this.yMax;
        }
        if (this.y + this.height > this.yMax) {
            this.y = this.yMax - this.height;
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
    }

    int stringWidth(String s, FontMetrics metrics, Graphics g) {
        if (IJ.isJava2()) {
            return Java2.getStringWidth(s, metrics, g);
        }
        return metrics.stringWidth(s);
    }
}

