/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.FitsDecoder;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FITS
extends ImagePlus
implements PlugIn {
    public void run(String arg) {
        OpenDialog od = new OpenDialog("Open FITS...", arg);
        String directory = od.getDirectory();
        String fileName = od.getFileName();
        if (fileName == null) {
            return;
        }
        IJ.showStatus("Opening: " + directory + fileName);
        FitsDecoder fd = new FitsDecoder(directory, fileName);
        FileInfo fi = null;
        try {
            fi = fd.getInfo();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (fi != null && fi.width > 0 && fi.height > 0 && fi.offset > 0) {
            FileOpener fo = new FileOpener(fi);
            ImagePlus imp = fo.open(false);
            if (fi.nImages == 1) {
                ImageProcessor ip = imp.getProcessor();
                ip.flipVertical();
                if (fi.height <= 10) {
                    int length;
                    fi.height = 100;
                    short[] shortpixels = null;
                    float[] floatpixels = null;
                    if (fi.fileType == 1) {
                        shortpixels = (short[])ip.getPixels();
                        length = shortpixels.length;
                    } else {
                        floatpixels = (float[])ip.getPixels();
                        length = floatpixels.length;
                    }
                    ip = ip.resize(fi.width, fi.height);
                    short[] newshortpixels = new short[100 * length];
                    float[] newfloatpixels = new float[100 * length];
                    for (int k = 0; k < 100; ++k) {
                        for (int i = 0; i < length; ++i) {
                            if (fi.fileType == 1) {
                                newshortpixels[length * k + i] = shortpixels[i];
                                continue;
                            }
                            newfloatpixels[length * k + i] = floatpixels[i];
                        }
                    }
                    if (fi.fileType == 1) {
                        ip.setPixels(newshortpixels);
                    } else {
                        ip.setPixels(newfloatpixels);
                    }
                    this.setFileInfo(fi);
                    this.setProcessor(fileName, ip);
                    this.updateAndDraw();
                } else {
                    this.setProcessor(fileName, ip);
                }
            } else {
                ImageStack stack = imp.getStack();
                for (int i = 1; i <= stack.getSize(); ++i) {
                    stack.getProcessor(i).flipVertical();
                }
                this.setStack(fileName, stack);
            }
            Calibration cal = imp.getCalibration();
            double[] coeff = new double[]{fd.bzero, fd.bscale};
            cal.setFunction(0, coeff, IJ.getBundle().getString("CalGrayVal"));
            this.setCalibration(cal);
            this.setProperty("Info", fd.getHeaderInfo());
            this.setFileInfo(fi);
            if (arg.equals("")) {
                this.show();
            }
        } else {
            IJ.error("This does not appear to be a FITS file.");
        }
        IJ.showStatus("");
    }

    public static String getkeyword(String keyword, String path) throws IOException {
        ImagePlus imp = new ImagePlus(path);
        FileInfo fi = imp.getFileInfo();
        ImageProcessor ip = imp.getProcessor();
        File file = new File(path);
        RandomAccessFile f = new RandomAccessFile(file, "r");
        f.seek(0L);
        String s = FITS.getString(80, f);
        while (!s.startsWith("END")) {
            if (s.startsWith(keyword)) {
                f.close();
                return s;
            }
            s = FITS.getString(80, f);
        }
        f.close();
        s = "";
        return s;
    }

    static String getString(int length, RandomAccessFile f) throws IOException {
        byte[] b = new byte[length];
        f.read(b);
        return new String(b);
    }
}

