/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class EDM
implements PlugInFilter {
    ImagePlus imp;
    String arg;
    int maxEDM;
    short[] xCoordinate;
    short[] yCoordinate;
    int[] levelStart;
    int[] levelOffset;
    int[] histogram;
    int slice;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        this.arg = arg;
        return IJ.setupDialog(imp, 1);
    }

    public void run(ImageProcessor ip) {
        ++this.slice;
        ImageStatistics stats = this.imp.getStatistics();
        if (this.slice == 1 && stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
            IJ.error("8-bit binary image (0 and 255) required.");
            return;
        }
        ImageProcessor ip2 = this.makeEDM(ip);
        if (this.arg.equals("points")) {
            this.findUltimatePoints(ip2);
        }
        ip.copyBits(ip2, 0, 0, 0);
    }

    public ImageProcessor makeEDM(ImageProcessor ip) {
        int offset;
        int x;
        int y;
        int one = 41;
        int sqrt2 = 58;
        int sqrt5 = 92;
        this.imp.killRoi();
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        int rowsize = width;
        int xmax = width - 3;
        int ymax = height - 3;
        ImageProcessor ip16 = ip.convertToShort(false);
        ip16.multiply(one);
        short[] image16 = (short[])ip16.getPixels();
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                offset = x + y * rowsize;
                if (image16[offset] <= 0) continue;
                if (x < 2 || x > xmax || y < 2 || y > ymax) {
                    this.setEdgeValue(offset, rowsize, image16, x, y, xmax, ymax);
                    continue;
                }
                this.setValue(offset, rowsize, image16);
            }
        }
        for (y = height - 1; y >= 0; --y) {
            for (x = width - 1; x >= 0; --x) {
                offset = x + y * rowsize;
                if (image16[offset] <= 0) continue;
                if (x < 2 || x > xmax || y < 2 || y > ymax) {
                    this.setEdgeValue(offset, rowsize, image16, x, y, xmax, ymax);
                    continue;
                }
                this.setValue(offset, rowsize, image16);
            }
        }
        ImageProcessor ip2 = ip.createProcessor(width, height);
        byte[] image8 = (byte[])ip2.getPixels();
        this.convertToBytes(width, height, image16, image8);
        return ip2;
    }

    void setValue(int offset, int rowsize, short[] image16) {
        int one = 41;
        int sqrt2 = 58;
        int sqrt5 = 92;
        int r1 = offset - rowsize - rowsize - 2;
        int r2 = r1 + rowsize;
        int r3 = r2 + rowsize;
        int r4 = r3 + rowsize;
        int r5 = r4 + rowsize;
        int v = image16[r2 + 2] + one;
        int min = Short.MAX_VALUE;
        if (v < min) {
            min = v;
        }
        if ((v = image16[r3 + 1] + one) < min) {
            min = v;
        }
        if ((v = image16[r3 + 3] + one) < min) {
            min = v;
        }
        if ((v = image16[r4 + 2] + one) < min) {
            min = v;
        }
        if ((v = image16[r2 + 1] + sqrt2) < min) {
            min = v;
        }
        if ((v = image16[r2 + 3] + sqrt2) < min) {
            min = v;
        }
        if ((v = image16[r4 + 1] + sqrt2) < min) {
            min = v;
        }
        if ((v = image16[r4 + 3] + sqrt2) < min) {
            min = v;
        }
        if ((v = image16[r1 + 1] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r1 + 3] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r2 + 4] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r4 + 4] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r5 + 3] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r5 + 1] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r4] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r2] + sqrt5) < min) {
            min = v;
        }
        image16[offset] = (short)min;
    }

    void setEdgeValue(int offset, int rowsize, short[] image16, int x, int y, int xmax, int ymax) {
        int one = 41;
        int sqrt2 = 58;
        int sqrt5 = 92;
        int r1 = offset - rowsize - rowsize - 2;
        int r2 = r1 + rowsize;
        int r3 = r2 + rowsize;
        int r4 = r3 + rowsize;
        int r5 = r4 + rowsize;
        int min = Short.MAX_VALUE;
        short offimage = image16[r3 + 2];
        int v = y < 2 ? offimage + one : image16[r2 + 2] + one;
        if (v < min) {
            min = v;
        }
        if ((v = x < 2 ? offimage + one : image16[r3 + 1] + one) < min) {
            min = v;
        }
        if ((v = x > xmax ? offimage + one : image16[r3 + 3] + one) < min) {
            min = v;
        }
        if ((v = y > ymax ? offimage + one : image16[r4 + 2] + one) < min) {
            min = v;
        }
        if ((v = x < 2 || y < 2 ? offimage + sqrt2 : image16[r2 + 1] + sqrt2) < min) {
            min = v;
        }
        if ((v = x > xmax || y < 2 ? offimage + sqrt2 : image16[r2 + 3] + sqrt2) < min) {
            min = v;
        }
        if ((v = x < 2 || y > ymax ? offimage + sqrt2 : image16[r4 + 1] + sqrt2) < min) {
            min = v;
        }
        if ((v = x > xmax || y > ymax ? offimage + sqrt2 : image16[r4 + 3] + sqrt2) < min) {
            min = v;
        }
        if ((v = x < 2 || y < 2 ? offimage + sqrt5 : image16[r1 + 1] + sqrt5) < min) {
            min = v;
        }
        if ((v = x > xmax || y < 2 ? offimage + sqrt5 : image16[r1 + 3] + sqrt5) < min) {
            min = v;
        }
        if ((v = x > xmax || y < 2 ? offimage + sqrt5 : image16[r2 + 4] + sqrt5) < min) {
            min = v;
        }
        if ((v = x > xmax || y > ymax ? offimage + sqrt5 : image16[r4 + 4] + sqrt5) < min) {
            min = v;
        }
        if ((v = x > xmax || y > ymax ? offimage + sqrt5 : image16[r5 + 3] + sqrt5) < min) {
            min = v;
        }
        if ((v = x < 2 || y > ymax ? offimage + sqrt5 : image16[r5 + 1] + sqrt5) < min) {
            min = v;
        }
        if ((v = x < 2 || y > ymax ? offimage + sqrt5 : image16[r4] + sqrt5) < min) {
            min = v;
        }
        if ((v = x < 2 || y < 2 ? offimage + sqrt5 : image16[r2] + sqrt5) < min) {
            min = v;
        }
        image16[offset] = (short)min;
    }

    void convertToBytes(int width, int height, short[] image16, byte[] image8) {
        int one = 41;
        int round = one / 2;
        this.maxEDM = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int offset = x + y * width;
                int v = (image16[offset] + round) / one;
                if (v > 255) {
                    v = 255;
                }
                if (v > this.maxEDM) {
                    this.maxEDM = v;
                }
                image8[offset] = (byte)v;
            }
        }
    }

    public void findUltimatePoints(ImageProcessor ip) {
        this.smoothEDM(ip);
        this.makeCoordinateArrays(ip);
        byte[] image = (byte[])ip.getPixels();
        ImageProcessor ip2 = ip.duplicate();
        byte[] image2 = (byte[])ip2.getPixels();
        int width = ip.getWidth();
        int height = ip.getHeight();
        int rowsize = width;
        int xmax = width - 1;
        int ymax = height - 1;
        for (int level = this.maxEDM - 1; level >= 1; --level) {
            int count;
            do {
                count = 0;
                for (int i = 0; i < this.histogram[level]; ++i) {
                    int CoordOffset = this.levelStart[level] + i;
                    short x = this.xCoordinate[CoordOffset];
                    short y = this.yCoordinate[CoordOffset];
                    int offset = x + y * rowsize;
                    if ((image[offset] & 0xFF) == 255) continue;
                    boolean setPixel = false;
                    if (x > 0 && y > 0 && (image[offset - rowsize - 1] & 0xFF) > level) {
                        setPixel = true;
                    }
                    if (y > 0 && (image[offset - rowsize] & 0xFF) > level) {
                        setPixel = true;
                    }
                    if (x < xmax && y > 0 && (image[offset - rowsize + 1] & 0xFF) > level) {
                        setPixel = true;
                    }
                    if (x < xmax && (image[offset + 1] & 0xFF) > level) {
                        setPixel = true;
                    }
                    if (x < xmax && y < ymax && (image[offset + rowsize + 1] & 0xFF) > level) {
                        setPixel = true;
                    }
                    if (y < ymax && (image[offset + rowsize] & 0xFF) > level) {
                        setPixel = true;
                    }
                    if (x > 0 && y < ymax && (image[offset + rowsize - 1] & 0xFF) > level) {
                        setPixel = true;
                    }
                    if (x > 0 && (image[offset - 1] & 0xFF) > level) {
                        setPixel = true;
                    }
                    if (!setPixel) continue;
                    image[offset] = -1;
                    ++count;
                }
            } while (count != 0);
        }
        for (int i = 0; i < width * height; ++i) {
            if ((image[i] & 0xFF) != 255) continue;
            image[i] = 0;
        }
    }

    void smoothEDM(ImageProcessor edm) {
        byte[] image = (byte[])edm.getPixels();
        ImageProcessor ip2 = edm.duplicate();
        byte[] image2 = (byte[])ip2.getPixels();
        int width = edm.getWidth();
        int height = edm.getHeight();
        int rowsize = width;
        int xmax = width - 1;
        int ymax = height - 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int offset = x + y * rowsize;
                if (image2[offset] == 1) continue;
                int sum = image2[offset] * 2;
                if (x > 0 && y > 0) {
                    sum += image2[offset - rowsize - 1];
                }
                if (y > 0) {
                    sum += image2[offset - rowsize];
                }
                if (x < xmax && y > 0) {
                    sum += image2[offset - rowsize + 1];
                }
                if (x < xmax) {
                    sum += image2[offset + 1];
                }
                if (x < xmax && y < ymax) {
                    sum += image2[offset + rowsize + 1];
                }
                if (y < ymax) {
                    sum += image2[offset + rowsize];
                }
                if (x > 0 && y < ymax) {
                    sum += image2[offset + rowsize - 1];
                }
                if (x > 0) {
                    sum += image2[offset - 1];
                }
                image[offset] = (byte)(sum / 10);
            }
        }
    }

    void makeCoordinateArrays(ImageProcessor edm) {
        int width = edm.getWidth();
        int height = edm.getHeight();
        this.histogram = edm.getHistogram();
        int ArraySize = 0;
        for (int i = 0; i < this.maxEDM - 1; ++i) {
            ArraySize += this.histogram[i];
        }
        this.xCoordinate = new short[ArraySize];
        this.yCoordinate = new short[ArraySize];
        byte[] image = (byte[])edm.getPixels();
        int offset = 0;
        this.levelStart = new int[256];
        for (int i = 0; i < 256; ++i) {
            this.levelStart[i] = offset;
            if (i <= 0 || i >= this.maxEDM) continue;
            offset += this.histogram[i];
        }
        this.levelOffset = new int[256];
        int rowsize = width;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int v = image[x + y * rowsize] & 0xFF;
                if (v <= 0 || v >= this.maxEDM) continue;
                offset = this.levelStart[v] + this.levelOffset[v];
                this.xCoordinate[offset] = (short)x;
                this.yCoordinate[offset] = (short)y;
                int n = v;
                this.levelOffset[n] = this.levelOffset[n] + 1;
            }
        }
    }
}

