/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.customizer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.media.CaptureDeviceInfo;

public class CusRegistry {
    private Hashtable defaultHash = null;
    private Hashtable fullHash = null;
    private static String filename = null;
    static final int versionNumber = 200;
    private static final String CLASSPATH = "java.class.path";
    private String classpath = null;
    private String workDir = null;
    private String javacpath = null;

    public void setWorkDir(String wdir) {
        this.workDir = wdir;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setJavacPath(String cpath) {
        this.javacpath = cpath;
    }

    public String getJavacPath() {
        return this.javacpath;
    }

    public boolean loadRegistry() {
        InputStream ris = null;
        boolean loadDef = false;
        this.defaultHash = new Hashtable();
        this.fullHash = new Hashtable();
        ris = this.findJMFPropertiesFile();
        boolean loadFull = this.readRegistry(this.fullHash, ris);
        if (loadFull) {
            return true;
        }
        try {
            Class<?> c = Class.forName("com.sun.media.util.RegistryLib");
            byte[] data = (byte[])c.getMethod("getData", null).invoke(c, null);
            if (data != null) {
                ris = new ByteArrayInputStream(data);
                loadDef = this.readRegistry(this.defaultHash, ris);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ris = null;
            loadDef = false;
        }
        return loadDef;
    }

    public Hashtable getDefaultRegistry() {
        return this.defaultHash;
    }

    public Hashtable getFullRegistry() {
        return this.fullHash;
    }

    public void removePlugIn(Hashtable newhash, String pname, int type) {
        String key = "PIM." + type + "_" + pname + ".in";
        newhash.remove(key);
        key = "PIM." + type + "_" + pname + ".out";
        newhash.remove(key);
    }

    public void removeCaptureD(Hashtable newhash, String cname) {
        String key1 = "CDM.nDevices";
        if (newhash.get(key1) != null) {
            String key;
            Object oo;
            int totalnum = (Integer)newhash.get(key1);
            int found = -1;
            int j = 0;
            int i = 0;
            while (i < totalnum) {
                CaptureDeviceInfo info;
                oo = newhash.get("CDM." + i);
                if (oo != null && (info = (CaptureDeviceInfo)oo).getLocator().getProtocol().equalsIgnoreCase(cname)) {
                    newhash.put(key1, new Integer(totalnum - 1));
                    newhash.remove("CDM." + i);
                    found = i;
                    break;
                }
                ++i;
            }
            int i2 = found + 1;
            while (i2 < totalnum) {
                oo = newhash.get("CDM." + i2);
                j = i2 - 1;
                key = "CDM." + j;
                newhash.put(key, oo);
                ++i2;
            }
            if (found >= 0) {
                key = "CDM." + --totalnum;
                newhash.remove(key);
            }
        }
    }

    private final InputStream findJMFPropertiesFile() {
        String pfileName = this.findJMF();
        FileInputStream ris = null;
        if (pfileName != null) {
            try {
                ris = new FileInputStream(pfileName);
            }
            catch (Exception ex) {
                ris = null;
            }
        }
        return ris;
    }

    public final String findJMF() {
        this.classpath = System.getProperty(CLASSPATH);
        if (this.classpath == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(this.classpath, File.pathSeparator);
        String strJMF = "jmf.properties";
        File file = null;
        Object ris = null;
        filename = null;
        while (tokens.hasMoreTokens()) {
            String dir = tokens.nextToken();
            String caps = dir.toUpperCase();
            try {
                if (caps.indexOf(".ZIP") > 0 || caps.indexOf(".JAR") > 0) {
                    int sep = dir.lastIndexOf(File.separator);
                    if (sep == -1 && !File.separator.equals("/")) {
                        sep = dir.lastIndexOf("/");
                    }
                    dir = sep == -1 ? ((sep = dir.lastIndexOf(":")) == -1 ? strJMF : dir.substring(0, sep) + ":" + strJMF) : dir.substring(0, sep) + File.separator + strJMF;
                } else {
                    dir = dir + File.separator + strJMF;
                }
            }
            catch (Exception e) {
                dir = dir + File.separator + strJMF;
            }
            try {
                file = new File(dir);
                if (!file.exists() || file.length() <= 0L) continue;
                filename = dir;
                System.out.println("Found jmf.properties in " + dir);
                break;
            }
            catch (Throwable t) {
                filename = null;
                return null;
            }
        }
        return filename;
    }

    private final boolean readRegistry(Hashtable hash, InputStream ris) {
        if (ris == null) {
            return false;
        }
        if (hash == null) {
            hash = new Hashtable<String, Object>();
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(ris);
            int tableSize = ois.readInt();
            int version = ois.readInt();
            if (version > 200) {
                System.err.println("Version number mismatch.\nThere could be errors in reading the registry");
            }
            int i = 0;
            while (i < tableSize) {
                String key = ois.readUTF();
                boolean failed = false;
                try {
                    Object value = ois.readObject();
                    hash.put(key, value);
                }
                catch (ClassNotFoundException cnfe) {
                    cnfe.printStackTrace();
                    failed = true;
                }
                catch (OptionalDataException ode) {
                    ode.printStackTrace();
                    failed = true;
                }
                ++i;
            }
            ois.close();
            ris.close();
        }
        catch (IOException ioe) {
            System.err.println("IOException in readRegistry: " + ioe);
            return false;
        }
        catch (Throwable t) {
            return false;
        }
        System.out.println("Registry Size = " + hash.size());
        return true;
    }

    public boolean saveRegistry(Hashtable newhash) {
        String tmpfilename = this.workDir + File.separator + "new_jmf.properties";
        try {
            File tmpF = new File(tmpfilename);
            if (tmpF.exists()) {
                tmpF.delete();
            }
            FileOutputStream fos = new FileOutputStream(tmpfilename);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            int tableSize = newhash.size();
            oos.writeInt(tableSize);
            oos.writeInt(200);
            Enumeration e = newhash.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object value = newhash.get(key);
                oos.writeUTF(key);
                oos.writeObject(value);
                oos.flush();
            }
            oos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    static {
        versionNumber = 200;
        CLASSPATH = CLASSPATH;
    }
}

