/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.MidiOutDeviceProvider;
import com.sun.media.sound.Printer;
import java.util.Vector;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

class MidiOutDevice
extends AbstractMidiDevice {
    private Vector receivers = new Vector();

    MidiOutDevice(MidiOutDeviceProvider.MidiOutDeviceInfo info) {
        super(info);
        if (Printer.trace) {
            Printer.trace(">> MidiOutDevice CONSTRUCTOR");
        }
        if (Printer.trace) {
            Printer.trace("<< MidiOutDevice CONSTRUCTOR completed");
        }
    }

    public int getMaxReceivers() {
        return -1;
    }

    public synchronized Receiver getReceiver() throws MidiUnavailableException {
        MidiOutReceiver receiver = new MidiOutReceiver();
        this.receivers.addElement(receiver);
        return receiver;
    }

    synchronized void implClose() {
        int i = 0;
        while (i < this.receivers.size()) {
            ((Receiver)this.receivers.elementAt(i)).close();
            ++i;
        }
        this.receivers.removeAllElements();
        int oldId = this.id;
        this.id = 0;
        this.nClose(oldId);
    }

    synchronized void implOpen() throws MidiUnavailableException {
        this.id = this.nOpen(((MidiOutDeviceProvider.MidiOutDeviceInfo)this.getDeviceInfo()).getIndex());
        if (this.id == 0) {
            throw new MidiUnavailableException("Unable to open native device");
        }
    }

    private native void nClose(int var1);

    private native int nOpen(int var1) throws MidiUnavailableException;

    private native void nSendShortMessage(int var1, int var2, int var3, int var4, long var5);

    class MidiOutReceiver
    implements Receiver {
        private boolean open = true;

        MidiOutReceiver() {
        }

        public void close() {
            MidiOutDevice.this.receivers.removeElement(this);
            this.open = false;
        }

        public void send(MidiMessage message, long timeStamp) {
        }

        public void send(ShortMessage message, long timeStamp) {
            if (this.open) {
                MidiOutDevice.this.nSendShortMessage(MidiOutDevice.this.id, message.getStatus(), message.getData1(), message.getData2(), timeStamp);
            }
        }

        public void send(SysexMessage message, long timeStamp) {
        }
    }
}

