/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.protocol.dsound.DSound;
import com.sun.media.protocol.dsound.DataSource;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.AudioFormat;

public class DirectSoundAuto {
    private static final String detectClass = "com.sun.media.protocol.dsound.DSound";
    CaptureDeviceInfo[] devices = null;

    public static void main(String[] args) {
        new DirectSoundAuto();
        System.exit(0);
    }

    private boolean supports(AudioFormat af) {
        try {
            DSound ds = new DSound(af, 1024);
            ds.open();
            ds.close();
        }
        catch (Exception e2) {
            System.err.println(e2);
            return false;
        }
        return true;
    }

    public DirectSoundAuto() {
        boolean supported = false;
        try {
            Class<?> cls = Class.forName(detectClass);
            supported = true;
        }
        catch (Throwable t) {
            supported = false;
        }
        System.out.println("DirectSound Capture Supported = " + supported);
        if (supported) {
            Vector devices = (Vector)CaptureDeviceManager.getDeviceList(null).clone();
            Enumeration enumeration = devices.elements();
            while (enumeration.hasMoreElements()) {
                CaptureDeviceInfo cdi = (CaptureDeviceInfo)enumeration.nextElement();
                String name = cdi.getName();
                if (!name.startsWith(DataSource.NAME)) continue;
                CaptureDeviceManager.removeDevice(cdi);
            }
            int LE = 0;
            int SI = 1;
            int US = 0;
            int UN = -1;
            float[] Rates = new float[]{48000.0f, 44100.0f, 32000.0f, 22050.0f, 16000.0f, 11025.0f, 8000.0f};
            Vector<AudioFormat> formats = new Vector<AudioFormat>(4);
            int rateIndex = 0;
            while (rateIndex < Rates.length) {
                float rate = Rates[rateIndex];
                AudioFormat af = new AudioFormat("LINEAR", rate, 16, 2, LE, SI);
                if (this.supports(af)) {
                    formats.addElement(af);
                }
                if (this.supports(af = new AudioFormat("LINEAR", rate, 16, 1, LE, SI))) {
                    formats.addElement(af);
                }
                if (this.supports(af = new AudioFormat("LINEAR", rate, 8, 2, UN, US))) {
                    formats.addElement(af);
                }
                if (this.supports(af = new AudioFormat("LINEAR", rate, 8, 1, UN, US))) {
                    formats.addElement(af);
                }
                ++rateIndex;
            }
            Format[] formatArray = new AudioFormat[formats.size()];
            int fa = 0;
            while (fa < formatArray.length) {
                formatArray[fa] = (AudioFormat)formats.elementAt(fa);
                ++fa;
            }
            CaptureDeviceInfo cdi = new CaptureDeviceInfo(DataSource.NAME, new MediaLocator("dsound://"), formatArray);
            CaptureDeviceManager.addDevice(cdi);
            try {
                CaptureDeviceManager.commit();
                System.out.println("DirectSoundAuto: Committed ok");
            }
            catch (IOException ioe) {
                System.err.println("DirectSoundAuto: error committing cdm");
            }
        }
    }

    static {
        detectClass = detectClass;
    }
}

