/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.mpeg;

import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.VideoFormat;

public class RTPDePacketizer {
    public static float[] RATE_TABLE = new float[]{0.0f, 23.976f, 24.0f, 25.0f, 29.97f, 30.0f, 50.0f, 59.94f, 60.0f};
    private static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private long discardtimestamp = -1L;
    private MPEGFrame currentframe = null;
    private boolean newframe = true;
    private boolean gotSequenceHeader = false;
    private boolean sequenceSent = false;
    private byte[] sequenceHeader = null;
    private boolean gopset = false;
    private int closedGop = 0;
    private int ref_pic_temp = -1;
    private int dep_pic_temp = -1;
    private int sequenceNumber = 0;
    private int width = 352;
    private int height = 240;
    private float frameRate = -1.0f;
    private VideoFormat outFormat = null;
    private boolean allowHeadless = false;
    private boolean fullFrameOnly = true;
    private boolean droppedPFrame = false;
    private boolean droppedIFrame = false;
    private boolean capture = false;
    private OutputStream captureFile = null;
    private static final boolean debug = false;
    private static int MAX_SEQ;

    RTPDePacketizer() {
        if (this.capture) {
            try {
                this.captureFile = new BufferedOutputStream(new FileOutputStream("/tmp/rtpstream.mpg"));
            }
            catch (IOException ioe) {
                System.err.println("RTPDePacketizer: unable to open file " + ioe);
                this.capture = false;
            }
        }
    }

    public void finalize() {
        if (this.capture) {
            try {
                this.captureFile.flush();
                this.captureFile.close();
                System.err.println("RTPDePacketizer: closed file");
            }
            catch (IOException ioe) {
                System.err.println("RTPDePacketizer: unable to close file " + ioe);
                this.capture = false;
            }
        }
    }

    public int process(Buffer inBuffer, Buffer outBuffer) {
        if (inBuffer.getTimeStamp() == this.discardtimestamp && this.discardtimestamp != -1L) {
            return 4;
        }
        if (!this.newframe && this.currentframe != null && inBuffer.getTimeStamp() != this.currentframe.rtptimestamp) {
            if (this.allowHeadless || this.firstPacket(inBuffer)) {
                boolean haveframe = false;
                if (this.fullFrameOnly) {
                    this.dropFrame();
                } else {
                    haveframe = this.constructFrame(outBuffer);
                }
                this.currentframe = this.createNewFrame(inBuffer);
                if (haveframe) {
                    return 0;
                }
                if ((this.currentframe.getFirst().getFlags() & 0x800) != 0 && this.constructFrame(outBuffer)) {
                    return 0;
                }
                return 4;
            }
            this.discardtimestamp = inBuffer.getTimeStamp();
            if (this.fullFrameOnly) {
                this.dropFrame();
                this.dropBufferFrame(inBuffer);
            } else if (this.compareSequenceNumbers(this.currentframe.seqno, inBuffer.getSequenceNumber()) > 0 && this.constructFrame(outBuffer)) {
                return 0;
            }
            return 4;
        }
        if (this.newframe) {
            if (this.firstPacket(inBuffer)) {
                this.newframe = false;
                this.currentframe = this.createNewFrame(inBuffer);
                if ((this.currentframe.getFirst().getFlags() & 0x800) != 0 && this.constructFrame(outBuffer)) {
                    return 0;
                }
                return 4;
            }
            if (this.fullFrameOnly) {
                this.dropBufferFrame(inBuffer);
            }
            this.discardtimestamp = inBuffer.getTimeStamp();
            this.newframe = true;
            return 4;
        }
        int ret = this.addToFrame(inBuffer, outBuffer);
        return ret;
    }

    protected String toHex(byte[] inData, int inOffset) {
        String hex = new String();
        int i2 = 0;
        while (i2 < 4) {
            hex = hex + hexChar[inData[inOffset + i2] >> 4 & 0xF];
            hex = hex + hexChar[inData[inOffset + i2] & 0xF];
            ++i2;
        }
        return hex;
    }

    private int addToFrame(Buffer inBuffer, Buffer outBuffer) {
        Buffer b2 = this.copyInto(inBuffer);
        this.currentframe.add(b2);
        if ((b2.getFlags() & 0x800) != 0 && this.constructFrame(outBuffer)) {
            return 0;
        }
        return 4;
    }

    private void constructGop(Buffer outBuffer) {
        byte[] dest = (byte[])outBuffer.getData();
        int outoffset = outBuffer.getLength();
        if (this.sequenceHeader != null) {
            System.arraycopy(this.sequenceHeader, 0, dest, outoffset, this.sequenceHeader.length);
            outBuffer.setLength(outBuffer.getLength() + this.sequenceHeader.length);
            outoffset += this.sequenceHeader.length;
            this.sequenceSent = true;
        }
        dest[outoffset] = 0;
        dest[outoffset + 1] = 0;
        dest[outoffset + 2] = 1;
        dest[outoffset + 3] = -72;
        dest[outoffset + 4] = -128;
        dest[outoffset + 5] = 8;
        dest[outoffset + 6] = 0;
        dest[outoffset + 7] = (byte)(this.closedGop | 0x20);
        outBuffer.setLength(outBuffer.getLength() + 8);
        this.ref_pic_temp = 0;
        this.dep_pic_temp = -1;
    }

    private void constructPicture(Buffer inBuffer, Buffer outBuffer) {
        byte[] payload = (byte[])inBuffer.getData();
        int offset = inBuffer.getOffset();
        byte[] dest = (byte[])outBuffer.getData();
        int outoffset = outBuffer.getLength();
        int next = 0;
        dest[outoffset] = 0;
        dest[outoffset + 1] = 0;
        dest[outoffset + 2] = 1;
        dest[outoffset + 3] = 0;
        dest[outoffset + 4] = (byte)((payload[offset] & 3) << 6 | (payload[offset + 1] & 0xFC) >> 2);
        int ptype = payload[offset + 2] & 7;
        int back = (payload[offset + 3] & 0xF0) >> 4;
        int fwd = payload[offset + 3] & 0xF;
        dest[outoffset + 5] = (byte)((payload[offset + 1] & 2) << 6 | ptype << 3);
        dest[outoffset + 6] = 0;
        if (ptype == 1) {
            dest[outoffset + 7] = 0;
            outBuffer.setLength(outBuffer.getLength() + 8);
        } else {
            next = fwd >> 1;
            dest[outoffset + 7] = (byte)next;
            next = (fwd & 1) << 7;
            if (ptype > 2) {
                next |= back << 3;
            }
            dest[outoffset + 8] = (byte)next;
            outBuffer.setLength(outBuffer.getLength() + 9);
        }
    }

    private void constructHeaders(Buffer outBuffer) {
        boolean havePicture = false;
        boolean outoffset = false;
        byte[] dest = (byte[])outBuffer.getData();
        Buffer src = (Buffer)this.currentframe.data.elementAt(0);
        byte[] payload = (byte[])src.getData();
        int offset = src.getOffset();
        int tr = (payload[offset] & 3) << 8 | payload[offset + 1] & 0xFF;
        int type = payload[offset + 2] & 7;
        if (src.getLength() >= 8 && (payload[offset + 2] & 0x10) == 16 && payload[offset + 4] == 0 && payload[offset + 5] == 0 && payload[offset + 6] == 1) {
            int startCode = payload[offset + 7] & 0xFF;
            if (startCode == 179) {
                this.sequenceSent = true;
                this.ref_pic_temp = tr;
                this.dep_pic_temp = -1;
                return;
            }
            if (startCode == 184) {
                if (this.sequenceHeader != null) {
                    System.arraycopy(this.sequenceHeader, 0, dest, outBuffer.getLength(), this.sequenceHeader.length);
                    outBuffer.setLength(outBuffer.getLength() + this.sequenceHeader.length);
                    this.sequenceSent = true;
                }
                this.ref_pic_temp = tr;
                this.dep_pic_temp = -1;
                return;
            }
            if (startCode == 0) {
                havePicture = true;
            }
        }
        ++this.ref_pic_temp;
        ++this.dep_pic_temp;
        if (type < 3) {
            if (tr < this.ref_pic_temp) {
                this.constructGop(outBuffer);
            }
            this.ref_pic_temp = tr;
        } else {
            if (tr < this.dep_pic_temp) {
                this.constructGop(outBuffer);
            }
            this.dep_pic_temp = tr;
        }
        if (!havePicture) {
            this.constructPicture(src, outBuffer);
        }
    }

    private void dropFrame() {
        Buffer src = (Buffer)this.currentframe.data.firstElement();
        this.dropBufferFrame(src);
    }

    private void dropBufferFrame(Buffer src) {
        int type = ((byte[])src.getData())[src.getOffset() + 2] & 7;
        if (type == 1) {
            this.droppedIFrame = true;
        } else if (type == 2) {
            this.droppedPFrame = true;
        }
        this.newframe = true;
        this.currentframe = null;
    }

    private boolean constructFrame(Buffer outBuffer) {
        Buffer src = (Buffer)this.currentframe.data.lastElement();
        int type = ((byte[])src.getData())[src.getOffset() + 2] & 7;
        if (this.fullFrameOnly) {
            if (type >= 2 && (this.droppedIFrame || this.droppedPFrame)) {
                this.dropFrame();
                return false;
            }
            if (type == 1) {
                this.droppedIFrame = false;
                this.droppedPFrame = false;
            }
            if ((src.getFlags() & 0x800) == 0) {
                this.dropFrame();
                return false;
            }
            int i2 = this.currentframe.data.size() - 2;
            while (i2 >= 0) {
                Buffer prev = (Buffer)this.currentframe.data.elementAt(i2);
                if (this.compareSequenceNumbers(prev.getSequenceNumber(), src.getSequenceNumber()) != 1) {
                    this.dropFrame();
                    return false;
                }
                src = prev;
                --i2;
            }
        }
        boolean noslices = true;
        byte[] dest = (byte[])outBuffer.getData();
        if (dest == null || dest.length < this.currentframe.datalength + this.sequenceHeader.length + 16) {
            dest = new byte[this.currentframe.datalength + this.sequenceHeader.length + 16];
        }
        outBuffer.setData(dest);
        outBuffer.setOffset(0);
        outBuffer.setLength(0);
        this.constructHeaders(outBuffer);
        if (!this.sequenceSent) {
            this.dropFrame();
            return false;
        }
        int outoffset = outBuffer.getLength();
        int i3 = 0;
        while (i3 < this.currentframe.data.size()) {
            block24: {
                int offset;
                src = (Buffer)this.currentframe.data.elementAt(i3);
                byte[] payload = (byte[])src.getData();
                if ((payload[(offset = src.getOffset()) + 2] & 0x10) == 16) {
                    if ((payload[offset + 2] & 8) == 8) {
                        System.arraycopy(payload, offset + 4, dest, outoffset, src.getLength() - 4);
                        outoffset += src.getLength() - 4;
                        noslices = false;
                    } else {
                        long seq = src.getSequenceNumber();
                        int j2 = i3 + 1;
                        while (j2 < this.currentframe.data.size()) {
                            Buffer next = (Buffer)this.currentframe.data.elementAt(j2);
                            if (this.compareSequenceNumbers(seq, next.getSequenceNumber()) != 1) {
                                if (i3 == 0) {
                                    int len = src.getLength() - 4;
                                    int off = offset += 4;
                                    while (len > 4) {
                                        if (payload[off + 0] == 0 && payload[off + 1] == 0 && payload[off + 2] == 1 && (payload[off + 3] & 0xFF) > 0 && (payload[off + 3] & 0xFF) <= 175) break;
                                        ++off;
                                        --len;
                                    }
                                    if (off != offset) {
                                        System.arraycopy(payload, offset, dest, outoffset, off - offset);
                                        outoffset += off - offset;
                                    }
                                }
                                break block24;
                            }
                            seq = next.getSequenceNumber();
                            if ((((byte[])next.getData())[next.getOffset() + 2] & 8) == 8) break;
                            ++j2;
                        }
                        if (j2 == this.currentframe.data.size()) break;
                        int k2 = i3;
                        while (k2 <= j2) {
                            src = (Buffer)this.currentframe.data.elementAt(k2);
                            System.arraycopy((byte[])src.getData(), src.getOffset() + 4, dest, outoffset, src.getLength() - 4);
                            outoffset += src.getLength() - 4;
                            ++k2;
                        }
                        noslices = false;
                        i3 = j2;
                    }
                }
            }
            ++i3;
        }
        if (this.outFormat == null || this.outFormat.getSize().width != this.width || this.outFormat.getSize().height != this.height || this.outFormat.getFrameRate() != this.frameRate) {
            Dimension d2 = new Dimension(this.width, this.height);
            this.outFormat = new VideoFormat("mpeg", d2, -1, Format.byteArray, this.frameRate);
        }
        outBuffer.setLength(outoffset);
        outBuffer.setFormat(this.outFormat);
        if (noslices) {
            outBuffer.setFlags(2);
        }
        outBuffer.setTimeStamp(this.currentframe.rtptimestamp);
        outBuffer.setSequenceNumber(this.sequenceNumber++);
        this.newframe = true;
        this.currentframe = null;
        if (noslices) {
            return false;
        }
        if (this.capture) {
            try {
                this.captureFile.write((byte[])outBuffer.getData(), outBuffer.getOffset(), outBuffer.getLength());
            }
            catch (IOException ioe) {
                System.err.println("RTPDePacketizer: write error for sequence number " + outBuffer.getSequenceNumber() + " : " + ioe);
                this.capture = false;
            }
        }
        return true;
    }

    private boolean firstPacket(Buffer inBuffer) {
        if (inBuffer == null) {
            return false;
        }
        byte[] payload = (byte[])inBuffer.getData();
        if (payload == null) {
            return false;
        }
        int offset = inBuffer.getOffset();
        int len = inBuffer.getLength();
        if (len < 12) {
            return false;
        }
        if (!this.gotSequenceHeader) {
            if ((payload[offset + 2] & 0x20) == 32 && payload[offset + 4] == 0 && payload[offset + 5] == 0 && payload[offset + 6] == 1 && (payload[offset + 7] & 0xFF) == 179) {
                this.width = (payload[offset + 8] & 0xFF) << 4 | (payload[offset + 9] & 0xF0) >> 4;
                this.height = (payload[offset + 9] & 0xF) << 8 | payload[offset + 10] & 0xFF;
                this.gotSequenceHeader = true;
                len -= 4;
                int off = offset += 4;
                while (len > 8) {
                    if (payload[off + 0] == 0 && payload[off + 1] == 0 && payload[off + 2] == 1 && (payload[off + 3] & 0xFF) == 184) {
                        this.gopset = true;
                        this.closedGop = payload[off + 7] & 0x40;
                        payload[off + 7] = (byte)(payload[off + 7] & 0x20);
                        this.sequenceHeader = new byte[off - offset];
                        System.arraycopy(payload, offset, this.sequenceHeader, 0, this.sequenceHeader.length);
                        return true;
                    }
                    ++off;
                    --len;
                }
                return true;
            }
            return false;
        }
        if ((payload[offset + 2] & 0x10) != 16) {
            return false;
        }
        offset += 4;
        len -= 4;
        while (len > 8) {
            if (payload[offset + 0] == 0 && payload[offset + 1] == 0 && payload[offset + 2] == 1) {
                if (payload[offset + 3] == 0) {
                    return true;
                }
                if ((payload[offset + 3] & 0xFF) == 184) {
                    this.gopset = true;
                    this.closedGop = payload[offset + 7] & 0x40;
                    payload[offset + 7] = (byte)(payload[offset + 7] | 0x20);
                    return true;
                }
                if ((payload[offset + 3] & 0xFF) <= 175) {
                    return false;
                }
            }
            ++offset;
            --len;
        }
        return false;
    }

    private int compareSequenceNumbers(long p, long c2) {
        if (c2 > p) {
            return (int)(c2 - p);
        }
        if (c2 == p) {
            return 0;
        }
        if (p > (long)(MAX_SEQ - 100) && c2 < 100L) {
            return (int)((long)MAX_SEQ - p + c2 + 1L);
        }
        return -1;
    }

    private MPEGFrame createNewFrame(Buffer inBuffer) {
        Buffer b2 = this.copyInto(inBuffer);
        MPEGFrame newframe = new MPEGFrame(b2);
        newframe.add(b2);
        return newframe;
    }

    private Buffer copyInto(Buffer src) {
        Buffer dest = new Buffer();
        dest.copy(src);
        src.setData(null);
        src.setHeader(null);
        src.setLength(0);
        src.setOffset(0);
        return dest;
    }

    static {
        debug = false;
        MAX_SEQ = 65535;
    }

    class MPEGFrame {
        public long rtptimestamp = -1L;
        public long seqno = -1L;
        private int datalength = 0;
        private Vector data = new Vector();

        public MPEGFrame(Buffer buffer) {
            this.rtptimestamp = buffer.getTimeStamp();
        }

        public void add(Buffer buffer) {
            if (buffer == null || buffer.getData() == null || buffer.getLength() < 4) {
                return;
            }
            if (RTPDePacketizer.this.compareSequenceNumbers(this.seqno, buffer.getSequenceNumber()) > 0) {
                this.data.addElement(buffer);
                this.seqno = buffer.getSequenceNumber();
            } else {
                long sq = buffer.getSequenceNumber();
                int i2 = 0;
                while (i2 < this.data.size()) {
                    long bsq = ((Buffer)this.data.elementAt(i2)).getSequenceNumber();
                    if (RTPDePacketizer.this.compareSequenceNumbers(bsq, sq) < 0) {
                        this.data.insertElementAt(buffer, i2);
                        break;
                    }
                    if (sq == bsq) {
                        return;
                    }
                    ++i2;
                }
            }
            this.datalength += buffer.getLength() - 4;
        }

        public Vector getData() {
            return this.data;
        }

        public Buffer getFirst() {
            if (this.data.size() > 0) {
                return (Buffer)this.data.firstElement();
            }
            return null;
        }

        public int getLength() {
            return this.datalength;
        }
    }
}

