/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.ExclusiveUse;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.SimpleGraphBuilder;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.renderer.audio.AudioRenderer;
import com.sun.media.renderer.audio.device.AudioOutput;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class DirectAudioRenderer
extends AudioRenderer
implements Runnable,
ExclusiveUse {
    static String NAME = "DirectSound Renderer";
    public static final int REQ_OPEN = 1;
    public static final int REQ_START = 2;
    public static final int REQ_STOP = 3;
    public static final int REQ_FLUSH = 4;
    public static final int REQ_DRAIN = 5;
    public static final int REQ_CLOSE = 6;
    public static final int REQ_SETGAIN = 7;
    public static final int REQ_SETMUTE = 8;
    public static final int REQ_SETRATE = 9;
    public static final int REQ_WRITE = 10;
    public static final int REQ_AVAILABLE = 11;
    public static final int REQ_TIME = 12;
    private static JMFSecurity jmfSecurity;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private Format ulawFormat;
    private Format linearFormat;
    private Codec ulawDecoder;
    private Format ulawOutputFormat;
    Buffer decodeBuffer = null;
    static boolean loaded;
    private int nativeData = 0;
    static /* synthetic */ Class class$java$lang$Thread;

    public DirectAudioRenderer() {
        this.supportedFormats = new Format[2];
        this.ulawFormat = new AudioFormat("ULAW");
        this.linearFormat = new AudioFormat("LINEAR");
        this.supportedFormats[0] = new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1);
        this.supportedFormats[1] = this.ulawFormat;
        this.gainControl = new MCA(this);
    }

    public String getName() {
        return NAME;
    }

    public void open() throws ResourceUnavailableException {
        if (this.device == null && this.inputFormat != null && !this.initDevice(this.inputFormat)) {
            throw new ResourceUnavailableException("Cannot intialize audio device for playback");
        }
    }

    protected boolean initDevice(AudioFormat in) {
        Format newInput = in;
        if (this.ulawDecoder != null) {
            this.ulawDecoder.close();
            this.ulawDecoder = null;
        }
        Format[] outs = new Format[1];
        if (this.ulawFormat.matches(in)) {
            this.ulawDecoder = SimpleGraphBuilder.findCodec(in, this.linearFormat, null, outs);
            if (this.ulawDecoder != null) {
                newInput = outs[0];
                this.ulawOutputFormat = newInput;
            } else {
                return false;
            }
        }
        this.devFormat = in;
        return super.initDevice((AudioFormat)newInput);
    }

    public boolean isExclusive() {
        return false;
    }

    public void close() {
        super.close();
    }

    public int processData(Buffer buffer) {
        if (!this.checkInput(buffer)) {
            return 1;
        }
        if (this.ulawDecoder == null) {
            return super.doProcessData(buffer);
        }
        if (this.decodeBuffer == null) {
            this.decodeBuffer = new Buffer();
            this.decodeBuffer.setFormat(this.ulawOutputFormat);
        }
        this.decodeBuffer.setLength(0);
        this.decodeBuffer.setOffset(0);
        this.decodeBuffer.setFlags(buffer.getFlags());
        this.decodeBuffer.setTimeStamp(buffer.getTimeStamp());
        this.decodeBuffer.setSequenceNumber(buffer.getSequenceNumber());
        int rc = this.ulawDecoder.process(buffer, this.decodeBuffer);
        if (rc == 0) {
            return super.doProcessData(this.decodeBuffer);
        }
        return 1;
    }

    protected AudioOutput createDevice(AudioFormat format) {
        return new DirectAudioOutput();
    }

    private static synchronized boolean grabDevice() {
        return true;
    }

    public void run() {
        ((Runnable)((Object)this.device)).run();
    }

    Thread chpThread() {
        Thread thread = null;
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable e2) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                Constructor cons = jdk12CreateThreadRunnableAction.cons;
                thread = (Thread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$java$lang$Thread == null ? (class$java$lang$Thread = DirectAudioRenderer.class$("java.lang.Thread")) : class$java$lang$Thread, this));
                thread.setName("DirectSound Request Thread");
                cons = jdk12PriorityAction.cons;
                jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(thread, new Integer(10)));
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        } else {
            thread = new Thread(this);
            thread.setName("DirectSound Request Thread");
            thread.setPriority(10);
        }
        return thread;
    }

    private native int nOpen(int var1, int var2, int var3, int var4);

    private native void nClose(int var1);

    private native void nPause(int var1);

    private native void nResume(int var1);

    private native void nDrain(int var1);

    private native void nFlush(int var1);

    private native void nSetGain(int var1, float var2);

    private native void nSetMute(int var1, boolean var2);

    private native long nGetSamplesPlayed(int var1);

    private native int nBufferAvailable(int var1);

    private native int nWrite(int var1, byte[] var2, int var3, int var4, boolean var5, boolean var6);

    private native void nCheckUnderflow(int var1);

    private native boolean nSetFrequency(int var1, int var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        REQ_OPEN = 1;
        REQ_START = 2;
        REQ_STOP = 3;
        REQ_FLUSH = 4;
        REQ_DRAIN = 5;
        REQ_CLOSE = 6;
        REQ_SETGAIN = 7;
        REQ_SETMUTE = 8;
        REQ_SETRATE = 9;
        REQ_WRITE = 10;
        REQ_AVAILABLE = 11;
        REQ_TIME = 12;
        jmfSecurity = null;
        securityPrivelege = false;
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException e2) {
            // empty catch block
        }
        loaded = false;
        if (!loaded) {
            try {
                JMFSecurityManager.loadLibrary("jmdaud");
                loaded = true;
            }
            catch (UnsatisfiedLinkError e3) {
                loaded = false;
            }
        }
    }

    class DirectAudioOutput
    implements AudioOutput,
    Runnable {
        private int bufSize;
        private AudioFormat format;
        private float gain;
        private boolean muted;
        private int request = 0;
        private Integer reqLock = new Integer(0);
        private boolean response = false;
        private Thread reqThread = null;
        private float rate = 1.0f;
        private boolean swapBytes = false;
        private boolean signChange = false;
        private float reqRate = 1.0f;
        private byte[] writeData;
        private int writeOffset;
        private int writeLen;
        private int writeResponse;
        private long nanoseconds;
        private int bufferAvailable;
        private boolean started = false;
        private Integer writeLock = new Integer(1);

        public boolean initialize(AudioFormat format, int bufSize) {
            if (!loaded) {
                return false;
            }
            this.format = format;
            this.bufSize = (int)(format.getSampleRate() * (double)format.getSampleSizeInBits() * (double)format.getChannels() / 8.0 / 32.0);
            if (this.reqThread == null) {
                this.reqThread = DirectAudioRenderer.this.chpThread();
                this.reqThread.start();
            }
            this.swapBytes = format.getEndian() == 1 && format.getSampleSizeInBits() == 16;
            this.signChange = format.getSigned() == 1 && format.getSampleSizeInBits() == 8;
            this.makeRequest(1);
            this.waitForResponse();
            return DirectAudioRenderer.this.nativeData != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void makeRequest(int request) {
            Integer n2 = this.reqLock;
            synchronized (n2) {
                this.request = request;
                this.response = false;
                this.reqLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitForResponse() {
            Integer n2 = this.reqLock;
            synchronized (n2) {
                while (!this.response) {
                    try {
                        this.reqLock.wait(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean done = false;
            while (!done) {
                Integer n2;
                int reqCopy;
                Integer n3 = this.reqLock;
                synchronized (n3) {
                    try {
                        if (this.request == 0) {
                            this.reqLock.wait(50L);
                        }
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    reqCopy = this.request;
                    this.request = 0;
                }
                switch (reqCopy) {
                    case 1: {
                        DirectAudioRenderer.this.nativeData = DirectAudioRenderer.this.nOpen((int)this.format.getSampleRate(), this.format.getSampleSizeInBits(), this.format.getChannels(), this.bufSize);
                        break;
                    }
                    case 2: {
                        DirectAudioRenderer.this.nResume(DirectAudioRenderer.this.nativeData);
                        break;
                    }
                    case 3: {
                        DirectAudioRenderer.this.nPause(DirectAudioRenderer.this.nativeData);
                        break;
                    }
                    case 4: {
                        DirectAudioRenderer.this.nFlush(DirectAudioRenderer.this.nativeData);
                        break;
                    }
                    case 5: {
                        DirectAudioRenderer.this.nDrain(DirectAudioRenderer.this.nativeData);
                        break;
                    }
                    case 7: {
                        DirectAudioRenderer.this.nSetGain(DirectAudioRenderer.this.nativeData, this.gain);
                        break;
                    }
                    case 8: {
                        DirectAudioRenderer.this.nSetMute(DirectAudioRenderer.this.nativeData, this.muted);
                        break;
                    }
                    case 9: {
                        this.doSetRate(this.reqRate);
                        break;
                    }
                    case 10: {
                        this.writeResponse = DirectAudioRenderer.this.nWrite(DirectAudioRenderer.this.nativeData, this.writeData, this.writeOffset, this.writeLen, this.swapBytes, this.signChange);
                        break;
                    }
                    case 12: {
                        long samples = DirectAudioRenderer.this.nGetSamplesPlayed(DirectAudioRenderer.this.nativeData);
                        this.nanoseconds = (long)((double)(1000000L * samples) / this.format.getSampleRate()) * 1000L;
                        break;
                    }
                    case 11: {
                        this.bufferAvailable = DirectAudioRenderer.this.nBufferAvailable(DirectAudioRenderer.this.nativeData);
                        break;
                    }
                    case 6: {
                        Integer n4 = this.writeLock;
                        synchronized (n4) {
                            DirectAudioRenderer.this.nClose(DirectAudioRenderer.this.nativeData);
                            DirectAudioRenderer.this.nativeData = 0;
                            done = true;
                            break;
                        }
                    }
                    default: {
                        if (!this.started) break;
                        n2 = this.writeLock;
                        synchronized (n2) {
                            DirectAudioRenderer.this.nCheckUnderflow(DirectAudioRenderer.this.nativeData);
                            break;
                        }
                    }
                }
                if (reqCopy <= 0) continue;
                n2 = this.reqLock;
                synchronized (n2) {
                    this.response = true;
                    this.reqLock.notifyAll();
                }
            }
            this.reqThread = null;
        }

        public synchronized void dispose() {
            if (DirectAudioRenderer.this.nativeData != 0) {
                this.makeRequest(6);
                this.waitForResponse();
            }
        }

        public synchronized void pause() {
            this.makeRequest(3);
            this.waitForResponse();
            this.started = false;
        }

        public synchronized void resume() {
            this.makeRequest(2);
            this.waitForResponse();
            this.started = true;
        }

        public synchronized void drain() {
            this.makeRequest(5);
            this.waitForResponse();
            this.started = false;
        }

        public synchronized void flush() {
            this.makeRequest(4);
            this.waitForResponse();
            this.started = false;
        }

        public AudioFormat getFormat() {
            return this.format;
        }

        public long getMediaNanoseconds() {
            long samples = DirectAudioRenderer.this.nGetSamplesPlayed(DirectAudioRenderer.this.nativeData);
            this.nanoseconds = (long)((double)(1000000L * samples) / this.format.getSampleRate()) * 1000L;
            return this.nanoseconds;
        }

        public double getGain() {
            return this.gain;
        }

        public synchronized void setGain(double g2) {
            this.gain = (float)g2;
            this.makeRequest(7);
            this.waitForResponse();
        }

        public synchronized void setMute(boolean m2) {
            this.muted = m2;
            this.makeRequest(8);
            this.waitForResponse();
        }

        public boolean getMute() {
            return this.muted;
        }

        public float doSetRate(float r) {
            if ((double)r * this.format.getSampleRate() > 100000.0) {
                r = 100000.0f / (float)this.format.getSampleRate();
            }
            if (r < 0.1f) {
                r = 0.1f;
            }
            int sampFreq = (int)((double)r * this.format.getSampleRate());
            if (DirectAudioRenderer.this.nSetFrequency(DirectAudioRenderer.this.nativeData, sampFreq)) {
                this.rate = r;
            } else {
                this.rate = 1.0f;
                r = 1.0f;
            }
            return r;
        }

        public synchronized float setRate(float r) {
            this.reqRate = r;
            this.makeRequest(9);
            this.waitForResponse();
            return this.rate;
        }

        public float getRate() {
            return this.rate;
        }

        public synchronized int bufferAvailable() {
            this.makeRequest(11);
            this.waitForResponse();
            return this.bufferAvailable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int write(byte[] data, int off, int len) {
            this.writeData = data;
            this.writeOffset = off;
            this.writeLen = len;
            Integer n2 = this.writeLock;
            synchronized (n2) {
                this.writeResponse = DirectAudioRenderer.this.nWrite(DirectAudioRenderer.this.nativeData, this.writeData, this.writeOffset, this.writeLen, this.swapBytes, this.signChange);
            }
            return this.writeResponse;
        }
    }

    class MCA
    extends GainControlAdapter {
        AudioRenderer renderer;

        protected MCA(AudioRenderer r) {
            super(1.0f);
            this.renderer = r;
        }

        public void setMute(boolean mute) {
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setMute(mute);
            }
            super.setMute(mute);
        }

        public float setLevel(float g2) {
            float level = super.setLevel(g2);
            g2 = this.getDB();
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setGain(g2);
            }
            return level;
        }
    }
}

